/* Admin End Js */
$wkadn = jQuery.noConflict();

$wkadn(document).ready(function () {
  'use strict';
  var $test_mode_checkbox = $wkadn('#woocommerce_adyen_payment_test_mode');
  var $payment_mode = $wkadn('#woocommerce_wkwc_adyen_credit_card_payment_mode');

  var $test_mode_setting = $wkadn('#wkwc-adyen-test-mode-enabled');

  if (!$test_mode_checkbox.is(':checked')) {
    woo_adyen_hide_test_mode_inputs();
    if ($wkadn('.information-setting').find('#wkwc-adyen-live-api-key').val() != '' && wkwc_adyen_util.api.adyen_merchant != '' ) {
      $wkadn('#wkwc_adyen_get_live_auth_connection_status').removeAttr('disabled');
    }
  }

  if ($test_mode_setting.length) {
    woo_wk_adyen_hide_test_mode_config_inputs();
    if ($wkadn('.information-setting').find('#wkwc-adyen-test-api-key').val() != '' && wkwc_adyen_util.api.adyen_merchant != '') {
      console.log('test connection');

      $wkadn('#wkwc_adyen_get_test_auth_connection_status').removeAttr('disabled');
    }
  }

  if ($payment_mode.val() === 'authorize_payment') {
    woo_adyen_hide_link_payment_mode_inputs();
  }

  function woo_adyen_hide_link_payment_mode_inputs() {
    $wkadn('#woocommerce_wkwc_adyen_credit_card_payment_link_desc').parent().parent().parent().hide();
  }

  function woo_adyen_show_link_payment_mode_inputs() {
    $wkadn('#woocommerce_wkwc_adyen_credit_card_payment_link_desc').parent().parent().parent().show();
  }

  $payment_mode.on('change', function () {

    var selectedMode = $wkadn(this).val()
    if (selectedMode === 'payment_links') {
      woo_adyen_show_link_payment_mode_inputs();
    } else {
      woo_adyen_hide_link_payment_mode_inputs();
    }
  });

  $test_mode_checkbox.change(function () {
    if (!this.checked) {
      woo_adyen_hide_test_mode_inputs();
    } else {
      $wkadn('#woocommerce_adyen_payment_test_api_key').parent().parent().parent().show();
      $wkadn('#woocommerce_adyen_payment_test_merchant').parent().parent().parent().show();
      $wkadn('#woocommerce_adyen_payment_test_origin_key').parent().parent().parent().show();
    }
  });

  $test_mode_setting.change(function () {
    woo_wk_adyen_hide_test_mode_config_inputs();
  });

  $wkadn('#mainform').on('submit', function () {
    var adyen_title = $wkadn('#woocommerce_adyen_payment_title').val();
    if ($payment_mode.val() == 'payment_links') {
      var adyen_desc = $wkadn('#woocommerce_adyen_payment_payment_link_desc').val();
    } else {
      var adyen_desc = $wkadn('#woocommerce_adyen_payment_description').val();
    }

    // do validation here
    if (adyen_title.length === 0) {
      alert('Title is required');
      return false;
    } else if (adyen_desc.length === 0) {
      alert('Description is required');
      return false;
    }
  });

  $wkadn('#wkwc_adyen_get_test_auth_connection_status, #wkwc_adyen_get_live_auth_connection_status').on('click', function (e) {
    e.preventDefault();
    let _this = $wkadn(this);
    var api_key = '', merchant_account = '', origin_key = '';
    if (_this.attr('id') === 'wkwc_adyen_get_test_auth_connection_status') {
      var api_key = $wkadn('#wkwc-adyen-test-api-key').val();
      var merchant_account = $wkadn('#wkwc_adyen_test_merchant_account').val();
      var origin_key = $wkadn('#wkwc_adyen_test_origin_key').val();

      if (api_key === '') {
        alert('Test API Key is required');
      }
      if (merchant_account === '') {
        alert('Test Merchant Account is required');
      }
      if (origin_key === '') {
        alert('Test Origin Key is required');
      }

    } else {
      var api_key = $wkadn('#wkwc-adyen-live-api-key').val();
      var merchant_account = $wkadn('#wkwc_adyen_live_merchant_account').val();
      var origin_key = $wkadn('#wkwc_adyen_live_origin_key').val();
      var live_end_prefix = $wkadn('#wkwc_adyen_live_endpoint_prefix').val();

      if (api_key === '') {
        alert('Live API Key is required');
      }
      if (merchant_account === '') {
        alert('Live Merchant Account is required');
      }
      if (origin_key === '') {
        alert('Live Origin Key is required');
      }
      if (live_end_prefix === '') {
        alert('Live Endpoint Prefix is required');
      }
    }

    if (api_key === '' || merchant_account === '' || origin_key === '') {
      alert('Api key, Merchant account and origin key are required to connection');
      return;
    }

    if (confirm('Are you sure you want to perform this action?')) {
      $wkadn.ajax({
        url: adyen_capture_data.ajax_url,
        method: 'POST',
        dataType: 'JSON',
        data: {
          action: 'wkwc_adyen_get_auth_connection_status',
          security: adyen_capture_data.auth_verification_nonce,
          api_key: api_key,
          merchant_account:merchant_account,
          origin_key:origin_key,
        },
        beforeSend: function () {
          _this.data('label', _this.text()).text(adyen_capture_data.translation.processing).prop('disabled', true);
        },
        success: function (response) {
          let res_data = response.data;
          if (response.success) {
            alert(res_data.message);
            window.location.reload();
          } else {
            alert(res_data.message);
            window.location.reload();
          }

        }
      });
    }

  });

  $wkadn('[data-capture-order-payment]').on('click', function () {
    let _this = $wkadn(this),
      order_id = _this.attr('data-capture-order-payment');

    if (confirm('Are you sure you want to perform this action?')) {
      $wkadn.ajax({
        url: adyen_capture_data.ajax_url,
        method: 'POST',
        dataType: 'JSON',
        data: {
          action: adyen_capture_data.action,
          security: adyen_capture_data.capture_nonce,
          order_id: order_id
        },
        beforeSend: function () {
          _this.data('label', _this.text()).text(adyen_capture_data.translation.processing).prop('disabled', true);
        },
        success: function (res) {
          const res_data = JSON.parse(res);
          if (res_data.result == 'success') {
            window.location.reload();
          }

        }
      });
    }

  });

  function woo_adyen_hide_test_mode_inputs() {
    $wkadn('#woocommerce_adyen_payment_test_api_key').parent().parent().parent().hide();
    $wkadn('#woocommerce_adyen_payment_test_merchant').parent().parent().parent().hide();
    $wkadn('#woocommerce_adyen_payment_test_origin_key').parent().parent().parent().hide();
  }

  function woo_wk_adyen_hide_test_mode_config_inputs() {
    if (!$test_mode_setting.is(':checked')) {
      $wkadn('.information-setting').find('#wkwc-adyen-test-api-key').parent().parent().hide();
      $wkadn('.information-setting').find('#wkwc_adyen_test_merchant_account').parent().parent().hide();
      $wkadn('.information-setting').find('#wkwc_adyen_test_origin_key').parent().parent().hide();
      $wkadn('.information-setting').find('.test-connection-btn').parent().hide();


      $wkadn('.information-setting').find('#wkwc-adyen-live-api-key').parent().parent().show();
      $wkadn('.information-setting').find('#wkwc_adyen_live_merchant_account').parent().parent().show();
      $wkadn('.information-setting').find('#wkwc_adyen_live_origin_key').parent().parent().show();
      $wkadn('.information-setting').find('#wkwc_adyen_live_endpoint_prefix').parent().parent().show();
      $wkadn('.information-setting').find('.live-connection-btn').parent().show();

    } else {
      $wkadn('.information-setting').find('#wkwc-adyen-live-api-key').parent().parent().hide();
      $wkadn('.information-setting').find('#wkwc_adyen_live_merchant_account').parent().parent().hide();
      $wkadn('.information-setting').find('#wkwc_adyen_live_origin_key').parent().parent().hide();
      $wkadn('.information-setting').find('#wkwc_adyen_live_endpoint_prefix').parent().parent().hide();
      $wkadn('.information-setting').find('.live-connection-btn').parent().hide();
      $wkadn('.information-setting').find('#wkwc-adyen-test-api-key').parent().parent().show();
      $wkadn('.information-setting').find('#wkwc_adyen_test_merchant_account').parent().parent().show();
      $wkadn('.information-setting').find('#wkwc_adyen_test_origin_key').parent().parent().show();

      $wkadn('.information-setting').find('.test-connection-btn').parent().show();
    }

  }
})
