<?php
/**
 * This file handles Refund Notification
 *
 * @package WkwcAdyen
 * @version 1.2.0
 */
namespace WkwcAdyen\Helper\Adyen\Notifications;

defined( 'ABSPATH' ) || exit; // Exit if access directly.

use Exception;

/**
 * Adyen Refund Handler
 */
class Wkwc_Authorization_Handler extends Wkwc_Abstract_Handler {
	/**
	 * Notification Request Object
	 *
	 * @param object DataObjects\Wkwc_Adyen_Notification_Request $notification_request .
	 *
	 * @return mixed|void
	 */
	public function handle( $notification_request ) {
		if ( ! $notification_request->success ) {
			return;
		}

		$order    = wc_get_order( intval( $notification_request->merchant_reference ) );
		$order_id = $order->get_id();

		wkwc_adn_log( "Order is: $order_id for handle authorization." );

		try {
			/* translators: %s: is PSP Reference */
			$order->update_status( 'processing', sprintf( __( 'Payment was authorized via WooCommerce Adyen Integration (PSP Reference: %s)', 'wkwc-adyen' ), $notification_request->psp_reference ) );
			wkwc_adn_log( 'Authorization for order id: ' . $order->get_id() );
		} catch ( Exception $e ) {
			wkwc_adn_log( $e->getMessage() );
		}
	}
}
