<?php
/**
 * This file handles Notification
 *
 * @package WkwcAdyen
 * @version 1.2.0
 */
namespace WkwcAdyen\Helper\Adyen\Notifications;

defined( 'ABSPATH' ) || exit; // Exit if access directly.

use WC_Order;

/**
 * Adyen Notification Capture Handler
 */
class Wkwc_Capture_Handler extends Wkwc_Abstract_Handler {
	/**
	 * Notification Request Object
	 *
	 * @param object DataObjects\Wkwc_Adyen_Notification_Request $notification_request .
	 *
	 * @return mixed|void
	 */
	public function handle( $notification_request ) {
		if ( ! $notification_request->success ) {
			return;
		}
		$order = new WC_Order( intval( $notification_request->merchant_reference ) );

		$order->update_meta_data( '_wkwc_adyen_payment_captured', 'yes' );
		$order->update_status( 'completed', __( 'Payment was captured via Adyen', 'wkwc-adyen' ) );
	}
}
