<?php
/**
 * This file handles Notification
 *
 * @package WkwcAdyen
 * @version 1.2.0
 */
namespace WkwcAdyen\Helper\Adyen\Notifications;

defined( 'ABSPATH' ) || exit; // Exit if access directly.

/**
 * Adyen Wkwc_Handlers_Factory Class
 */
class Wkwc_Handlers_Factory {
	/**
	 * Action On Different Events
	 *
	 * @param string $event_code .
	 *
	 * @return Wkwc_Abstract_Handler|null
	 */
	public static function make( $event_code ) {
		switch ( $event_code ) {
			case 'REFUND':
				return new Wkwc_Refund_Handler();
			case 'CAPTURE':
				return new Wkwc_Capture_Handler();
			case 'AUTHORISATION':
				return new Wkwc_Authorization_Handler();
		}
		return null;
	}
}
