<?php
/**
 * This file handles Notification Request
 *
 * @package WkwcAdyen
 * @version 1.2.0
 */
namespace WkwcAdyen\Helper\Adyen\Notifications\DataObjects;

defined( 'ABSPATH' ) || exit; // Exit if access directly.

/**
 * Adyen Wkwc_Adyen_Notification_Request
 */
class Wkwc_Adyen_Notification_Request {
	/**
	 * $event_code
	 *
	 * @var string
	 */
	public $event_code;

	/**
	 * $event_date
	 *
	 * @var string
	 */
	public $event_date;

	/**
	 * $merchant_account_code
	 *
	 * @var string
	 */
	public $merchant_account_code;

	/**
	 * $merchant_reference
	 *
	 * @var string
	 */
	public $merchant_reference;

	/**
	 * $original_reference
	 *
	 * @var string
	 */
	public $original_reference;

	/**
	 * $psp_reference
	 *
	 * @var string
	 */
	public $psp_reference;

	/**
	 * $reason
	 *
	 * @var string
	 */
	public $reason;

	/**
	 * $success
	 *
	 * @var boolean
	 */
	public $success;

	/**
	 * $amount
	 *
	 * @var Wkwc_Amount
	 */
	public $amount;

	/**
	 * $additional_data
	 *
	 * @var Wkwc_Additional_Data
	 */
	public $additional_data;

	/**
	 * $raw_notification_request
	 *
	 * @var array
	 */
	private $raw_notification_request;

	/**
	 * Wkwc_Adyen_Notification_Request constructor.
	 *
	 * @param object DataObjects\Wkwc_Adyen_Notification_Request $notification_request .
	 */
	public function __construct( $notification_request ) {
		$this->raw_notification_request = $notification_request;
		$this->event_code               = ( isset( $notification_request['eventCode'] ) ) ? $notification_request['eventCode'] : null;
		$this->event_date               = ( isset( $notification_request['eventDate'] ) ) ? strtotime( $notification_request['eventDate'] ) : null;
		$this->merchant_account_code    = ( isset( $notification_request['merchantAccountCode'] ) ) ? $notification_request['merchantAccountCode'] : null;
		$this->merchant_reference       = ( isset( $notification_request['merchantReference'] ) ) ? $notification_request['merchantReference'] : null;
		$this->original_reference       = ( isset( $notification_request['originalReference'] ) ) ? $notification_request['originalReference'] : null;
		$this->psp_reference            = ( isset( $notification_request['pspReference'] ) ) ? $notification_request['pspReference'] : null;
		$this->reason                   = ( isset( $notification_request['reason'] ) ) ? $notification_request['reason'] : null;
		$this->success                  = ( isset( $notification_request['success'] ) ) ? $notification_request['success'] : null;

		if ( isset( $notification_request['amount'] ) ) {
			$this->amount           = new Wkwc_Amount();
			$this->amount->currency = ( isset( $notification_request['amount']['currency'] ) ) ? $notification_request['amount']['currency'] : null;
			$this->amount->value    = ( isset( $notification_request['amount']['value'] ) ) ? $notification_request['amount']['value'] : null;
		}

		if ( isset( $notification_request['additionalData'] ) ) {
			$this->additional_data                 = new Wkwc_Additional_Data();
			$this->additional_data->hmac_signature = ( isset( $notification_request['additionalData']['hmacSignature'] ) ) ? $notification_request['additionalData']['hmacSignature'] : null;
		}
	}

	/**
	 * Notification in array
	 *
	 * @return string
	 */
	public function to_array() {
		return $this->raw_notification_request;
	}
}
