<?php
/**
 * This file handles Payment Gateway Core Action
 *
 * @package WkwcAdyen
 * @version 1.2.0
 */
namespace WkwcAdyen\Includes\Checkout_Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use WkwcAdyen\Helper\Adyen\Wkwc_Adyen_Helper;
use WkwcAdyen\Includes\Payment_Methods;
/**
 * Integration class
 */
class Wkwc_Adyen_Checkout_Blocks_Card extends AbstractPaymentMethodType {

	/**
	 * The single instance of the class.
	 *
	 * @var string $instance Wkwc_Adyen_Integration Instance.
	 * @since 2.1.1
	 */
	protected static $instance = null;

	/**
	 * @var Abstract_Gateway
	 */
	private $gateway;

	/**
	 * Adyen helper
	 *
	 * @var $adyen_helper
	 */
	protected $adyen_helper;

	/**
	 * Gateway name
	 *
	 * @var $name
	 */
	protected $name = 'wkwc_adyen_credit_card';

	/**
	 * Wkwc_Adyen_Integration
	 *
	 * @return Wkwc_Adyen_Integration
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Initialize the payment block
	 *
	 * @return void
	 */
	public function initialize() {
		$this->gateway      = new Payment_Methods\Wkwc_Adyen_Credit_Card();
		$this->settings     = $this->gateway->settings;
		$this->adyen_helper = new Wkwc_Adyen_Helper();
		// Handle the AJAX request to get the custom meta value.
		add_action( 'wp_ajax_wkwc_adyen_get_payment_method_data', array( $this, 'wkwc_adyen_get_payment_method_data' ) );
		add_action( 'wp_ajax_nopriv_wkwc_adyen_get_payment_method_data', array( $this, 'wkwc_adyen_get_payment_method_data' ) );
	}

	/**
	 * Is active
	 *
	 * @return bool
	 */
	public function is_active() {
		return $this->gateway->is_available();
	}

	/**
	 * Get payment method data
	 *
	 * @return array
	 */
	public function wkwc_adyen_get_payment_method_data() {

		$adyen_data = array(
			'title'            => $this->gateway->title,
			'description'      => $this->gateway->description,
			'icon'             => $this->gateway->get_icon_url(),
			'payment_mode'     => $this->gateway->payment_mode,
			'get_installments' => $this->gateway->get_installments(),
			'stored_cards'     => $this->gateway->get_stored_cards(),
			'supports'         => $this->gateway->supports,
			'payment_action'   => $this->gateway->get_payment_action(),
		);

		wp_send_json( $adyen_data );

	}

	/**
	 * Get payment method data
	 *
	 * @return array
	 */
	public function get_payment_method_data() {

		return array(
			'title'            => $this->gateway->title,
			'description'      => $this->gateway->description,
			'icon'             => $this->gateway->get_icon_url(),
			'payment_mode'     => $this->gateway->payment_mode,
			'get_installments' => $this->gateway->get_installments(),
			'stored_cards'     => $this->gateway->get_stored_cards(),
			'supports'         => $this->gateway->supports,
			'payment_action'   => $this->gateway->get_payment_action(),
		);

	}

	/**
	 * Register the payment block script
	 *
	 * @return string[]
	 */
	public function get_payment_method_script_handles() {

		$script_asset_path = WKWC_ADN_PLUGIN_FILE . 'block/build/wkwc-adyen-checkout-blocks-credit-card.asset.php';

		$script_asset = file_exists( $script_asset_path )
		 ? require $script_asset_path
		 : array(
			 'dependencies' => array(),
			 'version'      => WKADYEN_VERSION,
		 );

		$script_path = '/block/build/wkwc-adyen-checkout-blocks-credit-card.js';

		$script_asset['dependencies'] = array_merge(
			$script_asset['dependencies'],
			array(
				'wc-blocks-registry',
				'wc-settings',
				'wp-element',
				'wp-html-entities',
				'wp-i18n',
			),
		);

		$script_url = WKADYEN_PLUGIN_URL . $script_path;

		wp_register_script(
			'wkwc-adyen-checkout-blocks-credit-card',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		return array( 'wkwc-adyen-checkout-blocks-credit-card' );

	}
}
