<?php
/**
 * Checkout blocks Klarna Pay
 */

namespace WkwcAdyen\Includes\Checkout_Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

use WkwcAdyen\Includes\Payment_Methods;
// prevent direct access data leaks
defined( 'ABSPATH' ) || exit;

class Wkwc_Adyen_Checkout_Blocks_Klarna extends AbstractPaymentMethodType {

	/**
	 * @var Abstract_Gateway
	 */
	private $gateway;

	protected $name = 'wkwc_adyen_klarna';


	/**
	 * Initialize the payment block
	 *
	 * @return void
	 */
	public function initialize() {

		$this->gateway  = new Payment_Methods\Wkwc_Adyen_Klarna( false );
		$this->settings = $this->gateway->settings;

	}


	/**
	 * Is active
	 *
	 * @return bool
	 */
	public function is_active() {
		return $this->gateway->is_available();
	}



	/**
	 * Register the payment block script
	 *
	 * @return string[]
	 */
	public function get_payment_method_script_handles() {

		$script_asset_path = WKWC_ADN_PLUGIN_FILE . 'block/build/wkwc-adyen-checkout-blocks-klarna.asset.php';

		$script_asset = file_exists( $script_asset_path )
		 ? require $script_asset_path
		 : array(
			 'dependencies' => array(),
			 'version'      => WKADYEN_VERSION,
		 );

		$script_asset['dependencies'] = array_merge(
			$script_asset['dependencies'],
			array(
				'wc-blocks-registry',
				'wc-settings',
				'wp-element',
				'wp-html-entities',
				'wp-i18n',
			),
		);

		$script_path = '/block/build/wkwc-adyen-checkout-blocks-klarna.js';

		$script_url = WKADYEN_PLUGIN_URL . $script_path;

		wp_register_script(
			'wkwc-adyen-checkout-blocks-klarna',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		return array( 'wkwc-adyen-checkout-blocks-klarna' );

	}



	/**
	 * Get payment method data
	 *
	 * @return array
	 */
	public function get_payment_method_data() {

		return array(
			'title'          => $this->gateway->title,
			'description'    => $this->gateway->description,
			'icon'           => $this->gateway->get_icon_url(),
			'supports'       => $this->gateway->supports,
			'payment_action' => $this->gateway->get_payment_action(),
		);

	}

}
