<?php
/**
 * Module Wp List table.
 *
 * @package wp module purchase code collector
 *
 * @version 1.0.1
 *
 * Note: This file will always be copied from the client records repo.
 *
 * @LWDT: 202408121330
 */

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'Wp_Pcc_Helper' ) ) {
	/**
	 * License Helper.
	 */
	class Wp_Pcc_Helper {
		/**
		 * Instance variable.
		 *
		 * @var $instance
		 */
		protected static $instance = null;

		/**
		 * $db contains database object.
		 *
		 * @var db
		 */
		protected $db;

		/**
		 * Construct Function.
		 */
		public function __construct() {
			global $wpdb;
			$this->db = $wpdb;
		}

		/**
		 * Ensures only one instance of this class is loaded or can be loaded.
		 *
		 * @return object
		 */
		public static function get_instance() {
			if ( ! static::$instance ) {
				static::$instance = new self();
			}
			return static::$instance;
		}

		/**
		 * Get all webkul plugins.
		 *
		 * @return array
		 */
		public function wp_pcc_get_all_webkul_plugins() {
			$active_plugins = get_option( 'active_plugins', array() );

			if ( is_multisite() ) {
				$active_plugins = array_merge( $active_plugins, array_flip( get_site_option( 'active_sitewide_plugins', array() ) ) );
			}

			$wk_active_plugins = array();

			if ( ! empty( get_plugins() ) ) {
				foreach ( get_plugins() as $key => $plugin ) {
					$author     = empty( $plugin['Author'] ) ? ( empty( $plugin['author'] ) ? '' : $plugin['author'] ) : $plugin['Author'];
					$explode    = explode( '/', $key );
					$plugin_dir = ! empty( $explode[0] ) ? $explode[0] : '';
					if ( ( ! empty( $author ) && 'webkul' === strtolower( $author ) && ! empty( $plugin['PluginURI'] ) && ( ! defined( 'WKMP_LITE_PLUGIN_BASENAME' ) || ( defined( 'WKMP_LITE_PLUGIN_BASENAME' ) && WKMP_LITE_PLUGIN_BASENAME !== $key ) ) ) ) {
						if ( in_array( $key, $active_plugins, true ) ) {
							$plugin['plugin_dir'] = $plugin_dir;
							$wk_active_plugins[]  = $plugin;
						}
					}
				}
			}
			return apply_filters( 'wp_pcc_modify_plugins_data', $wk_active_plugins );
		}

		/**
		 * Get plugin directory.
		 *
		 * @param string $plugin_name Plugin name.
		 *
		 * @return string
		 */
		public function wp_pcc_get_plugin_dir( $plugin_name ) {
			$plugin_dir_name = '';
			$plugins         = get_plugins();

			$plugins = array_filter(
				$plugins,
				function ( $plugin ) use ( $plugin_name ) {
					if ( ( ( ! empty( $plugin['Author'] ) && 'webkul' === strtolower( $plugin['Author'] ) && ! empty( $plugin['PluginURI'] ) ) || ( ! empty( $plugin['author'] ) && 'webkul' === strtolower( $plugin['author'] ) && ! empty( $plugin['PluginURI'] ) ) ) && ( $plugin_name === $plugin['Name'] ) ) {
						return $plugin;
					}
				}
			);

			if ( ! empty( $plugins ) ) {
				$plugin_dir_name = explode( '/', array_keys( $plugins )[0] )[0];
			}
			return $plugin_dir_name;
		}
	}
}
