<?php
/**
 * Module Wp List table.
 *
 * @package wp module purchase code collector
 *
 * @version 1.0.2
 *
 * Note: This file will always be copied from the client records repo.
 *
 * @LWDT: 202408021330
 */
defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

if ( ! class_exists( 'Wp_Pcc_Licence_Table' ) ) {
	/**
	 * License List
	 */
	class Wp_Pcc_Licence_Table extends WP_List_Table {
		/**
		 * Helper object.
		 *
		 * @var Helper
		 */
		protected $helper;

		/**
		 * Construct Function.
		 */
		public function __construct() {
			parent::__construct(
				array(
					'singular' => esc_html__( 'Module List', 'wkwc_addons' ),
					'plural'   => esc_html__( 'Modules List', 'wkwc_addons' ),
					'ajax'     => false,
				)
			);
			require_once WKLICENSE_PLUGIN_FILE . 'class-wp-pcc-helper.php';

			$this->helper = Wp_Pcc_Helper::get_instance();
		}

		/**
		 * Prepare items function.
		 */
		public function prepare_items() {
			$columns  = $this->get_columns();
			$sortable = $this->get_sortable_columns();
			$hidden   = $this->get_hidden_columns();

			$this->process_bulk_action();

			$perpage     = get_option( 'notice_per_page', 10 );
			$modules     = $this->table_data( $perpage );
			$total_items = 0;

			$this->_column_headers = array( $columns, $hidden, $sortable );
			$total_pages           = ceil( $total_items / $perpage );

			$this->set_pagination_args(
				array(
					'total_items' => $total_items,
					'total_pages' => $total_pages,
					'per_page'    => $perpage,
				)
			);

			$this->items = $modules;
		}

		/**
		 * Columns to make sortable.
		 *
		 * @return array
		 */
		public function get_sortable_columns() {
			$sortable_columns = array(
				'wp_pcc_version' => array( 'wp_pcc_version', true ),
			);
			return $sortable_columns;
		}

		/**
		 * Define the columns that are going to be used in the table.
		 *
		 * @return array $columns Array of columns to use with the table.
		 */
		public function get_columns() {
			$columns = array(
				'wp_pcc_plugin'        => esc_html__( 'Plugin', 'wkwc_addons' ),
				'wp_pcc_version'       => esc_html__( 'Version', 'wkwc_addons' ),
				'wp_pcc_store'         => esc_html__( 'Purchase From', 'wkwc_addons' ),
				'wp_pcc_purchase_code' => esc_html__( 'Purchase Code', 'wkwc_addons' ),
				'wp_pcc_renew'         => esc_html__( 'Support Till', 'wkwc_addons' ),
				'wp_pcc_status'        => esc_html__( 'Status', 'wkwc_addons' ),
				'wp_pcc_action'        => esc_html__( 'Action', 'wkwc_addons' ),
			);
			return apply_filters( 'wp_pcc_modify_module_columns', $columns );
		}

		/**
		 * Default columns.
		 *
		 * @param array  $item Columns array.
		 * @param string $column_name Column name.
		 */
		public function column_default( $item, $column_name ) {
			switch ( $column_name ) {
				case 'wp_pcc_plugin':
				case 'wp_pcc_version':
				case 'wp_pcc_purchase_code':
				case 'wp_pcc_renew':
				case 'wp_pcc_status':
				case 'wp_pcc_action':
					return $item[ $column_name ];
				default:
					return $item[ $column_name ];
			}
		}

		/**
		 * Get hidden columns function.
		 *
		 * @return array hidden columns.
		 */
		public function get_hidden_columns() {
			return array();
		}

		/**
		 * Table data function.
		 *
		 * @param int $limit contains notice limit.
		 */
		private function table_data( $limit ) {
			echo '<style type="text/css">';
			echo 'select#wp_pcc_store_from {margin-bottom: 10px; width: 100%;}';
			echo '.column-wp_pcc_version { width: 10%; }';
			echo '.column-wp_pcc_purchase_code { width: 26%; }';
			echo '.column-wp_pcc_renew { width: 10%; }';
			echo '.column-wp_pcc_status { width: 10%; }';
			echo '.column-wp_pcc_action { width: 10%; }';
			echo '.wkwc-addon-license-action {position: relative;}';
			echo '</style>';

			$search = \WKWC_Addons::wk_get_request_data( 's' );
			$paged  = \WKWC_Addons::wk_get_request_data( 'paged' );
			$offset = $limit * ( $paged - 1 );

			$module_data = $this->helper->wp_pcc_get_all_webkul_plugins();
			$i           = 0;

			$module_data = array_map(
				function ( $module ) use ( $i ) {
					$option_key     = 'wp_pcc_' . str_replace( ' ', '_', strtolower( $module['Title'] ) );
					$db_module_data = ! empty( get_option( $option_key ) ) ? maybe_unserialize( get_option( $option_key ) ) : '';

					$store_select  = ! empty( $db_module_data['store_type'] ) ? $db_module_data['store_type'] : '';
					$wp_pcc_renew  = ! empty( $db_module_data['supported_until'] ) ? wp_date( 'Y-m-d h:m:i A', strtotime( $db_module_data['supported_until'] ) ) : esc_html__( 'Pending', 'wkwc_addons' );
					$purchase_code = ! empty( $db_module_data['purchase_code'] ) ? $db_module_data['purchase_code'] : '';

					$wp_pcc_status                  = empty( $db_module_data['supported_until'] ) ? 'pending' : ( ( strtotime( $db_module_data['supported_until'] ) >= gmdate( 'U' ) ) ? 'approved' : 'expired' );
					$module['wp_pcc_id']            = $i;
					$module['wp_pcc_plugin']        = $module['Title'];
					$module['wp_pcc_version']       = $module['Version'];
					$readonly                       = ! empty( $purchase_code ) ? 'readonly' : '';
					$module['wp_pcc_purchase_code'] = '<input type="password" style="font-size:large" class="wp_pcc_input" value="' . $purchase_code . '" placeholder="Enter code of ' . $module['Title'] . '"  ' . $readonly . ' >';
					$module['wp_pcc_renew']         = $wp_pcc_renew;
					$module['wp_pcc_status']        = ( 'pending' === $wp_pcc_status ) ? esc_html__( 'Pending', 'wkwc_addons' ) : ( ( 'approved' === $wp_pcc_status ) ? '<span style="color:#2e672e; font-weight:600">' . esc_html__( 'Approved', 'wkwc_addons' ) . '</span>' : '<span style="color:#FF0000; font-weight:600">' . esc_html__( 'Expired', 'wkwc_addons' ) . '</span>' );
					$select_store                   = '';
					$codecanon_status               = ( 'codecanyon' === $store_select ) ? 'selected' : '';
					$webkul_status                  = ( 'webkul_store' === $store_select ) ? 'selected' : '';
					$woocommerce_status             = ( 'woocommerce' === $store_select ) ? 'selected' : '';
					$select_store                  .= '<select class="wp_pcc_select_store_from" id="wp_pcc_store_from" name="wp_purchase_store" >';
					$select_store                  .= '<option ' . esc_attr( $codecanon_status ) . ' value="codecanyon">' . esc_html__( 'Codecanyon', 'wkwc_addons' ) . '</option>';
					$select_store                  .= '<option ' . esc_attr( $webkul_status ) . ' value="webkul_store">' . esc_html__( 'Webkul Store', 'wkwc_addons' ) . '</option>';
					$select_store                  .= '<option ' . esc_attr( $woocommerce_status ) . ' value="woocommerce">' . esc_html__( 'WooCommerce', 'wkwc_addons' ) . '</option>';
					$select_store                  .= '</select>';
					$module['wp_pcc_store']         = $select_store;

					$module['wp_pcc_action'] = '<span class="wkwc-addon-license-action spinner"></span><button data-title="' . str_replace( ' ', '_', strtolower( $module['Title'] ) ) . '" data-module="' . $module['Title'] . '" data-dir="' . $module['plugin_dir'] . '" type="button" class="button ' . ( 'pending' === $wp_pcc_status ? ' button-primary wp_pcc_purchase_code_btn' : ' wp_pcc_purchase_code_remove_btn' ) . '" >' . ( 'pending' === $wp_pcc_status ? esc_html__( 'Activate', 'wkwc_addons' ) : esc_html__( 'Remove', 'wkwc_addons' ) ) . '</button>';
					$i++;
					return $module;
				},
				$module_data
			);

			$orderby    = \WKWC_Addons::wk_get_request_data( 'orderby', array( 'default' => 'created_at' ) );
			$orderby    = ( 'wp_pcc_version' === $orderby ) ? 'Version' : $orderby;
			$sort_order = \WKWC_Addons::wk_get_request_data( 'order', array( 'default' => 'desc' ) );
			$this->sortbase_array_key( $module_data, $orderby, $sort_order );
			return apply_filters( 'wcpos_cc_modify_notice_list_data', $module_data );
		}

		/**
		 * Sort data base on key.
		 *
		 * @param array  $plugins plugin data.
		 * @param string $key key.
		 * @param string $order order by.
		 */
		public function sortbase_array_key( array &$plugins, string $key, string $order = 'asc' ) {
			usort(
				$plugins,
				function ( $a, $b ) use ( $key, $order ) {
					if ( ! isset( $a[ $key ] ) || ! isset( $b[ $key ] ) ) {
						return 0;
					}
					if ( 'asc' === $order ) {
						return strnatcmp( $a[ $key ], $b[ $key ] );
					}

					return strnatcmp( $b[ $key ], $a[ $key ] );
				}
			);
		}
	}
}
