/** @format */
/**
 * External dependencies
 */
const path = require("path");
const NODE_ENV = process.env.NODE_ENV || "development";

const webpackConfig = {
    mode: NODE_ENV,
    watch: NODE_ENV != "production" ? true : false,
    entry: {
        admin: ["./src/wkwc-addons.js"],
    },
    devtool: NODE_ENV != "production" ? "inline-source-map" : false,
    output: {
        filename: "js/[name].js",
        path: path.resolve(__dirname, "assets"),
        libraryTarget: "this",
    },
    stats: "errors-warnings",
};

if (webpackConfig.mode !== "production") {
    webpackConfig.devtool = "inline-source-map";
}
module.exports = webpackConfig;
