<?php
/**
 * This file handles main factory functions.
 *
 * @package WkwcAdyen
 * @version 1.0.0
 */

namespace WkwcAdyen\Rest_Api\Factory;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Wkwc_Adyen_Api_Factory' ) ) {
	/**
	 * Main Factory Class
	 */
	class Wkwc_Adyen_Api_Factory {
		/**
		 * Return class object
		 *
		 * @param string $classnames Class.
		 */
		public static function wkwc_adyen_get_api_object( $classname ) {
			$reflection_class = new \ReflectionClass( $classname );

			return $reflection_class->newInstanceArgs();
		}
	}
}
