<?php
/**
 * This file handles all front functions
 *
 * @package WkwcAdyen
 * @version 1.0.0
 */

namespace WkwcAdyen\Rest_Api\Includes\Front;

defined( 'ABSPATH' ) || exit;

use WkwcAdyen\Rest_Api\Factory;

if ( ! class_exists( 'Wkwc_Adyen_Front_Function_Handler' ) ) {
	/**
	 * Front functions
	 */
	class Wkwc_Adyen_Front_Function_Handler {
		/**
		 * Register Routes
		 *
		 * @return void
		 */
		public function wkwc_adyen_register_routes() {

			// CheckOut.

			// Get Payment Method.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/getPaymentMethod',
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_get_payment_method' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Create New Payment.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/create-payment',
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_create_new_payment' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Get payment return url.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/payment-return-url',
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_get_return_url_response' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Fetch Payment Detail.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/getPaymentDetail',
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_get_payment_info' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Create Payment Link.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/create/paymentLink',
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_create_payment_link' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Get Payment Link Info.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/paymentLinks/(?P<payment_link_id>[a-zA-Z0-9-]+)',
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_get_payment_link_info' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);

			// Update Status Existing Payment Link.
			register_rest_route(
				WKWC_ADN_NAMESPACE,
				'/update/paymentLinks/(?P<payment_link_id>[a-zA-Z0-9-]+)',
				array(
					'methods'             => \WP_REST_Server::EDITABLE,
					'callback'            => array( Factory\Wkwc_Adyen_Api_Factory::wkwc_adyen_get_api_object( 'WkwcAdyen\Rest_Api\Includes\Front\Checkout\Wkwc_Adyen_Execute_Checkout' ), 'wkwc_adyen_update_payment_link_info' ),
					'permission_callback' => function () {
						return true;
					},
				)
			);
		}
	}
}
