<?php
/**
 * Configuration Template
 *
 * @package WkwcAdyen
 * @since 1.0.0
 */
namespace WkwcAdyen\Templates\Admin\Form_Template;

defined( 'ABSPATH' ) || exit;


if ( ! class_exists( 'Wkwc_Adyen_Configuration_HTML' ) ) {
	/**
	 * Supplier list class
	 */
	class Wkwc_Adyen_Configuration_HTML {
		/**
		 * Class constructor
		 */
		public function __construct() {
			$api_key_doc_url   = 'https://docs.adyen.com/user-management/how-to-get-the-api-key';
			$origin_key_url    = 'https://docs.adyen.com/user-management/how-to-get-an-origin-key';
			$live_endpoint_url = 'https://docs.adyen.com/development-resources/live-endpoints#live-url-prefix';
			$origin_key_desc   = sprintf(
				/* translators: %s: is doc url */
				__(
					'To get your Adyen Origin key, please visit <a target="_blank" href="%s">(How to get an origin key) for instructions.</a>',
					'wkwc-adyen'
				),
				$origin_key_url
			);

			/* translators: %s: is doc url */
			$api_key_desc = sprintf(
			/* translators: %s: is doc url */
				__(
					'To get your Adyen API key, please visit <a target="_blank" href="%s">
(How to get the API key)</a> for instructions.',
					'wkwc-adyen'
				),
				$api_key_doc_url
			);
			/* translators: %s: is doc url */
			$live_endpoint_desc = sprintf( __( 'To get your Adyen Live endpoint prefix, please visit <a target="_blank" href="%s">Live endpoints</a>', 'wkwc-adyen' ), $live_endpoint_url );
			?>
			<div class="wrap">
				<h1 class="wp-heading-inline"><?php esc_html_e( 'Configuration', 'wkwc-adyen' ); ?></h1>
					<?php settings_errors(); ?>
				<div class="wkwc-adyen-configuration-container wkwc-adyen-padding-top-bottom-0">
					<form action="options.php" method="POST" id="wkwc_adyen-config-form">
						<?php settings_fields( 'wkwc-adyen-settings-group' ); ?>
							<div class="form-template">
								<div class="general-setting">
									<h2><?php esc_html_e( 'General', 'wkwc-adyen' ); ?></h2>
									<table class="form-table">
										<tbody>
											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-enabled"><?php esc_html_e( 'Enable Adyen', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'Enable/Disable the module functionalities for the users.' ), true );
													?>
													<input type="checkbox" value="yes" id="wkwc-adyen-enabled" name="_wkwc_adyen_enabled" <?php checked( get_option( '_wkwc_adyen_enabled' ), 'yes', true ); ?> >
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-test-mode-enabled"><?php esc_html_e( 'Enable Test Mode', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'Whether or not to use the test environment' ), true );
													?>
													<input type="checkbox" value="yes" id="wkwc-adyen-test-mode-enabled" name="_wkwc_adyen_test_mode_enabled" <?php checked( get_option( '_wkwc_adyen_test_mode_enabled' ), 'yes', true ); ?> >
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-immediate-capturing-enabled"><?php esc_html_e( 'Enable Capturing', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'Capture the payments immediately.' ), true );
													?>
													<input type="checkbox" value="yes" id="wkwc_adyen_immediate_capturing_enabled" name="_wkwc_adyen_immediate_capturing_enabled" <?php checked( get_option( '_wkwc_adyen_immediate_capturing_enabled' ), 'yes', true ); ?> >
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-refund-enabled"><?php esc_html_e( 'Enable Refund', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'When I change an order status to refunded in WooCommerce, the gateway should issue a refund in Adyen automatically.' ), true );
													?>
													<input type="checkbox" value="yes" id="wkwc_adyen_refund_enabled" name="_wkwc_adyen_refund_enabled" <?php checked( get_option( '_wkwc_adyen_refund_enabled' ), 'yes', true ); ?> >
												</td>
											</tr>

											<?php do_action( 'wkwc_adyen_config_general_additional_field' ); ?>
										</tbody>
									</table>
								</div>

								<div class="information-setting">
									<?php
										$auth_status = get_transient( 'wkwc_adyen_merchant_account_is_validated' );

										$auth_status_html = '';
									if ( $auth_status ) {
										$auth_status_html = '<span class="wkwc-adyen-connection-status wkwc-adyen-success" id="wkwc_adyen_webhook_status_connected">' . __( 'Connection Established' ) . '</span>';
									} else {
										$auth_status_html = '<span class="wkwc-adyen-connection-status wkwc-adyen-error" id="wkwc_adyen_webhook_status_error">' . __( 'Connection Error' ) . '</span>';
									}

									?>
									<h2> <?php esc_html_e( 'Authorization', 'wkwc-adyen' ); ?> <?php echo wp_kses_post( $auth_status_html ); ?> </h2>
									<table class="form-table">
										<tbody>
											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_test_merchant_account"><?php esc_html_e( 'Test Merchant account name', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The merchant account used in test environment.' ), true );
													?>
													<input type="text" id="wkwc_adyen_test_merchant_account" name="_wkwc_adyen_test_merchant_account" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_test_merchant_account' ) ); ?>">
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-test-api-key"><?php esc_html_e( 'Test API Key', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The API Key used in test environment.' ), true );
													?>
													<input type="text" id="wkwc-adyen-test-api-key" name="_wkwc_adyen_test_api_key" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_test_api_key' ) ); ?>">
													<p class="description"><?php echo wp_kses_post( $api_key_desc ); ?></p>
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_test_origin_key"><?php esc_html_e( 'Test Origin Key', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The origin key used in test environment.' ), true );
													?>
													<input type="text" id="wkwc_adyen_test_origin_key" name="_wkwc_adyen_test_origin_key" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_test_origin_key' ) ); ?>">
													<p class="description">To get your Adyen Origin key, please visit <a target="_blank" href="https://docs.adyen.com/user-management/how-to-get-an-origin-key">(How to get an origin key) for instructions.</a></p>
												</td>
											</tr>
											<?php if(!$auth_status){ ?>
											<tr>
												<td colspan="2" class="wkwc-adyen-auth-connection-btn test-connection-btn">
													<?php
														echo wc_help_tip( esc_html__( 'Please ensure all credentials are saved to verify the authorization connection status.', 'wkwc-adyen' ), true );
													?>
													<button id="wkwc_adyen_get_test_auth_connection_status" class="button button-primary" disabled>Check Connection</button>
												</td>
											</tr>
											<?php } ?>
											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_live_merchant_account"><?php esc_html_e( 'Merchant account name', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The merchant account used in production environment.' ), true );
													?>
													<input type="text" id="wkwc_adyen_live_merchant_account" name="_wkwc_adyen_live_merchant_account" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_live_merchant_account' ) ); ?>">
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc-adyen-live-api-key"><?php esc_html_e( 'API Key', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The API Key used in production environment.' ), true );
													?>
													<input type="text" id="wkwc-adyen-live-api-key" name="_wkwc_adyen_live_api_key" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_live_api_key' ) ); ?>">
													<p class="description"><?php echo wp_kses_post( $api_key_desc ); ?></p>
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_live_origin_key"><?php esc_html_e( 'Origin Key', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The origin key used in production environment.' ), true );
													?>
													<input type="text" id="wkwc_adyen_live_origin_key" name="_wkwc_adyen_live_origin_key" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_live_origin_key' ) ); ?>">
													<p class="description"><?php echo wp_kses_post( $origin_key_desc ); ?></p>
												</td>
											</tr>

											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_live_origin_key"><?php esc_html_e( 'Live Endpoint Prefix', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'The endpoint used in production environment.' ), true );
													?>
													<input type="text" id="wkwc_adyen_live_endpoint_prefix" name="_wkwc_adyen_live_endpoint_prefix" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_live_endpoint_prefix' ) ); ?>">
													<p class="description"><?php echo wp_kses_post( $live_endpoint_desc ); ?></p>
												</td>
											</tr>

											<tr>
												<td colspan="2" class="wkwc-adyen-auth-connection-btn live-connection-btn">
													<?php
														echo wc_help_tip( esc_html__( 'Please ensure all credentials are saved to verify the authorization connection status.', 'wkwc-adyen' ), true );
													?>
													<button id="wkwc_adyen_get_live_auth_connection_status" class="button button-primary" disabled>Check Connection</button>
												</td>
											</tr>

											<?php do_action( 'wkwc_pa_config_authorization_field' ); ?>
										</tbody>
									</table>
								</div>

								<div class="webhook-setting">
									<h2><?php esc_html_e( 'Webhook', 'wkwc-adyen' ); ?></h2>
									<p><?php esc_html_e( 'Configure the webhook settings to receive notifications from Adyen when a payment is made or failed.', 'wkwc-adyen' ); ?></p>
									<h3 class="wc-settings-sub-title " id="woocommerce_adyen_payment_webhook">Webhook Endpoints </h3>
									<p> <?php echo $this->wkwc_adyen_webhook_description(); ?> </p>
									<table class="form-table">
										<tbody>
											<tr valign="top">
												<th scope="row" class="titledesc">
													<label for="wkwc_adyen_live_origin_key"><?php esc_html_e( 'HMAC Key', 'wkwc-adyen' ); ?></label>
												</th>
												<td class="forminp forminp-text">
													<?php
														echo wc_help_tip( wp_kses_post( 'Provide HMAC key the from the Customer Area' ), true );
													?>
													<input type="text" id="wkwc_adyen_hmac_key" name="_wkwc_adyen_hmac_key" class="regular-text" value="<?php echo esc_attr( get_option( '_wkwc_adyen_hmac_key' ) ); ?>">

													<p class="description">HMAC key is used to verify notifications coming from Adyen server. It is recommended to set it up to <a href="https://docs.adyen.com/development-resources/notifications/verify-hmac-signatures#enable-hmac-signatures" target="_blank">secure the notifications endpoint</a>.</p>
												</td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
						<?php
						wp_nonce_field( 'wkwc_adyen_nonce_option_action', 'wkwc_adyen_option_nonce' );
						submit_button( esc_html__( 'Save Changes', 'wkwc-adyen' ) );
						?>
					</form>
				</div>
			</div>
			<?php
		}

		/**
		 * Webhook Description
		 *
		 * @return string
		 */
		public function wkwc_adyen_webhook_description() {
			$endpoint = add_query_arg( 'wc-api', 'wkwc_adyen', trailingslashit( get_home_url() ) );

			/* translators: %s: is Endpoint Url */
			return sprintf( __( 'To receive status updates from Adyen and sync payment statuses with WooCommerce, please add the following Webhook URL to your Adyen account <a href="https://docs.adyen.com/development-resources/notifications" target="_blank">server communication settings</a>. <strong style="background-color:#ddd;">&nbsp;%s&nbsp;</strong>', 'wkwc-adyen' ), $endpoint );
		}

	}
}
