<?php

/**
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\LegalEntityManagement;

use \ArrayAccess;
use Adyen\Model\LegalEntityManagement\ObjectSerializer;

/**
 * Organization Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Organization implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Organization';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dateOfIncorporation' => 'string',
        'description' => 'string',
        'doingBusinessAs' => 'string',
        'email' => 'string',
        'legalName' => 'string',
        'phone' => '\Adyen\Model\LegalEntityManagement\PhoneNumber',
        'principalPlaceOfBusiness' => '\Adyen\Model\LegalEntityManagement\Address',
        'registeredAddress' => '\Adyen\Model\LegalEntityManagement\Address',
        'registrationNumber' => 'string',
        'stockData' => '\Adyen\Model\LegalEntityManagement\StockData',
        'taxInformation' => '\Adyen\Model\LegalEntityManagement\TaxInformation[]',
        'taxReportingClassification' => '\Adyen\Model\LegalEntityManagement\TaxReportingClassification',
        'type' => 'string',
        'vatAbsenceReason' => 'string',
        'vatNumber' => 'string',
        'webData' => '\Adyen\Model\LegalEntityManagement\WebData'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dateOfIncorporation' => null,
        'description' => null,
        'doingBusinessAs' => null,
        'email' => null,
        'legalName' => null,
        'phone' => null,
        'principalPlaceOfBusiness' => null,
        'registeredAddress' => null,
        'registrationNumber' => null,
        'stockData' => null,
        'taxInformation' => null,
        'taxReportingClassification' => null,
        'type' => null,
        'vatAbsenceReason' => null,
        'vatNumber' => null,
        'webData' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'dateOfIncorporation' => false,
        'description' => false,
        'doingBusinessAs' => false,
        'email' => false,
        'legalName' => false,
        'phone' => false,
        'principalPlaceOfBusiness' => false,
        'registeredAddress' => false,
        'registrationNumber' => false,
        'stockData' => false,
        'taxInformation' => false,
        'taxReportingClassification' => false,
        'type' => false,
        'vatAbsenceReason' => false,
        'vatNumber' => false,
        'webData' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dateOfIncorporation' => 'dateOfIncorporation',
        'description' => 'description',
        'doingBusinessAs' => 'doingBusinessAs',
        'email' => 'email',
        'legalName' => 'legalName',
        'phone' => 'phone',
        'principalPlaceOfBusiness' => 'principalPlaceOfBusiness',
        'registeredAddress' => 'registeredAddress',
        'registrationNumber' => 'registrationNumber',
        'stockData' => 'stockData',
        'taxInformation' => 'taxInformation',
        'taxReportingClassification' => 'taxReportingClassification',
        'type' => 'type',
        'vatAbsenceReason' => 'vatAbsenceReason',
        'vatNumber' => 'vatNumber',
        'webData' => 'webData'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dateOfIncorporation' => 'setDateOfIncorporation',
        'description' => 'setDescription',
        'doingBusinessAs' => 'setDoingBusinessAs',
        'email' => 'setEmail',
        'legalName' => 'setLegalName',
        'phone' => 'setPhone',
        'principalPlaceOfBusiness' => 'setPrincipalPlaceOfBusiness',
        'registeredAddress' => 'setRegisteredAddress',
        'registrationNumber' => 'setRegistrationNumber',
        'stockData' => 'setStockData',
        'taxInformation' => 'setTaxInformation',
        'taxReportingClassification' => 'setTaxReportingClassification',
        'type' => 'setType',
        'vatAbsenceReason' => 'setVatAbsenceReason',
        'vatNumber' => 'setVatNumber',
        'webData' => 'setWebData'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dateOfIncorporation' => 'getDateOfIncorporation',
        'description' => 'getDescription',
        'doingBusinessAs' => 'getDoingBusinessAs',
        'email' => 'getEmail',
        'legalName' => 'getLegalName',
        'phone' => 'getPhone',
        'principalPlaceOfBusiness' => 'getPrincipalPlaceOfBusiness',
        'registeredAddress' => 'getRegisteredAddress',
        'registrationNumber' => 'getRegistrationNumber',
        'stockData' => 'getStockData',
        'taxInformation' => 'getTaxInformation',
        'taxReportingClassification' => 'getTaxReportingClassification',
        'type' => 'getType',
        'vatAbsenceReason' => 'getVatAbsenceReason',
        'vatNumber' => 'getVatNumber',
        'webData' => 'getWebData'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_ASSOCIATION_INCORPORATED = 'associationIncorporated';
    public const TYPE_GOVERNMENTAL_ORGANIZATION = 'governmentalOrganization';
    public const TYPE_LISTED_PUBLIC_COMPANY = 'listedPublicCompany';
    public const TYPE_NON_PROFIT = 'nonProfit';
    public const TYPE_PARTNERSHIP_INCORPORATED = 'partnershipIncorporated';
    public const TYPE_PRIVATE_COMPANY = 'privateCompany';
    public const VAT_ABSENCE_REASON_INDUSTRY_EXEMPTION = 'industryExemption';
    public const VAT_ABSENCE_REASON_BELOW_TAX_THRESHOLD = 'belowTaxThreshold';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ASSOCIATION_INCORPORATED,
            self::TYPE_GOVERNMENTAL_ORGANIZATION,
            self::TYPE_LISTED_PUBLIC_COMPANY,
            self::TYPE_NON_PROFIT,
            self::TYPE_PARTNERSHIP_INCORPORATED,
            self::TYPE_PRIVATE_COMPANY,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVatAbsenceReasonAllowableValues()
    {
        return [
            self::VAT_ABSENCE_REASON_INDUSTRY_EXEMPTION,
            self::VAT_ABSENCE_REASON_BELOW_TAX_THRESHOLD,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('dateOfIncorporation', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('doingBusinessAs', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('legalName', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('principalPlaceOfBusiness', $data ?? [], null);
        $this->setIfExists('registeredAddress', $data ?? [], null);
        $this->setIfExists('registrationNumber', $data ?? [], null);
        $this->setIfExists('stockData', $data ?? [], null);
        $this->setIfExists('taxInformation', $data ?? [], null);
        $this->setIfExists('taxReportingClassification', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('vatAbsenceReason', $data ?? [], null);
        $this->setIfExists('vatNumber', $data ?? [], null);
        $this->setIfExists('webData', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['legalName'] === null) {
            $invalidProperties[] = "'legalName' can't be null";
        }
        if ($this->container['registeredAddress'] === null) {
            $invalidProperties[] = "'registeredAddress' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getVatAbsenceReasonAllowableValues();
        if (!is_null($this->container['vatAbsenceReason']) && !in_array($this->container['vatAbsenceReason'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'vatAbsenceReason', must be one of '%s'",
                $this->container['vatAbsenceReason'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dateOfIncorporation
     *
     * @return string|null
     */
    public function getDateOfIncorporation()
    {
        return $this->container['dateOfIncorporation'];
    }

    /**
     * Sets dateOfIncorporation
     *
     * @param string|null $dateOfIncorporation The date when the organization was incorporated in YYYY-MM-DD format.
     *
     * @return self
     */
    public function setDateOfIncorporation($dateOfIncorporation)
    {
        $this->container['dateOfIncorporation'] = $dateOfIncorporation;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Your description for the organization.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets doingBusinessAs
     *
     * @return string|null
     */
    public function getDoingBusinessAs()
    {
        return $this->container['doingBusinessAs'];
    }

    /**
     * Sets doingBusinessAs
     *
     * @param string|null $doingBusinessAs The organization's trading name, if different from the registered legal name.
     *
     * @return self
     */
    public function setDoingBusinessAs($doingBusinessAs)
    {
        $this->container['doingBusinessAs'] = $doingBusinessAs;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email address of the legal entity.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets legalName
     *
     * @return string
     */
    public function getLegalName()
    {
        return $this->container['legalName'];
    }

    /**
     * Sets legalName
     *
     * @param string $legalName The organization's legal name.
     *
     * @return self
     */
    public function setLegalName($legalName)
    {
        $this->container['legalName'] = $legalName;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return \Adyen\Model\LegalEntityManagement\PhoneNumber|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param \Adyen\Model\LegalEntityManagement\PhoneNumber|null $phone phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets principalPlaceOfBusiness
     *
     * @return \Adyen\Model\LegalEntityManagement\Address|null
     */
    public function getPrincipalPlaceOfBusiness()
    {
        return $this->container['principalPlaceOfBusiness'];
    }

    /**
     * Sets principalPlaceOfBusiness
     *
     * @param \Adyen\Model\LegalEntityManagement\Address|null $principalPlaceOfBusiness principalPlaceOfBusiness
     *
     * @return self
     */
    public function setPrincipalPlaceOfBusiness($principalPlaceOfBusiness)
    {
        $this->container['principalPlaceOfBusiness'] = $principalPlaceOfBusiness;

        return $this;
    }

    /**
     * Gets registeredAddress
     *
     * @return \Adyen\Model\LegalEntityManagement\Address
     */
    public function getRegisteredAddress()
    {
        return $this->container['registeredAddress'];
    }

    /**
     * Sets registeredAddress
     *
     * @param \Adyen\Model\LegalEntityManagement\Address $registeredAddress registeredAddress
     *
     * @return self
     */
    public function setRegisteredAddress($registeredAddress)
    {
        $this->container['registeredAddress'] = $registeredAddress;

        return $this;
    }

    /**
     * Gets registrationNumber
     *
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->container['registrationNumber'];
    }

    /**
     * Sets registrationNumber
     *
     * @param string|null $registrationNumber The organization's registration number.
     *
     * @return self
     */
    public function setRegistrationNumber($registrationNumber)
    {
        $this->container['registrationNumber'] = $registrationNumber;

        return $this;
    }

    /**
     * Gets stockData
     *
     * @return \Adyen\Model\LegalEntityManagement\StockData|null
     */
    public function getStockData()
    {
        return $this->container['stockData'];
    }

    /**
     * Sets stockData
     *
     * @param \Adyen\Model\LegalEntityManagement\StockData|null $stockData stockData
     *
     * @return self
     */
    public function setStockData($stockData)
    {
        $this->container['stockData'] = $stockData;

        return $this;
    }

    /**
     * Gets taxInformation
     *
     * @return \Adyen\Model\LegalEntityManagement\TaxInformation[]|null
     */
    public function getTaxInformation()
    {
        return $this->container['taxInformation'];
    }

    /**
     * Sets taxInformation
     *
     * @param \Adyen\Model\LegalEntityManagement\TaxInformation[]|null $taxInformation The tax information of the organization.
     *
     * @return self
     */
    public function setTaxInformation($taxInformation)
    {
        $this->container['taxInformation'] = $taxInformation;

        return $this;
    }

    /**
     * Gets taxReportingClassification
     *
     * @return \Adyen\Model\LegalEntityManagement\TaxReportingClassification|null
     */
    public function getTaxReportingClassification()
    {
        return $this->container['taxReportingClassification'];
    }

    /**
     * Sets taxReportingClassification
     *
     * @param \Adyen\Model\LegalEntityManagement\TaxReportingClassification|null $taxReportingClassification taxReportingClassification
     *
     * @return self
     */
    public function setTaxReportingClassification($taxReportingClassification)
    {
        $this->container['taxReportingClassification'] = $taxReportingClassification;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Type of organization.  Possible values: **associationIncorporated**, **governmentalOrganization**, **listedPublicCompany**, **nonProfit**, **partnershipIncorporated**, **privateCompany**.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets vatAbsenceReason
     *
     * @return string|null
     */
    public function getVatAbsenceReason()
    {
        return $this->container['vatAbsenceReason'];
    }

    /**
     * Sets vatAbsenceReason
     *
     * @param string|null $vatAbsenceReason The reason the organization has not provided a VAT number.  Possible values: **industryExemption**, **belowTaxThreshold**.
     *
     * @return self
     */
    public function setVatAbsenceReason($vatAbsenceReason)
    {
        $allowedValues = $this->getVatAbsenceReasonAllowableValues();
        if (!in_array($vatAbsenceReason, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'vatAbsenceReason', must be one of '%s'",
                    $vatAbsenceReason,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['vatAbsenceReason'] = $vatAbsenceReason;

        return $this;
    }

    /**
     * Gets vatNumber
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vatNumber'];
    }

    /**
     * Sets vatNumber
     *
     * @param string|null $vatNumber The organization's VAT number.
     *
     * @return self
     */
    public function setVatNumber($vatNumber)
    {
        $this->container['vatNumber'] = $vatNumber;

        return $this;
    }

    /**
     * Gets webData
     *
     * @return \Adyen\Model\LegalEntityManagement\WebData|null
     */
    public function getWebData()
    {
        return $this->container['webData'];
    }

    /**
     * Sets webData
     *
     * @param \Adyen\Model\LegalEntityManagement\WebData|null $webData webData
     *
     * @return self
     */
    public function setWebData($webData)
    {
        $this->container['webData'] = $webData;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
