<?php

/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Management;

use \ArrayAccess;
use Adyen\Model\Management\ObjectSerializer;

/**
 * PaymentMethod Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentMethod implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentMethod';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'afterpayTouch' => '\Adyen\Model\Management\AfterpayTouchInfo',
        'allowed' => 'bool',
        'amex' => '\Adyen\Model\Management\AmexInfo',
        'applePay' => '\Adyen\Model\Management\ApplePayInfo',
        'bcmc' => '\Adyen\Model\Management\BcmcInfo',
        'businessLineId' => 'string',
        'cartesBancaires' => '\Adyen\Model\Management\CartesBancairesInfo',
        'clearpay' => '\Adyen\Model\Management\ClearpayInfo',
        'countries' => 'string[]',
        'cup' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'currencies' => 'string[]',
        'customRoutingFlags' => 'string[]',
        'diners' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'discover' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'eftposAustralia' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'enabled' => 'bool',
        'giroPay' => '\Adyen\Model\Management\GiroPayInfo',
        'girocard' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'googlePay' => '\Adyen\Model\Management\GooglePayInfo',
        'id' => 'string',
        'ideal' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'interacCard' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'jcb' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'klarna' => '\Adyen\Model\Management\KlarnaInfo',
        'maestro' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'mc' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'mealVoucherFR' => '\Adyen\Model\Management\MealVoucherFRInfo',
        'paypal' => '\Adyen\Model\Management\PayPalInfo',
        'reference' => 'string',
        'shopperInteraction' => 'string',
        'sofort' => '\Adyen\Model\Management\SofortInfo',
        'storeIds' => 'string[]',
        'swish' => '\Adyen\Model\Management\SwishInfo',
        'twint' => '\Adyen\Model\Management\TwintInfo',
        'type' => 'string',
        'verificationStatus' => 'string',
        'vipps' => '\Adyen\Model\Management\VippsInfo',
        'visa' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'wechatpay' => '\Adyen\Model\Management\WeChatPayInfo',
        'wechatpayPos' => '\Adyen\Model\Management\WeChatPayPosInfo'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'afterpayTouch' => null,
        'allowed' => null,
        'amex' => null,
        'applePay' => null,
        'bcmc' => null,
        'businessLineId' => null,
        'cartesBancaires' => null,
        'clearpay' => null,
        'countries' => null,
        'cup' => null,
        'currencies' => null,
        'customRoutingFlags' => null,
        'diners' => null,
        'discover' => null,
        'eftposAustralia' => null,
        'enabled' => null,
        'giroPay' => null,
        'girocard' => null,
        'googlePay' => null,
        'id' => null,
        'ideal' => null,
        'interacCard' => null,
        'jcb' => null,
        'klarna' => null,
        'maestro' => null,
        'mc' => null,
        'mealVoucherFR' => null,
        'paypal' => null,
        'reference' => null,
        'shopperInteraction' => null,
        'sofort' => null,
        'storeIds' => null,
        'swish' => null,
        'twint' => null,
        'type' => null,
        'verificationStatus' => null,
        'vipps' => null,
        'visa' => null,
        'wechatpay' => null,
        'wechatpayPos' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'afterpayTouch' => false,
        'allowed' => false,
        'amex' => false,
        'applePay' => false,
        'bcmc' => false,
        'businessLineId' => false,
        'cartesBancaires' => false,
        'clearpay' => false,
        'countries' => false,
        'cup' => false,
        'currencies' => false,
        'customRoutingFlags' => false,
        'diners' => false,
        'discover' => false,
        'eftposAustralia' => false,
        'enabled' => false,
        'giroPay' => false,
        'girocard' => false,
        'googlePay' => false,
        'id' => false,
        'ideal' => false,
        'interacCard' => false,
        'jcb' => false,
        'klarna' => false,
        'maestro' => false,
        'mc' => false,
        'mealVoucherFR' => false,
        'paypal' => false,
        'reference' => false,
        'shopperInteraction' => false,
        'sofort' => false,
        'storeIds' => false,
        'swish' => false,
        'twint' => false,
        'type' => false,
        'verificationStatus' => false,
        'vipps' => false,
        'visa' => false,
        'wechatpay' => false,
        'wechatpayPos' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'afterpayTouch' => 'afterpayTouch',
        'allowed' => 'allowed',
        'amex' => 'amex',
        'applePay' => 'applePay',
        'bcmc' => 'bcmc',
        'businessLineId' => 'businessLineId',
        'cartesBancaires' => 'cartesBancaires',
        'clearpay' => 'clearpay',
        'countries' => 'countries',
        'cup' => 'cup',
        'currencies' => 'currencies',
        'customRoutingFlags' => 'customRoutingFlags',
        'diners' => 'diners',
        'discover' => 'discover',
        'eftposAustralia' => 'eftpos_australia',
        'enabled' => 'enabled',
        'giroPay' => 'giroPay',
        'girocard' => 'girocard',
        'googlePay' => 'googlePay',
        'id' => 'id',
        'ideal' => 'ideal',
        'interacCard' => 'interac_card',
        'jcb' => 'jcb',
        'klarna' => 'klarna',
        'maestro' => 'maestro',
        'mc' => 'mc',
        'mealVoucherFR' => 'mealVoucher_FR',
        'paypal' => 'paypal',
        'reference' => 'reference',
        'shopperInteraction' => 'shopperInteraction',
        'sofort' => 'sofort',
        'storeIds' => 'storeIds',
        'swish' => 'swish',
        'twint' => 'twint',
        'type' => 'type',
        'verificationStatus' => 'verificationStatus',
        'vipps' => 'vipps',
        'visa' => 'visa',
        'wechatpay' => 'wechatpay',
        'wechatpayPos' => 'wechatpay_pos'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'afterpayTouch' => 'setAfterpayTouch',
        'allowed' => 'setAllowed',
        'amex' => 'setAmex',
        'applePay' => 'setApplePay',
        'bcmc' => 'setBcmc',
        'businessLineId' => 'setBusinessLineId',
        'cartesBancaires' => 'setCartesBancaires',
        'clearpay' => 'setClearpay',
        'countries' => 'setCountries',
        'cup' => 'setCup',
        'currencies' => 'setCurrencies',
        'customRoutingFlags' => 'setCustomRoutingFlags',
        'diners' => 'setDiners',
        'discover' => 'setDiscover',
        'eftposAustralia' => 'setEftposAustralia',
        'enabled' => 'setEnabled',
        'giroPay' => 'setGiroPay',
        'girocard' => 'setGirocard',
        'googlePay' => 'setGooglePay',
        'id' => 'setId',
        'ideal' => 'setIdeal',
        'interacCard' => 'setInteracCard',
        'jcb' => 'setJcb',
        'klarna' => 'setKlarna',
        'maestro' => 'setMaestro',
        'mc' => 'setMc',
        'mealVoucherFR' => 'setMealVoucherFR',
        'paypal' => 'setPaypal',
        'reference' => 'setReference',
        'shopperInteraction' => 'setShopperInteraction',
        'sofort' => 'setSofort',
        'storeIds' => 'setStoreIds',
        'swish' => 'setSwish',
        'twint' => 'setTwint',
        'type' => 'setType',
        'verificationStatus' => 'setVerificationStatus',
        'vipps' => 'setVipps',
        'visa' => 'setVisa',
        'wechatpay' => 'setWechatpay',
        'wechatpayPos' => 'setWechatpayPos'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'afterpayTouch' => 'getAfterpayTouch',
        'allowed' => 'getAllowed',
        'amex' => 'getAmex',
        'applePay' => 'getApplePay',
        'bcmc' => 'getBcmc',
        'businessLineId' => 'getBusinessLineId',
        'cartesBancaires' => 'getCartesBancaires',
        'clearpay' => 'getClearpay',
        'countries' => 'getCountries',
        'cup' => 'getCup',
        'currencies' => 'getCurrencies',
        'customRoutingFlags' => 'getCustomRoutingFlags',
        'diners' => 'getDiners',
        'discover' => 'getDiscover',
        'eftposAustralia' => 'getEftposAustralia',
        'enabled' => 'getEnabled',
        'giroPay' => 'getGiroPay',
        'girocard' => 'getGirocard',
        'googlePay' => 'getGooglePay',
        'id' => 'getId',
        'ideal' => 'getIdeal',
        'interacCard' => 'getInteracCard',
        'jcb' => 'getJcb',
        'klarna' => 'getKlarna',
        'maestro' => 'getMaestro',
        'mc' => 'getMc',
        'mealVoucherFR' => 'getMealVoucherFR',
        'paypal' => 'getPaypal',
        'reference' => 'getReference',
        'shopperInteraction' => 'getShopperInteraction',
        'sofort' => 'getSofort',
        'storeIds' => 'getStoreIds',
        'swish' => 'getSwish',
        'twint' => 'getTwint',
        'type' => 'getType',
        'verificationStatus' => 'getVerificationStatus',
        'vipps' => 'getVipps',
        'visa' => 'getVisa',
        'wechatpay' => 'getWechatpay',
        'wechatpayPos' => 'getWechatpayPos'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const VERIFICATION_STATUS_VALID = 'valid';
    public const VERIFICATION_STATUS_PENDING = 'pending';
    public const VERIFICATION_STATUS_INVALID = 'invalid';
    public const VERIFICATION_STATUS_REJECTED = 'rejected';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVerificationStatusAllowableValues()
    {
        return [
            self::VERIFICATION_STATUS_VALID,
            self::VERIFICATION_STATUS_PENDING,
            self::VERIFICATION_STATUS_INVALID,
            self::VERIFICATION_STATUS_REJECTED,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('afterpayTouch', $data ?? [], null);
        $this->setIfExists('allowed', $data ?? [], null);
        $this->setIfExists('amex', $data ?? [], null);
        $this->setIfExists('applePay', $data ?? [], null);
        $this->setIfExists('bcmc', $data ?? [], null);
        $this->setIfExists('businessLineId', $data ?? [], null);
        $this->setIfExists('cartesBancaires', $data ?? [], null);
        $this->setIfExists('clearpay', $data ?? [], null);
        $this->setIfExists('countries', $data ?? [], null);
        $this->setIfExists('cup', $data ?? [], null);
        $this->setIfExists('currencies', $data ?? [], null);
        $this->setIfExists('customRoutingFlags', $data ?? [], null);
        $this->setIfExists('diners', $data ?? [], null);
        $this->setIfExists('discover', $data ?? [], null);
        $this->setIfExists('eftposAustralia', $data ?? [], null);
        $this->setIfExists('enabled', $data ?? [], null);
        $this->setIfExists('giroPay', $data ?? [], null);
        $this->setIfExists('girocard', $data ?? [], null);
        $this->setIfExists('googlePay', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('ideal', $data ?? [], null);
        $this->setIfExists('interacCard', $data ?? [], null);
        $this->setIfExists('jcb', $data ?? [], null);
        $this->setIfExists('klarna', $data ?? [], null);
        $this->setIfExists('maestro', $data ?? [], null);
        $this->setIfExists('mc', $data ?? [], null);
        $this->setIfExists('mealVoucherFR', $data ?? [], null);
        $this->setIfExists('paypal', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('shopperInteraction', $data ?? [], null);
        $this->setIfExists('sofort', $data ?? [], null);
        $this->setIfExists('storeIds', $data ?? [], null);
        $this->setIfExists('swish', $data ?? [], null);
        $this->setIfExists('twint', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('verificationStatus', $data ?? [], null);
        $this->setIfExists('vipps', $data ?? [], null);
        $this->setIfExists('visa', $data ?? [], null);
        $this->setIfExists('wechatpay', $data ?? [], null);
        $this->setIfExists('wechatpayPos', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        $allowedValues = $this->getVerificationStatusAllowableValues();
        if (!is_null($this->container['verificationStatus']) && !in_array($this->container['verificationStatus'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'verificationStatus', must be one of '%s'",
                $this->container['verificationStatus'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets afterpayTouch
     *
     * @return \Adyen\Model\Management\AfterpayTouchInfo|null
     */
    public function getAfterpayTouch()
    {
        return $this->container['afterpayTouch'];
    }

    /**
     * Sets afterpayTouch
     *
     * @param \Adyen\Model\Management\AfterpayTouchInfo|null $afterpayTouch afterpayTouch
     *
     * @return self
     */
    public function setAfterpayTouch($afterpayTouch)
    {
        $this->container['afterpayTouch'] = $afterpayTouch;

        return $this;
    }

    /**
     * Gets allowed
     *
     * @return bool|null
     */
    public function getAllowed()
    {
        return $this->container['allowed'];
    }

    /**
     * Sets allowed
     *
     * @param bool|null $allowed Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.
     *
     * @return self
     */
    public function setAllowed($allowed)
    {
        $this->container['allowed'] = $allowed;

        return $this;
    }

    /**
     * Gets amex
     *
     * @return \Adyen\Model\Management\AmexInfo|null
     */
    public function getAmex()
    {
        return $this->container['amex'];
    }

    /**
     * Sets amex
     *
     * @param \Adyen\Model\Management\AmexInfo|null $amex amex
     *
     * @return self
     */
    public function setAmex($amex)
    {
        $this->container['amex'] = $amex;

        return $this;
    }

    /**
     * Gets applePay
     *
     * @return \Adyen\Model\Management\ApplePayInfo|null
     */
    public function getApplePay()
    {
        return $this->container['applePay'];
    }

    /**
     * Sets applePay
     *
     * @param \Adyen\Model\Management\ApplePayInfo|null $applePay applePay
     *
     * @return self
     */
    public function setApplePay($applePay)
    {
        $this->container['applePay'] = $applePay;

        return $this;
    }

    /**
     * Gets bcmc
     *
     * @return \Adyen\Model\Management\BcmcInfo|null
     */
    public function getBcmc()
    {
        return $this->container['bcmc'];
    }

    /**
     * Sets bcmc
     *
     * @param \Adyen\Model\Management\BcmcInfo|null $bcmc bcmc
     *
     * @return self
     */
    public function setBcmc($bcmc)
    {
        $this->container['bcmc'] = $bcmc;

        return $this;
    }

    /**
     * Gets businessLineId
     *
     * @return string|null
     */
    public function getBusinessLineId()
    {
        return $this->container['businessLineId'];
    }

    /**
     * Sets businessLineId
     *
     * @param string|null $businessLineId The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
     *
     * @return self
     */
    public function setBusinessLineId($businessLineId)
    {
        $this->container['businessLineId'] = $businessLineId;

        return $this;
    }

    /**
     * Gets cartesBancaires
     *
     * @return \Adyen\Model\Management\CartesBancairesInfo|null
     */
    public function getCartesBancaires()
    {
        return $this->container['cartesBancaires'];
    }

    /**
     * Sets cartesBancaires
     *
     * @param \Adyen\Model\Management\CartesBancairesInfo|null $cartesBancaires cartesBancaires
     *
     * @return self
     */
    public function setCartesBancaires($cartesBancaires)
    {
        $this->container['cartesBancaires'] = $cartesBancaires;

        return $this;
    }

    /**
     * Gets clearpay
     *
     * @return \Adyen\Model\Management\ClearpayInfo|null
     */
    public function getClearpay()
    {
        return $this->container['clearpay'];
    }

    /**
     * Sets clearpay
     *
     * @param \Adyen\Model\Management\ClearpayInfo|null $clearpay clearpay
     *
     * @return self
     */
    public function setClearpay($clearpay)
    {
        $this->container['clearpay'] = $clearpay;

        return $this;
    }

    /**
     * Gets countries
     *
     * @return string[]|null
     */
    public function getCountries()
    {
        return $this->container['countries'];
    }

    /**
     * Sets countries
     *
     * @param string[]|null $countries The list of countries where a payment method is available. By default, all countries supported by the payment method.
     *
     * @return self
     */
    public function setCountries($countries)
    {
        $this->container['countries'] = $countries;

        return $this;
    }

    /**
     * Gets cup
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getCup()
    {
        return $this->container['cup'];
    }

    /**
     * Sets cup
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $cup cup
     *
     * @return self
     */
    public function setCup($cup)
    {
        $this->container['cup'] = $cup;

        return $this;
    }

    /**
     * Gets currencies
     *
     * @return string[]|null
     */
    public function getCurrencies()
    {
        return $this->container['currencies'];
    }

    /**
     * Sets currencies
     *
     * @param string[]|null $currencies The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
     *
     * @return self
     */
    public function setCurrencies($currencies)
    {
        $this->container['currencies'] = $currencies;

        return $this;
    }

    /**
     * Gets customRoutingFlags
     *
     * @return string[]|null
     */
    public function getCustomRoutingFlags()
    {
        return $this->container['customRoutingFlags'];
    }

    /**
     * Sets customRoutingFlags
     *
     * @param string[]|null $customRoutingFlags The list of custom routing flags to route payment to the intended acquirer.
     *
     * @return self
     */
    public function setCustomRoutingFlags($customRoutingFlags)
    {
        $this->container['customRoutingFlags'] = $customRoutingFlags;

        return $this;
    }

    /**
     * Gets diners
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getDiners()
    {
        return $this->container['diners'];
    }

    /**
     * Sets diners
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $diners diners
     *
     * @return self
     */
    public function setDiners($diners)
    {
        $this->container['diners'] = $diners;

        return $this;
    }

    /**
     * Gets discover
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getDiscover()
    {
        return $this->container['discover'];
    }

    /**
     * Sets discover
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $discover discover
     *
     * @return self
     */
    public function setDiscover($discover)
    {
        $this->container['discover'] = $discover;

        return $this;
    }

    /**
     * Gets eftposAustralia
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getEftposAustralia()
    {
        return $this->container['eftposAustralia'];
    }

    /**
     * Sets eftposAustralia
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $eftposAustralia eftposAustralia
     *
     * @return self
     */
    public function setEftposAustralia($eftposAustralia)
    {
        $this->container['eftposAustralia'] = $eftposAustralia;

        return $this;
    }

    /**
     * Gets enabled
     *
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     *
     * @param bool|null $enabled Indicates whether the payment method is enabled (**true**) or disabled (**false**).
     *
     * @return self
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets giroPay
     *
     * @return \Adyen\Model\Management\GiroPayInfo|null
     */
    public function getGiroPay()
    {
        return $this->container['giroPay'];
    }

    /**
     * Sets giroPay
     *
     * @param \Adyen\Model\Management\GiroPayInfo|null $giroPay giroPay
     *
     * @return self
     */
    public function setGiroPay($giroPay)
    {
        $this->container['giroPay'] = $giroPay;

        return $this;
    }

    /**
     * Gets girocard
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getGirocard()
    {
        return $this->container['girocard'];
    }

    /**
     * Sets girocard
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $girocard girocard
     *
     * @return self
     */
    public function setGirocard($girocard)
    {
        $this->container['girocard'] = $girocard;

        return $this;
    }

    /**
     * Gets googlePay
     *
     * @return \Adyen\Model\Management\GooglePayInfo|null
     */
    public function getGooglePay()
    {
        return $this->container['googlePay'];
    }

    /**
     * Sets googlePay
     *
     * @param \Adyen\Model\Management\GooglePayInfo|null $googlePay googlePay
     *
     * @return self
     */
    public function setGooglePay($googlePay)
    {
        $this->container['googlePay'] = $googlePay;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The identifier of the resource.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets ideal
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getIdeal()
    {
        return $this->container['ideal'];
    }

    /**
     * Sets ideal
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $ideal ideal
     *
     * @return self
     */
    public function setIdeal($ideal)
    {
        $this->container['ideal'] = $ideal;

        return $this;
    }

    /**
     * Gets interacCard
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getInteracCard()
    {
        return $this->container['interacCard'];
    }

    /**
     * Sets interacCard
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $interacCard interacCard
     *
     * @return self
     */
    public function setInteracCard($interacCard)
    {
        $this->container['interacCard'] = $interacCard;

        return $this;
    }

    /**
     * Gets jcb
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getJcb()
    {
        return $this->container['jcb'];
    }

    /**
     * Sets jcb
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $jcb jcb
     *
     * @return self
     */
    public function setJcb($jcb)
    {
        $this->container['jcb'] = $jcb;

        return $this;
    }

    /**
     * Gets klarna
     *
     * @return \Adyen\Model\Management\KlarnaInfo|null
     */
    public function getKlarna()
    {
        return $this->container['klarna'];
    }

    /**
     * Sets klarna
     *
     * @param \Adyen\Model\Management\KlarnaInfo|null $klarna klarna
     *
     * @return self
     */
    public function setKlarna($klarna)
    {
        $this->container['klarna'] = $klarna;

        return $this;
    }

    /**
     * Gets maestro
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getMaestro()
    {
        return $this->container['maestro'];
    }

    /**
     * Sets maestro
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $maestro maestro
     *
     * @return self
     */
    public function setMaestro($maestro)
    {
        $this->container['maestro'] = $maestro;

        return $this;
    }

    /**
     * Gets mc
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getMc()
    {
        return $this->container['mc'];
    }

    /**
     * Sets mc
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $mc mc
     *
     * @return self
     */
    public function setMc($mc)
    {
        $this->container['mc'] = $mc;

        return $this;
    }

    /**
     * Gets mealVoucherFR
     *
     * @return \Adyen\Model\Management\MealVoucherFRInfo|null
     */
    public function getMealVoucherFR()
    {
        return $this->container['mealVoucherFR'];
    }

    /**
     * Sets mealVoucherFR
     *
     * @param \Adyen\Model\Management\MealVoucherFRInfo|null $mealVoucherFR mealVoucherFR
     *
     * @return self
     */
    public function setMealVoucherFR($mealVoucherFR)
    {
        $this->container['mealVoucherFR'] = $mealVoucherFR;

        return $this;
    }

    /**
     * Gets paypal
     *
     * @return \Adyen\Model\Management\PayPalInfo|null
     */
    public function getPaypal()
    {
        return $this->container['paypal'];
    }

    /**
     * Sets paypal
     *
     * @param \Adyen\Model\Management\PayPalInfo|null $paypal paypal
     *
     * @return self
     */
    public function setPaypal($paypal)
    {
        $this->container['paypal'] = $paypal;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets shopperInteraction
     *
     * @return string|null
     */
    public function getShopperInteraction()
    {
        return $this->container['shopperInteraction'];
    }

    /**
     * Sets shopperInteraction
     *
     * @param string|null $shopperInteraction The sales channel.
     *
     * @return self
     */
    public function setShopperInteraction($shopperInteraction)
    {
        $this->container['shopperInteraction'] = $shopperInteraction;

        return $this;
    }

    /**
     * Gets sofort
     *
     * @return \Adyen\Model\Management\SofortInfo|null
     */
    public function getSofort()
    {
        return $this->container['sofort'];
    }

    /**
     * Sets sofort
     *
     * @param \Adyen\Model\Management\SofortInfo|null $sofort sofort
     *
     * @return self
     */
    public function setSofort($sofort)
    {
        $this->container['sofort'] = $sofort;

        return $this;
    }

    /**
     * Gets storeIds
     *
     * @return string[]|null
     */
    public function getStoreIds()
    {
        return $this->container['storeIds'];
    }

    /**
     * Sets storeIds
     *
     * @param string[]|null $storeIds The unique identifier of the store for which to configure the payment method, if any.
     *
     * @return self
     */
    public function setStoreIds($storeIds)
    {
        $this->container['storeIds'] = $storeIds;

        return $this;
    }

    /**
     * Gets swish
     *
     * @return \Adyen\Model\Management\SwishInfo|null
     */
    public function getSwish()
    {
        return $this->container['swish'];
    }

    /**
     * Sets swish
     *
     * @param \Adyen\Model\Management\SwishInfo|null $swish swish
     *
     * @return self
     */
    public function setSwish($swish)
    {
        $this->container['swish'] = $swish;

        return $this;
    }

    /**
     * Gets twint
     *
     * @return \Adyen\Model\Management\TwintInfo|null
     */
    public function getTwint()
    {
        return $this->container['twint'];
    }

    /**
     * Sets twint
     *
     * @param \Adyen\Model\Management\TwintInfo|null $twint twint
     *
     * @return self
     */
    public function setTwint($twint)
    {
        $this->container['twint'] = $twint;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets verificationStatus
     *
     * @return string|null
     */
    public function getVerificationStatus()
    {
        return $this->container['verificationStatus'];
    }

    /**
     * Sets verificationStatus
     *
     * @param string|null $verificationStatus Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
     *
     * @return self
     */
    public function setVerificationStatus($verificationStatus)
    {
        $allowedValues = $this->getVerificationStatusAllowableValues();
        if (!in_array($verificationStatus, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'verificationStatus', must be one of '%s'",
                    $verificationStatus,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['verificationStatus'] = $verificationStatus;

        return $this;
    }

    /**
     * Gets vipps
     *
     * @return \Adyen\Model\Management\VippsInfo|null
     */
    public function getVipps()
    {
        return $this->container['vipps'];
    }

    /**
     * Sets vipps
     *
     * @param \Adyen\Model\Management\VippsInfo|null $vipps vipps
     *
     * @return self
     */
    public function setVipps($vipps)
    {
        $this->container['vipps'] = $vipps;

        return $this;
    }

    /**
     * Gets visa
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getVisa()
    {
        return $this->container['visa'];
    }

    /**
     * Sets visa
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $visa visa
     *
     * @return self
     */
    public function setVisa($visa)
    {
        $this->container['visa'] = $visa;

        return $this;
    }

    /**
     * Gets wechatpay
     *
     * @return \Adyen\Model\Management\WeChatPayInfo|null
     */
    public function getWechatpay()
    {
        return $this->container['wechatpay'];
    }

    /**
     * Sets wechatpay
     *
     * @param \Adyen\Model\Management\WeChatPayInfo|null $wechatpay wechatpay
     *
     * @return self
     */
    public function setWechatpay($wechatpay)
    {
        $this->container['wechatpay'] = $wechatpay;

        return $this;
    }

    /**
     * Gets wechatpayPos
     *
     * @return \Adyen\Model\Management\WeChatPayPosInfo|null
     */
    public function getWechatpayPos()
    {
        return $this->container['wechatpayPos'];
    }

    /**
     * Sets wechatpayPos
     *
     * @param \Adyen\Model\Management\WeChatPayPosInfo|null $wechatpayPos wechatpayPos
     *
     * @return self
     */
    public function setWechatpayPos($wechatpayPos)
    {
        $this->container['wechatpayPos'] = $wechatpayPos;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
