<?php

/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Management;

use \ArrayAccess;
use Adyen\Model\Management\ObjectSerializer;

/**
 * SplitConfigurationLogic Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SplitConfigurationLogic implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SplitConfigurationLogic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'acquiringFees' => 'string',
        'additionalCommission' => '\Adyen\Model\Management\AdditionalCommission',
        'adyenCommission' => 'string',
        'adyenFees' => 'string',
        'adyenMarkup' => 'string',
        'chargeback' => 'string',
        'chargebackCostAllocation' => 'string',
        'commission' => '\Adyen\Model\Management\Commission',
        'interchange' => 'string',
        'paymentFee' => 'string',
        'refund' => 'string',
        'refundCostAllocation' => 'string',
        'remainder' => 'string',
        'schemeFee' => 'string',
        'splitLogicId' => 'string',
        'surcharge' => 'string',
        'tip' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'acquiringFees' => null,
        'additionalCommission' => null,
        'adyenCommission' => null,
        'adyenFees' => null,
        'adyenMarkup' => null,
        'chargeback' => null,
        'chargebackCostAllocation' => null,
        'commission' => null,
        'interchange' => null,
        'paymentFee' => null,
        'refund' => null,
        'refundCostAllocation' => null,
        'remainder' => null,
        'schemeFee' => null,
        'splitLogicId' => null,
        'surcharge' => null,
        'tip' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'acquiringFees' => false,
        'additionalCommission' => false,
        'adyenCommission' => false,
        'adyenFees' => false,
        'adyenMarkup' => false,
        'chargeback' => false,
        'chargebackCostAllocation' => false,
        'commission' => false,
        'interchange' => false,
        'paymentFee' => false,
        'refund' => false,
        'refundCostAllocation' => false,
        'remainder' => false,
        'schemeFee' => false,
        'splitLogicId' => false,
        'surcharge' => false,
        'tip' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'acquiringFees' => 'acquiringFees',
        'additionalCommission' => 'additionalCommission',
        'adyenCommission' => 'adyenCommission',
        'adyenFees' => 'adyenFees',
        'adyenMarkup' => 'adyenMarkup',
        'chargeback' => 'chargeback',
        'chargebackCostAllocation' => 'chargebackCostAllocation',
        'commission' => 'commission',
        'interchange' => 'interchange',
        'paymentFee' => 'paymentFee',
        'refund' => 'refund',
        'refundCostAllocation' => 'refundCostAllocation',
        'remainder' => 'remainder',
        'schemeFee' => 'schemeFee',
        'splitLogicId' => 'splitLogicId',
        'surcharge' => 'surcharge',
        'tip' => 'tip'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'acquiringFees' => 'setAcquiringFees',
        'additionalCommission' => 'setAdditionalCommission',
        'adyenCommission' => 'setAdyenCommission',
        'adyenFees' => 'setAdyenFees',
        'adyenMarkup' => 'setAdyenMarkup',
        'chargeback' => 'setChargeback',
        'chargebackCostAllocation' => 'setChargebackCostAllocation',
        'commission' => 'setCommission',
        'interchange' => 'setInterchange',
        'paymentFee' => 'setPaymentFee',
        'refund' => 'setRefund',
        'refundCostAllocation' => 'setRefundCostAllocation',
        'remainder' => 'setRemainder',
        'schemeFee' => 'setSchemeFee',
        'splitLogicId' => 'setSplitLogicId',
        'surcharge' => 'setSurcharge',
        'tip' => 'setTip'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'acquiringFees' => 'getAcquiringFees',
        'additionalCommission' => 'getAdditionalCommission',
        'adyenCommission' => 'getAdyenCommission',
        'adyenFees' => 'getAdyenFees',
        'adyenMarkup' => 'getAdyenMarkup',
        'chargeback' => 'getChargeback',
        'chargebackCostAllocation' => 'getChargebackCostAllocation',
        'commission' => 'getCommission',
        'interchange' => 'getInterchange',
        'paymentFee' => 'getPaymentFee',
        'refund' => 'getRefund',
        'refundCostAllocation' => 'getRefundCostAllocation',
        'remainder' => 'getRemainder',
        'schemeFee' => 'getSchemeFee',
        'splitLogicId' => 'getSplitLogicId',
        'surcharge' => 'getSurcharge',
        'tip' => 'getTip'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ACQUIRING_FEES_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const ACQUIRING_FEES_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const ADYEN_COMMISSION_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const ADYEN_COMMISSION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const ADYEN_FEES_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const ADYEN_FEES_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const ADYEN_MARKUP_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const ADYEN_MARKUP_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const CHARGEBACK_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const CHARGEBACK_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const CHARGEBACK_DEDUCT_ACCORDING_TO_SPLIT_RATIO = 'deductAccordingToSplitRatio';
    public const CHARGEBACK_COST_ALLOCATION_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const CHARGEBACK_COST_ALLOCATION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const INTERCHANGE_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const INTERCHANGE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const PAYMENT_FEE_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const PAYMENT_FEE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const REFUND_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const REFUND_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const REFUND_DEDUCT_ACCORDING_TO_SPLIT_RATIO = 'deductAccordingToSplitRatio';
    public const REFUND_COST_ALLOCATION_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const REFUND_COST_ALLOCATION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const REMAINDER_ADD_TO_LIABLE_ACCOUNT = 'addToLiableAccount';
    public const REMAINDER_ADD_TO_ONE_BALANCE_ACCOUNT = 'addToOneBalanceAccount';
    public const SCHEME_FEE_DEDUCT_FROM_LIABLE_ACCOUNT = 'deductFromLiableAccount';
    public const SCHEME_FEE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT = 'deductFromOneBalanceAccount';
    public const SURCHARGE_ADD_TO_LIABLE_ACCOUNT = 'addToLiableAccount';
    public const SURCHARGE_ADD_TO_ONE_BALANCE_ACCOUNT = 'addToOneBalanceAccount';
    public const TIP_ADD_TO_LIABLE_ACCOUNT = 'addToLiableAccount';
    public const TIP_ADD_TO_ONE_BALANCE_ACCOUNT = 'addToOneBalanceAccount';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAcquiringFeesAllowableValues()
    {
        return [
            self::ACQUIRING_FEES_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::ACQUIRING_FEES_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAdyenCommissionAllowableValues()
    {
        return [
            self::ADYEN_COMMISSION_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::ADYEN_COMMISSION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAdyenFeesAllowableValues()
    {
        return [
            self::ADYEN_FEES_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::ADYEN_FEES_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAdyenMarkupAllowableValues()
    {
        return [
            self::ADYEN_MARKUP_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::ADYEN_MARKUP_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getChargebackAllowableValues()
    {
        return [
            self::CHARGEBACK_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::CHARGEBACK_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
            self::CHARGEBACK_DEDUCT_ACCORDING_TO_SPLIT_RATIO,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getChargebackCostAllocationAllowableValues()
    {
        return [
            self::CHARGEBACK_COST_ALLOCATION_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::CHARGEBACK_COST_ALLOCATION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getInterchangeAllowableValues()
    {
        return [
            self::INTERCHANGE_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::INTERCHANGE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPaymentFeeAllowableValues()
    {
        return [
            self::PAYMENT_FEE_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::PAYMENT_FEE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundAllowableValues()
    {
        return [
            self::REFUND_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::REFUND_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
            self::REFUND_DEDUCT_ACCORDING_TO_SPLIT_RATIO,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundCostAllocationAllowableValues()
    {
        return [
            self::REFUND_COST_ALLOCATION_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::REFUND_COST_ALLOCATION_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRemainderAllowableValues()
    {
        return [
            self::REMAINDER_ADD_TO_LIABLE_ACCOUNT,
            self::REMAINDER_ADD_TO_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSchemeFeeAllowableValues()
    {
        return [
            self::SCHEME_FEE_DEDUCT_FROM_LIABLE_ACCOUNT,
            self::SCHEME_FEE_DEDUCT_FROM_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSurchargeAllowableValues()
    {
        return [
            self::SURCHARGE_ADD_TO_LIABLE_ACCOUNT,
            self::SURCHARGE_ADD_TO_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTipAllowableValues()
    {
        return [
            self::TIP_ADD_TO_LIABLE_ACCOUNT,
            self::TIP_ADD_TO_ONE_BALANCE_ACCOUNT,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('acquiringFees', $data ?? [], null);
        $this->setIfExists('additionalCommission', $data ?? [], null);
        $this->setIfExists('adyenCommission', $data ?? [], null);
        $this->setIfExists('adyenFees', $data ?? [], null);
        $this->setIfExists('adyenMarkup', $data ?? [], null);
        $this->setIfExists('chargeback', $data ?? [], null);
        $this->setIfExists('chargebackCostAllocation', $data ?? [], null);
        $this->setIfExists('commission', $data ?? [], null);
        $this->setIfExists('interchange', $data ?? [], null);
        $this->setIfExists('paymentFee', $data ?? [], null);
        $this->setIfExists('refund', $data ?? [], null);
        $this->setIfExists('refundCostAllocation', $data ?? [], null);
        $this->setIfExists('remainder', $data ?? [], null);
        $this->setIfExists('schemeFee', $data ?? [], null);
        $this->setIfExists('splitLogicId', $data ?? [], null);
        $this->setIfExists('surcharge', $data ?? [], null);
        $this->setIfExists('tip', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAcquiringFeesAllowableValues();
        if (!is_null($this->container['acquiringFees']) && !in_array($this->container['acquiringFees'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'acquiringFees', must be one of '%s'",
                $this->container['acquiringFees'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAdyenCommissionAllowableValues();
        if (!is_null($this->container['adyenCommission']) && !in_array($this->container['adyenCommission'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'adyenCommission', must be one of '%s'",
                $this->container['adyenCommission'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAdyenFeesAllowableValues();
        if (!is_null($this->container['adyenFees']) && !in_array($this->container['adyenFees'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'adyenFees', must be one of '%s'",
                $this->container['adyenFees'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAdyenMarkupAllowableValues();
        if (!is_null($this->container['adyenMarkup']) && !in_array($this->container['adyenMarkup'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'adyenMarkup', must be one of '%s'",
                $this->container['adyenMarkup'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getChargebackAllowableValues();
        if (!is_null($this->container['chargeback']) && !in_array($this->container['chargeback'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'chargeback', must be one of '%s'",
                $this->container['chargeback'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getChargebackCostAllocationAllowableValues();
        if (!is_null($this->container['chargebackCostAllocation']) && !in_array($this->container['chargebackCostAllocation'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'chargebackCostAllocation', must be one of '%s'",
                $this->container['chargebackCostAllocation'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['commission'] === null) {
            $invalidProperties[] = "'commission' can't be null";
        }
        $allowedValues = $this->getInterchangeAllowableValues();
        if (!is_null($this->container['interchange']) && !in_array($this->container['interchange'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'interchange', must be one of '%s'",
                $this->container['interchange'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPaymentFeeAllowableValues();
        if (!is_null($this->container['paymentFee']) && !in_array($this->container['paymentFee'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'paymentFee', must be one of '%s'",
                $this->container['paymentFee'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRefundAllowableValues();
        if (!is_null($this->container['refund']) && !in_array($this->container['refund'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund', must be one of '%s'",
                $this->container['refund'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRefundCostAllocationAllowableValues();
        if (!is_null($this->container['refundCostAllocation']) && !in_array($this->container['refundCostAllocation'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refundCostAllocation', must be one of '%s'",
                $this->container['refundCostAllocation'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRemainderAllowableValues();
        if (!is_null($this->container['remainder']) && !in_array($this->container['remainder'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'remainder', must be one of '%s'",
                $this->container['remainder'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getSchemeFeeAllowableValues();
        if (!is_null($this->container['schemeFee']) && !in_array($this->container['schemeFee'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'schemeFee', must be one of '%s'",
                $this->container['schemeFee'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getSurchargeAllowableValues();
        if (!is_null($this->container['surcharge']) && !in_array($this->container['surcharge'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'surcharge', must be one of '%s'",
                $this->container['surcharge'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTipAllowableValues();
        if (!is_null($this->container['tip']) && !in_array($this->container['tip'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'tip', must be one of '%s'",
                $this->container['tip'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets acquiringFees
     *
     * @return string|null
     */
    public function getAcquiringFees()
    {
        return $this->container['acquiringFees'];
    }

    /**
     * Sets acquiringFees
     *
     * @param string|null $acquiringFees Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setAcquiringFees($acquiringFees)
    {
        $allowedValues = $this->getAcquiringFeesAllowableValues();
        if (!in_array($acquiringFees, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'acquiringFees', must be one of '%s'",
                    $acquiringFees,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['acquiringFees'] = $acquiringFees;

        return $this;
    }

    /**
     * Gets additionalCommission
     *
     * @return \Adyen\Model\Management\AdditionalCommission|null
     */
    public function getAdditionalCommission()
    {
        return $this->container['additionalCommission'];
    }

    /**
     * Sets additionalCommission
     *
     * @param \Adyen\Model\Management\AdditionalCommission|null $additionalCommission additionalCommission
     *
     * @return self
     */
    public function setAdditionalCommission($additionalCommission)
    {
        $this->container['additionalCommission'] = $additionalCommission;

        return $this;
    }

    /**
     * Gets adyenCommission
     *
     * @return string|null
     */
    public function getAdyenCommission()
    {
        return $this->container['adyenCommission'];
    }

    /**
     * Sets adyenCommission
     *
     * @param string|null $adyenCommission Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setAdyenCommission($adyenCommission)
    {
        $allowedValues = $this->getAdyenCommissionAllowableValues();
        if (!in_array($adyenCommission, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'adyenCommission', must be one of '%s'",
                    $adyenCommission,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['adyenCommission'] = $adyenCommission;

        return $this;
    }

    /**
     * Gets adyenFees
     *
     * @return string|null
     */
    public function getAdyenFees()
    {
        return $this->container['adyenFees'];
    }

    /**
     * Sets adyenFees
     *
     * @param string|null $adyenFees Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setAdyenFees($adyenFees)
    {
        $allowedValues = $this->getAdyenFeesAllowableValues();
        if (!in_array($adyenFees, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'adyenFees', must be one of '%s'",
                    $adyenFees,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['adyenFees'] = $adyenFees;

        return $this;
    }

    /**
     * Gets adyenMarkup
     *
     * @return string|null
     */
    public function getAdyenMarkup()
    {
        return $this->container['adyenMarkup'];
    }

    /**
     * Sets adyenMarkup
     *
     * @param string|null $adyenMarkup Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setAdyenMarkup($adyenMarkup)
    {
        $allowedValues = $this->getAdyenMarkupAllowableValues();
        if (!in_array($adyenMarkup, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'adyenMarkup', must be one of '%s'",
                    $adyenMarkup,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['adyenMarkup'] = $adyenMarkup;

        return $this;
    }

    /**
     * Gets chargeback
     *
     * @return string|null
     */
    public function getChargeback()
    {
        return $this->container['chargeback'];
    }

    /**
     * Sets chargeback
     *
     * @param string|null $chargeback Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
     *
     * @return self
     */
    public function setChargeback($chargeback)
    {
        $allowedValues = $this->getChargebackAllowableValues();
        if (!in_array($chargeback, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'chargeback', must be one of '%s'",
                    $chargeback,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['chargeback'] = $chargeback;

        return $this;
    }

    /**
     * Gets chargebackCostAllocation
     *
     * @return string|null
     */
    public function getChargebackCostAllocation()
    {
        return $this->container['chargebackCostAllocation'];
    }

    /**
     * Sets chargebackCostAllocation
     *
     * @param string|null $chargebackCostAllocation Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
     *
     * @return self
     */
    public function setChargebackCostAllocation($chargebackCostAllocation)
    {
        $allowedValues = $this->getChargebackCostAllocationAllowableValues();
        if (!in_array($chargebackCostAllocation, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'chargebackCostAllocation', must be one of '%s'",
                    $chargebackCostAllocation,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['chargebackCostAllocation'] = $chargebackCostAllocation;

        return $this;
    }

    /**
     * Gets commission
     *
     * @return \Adyen\Model\Management\Commission
     */
    public function getCommission()
    {
        return $this->container['commission'];
    }

    /**
     * Sets commission
     *
     * @param \Adyen\Model\Management\Commission $commission commission
     *
     * @return self
     */
    public function setCommission($commission)
    {
        $this->container['commission'] = $commission;

        return $this;
    }

    /**
     * Gets interchange
     *
     * @return string|null
     */
    public function getInterchange()
    {
        return $this->container['interchange'];
    }

    /**
     * Sets interchange
     *
     * @param string|null $interchange Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setInterchange($interchange)
    {
        $allowedValues = $this->getInterchangeAllowableValues();
        if (!in_array($interchange, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'interchange', must be one of '%s'",
                    $interchange,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['interchange'] = $interchange;

        return $this;
    }

    /**
     * Gets paymentFee
     *
     * @return string|null
     */
    public function getPaymentFee()
    {
        return $this->container['paymentFee'];
    }

    /**
     * Sets paymentFee
     *
     * @param string|null $paymentFee Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [`adyenCommission`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`adyenMarkup`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`schemeFee`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [`interchange`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [`adyenFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen's commission and markup. - [`acquiringFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don't include at least one transaction fee type in the `splitLogic` object, Adyen updates the payment request with the `paymentFee` parameter, booking all transaction fees to your platform's liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setPaymentFee($paymentFee)
    {
        $allowedValues = $this->getPaymentFeeAllowableValues();
        if (!in_array($paymentFee, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'paymentFee', must be one of '%s'",
                    $paymentFee,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['paymentFee'] = $paymentFee;

        return $this;
    }

    /**
     * Gets refund
     *
     * @return string|null
     */
    public function getRefund()
    {
        return $this->container['refund'];
    }

    /**
     * Sets refund
     *
     * @param string|null $refund Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**
     *
     * @return self
     */
    public function setRefund($refund)
    {
        $allowedValues = $this->getRefundAllowableValues();
        if (!in_array($refund, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund', must be one of '%s'",
                    $refund,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund'] = $refund;

        return $this;
    }

    /**
     * Gets refundCostAllocation
     *
     * @return string|null
     */
    public function getRefundCostAllocation()
    {
        return $this->container['refundCostAllocation'];
    }

    /**
     * Sets refundCostAllocation
     *
     * @param string|null $refundCostAllocation Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**
     *
     * @return self
     */
    public function setRefundCostAllocation($refundCostAllocation)
    {
        $allowedValues = $this->getRefundCostAllocationAllowableValues();
        if (!in_array($refundCostAllocation, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refundCostAllocation', must be one of '%s'",
                    $refundCostAllocation,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refundCostAllocation'] = $refundCostAllocation;

        return $this;
    }

    /**
     * Gets remainder
     *
     * @return string|null
     */
    public function getRemainder()
    {
        return $this->container['remainder'];
    }

    /**
     * Sets remainder
     *
     * @param string|null $remainder Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
     *
     * @return self
     */
    public function setRemainder($remainder)
    {
        $allowedValues = $this->getRemainderAllowableValues();
        if (!in_array($remainder, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'remainder', must be one of '%s'",
                    $remainder,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['remainder'] = $remainder;

        return $this;
    }

    /**
     * Gets schemeFee
     *
     * @return string|null
     */
    public function getSchemeFee()
    {
        return $this->container['schemeFee'];
    }

    /**
     * Sets schemeFee
     *
     * @param string|null $schemeFee Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
     *
     * @return self
     */
    public function setSchemeFee($schemeFee)
    {
        $allowedValues = $this->getSchemeFeeAllowableValues();
        if (!in_array($schemeFee, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'schemeFee', must be one of '%s'",
                    $schemeFee,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['schemeFee'] = $schemeFee;

        return $this;
    }

    /**
     * Gets splitLogicId
     *
     * @return string|null
     */
    public function getSplitLogicId()
    {
        return $this->container['splitLogicId'];
    }

    /**
     * Sets splitLogicId
     *
     * @param string|null $splitLogicId Unique identifier of the collection of split instructions that are applied when the rule conditions are met.
     *
     * @return self
     */
    public function setSplitLogicId($splitLogicId)
    {
        $this->container['splitLogicId'] = $splitLogicId;

        return $this;
    }

    /**
     * Gets surcharge
     *
     * @return string|null
     */
    public function getSurcharge()
    {
        return $this->container['surcharge'];
    }

    /**
     * Sets surcharge
     *
     * @param string|null $surcharge Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
     *
     * @return self
     */
    public function setSurcharge($surcharge)
    {
        $allowedValues = $this->getSurchargeAllowableValues();
        if (!in_array($surcharge, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'surcharge', must be one of '%s'",
                    $surcharge,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['surcharge'] = $surcharge;

        return $this;
    }

    /**
     * Gets tip
     *
     * @return string|null
     */
    public function getTip()
    {
        return $this->container['tip'];
    }

    /**
     * Sets tip
     *
     * @param string|null $tip Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
     *
     * @return self
     */
    public function setTip($tip)
    {
        $allowedValues = $this->getTipAllowableValues();
        if (!in_array($tip, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'tip', must be one of '%s'",
                    $tip,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['tip'] = $tip;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
