<?php

/**
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Transfers;

use \ArrayAccess;
use Adyen\Model\Transfers\ObjectSerializer;

/**
 * TransferData Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransferData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransferData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'accountHolder' => '\Adyen\Model\Transfers\ResourceReference',
        'amount' => '\Adyen\Model\Transfers\Amount',
        'balanceAccount' => '\Adyen\Model\Transfers\ResourceReference',
        'balancePlatform' => 'string',
        'balances' => '\Adyen\Model\Transfers\BalanceMutation[]',
        'category' => 'string',
        'categoryData' => '\Adyen\Model\Transfers\TransferCategoryData',
        'counterparty' => '\Adyen\Model\Transfers\TransferNotificationCounterParty',
        'creationDate' => '\DateTime',
        'description' => 'string',
        'direction' => 'string',
        'events' => '\Adyen\Model\Transfers\TransferEvent[]',
        'id' => 'string',
        'paymentInstrument' => '\Adyen\Model\Transfers\PaymentInstrument',
        'reason' => 'string',
        'reference' => 'string',
        'referenceForBeneficiary' => 'string',
        'sequenceNumber' => 'int',
        'status' => 'string',
        'tracking' => '\Adyen\Model\Transfers\TransferDataTracking',
        'transactionRulesResult' => '\Adyen\Model\Transfers\TransactionRulesResult',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'accountHolder' => null,
        'amount' => null,
        'balanceAccount' => null,
        'balancePlatform' => null,
        'balances' => null,
        'category' => null,
        'categoryData' => null,
        'counterparty' => null,
        'creationDate' => 'date-time',
        'description' => null,
        'direction' => null,
        'events' => null,
        'id' => null,
        'paymentInstrument' => null,
        'reason' => null,
        'reference' => null,
        'referenceForBeneficiary' => null,
        'sequenceNumber' => 'int32',
        'status' => null,
        'tracking' => null,
        'transactionRulesResult' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'accountHolder' => false,
        'amount' => false,
        'balanceAccount' => false,
        'balancePlatform' => false,
        'balances' => false,
        'category' => false,
        'categoryData' => false,
        'counterparty' => false,
        'creationDate' => false,
        'description' => false,
        'direction' => false,
        'events' => false,
        'id' => false,
        'paymentInstrument' => false,
        'reason' => false,
        'reference' => false,
        'referenceForBeneficiary' => false,
        'sequenceNumber' => true,
        'status' => false,
        'tracking' => false,
        'transactionRulesResult' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'accountHolder' => 'accountHolder',
        'amount' => 'amount',
        'balanceAccount' => 'balanceAccount',
        'balancePlatform' => 'balancePlatform',
        'balances' => 'balances',
        'category' => 'category',
        'categoryData' => 'categoryData',
        'counterparty' => 'counterparty',
        'creationDate' => 'creationDate',
        'description' => 'description',
        'direction' => 'direction',
        'events' => 'events',
        'id' => 'id',
        'paymentInstrument' => 'paymentInstrument',
        'reason' => 'reason',
        'reference' => 'reference',
        'referenceForBeneficiary' => 'referenceForBeneficiary',
        'sequenceNumber' => 'sequenceNumber',
        'status' => 'status',
        'tracking' => 'tracking',
        'transactionRulesResult' => 'transactionRulesResult',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'accountHolder' => 'setAccountHolder',
        'amount' => 'setAmount',
        'balanceAccount' => 'setBalanceAccount',
        'balancePlatform' => 'setBalancePlatform',
        'balances' => 'setBalances',
        'category' => 'setCategory',
        'categoryData' => 'setCategoryData',
        'counterparty' => 'setCounterparty',
        'creationDate' => 'setCreationDate',
        'description' => 'setDescription',
        'direction' => 'setDirection',
        'events' => 'setEvents',
        'id' => 'setId',
        'paymentInstrument' => 'setPaymentInstrument',
        'reason' => 'setReason',
        'reference' => 'setReference',
        'referenceForBeneficiary' => 'setReferenceForBeneficiary',
        'sequenceNumber' => 'setSequenceNumber',
        'status' => 'setStatus',
        'tracking' => 'setTracking',
        'transactionRulesResult' => 'setTransactionRulesResult',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'accountHolder' => 'getAccountHolder',
        'amount' => 'getAmount',
        'balanceAccount' => 'getBalanceAccount',
        'balancePlatform' => 'getBalancePlatform',
        'balances' => 'getBalances',
        'category' => 'getCategory',
        'categoryData' => 'getCategoryData',
        'counterparty' => 'getCounterparty',
        'creationDate' => 'getCreationDate',
        'description' => 'getDescription',
        'direction' => 'getDirection',
        'events' => 'getEvents',
        'id' => 'getId',
        'paymentInstrument' => 'getPaymentInstrument',
        'reason' => 'getReason',
        'reference' => 'getReference',
        'referenceForBeneficiary' => 'getReferenceForBeneficiary',
        'sequenceNumber' => 'getSequenceNumber',
        'status' => 'getStatus',
        'tracking' => 'getTracking',
        'transactionRulesResult' => 'getTransactionRulesResult',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CATEGORY_BANK = 'bank';
    public const CATEGORY_INTERNAL = 'internal';
    public const CATEGORY_ISSUED_CARD = 'issuedCard';
    public const CATEGORY_PLATFORM_PAYMENT = 'platformPayment';
    public const DIRECTION_INCOMING = 'incoming';
    public const DIRECTION_OUTGOING = 'outgoing';
    public const REASON_AMOUNT_LIMIT_EXCEEDED = 'amountLimitExceeded';
    public const REASON_APPROVED = 'approved';
    public const REASON_BALANCE_ACCOUNT_TEMPORARILY_BLOCKED_BY_TRANSACTION_RULE = 'balanceAccountTemporarilyBlockedByTransactionRule';
    public const REASON_COUNTERPARTY_ACCOUNT_BLOCKED = 'counterpartyAccountBlocked';
    public const REASON_COUNTERPARTY_ACCOUNT_CLOSED = 'counterpartyAccountClosed';
    public const REASON_COUNTERPARTY_ACCOUNT_NOT_FOUND = 'counterpartyAccountNotFound';
    public const REASON_COUNTERPARTY_ADDRESS_REQUIRED = 'counterpartyAddressRequired';
    public const REASON_COUNTERPARTY_BANK_TIMED_OUT = 'counterpartyBankTimedOut';
    public const REASON_COUNTERPARTY_BANK_UNAVAILABLE = 'counterpartyBankUnavailable';
    public const REASON_DECLINED = 'declined';
    public const REASON_DECLINED_BY_TRANSACTION_RULE = 'declinedByTransactionRule';
    public const REASON_ERROR = 'error';
    public const REASON_NOT_ENOUGH_BALANCE = 'notEnoughBalance';
    public const REASON_PENDING_APPROVAL = 'pendingApproval';
    public const REASON_REFUSED_BY_COUNTERPARTY_BANK = 'refusedByCounterpartyBank';
    public const REASON_ROUTE_NOT_FOUND = 'routeNotFound';
    public const REASON_SCA_FAILED = 'scaFailed';
    public const REASON_UNKNOWN = 'unknown';
    public const STATUS_APPROVAL_PENDING = 'approvalPending';
    public const STATUS_ATM_WITHDRAWAL = 'atmWithdrawal';
    public const STATUS_ATM_WITHDRAWAL_REVERSAL_PENDING = 'atmWithdrawalReversalPending';
    public const STATUS_ATM_WITHDRAWAL_REVERSED = 'atmWithdrawalReversed';
    public const STATUS_AUTH_ADJUSTMENT_AUTHORISED = 'authAdjustmentAuthorised';
    public const STATUS_AUTH_ADJUSTMENT_ERROR = 'authAdjustmentError';
    public const STATUS_AUTH_ADJUSTMENT_REFUSED = 'authAdjustmentRefused';
    public const STATUS_AUTHORISED = 'authorised';
    public const STATUS_BANK_TRANSFER = 'bankTransfer';
    public const STATUS_BANK_TRANSFER_PENDING = 'bankTransferPending';
    public const STATUS_BOOKED = 'booked';
    public const STATUS_BOOKING_PENDING = 'bookingPending';
    public const STATUS_CANCELLED = 'cancelled';
    public const STATUS_CAPTURE_PENDING = 'capturePending';
    public const STATUS_CAPTURE_REVERSAL_PENDING = 'captureReversalPending';
    public const STATUS_CAPTURE_REVERSED = 'captureReversed';
    public const STATUS_CAPTURED = 'captured';
    public const STATUS_CAPTURED_EXTERNALLY = 'capturedExternally';
    public const STATUS_CHARGEBACK = 'chargeback';
    public const STATUS_CHARGEBACK_EXTERNALLY = 'chargebackExternally';
    public const STATUS_CHARGEBACK_PENDING = 'chargebackPending';
    public const STATUS_CHARGEBACK_REVERSAL_PENDING = 'chargebackReversalPending';
    public const STATUS_CHARGEBACK_REVERSED = 'chargebackReversed';
    public const STATUS_CREDITED = 'credited';
    public const STATUS_DEPOSIT_CORRECTION = 'depositCorrection';
    public const STATUS_DEPOSIT_CORRECTION_PENDING = 'depositCorrectionPending';
    public const STATUS_DISPUTE = 'dispute';
    public const STATUS_DISPUTE_CLOSED = 'disputeClosed';
    public const STATUS_DISPUTE_EXPIRED = 'disputeExpired';
    public const STATUS_DISPUTE_NEEDS_REVIEW = 'disputeNeedsReview';
    public const STATUS_ERROR = 'error';
    public const STATUS_EXPIRED = 'expired';
    public const STATUS_FAILED = 'failed';
    public const STATUS_FEE = 'fee';
    public const STATUS_FEE_PENDING = 'feePending';
    public const STATUS_INTERNAL_TRANSFER = 'internalTransfer';
    public const STATUS_INTERNAL_TRANSFER_PENDING = 'internalTransferPending';
    public const STATUS_INVOICE_DEDUCTION = 'invoiceDeduction';
    public const STATUS_INVOICE_DEDUCTION_PENDING = 'invoiceDeductionPending';
    public const STATUS_MANUAL_CORRECTION_PENDING = 'manualCorrectionPending';
    public const STATUS_MANUALLY_CORRECTED = 'manuallyCorrected';
    public const STATUS_MATCHED_STATEMENT = 'matchedStatement';
    public const STATUS_MATCHED_STATEMENT_PENDING = 'matchedStatementPending';
    public const STATUS_MERCHANT_PAYIN = 'merchantPayin';
    public const STATUS_MERCHANT_PAYIN_PENDING = 'merchantPayinPending';
    public const STATUS_MERCHANT_PAYIN_REVERSED = 'merchantPayinReversed';
    public const STATUS_MERCHANT_PAYIN_REVERSED_PENDING = 'merchantPayinReversedPending';
    public const STATUS_MISC_COST = 'miscCost';
    public const STATUS_MISC_COST_PENDING = 'miscCostPending';
    public const STATUS_PAYMENT_COST = 'paymentCost';
    public const STATUS_PAYMENT_COST_PENDING = 'paymentCostPending';
    public const STATUS_PENDING_APPROVAL = 'pendingApproval';
    public const STATUS_RECEIVED = 'received';
    public const STATUS_REFUND_PENDING = 'refundPending';
    public const STATUS_REFUND_REVERSAL_PENDING = 'refundReversalPending';
    public const STATUS_REFUND_REVERSED = 'refundReversed';
    public const STATUS_REFUNDED = 'refunded';
    public const STATUS_REFUNDED_EXTERNALLY = 'refundedExternally';
    public const STATUS_REFUSED = 'refused';
    public const STATUS_REJECTED = 'rejected';
    public const STATUS_RESERVE_ADJUSTMENT = 'reserveAdjustment';
    public const STATUS_RESERVE_ADJUSTMENT_PENDING = 'reserveAdjustmentPending';
    public const STATUS_RETURNED = 'returned';
    public const STATUS_SECOND_CHARGEBACK = 'secondChargeback';
    public const STATUS_SECOND_CHARGEBACK_PENDING = 'secondChargebackPending';
    public const STATUS_UNDEFINED = 'undefined';
    public const TYPE_ATM_WITHDRAWAL = 'atmWithdrawal';
    public const TYPE_ATM_WITHDRAWAL_REVERSAL = 'atmWithdrawalReversal';
    public const TYPE_BALANCE_ADJUSTMENT = 'balanceAdjustment';
    public const TYPE_BALANCE_MIGRATION = 'balanceMigration';
    public const TYPE_BALANCE_ROLLOVER = 'balanceRollover';
    public const TYPE_BANK_DIRECT_DEBIT = 'bankDirectDebit';
    public const TYPE_BANK_TRANSFER = 'bankTransfer';
    public const TYPE_CAPITAL_FUNDS_COLLECTION = 'capitalFundsCollection';
    public const TYPE_CAPTURE = 'capture';
    public const TYPE_CAPTURE_REVERSAL = 'captureReversal';
    public const TYPE_CARD_TRANSFER = 'cardTransfer';
    public const TYPE_CASH_OUT_FEE = 'cashOutFee';
    public const TYPE_CASH_OUT_FUNDING = 'cashOutFunding';
    public const TYPE_CASH_OUT_INSTRUCTION = 'cashOutInstruction';
    public const TYPE_CASHOUT_FEE = 'cashoutFee';
    public const TYPE_CASHOUT_FUNDING = 'cashoutFunding';
    public const TYPE_CASHOUT_REPAYMENT = 'cashoutRepayment';
    public const TYPE_CHARGEBACK = 'chargeback';
    public const TYPE_CHARGEBACK_CORRECTION = 'chargebackCorrection';
    public const TYPE_CHARGEBACK_REVERSAL = 'chargebackReversal';
    public const TYPE_CHARGEBACK_REVERSAL_CORRECTION = 'chargebackReversalCorrection';
    public const TYPE_DEPOSIT_CORRECTION = 'depositCorrection';
    public const TYPE_FEE = 'fee';
    public const TYPE_GRANT = 'grant';
    public const TYPE_INSTALLMENT = 'installment';
    public const TYPE_INSTALLMENT_REVERSAL = 'installmentReversal';
    public const TYPE_INTERNAL_DIRECT_DEBIT = 'internalDirectDebit';
    public const TYPE_INTERNAL_TRANSFER = 'internalTransfer';
    public const TYPE_INVOICE_DEDUCTION = 'invoiceDeduction';
    public const TYPE_LEFTOVER = 'leftover';
    public const TYPE_MANUAL_CORRECTION = 'manualCorrection';
    public const TYPE_MISC_COST = 'miscCost';
    public const TYPE_PAYMENT = 'payment';
    public const TYPE_PAYMENT_COST = 'paymentCost';
    public const TYPE_REFUND = 'refund';
    public const TYPE_REFUND_REVERSAL = 'refundReversal';
    public const TYPE_REPAYMENT = 'repayment';
    public const TYPE_RESERVE_ADJUSTMENT = 'reserveAdjustment';
    public const TYPE_SECOND_CHARGEBACK = 'secondChargeback';
    public const TYPE_SECOND_CHARGEBACK_CORRECTION = 'secondChargebackCorrection';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCategoryAllowableValues()
    {
        return [
            self::CATEGORY_BANK,
            self::CATEGORY_INTERNAL,
            self::CATEGORY_ISSUED_CARD,
            self::CATEGORY_PLATFORM_PAYMENT,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INCOMING,
            self::DIRECTION_OUTGOING,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getReasonAllowableValues()
    {
        return [
            self::REASON_AMOUNT_LIMIT_EXCEEDED,
            self::REASON_APPROVED,
            self::REASON_BALANCE_ACCOUNT_TEMPORARILY_BLOCKED_BY_TRANSACTION_RULE,
            self::REASON_COUNTERPARTY_ACCOUNT_BLOCKED,
            self::REASON_COUNTERPARTY_ACCOUNT_CLOSED,
            self::REASON_COUNTERPARTY_ACCOUNT_NOT_FOUND,
            self::REASON_COUNTERPARTY_ADDRESS_REQUIRED,
            self::REASON_COUNTERPARTY_BANK_TIMED_OUT,
            self::REASON_COUNTERPARTY_BANK_UNAVAILABLE,
            self::REASON_DECLINED,
            self::REASON_DECLINED_BY_TRANSACTION_RULE,
            self::REASON_ERROR,
            self::REASON_NOT_ENOUGH_BALANCE,
            self::REASON_PENDING_APPROVAL,
            self::REASON_REFUSED_BY_COUNTERPARTY_BANK,
            self::REASON_ROUTE_NOT_FOUND,
            self::REASON_SCA_FAILED,
            self::REASON_UNKNOWN,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_APPROVAL_PENDING,
            self::STATUS_ATM_WITHDRAWAL,
            self::STATUS_ATM_WITHDRAWAL_REVERSAL_PENDING,
            self::STATUS_ATM_WITHDRAWAL_REVERSED,
            self::STATUS_AUTH_ADJUSTMENT_AUTHORISED,
            self::STATUS_AUTH_ADJUSTMENT_ERROR,
            self::STATUS_AUTH_ADJUSTMENT_REFUSED,
            self::STATUS_AUTHORISED,
            self::STATUS_BANK_TRANSFER,
            self::STATUS_BANK_TRANSFER_PENDING,
            self::STATUS_BOOKED,
            self::STATUS_BOOKING_PENDING,
            self::STATUS_CANCELLED,
            self::STATUS_CAPTURE_PENDING,
            self::STATUS_CAPTURE_REVERSAL_PENDING,
            self::STATUS_CAPTURE_REVERSED,
            self::STATUS_CAPTURED,
            self::STATUS_CAPTURED_EXTERNALLY,
            self::STATUS_CHARGEBACK,
            self::STATUS_CHARGEBACK_EXTERNALLY,
            self::STATUS_CHARGEBACK_PENDING,
            self::STATUS_CHARGEBACK_REVERSAL_PENDING,
            self::STATUS_CHARGEBACK_REVERSED,
            self::STATUS_CREDITED,
            self::STATUS_DEPOSIT_CORRECTION,
            self::STATUS_DEPOSIT_CORRECTION_PENDING,
            self::STATUS_DISPUTE,
            self::STATUS_DISPUTE_CLOSED,
            self::STATUS_DISPUTE_EXPIRED,
            self::STATUS_DISPUTE_NEEDS_REVIEW,
            self::STATUS_ERROR,
            self::STATUS_EXPIRED,
            self::STATUS_FAILED,
            self::STATUS_FEE,
            self::STATUS_FEE_PENDING,
            self::STATUS_INTERNAL_TRANSFER,
            self::STATUS_INTERNAL_TRANSFER_PENDING,
            self::STATUS_INVOICE_DEDUCTION,
            self::STATUS_INVOICE_DEDUCTION_PENDING,
            self::STATUS_MANUAL_CORRECTION_PENDING,
            self::STATUS_MANUALLY_CORRECTED,
            self::STATUS_MATCHED_STATEMENT,
            self::STATUS_MATCHED_STATEMENT_PENDING,
            self::STATUS_MERCHANT_PAYIN,
            self::STATUS_MERCHANT_PAYIN_PENDING,
            self::STATUS_MERCHANT_PAYIN_REVERSED,
            self::STATUS_MERCHANT_PAYIN_REVERSED_PENDING,
            self::STATUS_MISC_COST,
            self::STATUS_MISC_COST_PENDING,
            self::STATUS_PAYMENT_COST,
            self::STATUS_PAYMENT_COST_PENDING,
            self::STATUS_PENDING_APPROVAL,
            self::STATUS_RECEIVED,
            self::STATUS_REFUND_PENDING,
            self::STATUS_REFUND_REVERSAL_PENDING,
            self::STATUS_REFUND_REVERSED,
            self::STATUS_REFUNDED,
            self::STATUS_REFUNDED_EXTERNALLY,
            self::STATUS_REFUSED,
            self::STATUS_REJECTED,
            self::STATUS_RESERVE_ADJUSTMENT,
            self::STATUS_RESERVE_ADJUSTMENT_PENDING,
            self::STATUS_RETURNED,
            self::STATUS_SECOND_CHARGEBACK,
            self::STATUS_SECOND_CHARGEBACK_PENDING,
            self::STATUS_UNDEFINED,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ATM_WITHDRAWAL,
            self::TYPE_ATM_WITHDRAWAL_REVERSAL,
            self::TYPE_BALANCE_ADJUSTMENT,
            self::TYPE_BALANCE_MIGRATION,
            self::TYPE_BALANCE_ROLLOVER,
            self::TYPE_BANK_DIRECT_DEBIT,
            self::TYPE_BANK_TRANSFER,
            self::TYPE_CAPITAL_FUNDS_COLLECTION,
            self::TYPE_CAPTURE,
            self::TYPE_CAPTURE_REVERSAL,
            self::TYPE_CARD_TRANSFER,
            self::TYPE_CASH_OUT_FEE,
            self::TYPE_CASH_OUT_FUNDING,
            self::TYPE_CASH_OUT_INSTRUCTION,
            self::TYPE_CASHOUT_FEE,
            self::TYPE_CASHOUT_FUNDING,
            self::TYPE_CASHOUT_REPAYMENT,
            self::TYPE_CHARGEBACK,
            self::TYPE_CHARGEBACK_CORRECTION,
            self::TYPE_CHARGEBACK_REVERSAL,
            self::TYPE_CHARGEBACK_REVERSAL_CORRECTION,
            self::TYPE_DEPOSIT_CORRECTION,
            self::TYPE_FEE,
            self::TYPE_GRANT,
            self::TYPE_INSTALLMENT,
            self::TYPE_INSTALLMENT_REVERSAL,
            self::TYPE_INTERNAL_DIRECT_DEBIT,
            self::TYPE_INTERNAL_TRANSFER,
            self::TYPE_INVOICE_DEDUCTION,
            self::TYPE_LEFTOVER,
            self::TYPE_MANUAL_CORRECTION,
            self::TYPE_MISC_COST,
            self::TYPE_PAYMENT,
            self::TYPE_PAYMENT_COST,
            self::TYPE_REFUND,
            self::TYPE_REFUND_REVERSAL,
            self::TYPE_REPAYMENT,
            self::TYPE_RESERVE_ADJUSTMENT,
            self::TYPE_SECOND_CHARGEBACK,
            self::TYPE_SECOND_CHARGEBACK_CORRECTION,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('accountHolder', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('balanceAccount', $data ?? [], null);
        $this->setIfExists('balancePlatform', $data ?? [], null);
        $this->setIfExists('balances', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('categoryData', $data ?? [], null);
        $this->setIfExists('counterparty', $data ?? [], null);
        $this->setIfExists('creationDate', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('direction', $data ?? [], null);
        $this->setIfExists('events', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('paymentInstrument', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('referenceForBeneficiary', $data ?? [], null);
        $this->setIfExists('sequenceNumber', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('tracking', $data ?? [], null);
        $this->setIfExists('transactionRulesResult', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        if ($this->container['category'] === null) {
            $invalidProperties[] = "'category' can't be null";
        }
        $allowedValues = $this->getCategoryAllowableValues();
        if (!is_null($this->container['category']) && !in_array($this->container['category'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'category', must be one of '%s'",
                $this->container['category'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getDirectionAllowableValues();
        if (!is_null($this->container['direction']) && !in_array($this->container['direction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'direction', must be one of '%s'",
                $this->container['direction'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getReasonAllowableValues();
        if (!is_null($this->container['reason']) && !in_array($this->container['reason'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'reason', must be one of '%s'",
                $this->container['reason'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets accountHolder
     *
     * @return \Adyen\Model\Transfers\ResourceReference|null
     */
    public function getAccountHolder()
    {
        return $this->container['accountHolder'];
    }

    /**
     * Sets accountHolder
     *
     * @param \Adyen\Model\Transfers\ResourceReference|null $accountHolder accountHolder
     *
     * @return self
     */
    public function setAccountHolder($accountHolder)
    {
        $this->container['accountHolder'] = $accountHolder;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return \Adyen\Model\Transfers\Amount
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param \Adyen\Model\Transfers\Amount $amount amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets balanceAccount
     *
     * @return \Adyen\Model\Transfers\ResourceReference|null
     */
    public function getBalanceAccount()
    {
        return $this->container['balanceAccount'];
    }

    /**
     * Sets balanceAccount
     *
     * @param \Adyen\Model\Transfers\ResourceReference|null $balanceAccount balanceAccount
     *
     * @return self
     */
    public function setBalanceAccount($balanceAccount)
    {
        $this->container['balanceAccount'] = $balanceAccount;

        return $this;
    }

    /**
     * Gets balancePlatform
     *
     * @return string|null
     */
    public function getBalancePlatform()
    {
        return $this->container['balancePlatform'];
    }

    /**
     * Sets balancePlatform
     *
     * @param string|null $balancePlatform The unique identifier of the balance platform.
     *
     * @return self
     */
    public function setBalancePlatform($balancePlatform)
    {
        $this->container['balancePlatform'] = $balancePlatform;

        return $this;
    }

    /**
     * Gets balances
     *
     * @return \Adyen\Model\Transfers\BalanceMutation[]|null
     */
    public function getBalances()
    {
        return $this->container['balances'];
    }

    /**
     * Sets balances
     *
     * @param \Adyen\Model\Transfers\BalanceMutation[]|null $balances The list of the latest balance statuses in the transfer.
     *
     * @return self
     */
    public function setBalances($balances)
    {
        $this->container['balances'] = $balances;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string $category The category of the transfer.  Possible values:   - **bank**: a transfer involving a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: a transfer between [balance accounts](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: a transfer initiated by an Adyen-issued card.  - **platformPayment**: funds movements related to payments that are acquired for your users.
     *
     * @return self
     */
    public function setCategory($category)
    {
        $allowedValues = $this->getCategoryAllowableValues();
        if (!in_array($category, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'category', must be one of '%s'",
                    $category,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets categoryData
     *
     * @return \Adyen\Model\Transfers\TransferCategoryData|null
     */
    public function getCategoryData()
    {
        return $this->container['categoryData'];
    }

    /**
     * Sets categoryData
     *
     * @param \Adyen\Model\Transfers\TransferCategoryData|null $categoryData categoryData
     *
     * @return self
     */
    public function setCategoryData($categoryData)
    {
        $this->container['categoryData'] = $categoryData;

        return $this;
    }

    /**
     * Gets counterparty
     *
     * @return \Adyen\Model\Transfers\TransferNotificationCounterParty|null
     */
    public function getCounterparty()
    {
        return $this->container['counterparty'];
    }

    /**
     * Sets counterparty
     *
     * @param \Adyen\Model\Transfers\TransferNotificationCounterParty|null $counterparty counterparty
     *
     * @return self
     */
    public function setCounterparty($counterparty)
    {
        $this->container['counterparty'] = $counterparty;

        return $this;
    }

    /**
     * Gets creationDate
     *
     * @return \DateTime|null
     */
    public function getCreationDate()
    {
        return $this->container['creationDate'];
    }

    /**
     * Sets creationDate
     *
     * @param \DateTime|null $creationDate The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
     *
     * @return self
     */
    public function setCreationDate($creationDate)
    {
        $this->container['creationDate'] = $creationDate;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets direction
     *
     * @return string|null
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     *
     * @param string|null $direction The direction of the transfer.  Possible values: **incoming**, **outgoing**.
     *
     * @return self
     */
    public function setDirection($direction)
    {
        $allowedValues = $this->getDirectionAllowableValues();
        if (!in_array($direction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'direction', must be one of '%s'",
                    $direction,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets events
     *
     * @return \Adyen\Model\Transfers\TransferEvent[]|null
     */
    public function getEvents()
    {
        return $this->container['events'];
    }

    /**
     * Sets events
     *
     * @param \Adyen\Model\Transfers\TransferEvent[]|null $events The list of events leading up to the current status of the transfer.
     *
     * @return self
     */
    public function setEvents($events)
    {
        $this->container['events'] = $events;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The ID of the resource.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets paymentInstrument
     *
     * @return \Adyen\Model\Transfers\PaymentInstrument|null
     */
    public function getPaymentInstrument()
    {
        return $this->container['paymentInstrument'];
    }

    /**
     * Sets paymentInstrument
     *
     * @param \Adyen\Model\Transfers\PaymentInstrument|null $paymentInstrument paymentInstrument
     *
     * @return self
     */
    public function setPaymentInstrument($paymentInstrument)
    {
        $this->container['paymentInstrument'] = $paymentInstrument;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason Additional information about the status of the transfer.
     *
     * @return self
     */
    public function setReason($reason)
    {
        $allowedValues = $this->getReasonAllowableValues();
        if (!in_array($reason, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'reason', must be one of '%s'",
                    $reason,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets referenceForBeneficiary
     *
     * @return string|null
     */
    public function getReferenceForBeneficiary()
    {
        return $this->container['referenceForBeneficiary'];
    }

    /**
     * Sets referenceForBeneficiary
     *
     * @param string|null $referenceForBeneficiary A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**.The maximum length depends on the `category`.   - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.
     *
     * @return self
     */
    public function setReferenceForBeneficiary($referenceForBeneficiary)
    {
        $this->container['referenceForBeneficiary'] = $referenceForBeneficiary;

        return $this;
    }

    /**
     * Gets sequenceNumber
     *
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->container['sequenceNumber'];
    }

    /**
     * Sets sequenceNumber
     *
     * @param int|null $sequenceNumber The sequence number of the transfer webhook. The numbers start from 1 and increase with each new webhook for a specific transfer.  The sequence number can help you restore the correct sequence of events even if they arrive out of order.
     *
     * @return self
     */
    public function setSequenceNumber($sequenceNumber)
    {
        $this->container['sequenceNumber'] = $sequenceNumber;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status The result of the transfer.   For example, **authorised**, **refused**, or **error**.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets tracking
     *
     * @return \Adyen\Model\Transfers\TransferDataTracking|null
     */
    public function getTracking()
    {
        return $this->container['tracking'];
    }

    /**
     * Sets tracking
     *
     * @param \Adyen\Model\Transfers\TransferDataTracking|null $tracking tracking
     *
     * @return self
     */
    public function setTracking($tracking)
    {
        $this->container['tracking'] = $tracking;

        return $this;
    }

    /**
     * Gets transactionRulesResult
     *
     * @return \Adyen\Model\Transfers\TransactionRulesResult|null
     */
    public function getTransactionRulesResult()
    {
        return $this->container['transactionRulesResult'];
    }

    /**
     * Sets transactionRulesResult
     *
     * @param \Adyen\Model\Transfers\TransactionRulesResult|null $transactionRulesResult transactionRulesResult
     *
     * @return self
     */
    public function setTransactionRulesResult($transactionRulesResult)
    {
        $this->container['transactionRulesResult'] = $transactionRulesResult;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
