<?php
/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Checkout;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Checkout\ObjectSerializer;

class ClassicCheckoutSDKApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * ClassicCheckoutSDKApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://checkout-test.adyen.com/v71");
    }

    /**
    * Create a payment session
    *
    * @param \Adyen\Model\Checkout\PaymentSetupRequest $paymentSetupRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Checkout\PaymentSetupResponse
    * @throws AdyenException
    */
    public function paymentSession(\Adyen\Model\Checkout\PaymentSetupRequest $paymentSetupRequest, array $requestOptions = null): \Adyen\Model\Checkout\PaymentSetupResponse
    {
        $endpoint = $this->baseURL . "/paymentSession";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $paymentSetupRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Checkout\PaymentSetupResponse::class);
    }

    /**
    * Verify a payment result
    *
    * @param \Adyen\Model\Checkout\PaymentVerificationRequest $paymentVerificationRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Checkout\PaymentVerificationResponse
    * @throws AdyenException
    */
    public function verifyPaymentResult(\Adyen\Model\Checkout\PaymentVerificationRequest $paymentVerificationRequest, array $requestOptions = null): \Adyen\Model\Checkout\PaymentVerificationResponse
    {
        $endpoint = $this->baseURL . "/payments/result";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $paymentVerificationRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Checkout\PaymentVerificationResponse::class);
    }
}
