<?php
/**
 * Disputes API
 *
 * The version of the OpenAPI document: 30
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Disputes\ObjectSerializer;

class DisputesApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * DisputesApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://ca-test.adyen.com/ca/services/DisputeService/v30");
    }

    /**
    * Accept a dispute
    *
    * @param \Adyen\Model\Disputes\AcceptDisputeRequest $acceptDisputeRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Disputes\AcceptDisputeResponse
    * @throws AdyenException
    */
    public function acceptDispute(\Adyen\Model\Disputes\AcceptDisputeRequest $acceptDisputeRequest, array $requestOptions = null): \Adyen\Model\Disputes\AcceptDisputeResponse
    {
        $endpoint = $this->baseURL . "/acceptDispute";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $acceptDisputeRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Disputes\AcceptDisputeResponse::class);
    }

    /**
    * Defend a dispute
    *
    * @param \Adyen\Model\Disputes\DefendDisputeRequest $defendDisputeRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Disputes\DefendDisputeResponse
    * @throws AdyenException
    */
    public function defendDispute(\Adyen\Model\Disputes\DefendDisputeRequest $defendDisputeRequest, array $requestOptions = null): \Adyen\Model\Disputes\DefendDisputeResponse
    {
        $endpoint = $this->baseURL . "/defendDispute";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $defendDisputeRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Disputes\DefendDisputeResponse::class);
    }

    /**
    * Delete a defense document
    *
    * @param \Adyen\Model\Disputes\DeleteDefenseDocumentRequest $deleteDefenseDocumentRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Disputes\DeleteDefenseDocumentResponse
    * @throws AdyenException
    */
    public function deleteDisputeDefenseDocument(\Adyen\Model\Disputes\DeleteDefenseDocumentRequest $deleteDefenseDocumentRequest, array $requestOptions = null): \Adyen\Model\Disputes\DeleteDefenseDocumentResponse
    {
        $endpoint = $this->baseURL . "/deleteDisputeDefenseDocument";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $deleteDefenseDocumentRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Disputes\DeleteDefenseDocumentResponse::class);
    }

    /**
    * Get applicable defense reasons
    *
    * @param \Adyen\Model\Disputes\DefenseReasonsRequest $defenseReasonsRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Disputes\DefenseReasonsResponse
    * @throws AdyenException
    */
    public function retrieveApplicableDefenseReasons(\Adyen\Model\Disputes\DefenseReasonsRequest $defenseReasonsRequest, array $requestOptions = null): \Adyen\Model\Disputes\DefenseReasonsResponse
    {
        $endpoint = $this->baseURL . "/retrieveApplicableDefenseReasons";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $defenseReasonsRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Disputes\DefenseReasonsResponse::class);
    }

    /**
    * Supply a defense document
    *
    * @param \Adyen\Model\Disputes\SupplyDefenseDocumentRequest $supplyDefenseDocumentRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Disputes\SupplyDefenseDocumentResponse
    * @throws AdyenException
    */
    public function supplyDefenseDocument(\Adyen\Model\Disputes\SupplyDefenseDocumentRequest $supplyDefenseDocumentRequest, array $requestOptions = null): \Adyen\Model\Disputes\SupplyDefenseDocumentResponse
    {
        $endpoint = $this->baseURL . "/supplyDefenseDocument";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $supplyDefenseDocumentRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Disputes\SupplyDefenseDocumentResponse::class);
    }
}
