<?php
/**
 * Payments App API
 *
 * The version of the OpenAPI document: 1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\PaymentsApp;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\PaymentsApp\ObjectSerializer;

class PaymentsAppApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * PaymentsAppApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-live.adyen.com/v1");
    }

    /**
    * Create a boarding token - merchant level
    *
    * @param string $merchantId
    * @param \Adyen\Model\PaymentsApp\BoardingTokenRequest $boardingTokenRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\PaymentsApp\BoardingTokenResponse
    * @throws AdyenException
    */
    public function generatePaymentsAppBoardingTokenForMerchant(string $merchantId, \Adyen\Model\PaymentsApp\BoardingTokenRequest $boardingTokenRequest, array $requestOptions = null): \Adyen\Model\PaymentsApp\BoardingTokenResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/generatePaymentsAppBoardingToken");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $boardingTokenRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\PaymentsApp\BoardingTokenResponse::class);
    }

    /**
    * Create a boarding token - store level
    *
    * @param string $merchantId
    * @param string $storeId
    * @param \Adyen\Model\PaymentsApp\BoardingTokenRequest $boardingTokenRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\PaymentsApp\BoardingTokenResponse
    * @throws AdyenException
    */
    public function generatePaymentsAppBoardingTokenForStore(string $merchantId, string $storeId, \Adyen\Model\PaymentsApp\BoardingTokenRequest $boardingTokenRequest, array $requestOptions = null): \Adyen\Model\PaymentsApp\BoardingTokenResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{storeId}'], [$merchantId, $storeId], "/merchants/{merchantId}/stores/{storeId}/generatePaymentsAppBoardingToken");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $boardingTokenRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\PaymentsApp\BoardingTokenResponse::class);
    }

    /**
    * Get a list of Payments Apps - merchant level
    *
    * @param string $merchantId
    * @param array|null $requestOptions ['queryParams' => ['statuses'=> string, 'limit'=> int, 'offset'=> int]]
    * @return \Adyen\Model\PaymentsApp\PaymentsAppResponse
    * @throws AdyenException
    */
    public function listPaymentsAppForMerchant(string $merchantId, array $requestOptions = null): \Adyen\Model\PaymentsApp\PaymentsAppResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/paymentsApps");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\PaymentsApp\PaymentsAppResponse::class);
    }

    /**
    * Get a list of Payments Apps - store level
    *
    * @param string $merchantId
    * @param string $storeId
    * @param array|null $requestOptions ['queryParams' => ['statuses'=> string, 'limit'=> int, 'offset'=> int]]
    * @return \Adyen\Model\PaymentsApp\PaymentsAppResponse
    * @throws AdyenException
    */
    public function listPaymentsAppForStore(string $merchantId, string $storeId, array $requestOptions = null): \Adyen\Model\PaymentsApp\PaymentsAppResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{storeId}'], [$merchantId, $storeId], "/merchants/{merchantId}/stores/{storeId}/paymentsApps");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\PaymentsApp\PaymentsAppResponse::class);
    }

    /**
    * Revoke Payments App instance authentication
    *
    * @param string $merchantId
    * @param string $installationId
    * @param array|null $requestOptions

    * @throws AdyenException
    */
    public function revokePaymentsApp(string $merchantId, string $installationId, array $requestOptions = null)
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{installationId}'], [$merchantId, $installationId], "/merchants/{merchantId}/paymentsApps/{installationId}/revoke");
        $this->requestHttp($endpoint, strtolower('POST'), null, $requestOptions);
    }
}
