<?php
/**
 * Adyen Recurring API
 *
 * The version of the OpenAPI document: 68
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Recurring\ObjectSerializer;

class RecurringApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * RecurringApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://pal-test.adyen.com/pal/servlet/Recurring/v68");
    }

    /**
    * Create new permits linked to a recurring contract.
    *
    * @param \Adyen\Model\Recurring\CreatePermitRequest $createPermitRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\CreatePermitResult
    * @throws AdyenException
    */
    public function createPermit(\Adyen\Model\Recurring\CreatePermitRequest $createPermitRequest, array $requestOptions = null): \Adyen\Model\Recurring\CreatePermitResult
    {
        $endpoint = $this->baseURL . "/createPermit";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $createPermitRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\CreatePermitResult::class);
    }

    /**
    * Disable stored payment details
    *
    * @param \Adyen\Model\Recurring\DisableRequest $disableRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\DisableResult
    * @throws AdyenException
    */
    public function disable(\Adyen\Model\Recurring\DisableRequest $disableRequest, array $requestOptions = null): \Adyen\Model\Recurring\DisableResult
    {
        $endpoint = $this->baseURL . "/disable";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $disableRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\DisableResult::class);
    }

    /**
    * Disable an existing permit.
    *
    * @param \Adyen\Model\Recurring\DisablePermitRequest $disablePermitRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\DisablePermitResult
    * @throws AdyenException
    */
    public function disablePermit(\Adyen\Model\Recurring\DisablePermitRequest $disablePermitRequest, array $requestOptions = null): \Adyen\Model\Recurring\DisablePermitResult
    {
        $endpoint = $this->baseURL . "/disablePermit";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $disablePermitRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\DisablePermitResult::class);
    }

    /**
    * Get stored payment details
    *
    * @param \Adyen\Model\Recurring\RecurringDetailsRequest $recurringDetailsRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\RecurringDetailsResult
    * @throws AdyenException
    */
    public function listRecurringDetails(\Adyen\Model\Recurring\RecurringDetailsRequest $recurringDetailsRequest, array $requestOptions = null): \Adyen\Model\Recurring\RecurringDetailsResult
    {
        $endpoint = $this->baseURL . "/listRecurringDetails";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $recurringDetailsRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\RecurringDetailsResult::class);
    }

    /**
    * Ask issuer to notify the shopper
    *
    * @param \Adyen\Model\Recurring\NotifyShopperRequest $notifyShopperRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\NotifyShopperResult
    * @throws AdyenException
    */
    public function notifyShopper(\Adyen\Model\Recurring\NotifyShopperRequest $notifyShopperRequest, array $requestOptions = null): \Adyen\Model\Recurring\NotifyShopperResult
    {
        $endpoint = $this->baseURL . "/notifyShopper";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $notifyShopperRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\NotifyShopperResult::class);
    }

    /**
    * Schedule running the Account Updater
    *
    * @param \Adyen\Model\Recurring\ScheduleAccountUpdaterRequest $scheduleAccountUpdaterRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Recurring\ScheduleAccountUpdaterResult
    * @throws AdyenException
    */
    public function scheduleAccountUpdater(\Adyen\Model\Recurring\ScheduleAccountUpdaterRequest $scheduleAccountUpdaterRequest, array $requestOptions = null): \Adyen\Model\Recurring\ScheduleAccountUpdaterResult
    {
        $endpoint = $this->baseURL . "/scheduleAccountUpdater";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $scheduleAccountUpdaterRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Recurring\ScheduleAccountUpdaterResult::class);
    }
}
