<?php
/**
 * Plugin Name: WooCommerce Adyen Payment Gateway
 * Description: Accepts Adyen payments on your WooCommerce shop.
 * Version: 1.6.1
 * Author: Webkul
 * Author URI: https://webkul.com
 * Domain Path: /languages
 * Text Domain: wkwc-adyen
 * Requires at least: 5.0
 * Tested up to: 6.6
 * Requires PHP: 7.4
 * Tested up to PHP: 8.3
 * WC requires at least: 6.0
 * WC tested up to: 9.3
 * WKWC_Addons: 1.1.9
 * WKWC_Settings: wkwc-adyen
 * WKWC_Icon_URL: https://store.webkul.com/media/catalog/product/cache/1/image/260x260/9df78eab33525d08d6e5fb8d27136e95/w/o/woocommerce-adyen-payment-integration-webkul_1.png
 * Blog URI: https://webkul.com/blog/woocommerce-adyen-payment-gateway/
 *
 * Requires Plugins: woocommerce
 *
 * @package WkwcAdyen
 */

defined( 'ABSPATH' ) || exit; // Exit if access directly.

// Define Constants.
defined( 'WKADYEN_FILE' ) || define( 'WKADYEN_FILE', __FILE__ );
defined( 'WKADYEN_NAME' ) || define( 'WKADYEN_NAME', 'WooCommerce Adyen Payment Gateway' );
defined( 'WKADYEN_VERSION' ) || define( 'WKADYEN_VERSION', '1.3.0' );
defined( 'WKADYEN_PLUGIN_URL' ) || define( 'WKADYEN_PLUGIN_URL', plugin_dir_url( WKADYEN_FILE ) );

require_once __DIR__ . '/inc/autoload.php';

// Include the main WKWC_ADYEN class.
if ( ! class_exists( 'WKWC_ADYEN', false ) ) {
	include_once dirname( WKADYEN_FILE ) . '/includes/class-wkwc-adyen.php';
}

if ( ! function_exists( 'wkwc_adn_add_submodules' ) ) {

	/**
	 * Add submodules.
	 *
	 * @param array $modules Submodules.
	 *
	 * @return array
	 */
	function wkwc_adn_add_submodules( $modules = array() ) {
		$modules = empty( $modules ) ? array() : $modules;

		if ( ! array_key_exists( 'wkwc_addons', $modules ) ) {
			$modules['wkwc_addons'] = array(
				'version' => 'WKWC_Addons',
				'file'    => 'wkwc-addons/class-wkwc-addons.php',
			);
		}
		return $modules;
	}

	add_filter( 'wkwc_modify_modules_list', 'wkwc_adn_add_submodules' );
}

if ( ! function_exists( 'wkwc_adn_log' ) ) {
	/**
	 * Adding log for debugging.
	 *
	 * @param mixed  $message Message string or array.
	 * @param array  $context Additional parameter, like file name 'source'.
	 * @param string $level One of the following:
	 *     'emergency': System is unusable.
	 *     'alert': Action must be taken immediately.
	 *     'critical': Critical conditions.
	 *     'error': Error conditions.
	 *     'warning': Warning conditions.
	 *     'notice': Normal but significant condition.
	 *     'info': Informational messages.
	 *     'debug': Debug-level messages.
	 *
	 * @return void
	 */
	function wkwc_adn_log( $message, $context = array(), $level = 'info' ) {
		/** Allow to disable the log.
		 *
		 * @since 1.3.0
		*/
		$log_enabled = apply_filters( 'wkwc_adn_is_log_enabled', true );

		if ( function_exists( 'wc_get_logger' ) && $log_enabled ) {
			$source            = ( is_array( $context ) && ! empty( $context['source'] ) ) ? $context['source'] : 'wkwc_adyen';
			$context['source'] = $source;
			$logger            = wc_get_logger();
			$current_user_id   = get_current_user_id();

			$in_action = sprintf( ( /* translators: %s current user id */ esc_html__( 'User in action: %s: ', 'wkwc-adyen' ) ), $current_user_id );
			$message   = $in_action . $message;

			$logger->log( $level, $message, $context );
		}
	}
}

/**
 * Returns the main instance of WC.
 *
 * @return WKWC_ADYEN
 */
function wkwc_adyen_init() {
	return Wkwc_Adyen::instance();
}

// Global for backwards compatibility.
$GLOBALS['wkwc_adyen'] = wkwc_adyen_init();
