<?php
/*
 * Funcion de configuracion para payb
 * version 1.1
 * Fecha: 20 de mayo de 2024
 * Actualizado: 29 de enero de 2025
 * Desarrollado por : Arturo
 * Changelog: Configuración de envio para cada metodo de pago. Configuracion de checked_checkout_link 
 * ShopA
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
add_action('admin_menu', 'my_custom_payment_gateway_menu');
function my_custom_payment_gateway_menu() {
    add_submenu_page(
        'woocommerce',
        'Configuración Pasarela de Pago',
        'Stephan pay cliente',
        'manage_options',
        'my-custom-payment-gateway-settings',
        'my_custom_payment_gateway_settings_page'
    );
}

// Configuración inicial
function initialize_default_stephan_pay_configuration() {
    if (get_option('stephan_pay_configuration') === false) {
		$default_config = array(
			'url' => 'https://payments-shops.softwarelizenzexpress.de/soft-licenses',
			'email_completed_order_template' => '<div style="background-color:#eef562;border-left:solid 2px gray;margin-left:10px;margin-right:10px;padding:10px;text-decoration:none;margin-bottom:8px;font-size:16px;">{mensaje}</div>',
			'checkout_page_message_template' => '<style>.payment-method-icon i{font-size:40px;color:#D20062;}</style><div style="height:10px;"></div><div class="alert-message" style="display: flex; align-items: center; gap: 10px; width: 90%;background-color:#E7E7EE;"><div class="payment-method-icon" style="flex-shrink: 0;"><i class="fas fa-credit-card" style="font-size: 40px; color: #D20062;"></i></div><div class="message-content" style="flex-grow: 1;color:black;">{mensaje}</div></div>',
			'payment_link_template' => '<style>.message-content a{color:red!important;font-size:20px;}</style><div style="height:10px"></div><div class="verde alert-message"><div class="payment-method-icon" style="flex-shrink: 0"><i class="fas fa-credit-card" style="font-size: 40px;color: #D20062"></i></div><div class="message-content" style="flex-grow: 1;color:black">{mensaje}</div></div>',
			'email_completed_order_message' => 'You can pay your dispatched order by clicking <a href="%s">here</a>.',
			'checkout_page_message' => 'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.',
			'checkout_page_message_1' => 'You will receive the payment link in another email.',
			'checkout_link_message' => 'Now that you have your product, you can easily pay by clicking on the following <a href="%s">link</a>',
		);

		$translations = array(
			'en' => [
				'To pay for this order, please contact %s' => 'To pay for this order, please contact %s',
				'You can pay your dispatched order by clicking <a href="%s">here</a>.' => 'You can pay your dispatched order by clicking <a href="%s">here</a>.',
				'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.'=>'You are paying with <b>Pay after invoice</b> method, that means you already have the product in your inbox email.',
				'Service for'=>'Service for',
				'Click <a href="%s" %s>here</a> to proceed to pay.' => 'Click <a href="%s" %s>here</a> to proceed to pay.',
				'You will receive the payment link in another email.' => 'You will receive the payment link in another email.',
				'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]' => 'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]',
			],
			'es' => [
				'To pay for this order, please contact %s' => 'Para pagar este pedido, por favor contacta a %s',
				'You can pay your dispatched order by clicking <a href="%s">here</a>.' => 'Puede pagar su pedido enviado haciendo clic <a href="%s">aquí</a>.',
				'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.'=>'Estás pagando con el método <b>Pago después de la factura</b>, eso significa que ya tienes el producto en tu bandeja de entrada de correo electrónico.',
				'Service for'=>'Servicio para',
				'Click <a href="%s" %s>here</a> to proceed to pay.' => 'Haga clic <a href="%s" %s>aquí</a> para proceder al pago.',
				'You will receive the payment link in another email.' => 'Recibirás el enlace de pago en otro correo electrónico.',
				'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]' => 'Ahora que tienes tu producto, puedes pagar fácilmente haciendo clic en el siguiente [[a href=%s]]enlace[[/a]]',
			],
			'it' => [
				'To pay for this order, please contact %s' => 'Per pagare questo ordine, si prega di contattare %s',
				'You can pay your dispatched order by clicking <a href="%s">here</a>.' => 'Puoi pagare il tuo ordine spedito facendo clic <a href="%s">qui</a>.',
				'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.'=>'Stai pagando con il metodo <b>Paga dopo la fattura</b>, ciò significa che hai già il prodotto nella tua casella di posta elettronica.',
				'Service for'=>'Servizio per',
				'Click <a href="%s" %s>here</a> to proceed to pay.' => 'Fai clic <a href="%s" %s>qui</a> per procedere con il pagamento.',
				'You will receive the payment link in another email.' => 'Riceverai il link per il pagamento in un&apos;altra email.',
				'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]' => 'Ora che hai il tuo prodotto, puoi pagare facilmente cliccando sul seguente [[a href=%s]]link[[/a]]',
			],
			'de' => [
				'To pay for this order, please contact %s' => 'Um diese Bestellung zu bezahlen, bitte kontaktieren Sie %s',
				'You can pay your dispatched order by clicking <a href="%s">here</a>.' => 'Sie können Ihre bereits versendete Bestellung bezahlen, indem Sie <a href="%s">hier</a> klicken.',
				'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.'=>'Sie zahlen mit der Methode <b>Zahlung nach Rechnung</b>, das heißt, Sie haben das Produkt bereits in Ihrem E-Mail-Posteingang.',
				'Service for'=>'Service für',
				'Click <a href="%s" %s>here</a> to proceed to pay.' => 'Klicken Sie <a href="%s" %s>hier</a>, um mit der Zahlung fortzufahren.',
				'You will receive the payment link in another email.' => 'Den Zahlungslink erhalten Sie in einer weiteren E-Mail.',
				'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]' => 'Nachdem Sie nun Ihr Produkt haben, können Sie ganz einfach bezahlen, indem Sie auf den folgenden [[a href=%s]]Link[[/a]] klicken.',
			],
			'fr' => [
				'To pay for this order, please contact %s' => 'Pour payer cette commande, veuillez contacter %s',
				'You can pay your dispatched order by clicking <a href="%s">here</a>.' => 'Vous pouvez payer votre commande expédiée en cliquant <a href="%s">ici</a>.',
				'You are paying with *Pay after invoice* method, that means you already have the product in your inbox email.'=>'Vous payez avec la méthode <b>Payer après facture</b>, cela signifie que vous avez déjà le produit dans votre boîte de réception.',
				'Service for'=>'Service pour',
				'Click <a href="%s" %s>here</a> to proceed to pay.' => 'Cliquez <a href="%s" %s>ici</a> pour procéder au paiement.',
				'You will receive the payment link in another email.' => 'Vous recevrez le lien de paiement dans un autre e-mail.',
				'Now that you have your product, you can easily pay by clicking on the following [[a href=%s]]link[[/a]]' => 'Maintenant que vous avez votre produit, vous pouvez facilement payer en cliquant sur le [[a href=%s]]lien suivant[[/a]]',
			],
		);
        update_option('stephan_pay_configuration', $default_config);
	    update_option('stephan_pay_translations', $translations);
    }
}
add_action('admin_init', 'initialize_default_stephan_pay_configuration');

function my_custom_payment_gateway_settings_page() {
    $config = get_option('stephan_pay_configuration', array());
    $translations1 = get_option('stephan_pay_translations', array());
	$urls = $config['urls'];
	$firstpays = $config['firstpays'];
	$checked_checkout_link = "";
	if($config['checkout_link']==1){
		$checked_checkout_link = "checked";
		$checkout_link_message = $config['checkout_link'];
	}
    ?>
    <div class="wrap">
        <h1>Configuración de la Pasarela de Pago</h1>
        <h2 class="nav-tab-wrapper">
            <a href="#tab-url" class="nav-tab nav-tab-active" data-tab="tab-url">URL</a>
            <a href="#tab-templates" class="nav-tab" data-tab="tab-templates">Templates</a>
            <a href="#tab-messages" class="nav-tab" data-tab="tab-messages">Mensajes</a>
            <a href="#tab-translations" class="nav-tab" data-tab="tab-translations">Traducciones</a>
            <a href="#tab-checkout" class="nav-tab" data-tab="tab-checkout">Checkout</a>
        </h2>
        <form method="post" action="admin-post.php">
            <input type="hidden" name="action" value="save_stephan_pay_configuration">
            <?php wp_nonce_field('save_stephan_pay_configuration_nonce'); ?>
            <div id="tab-url" class="tab-content active">
                <table id="urls-table" class="widefat fixed">
					<tr>
						<th>CODIGO DEL METODO DE PAGO</th>
						<th>URL PARA ESTE METODO <br>Ejemplo: https://arturo.winandoffice.com/payb</th>
						<th style="width:70px;">ESPERAR PAGO<br><small style="font-size:8px;">ANTES DE DESPACHAR</small></th>
						<th>ELIMINAR</th>
					</tr>
					<?php $i=0; ?>
					<?php foreach ($urls as $metpago => $url): ?>
					<?php 
							$firstpaychecked=$firstpays[$metpago]?'checked':'';
					?>
						<tr>
							<td><input name="met_pago[]" type="text" value="<?php echo esc_attr($metpago); ?>" style="width:100%" /></td>
							<td><textarea  name="url[]" style="width:100%"/><?php echo esc_attr($url); ?></textarea></td>
							<td><input name="firstpay[<?php echo $i;?>]" type="hidden" value=0><input name="firstpay[<?php echo $i;?>]" type="checkbox" <?php echo $firstpaychecked;?> value=1></td>
							<td><button type="button" class="button remove-row">-</button></td>
						</tr>
						<?php $i++; ?>
					<?php endforeach; ?>
                </table>
                <button type="button" id="add-url-row" class="button">+</button>
            </div>
            <div id="tab-templates" class="tab-content">
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="email_completed_order_template">Email Completed Order Template</label></th>
                        <td>
                            <textarea id="email_completed_order_template" name="email_completed_order_template" rows="5" class="large-text"><?php echo esc_textarea($config['email_completed_order_template']); ?></textarea>
							<h4 style="margin:0px;">Este es el template que se muestra en los correos de orden completada que recibe el cliente. {mensaje} debe ser configurado en la pestaña de mensajes</h4>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="checkout_page_message_template">Checkout Page Message Template</label></th>
                        <td>
                            <textarea id="checkout_page_message_template" name="checkout_page_message_template" rows="5" class="large-text"><?php echo esc_textarea($config['checkout_page_message_template']); ?></textarea>
							<h4 style="margin:0px;">Este es el template que se muestra en la checkout page. {mensaje} debe ser configurado en la pestaña de mensajes</h4>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="payment_link_template">Link de pago en la Checkout Page Template</label></th>
                        <td>
                            <textarea id="payment_link_template" name="payment_link_template" rows="5" class="large-text"><?php echo esc_textarea($config['payment_link_template']); ?></textarea>
							<h4 style="margin:0px;">Template para link de pago en Checkout Page</h4>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="tab-messages" class="tab-content">
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="email_completed_order_message">Email Completed Order Message</label></th>
                        <td>
                            <textarea id="email_completed_order_message" name="email_completed_order_message" rows="2" class="large-text"><?php echo esc_textarea($config['email_completed_order_message']); ?></textarea>
							<h4 style="margin:0px;">Mensaje que se muestra en los correos de orden completada que recibe el cliente. Este texto reemplaza a {mensaje} en el template correspondiente</h4>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="checkout_page_message">Checkout Page Message</label></th>
                        <td>
                            <textarea id="checkout_page_message" name="checkout_page_message" rows="2" class="large-text"><?php echo esc_textarea($config['checkout_page_message']); ?></textarea>
							<h4 style="margin:0px;">Mensaje que se muestra en la checkout page. Este texto reemplaza a {mensaje} en el template correspondiente</h4>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="checkout_page_message_1">Checkout Page Message 1</label></th>
                        <td>
                            <textarea id="checkout_page_message_1" name="checkout_page_message_1" rows="2" class="large-text"><?php echo esc_textarea($config['checkout_page_message_1']); ?></textarea>
							<h4 style="margin:0px;">Mensaje alternativo que se muestra en la checkout page. Este texto reemplaza a {mensaje} en el template correspondiente</h4>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="checkout_page_message_1">Mensaje para link en checkout</label></th>
                        <td>
                            <textarea id="checkout_link_message" name="checkout_link_message" rows="2" class="large-text"><?php echo esc_textarea($config['checkout_link_message']); ?></textarea>
							<h4 style="margin:0px;">Mostrar link de pago en checkout (Si esta configurado)</h4>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="tab-translations" class="tab-content">
                <table id="translations-table" class="widefat fixed">
                    <thead>
                        <tr>
                            <th class="manage-column" width="100px">Idioma</th>
                            <th class="manage-column">Cadena a traducir</th>
                            <th class="manage-column">Cadena traducida</th>
                            <th class="manage-column"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($translations1 as $lang => $translations): ?>
                            <?php foreach ($translations as $key => $value): ?>
                                <tr>
                                    <td><input type="text" name="translations_lang[]" value="<?php echo esc_attr($lang); ?>" style="width:100%" /></td>
                                    <td><textarea  name="translations_key[]" style="width:100%"/><?php echo esc_attr($key); ?></textarea></td>
                                    <td><textarea type="text" name="translations_value[]" style="width:100%" /><?php echo esc_attr($value); ?></textarea></td>
                                    <td><button type="button" class="button remove-row">-</button></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <button type="button" id="add-translation-row" class="button">+</button>
            </div>
            <div id="tab-checkout" class="tab-content">
				<div style="padding:15px;margin: 20px;">
				<input type="checkbox" id="checkout_link" name="checkout_link" <?php echo $checked_checkout_link;?>>
				<label for="checkout_link">Mostrar link de pago en página checkout</label>
				</div>
				
            </div>
            <button type="submit" class="button button-primary">Guardar</button>
        </form>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tabs = document.querySelectorAll('.nav-tab');
            var tabContents = document.querySelectorAll('.tab-content');
            var addTranslationRowButton = document.getElementById('add-translation-row');
            var addUrlRowButton = document.getElementById('add-url-row');
            var translationsTableBody = document.querySelector('#translations-table tbody');
            var urlsTableBody = document.querySelector('#urls-table tbody');

            tabs.forEach(function(tab) {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    tabs.forEach(function(t) { t.classList.remove('nav-tab-active'); });
                    tabContents.forEach(function(tc) { tc.classList.remove('active'); });

                    tab.classList.add('nav-tab-active');
                    document.querySelector(tab.getAttribute('href')).classList.add('active');
                });
            });

            addTranslationRowButton.addEventListener('click', function() {
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="translations_lang[]" /></td>
                    <td><input type="text" name="translations_key[]" /></td>
                    <td><input type="text" name="translations_value[]" /></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;
                translationsTableBody.appendChild(newRow);

                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            addUrlRowButton.addEventListener('click', function() {
				var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="met_pago[]" style="width:100%"/></td>
                    <td><input type="text" name="url[]" style="width:100%"/></td>
					<td><input name="firstpay[]" type="checkbox"></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;

                urlsTableBody.appendChild(newRow);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });


            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
    <?php
}

add_action('admin_post_save_stephan_pay_configuration', 'save_stephan_pay_configuration');
function save_stephan_pay_configuration() {
    check_admin_referer('save_stephan_pay_configuration_nonce');
 if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }

    $config = get_option('stephan_pay_configuration', array());
    $allowed_html = array(
    'style' => array(),
    'div' => array(
        'style' => array(),
        'class' => array(), // Permitir el atributo 'class' en la etiqueta 'div'
    ),
    'i' => array(
        'class' => array(),
        'style' => array(),
    ),
    'a' => array(
        'href' => array(),
        'class' => array(), // Permitir el atributo 'class' en la etiqueta 'a'
    ),
    'br' => array(),
    'p' => array(),
    'strong' => array(),
    'em' => array(),
    'span' => array(
        'style' => array(),
        'class' => array(), // Permitir el atributo 'class' en la etiqueta 'span'
    ),
    );
    if (isset($_POST['shopa_pagar_host'])) {
        $config['url'] = sanitize_text_field($_POST['shopa_pagar_host']);
    }

    if (isset($_POST['email_completed_order_template'])) {
        $config['email_completed_order_template'] = wp_kses($_POST['email_completed_order_template'], $allowed_html);
    }

    if (isset($_POST['checkout_page_message_template'])) {
        //$config['checkout_page_message_template'] = wp_kses($_POST['checkout_page_message_template'],$allowed_html);
		$config['checkout_page_message_template'] = wp_kses($_POST['checkout_page_message_template'], $allowed_html);

    }

    if (isset($_POST['payment_link_template'])) {
		$config['payment_link_template'] = wp_kses($_POST['payment_link_template'], $allowed_html);

    }

    if (isset($_POST['email_completed_order_message'])) {
        $config['email_completed_order_message'] = wp_kses_post($_POST['email_completed_order_message']);
    }

    if (isset($_POST['checkout_page_message'])) {
        $config['checkout_page_message'] = wp_kses_post($_POST['checkout_page_message']);
    }

    if (isset($_POST['checkout_page_message_1'])) {
        $config['checkout_page_message_1'] = wp_kses_post($_POST['checkout_page_message_1']);
    }

    if (isset($_POST['checkout_link_message'])) {
        $config['checkout_link_message'] = wp_kses_post($_POST['checkout_link_message']);
    }

    $translations = array();
    if (isset($_POST['translations_lang']) && isset($_POST['translations_key']) && isset($_POST['translations_value'])) {
        for ($i = 0; $i < count($_POST['translations_lang']); $i++) {
            $lang = sanitize_text_field($_POST['translations_lang'][$i]);
            $key = sanitize_text_field($_POST['translations_key'][$i]);
			//$value = str_replace("&apos;","'",$_POST['translations_value'][$i]);
            $value = sanitize_text_field($_POST['translations_value'][$i]);
            if (!empty($lang) && !empty($key) && !empty($value)) {
                if (!isset($translations[$lang])) {
                    $translations[$lang] = array();
                }
                $translations[$lang][$key] = $value;
            }
        }
    }

    $url = array();
 
   if (isset($_POST['met_pago']) && isset($_POST['url'])) {
        for ($i = 0; $i < count($_POST['met_pago']); $i++) {
            $met_pago = sanitize_text_field($_POST['met_pago'][$i]);
            $url = sanitize_text_field($_POST['url'][$i]);
			$urls[$met_pago]=$url;

			$firstpays[$met_pago]=isset($_POST['firstpay'][$i])&&$_POST['firstpay'][$i]==1?1:0;
			
        }
        $config['urls'] = $urls;
        $config['firstpays'] = $firstpays;
    }


    if (isset($_POST['checkout_link'])) {
        $config['checkout_link'] = 1;
    }else{
        $config['checkout_link'] = 0;
	}

    update_option('stephan_pay_configuration', $config);
    update_option('stephan_pay_translations', $translations);

    wp_redirect(admin_url('admin.php?page=my-custom-payment-gateway-settings&status=1'));
    exit;
}
