<?php
/*
 * Pasarela de pago propio de WAO.
 * version 1.0
 * Fecha: 27 de marzo de 2024
 * Actualizado: 29 de enero de 2025
 * Desarrollado por : Arturo
 * ShopA
 * CONFIGURAR: $pagar_host, ESTILOS DE MENSAJES EN $template, mensajes $mensaje|| TODO ESTO YA SE PUSO EN pay_configuracion_cliente.php
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/* CONFIGURAR VARIABLES*/
global $pagar_host;
$pagar_host = 'https://arturo.winandoffice.com/payb'; // URL DEL SERVIDOR PAYB

/*
 * Código para ShopA (Enviar Petición) 
*/
// Cuando se ha finalizado un pedido, prepara un json con información para enviar a PayB
function custom_process_order($order_id) {
	$order = wc_get_order($order_id);
	$option = get_option('stephan_pay_configuration');
	$met_pagos = $option['urls'];
	$payment_method = $order->get_payment_method();
	$met_pagos_column = array();
	foreach($met_pagos as $met_pago => $url){
		$met_pagos_column[] = $met_pago;
	}
	//if ($order->get_payment_method() == 'cod') {
	if (in_array($payment_method,$met_pagos_column)) {
		// Extraer información de facturación
		$billing_email = $order->get_billing_email();
		$billing_info = [
			'first_name' => $order->get_billing_first_name(),
			'last_name'  => $order->get_billing_last_name(),
			'company'    => $order->get_billing_company(),
			'address_1'  => $order->get_billing_address_1(),
			'address_2'  => $order->get_billing_address_2(),
			'city'       => $order->get_billing_city(),
			'state'      => $order->get_billing_state(),
			'postcode'   => $order->get_billing_postcode(),
			'country'    => $order->get_billing_country(),
			'email'      => $billing_email,
			'phone'      => $order->get_billing_phone()
		];

		$site_id = is_multisite()?get_current_blog_id():0; 

		$itemsforgo = array();
		$items = $order->get_items();
		
		foreach ($items as $item_id => $item) {
			$product = $item->get_product();
			$itemsforgo[] = array(
				'name' => $item->get_name(),
				'quantity' => $item->get_quantity(),
				'price' => $item->get_total(), // O usa get_subtotal() según lo que necesites
			);
		}
		if(is_multisite()){
			$blog_id = get_current_blog_id(); // Obtiene el ID del blog actual
			$blog_details = get_blog_details($blog_id);
			$path = $blog_details->path;
		}else{
			$path = '';
		}
		// Preparar los datos para enviar a PayB
		$data = [
			'order_id' => $order_id,
			'total' => $order->get_total(),
			'taxes' => $order->get_total_tax(),
			'items' => $itemsforgo,
			'currency' => get_woocommerce_currency(),
			'shop_url' => get_site_url(),
			'shop_path' => $path,
			'shop_name' => get_bloginfo('name'),
			'shop_site_id' => $site_id,
			'payment_method_note' => ___(get_stephan_pay_option('checkout_page_message')),
			'billing_info'  => $billing_info // Incluir la información de facturación
		];
		
		// Endpoint de PayB
		//$remote_host = get_stephan_pay_option('url')."/wp-json/custom/v1/process-order";
		$remote_host = $met_pagos[$payment_method]."/wp-json/custom/v1/process-order";

		//$remote_host = $pagar_host;
		$response = wp_remote_post($remote_host, [
			'body' => json_encode($data),
			'headers' => ['Content-Type' => 'application/json'],
			'timeout' => 90,
		]);
		
		// Verificar si la respuesta es exitosa
		if (wp_remote_retrieve_response_code($response) == 200) {
			$body = wp_remote_retrieve_body($response);
			$result = json_decode($body, true);
			if (!empty($result['checkout_url'])) {
				 // Guardar la URL de checkout en los metadatos del pedido para su uso en el correo
				update_post_meta($order_id, '_payb_checkout_url', $result['checkout_url']);
				update_post_meta($order_id, '_shopa_checkout_message', $data['payment_method_note']);

				$note = 'Link del producto creado en la pasarela de pago: <a href="'.$result['checkout_url'].'">'.$result['checkout_url'].'</a>';
				$order->add_order_note($note, false); 

				$note1 = 'El total fue:'.$order->get_total().' y los taxes: '.$order->get_total_tax();
				$order->add_order_note($note1, false); 

				// Redirigir al cliente a la página de checkout de PayB  
				//wp_redirect($result['checkout_url']);
				//exit;  
		  }
		}
		// Cambiar el estado de la orden a "Completed" 
		//$order->update_status('completed');
		//return $result['checkout_url'];
	}
}
add_action('woocommerce_checkout_order_processed', 'custom_process_order', 10, 1);

// Adjunta al email, el link de pago hacia PayB
function customize_order_completed_email($order, $sent_to_admin, $plain_text, $email) {
	$order_id = $order->get_id();
	if(verifica_met_pago($order_id)){
		if ($email->id == 'customer_completed_order') {
			$order_id = $order->get_id();
			$checkout_url = get_post_meta($order_id, '_payb_checkout_url', true);
			$template = get_stephan_pay_option('email_completed_order_template');
			if (!empty($checkout_url)) {
				$mensaje = sprintf(___( get_stephan_pay_option('email_completed_order_message')),esc_url($checkout_url));
			}else{
				$admin_email = get_option('admin_email');
				$mensaje = sprintf(___( 'To pay for this order, please contact %s'),$admin_email);
				
			}
			$template = str_replace('{mensaje}',$mensaje,$template);
			echo $template;
		}
	}
}
add_action('woocommerce_email_order_details', 'customize_order_completed_email', 1, 4);  

// Comparar metodos de pago configurado vs metodo de pago actual
function verifica_met_pago($order_id){
	$order = wc_get_order($order_id);	
	$current_payment_method = $order->get_payment_method();
	$steph_config=get_option('stephan_pay_configuration');
	$steph_urls=$steph_config['urls'];
	if(array_key_exists($current_payment_method, $steph_urls)){
		return true;
	}else{
		return false;
	}
}
// Coloca mensaje en checkout page con el link de pago hacia PayB
function custom_checkout_message($order_id) {
	if(!verifica_met_pago($order_id)){return;}

	$payment_method_note = get_post_meta($order_id, '_shopa_checkout_message', true); 
    $order = wc_get_order($order_id);
	if ($order) {
        $checkout_page_message = 'You will receive the payment link in another email.';
		$template = '
			<style>
				.payment-method-icon i{font-size:40px;color:#D20062;}
				
			</style>
			<div style="height:10px;"></div>
			<div class="alert-message" style="display: flex; align-items: center; gap: 10px; width: 90%;background-color:#E7E7EE;">
			  <div class="payment-method-icon" style="flex-shrink: 0;"><i class="fas fa-credit-card" style="font-size: 40px; color: #D20062;"></i></div>
			  <div class="message-content" style="flex-grow: 1;color:black;">{mensaje}</div>
			</div>
		';
		$template = get_stephan_pay_option('checkout_page_message_template');
		//<span class="dashicons dashicons-money" style="font-size: 40px; color: #D20062;"></span>
        // Verificar si el mensaje y la URL existen y no están vacíos
        if (!empty($payment_method_note)) {
            $msj = '<div>'.___($payment_method_note).'</div>';
        }
		if (!empty($checkout_page_message)) {
            $msj .= '<div>'.___($checkout_page_message).'</div>';
        }
		$template = str_replace('{mensaje}',$msj,$template); 
		echo $template;

		// Aqui se verifica si se activo link de pago en thankyoupage, por si carga la informacion y la muestra
		//$config = get_option('stephan_pay_configuration', array());
		//$checkout_link = $config['checkout_link'] ?? false; // Valor predeterminado es false
		$checkout_link = get_stephan_pay_option('checkout_link');
		if($checkout_link){
				$template33 = '
					<style>
						.icon1{background-color:#4caf50!important;border-color:#4caf50!important}
						.icon1:after{background-color:#4caf50!important;border-color:#4caf50!important}
						.message-content2 a{color:red!important;}
					</style>
					<div class="alert alert-warning alert-white rounded">
						<div class="icon icon1"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M0 80C0 53.5 21.5 32 48 32H528c26.5 0 48 21.5 48 48v48H0V80zM576 176v240c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V176H576zM96 368a16 16 0 1 0 0-32h-32a16 16 0 1 0 0 32h32zm64 0a16 16 0 1 0 0-32H128a16 16 0 1 0 0 32h32zm64 0a16 16 0 1 0 0-32H192a16 16 0 1 0 0 32h32zm64 0a16 16 0 1 0 0-32H256a16 16 0 1 0 0 32h32zm224-64H368c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16z"/></svg></div>
						<div class="message-content2">{mensaje}</div>
					</div>
				';	
			$template = get_stephan_pay_option('payment_link_template');
			//$checkout_link_message = $config['checkout_link_message'];
			$checkout_link_message = get_stephan_pay_option('checkout_link_message');
			$checkout_url = get_post_meta($order_id, '_payb_checkout_url', true);
			$checkout_link_message = sprintf(___($checkout_link_message), esc_url($checkout_url));
			$template = str_replace('{mensaje}',$checkout_link_message,$template); 
			echo $template;
		}
		
		
	}
}
add_action('woocommerce_thankyou', 'custom_checkout_message',2,2); 

// Cargamos font-awesome para mostrar en el mensaje en checkout page
function mi_tema_enqueue_scripts() {
    wp_enqueue_style( 'font-awesome', 'https://use.fontawesome.com/releases/v5.15.1/css/all.css' );
}
add_action( 'wp_enqueue_scripts', 'mi_tema_enqueue_scripts' );

// Funcion para traducir pocas cadenas
if (!function_exists('___')) {
	function ___($cadena) {
		$locale = get_locale();
		$idioma = substr($locale, 0, 2);
		// Arreglo de traducciones
		$traducciones = get_option('stephan_pay_translations');
		// Verificar si el idioma y la cadena existen en el arreglo de traducciones
		if (isset($traducciones[$idioma][$cadena])) {
			return $traducciones[$idioma][$cadena];
		}

		// Si no se encuentra la traducción, devolver la cadena original
		return $cadena;
	}
}
// Funcion para hacer depuracion
if (!function_exists('depu')) {
	function depu($masdato){
		$dato = get_option('_depu');
		if ($masdato == "*"){
			$dato = "";
		}else{
			$dato .= "|".$masdato;
		}
		update_option('_depu',$dato);
	}
}

// Añadir estado de orden personalizado: Pagado
function wc_add_order_status_paid() {
    register_post_status('wc-paid', array(
        'label'                     => _x('Pagado', 'Order status', 'woocommerce'),
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop('Pagado <span class="count">(%s)</span>', 'Pagado <span class="count">(%s)</span>', 'woocommerce')
    ));
}
add_action('init', 'wc_add_order_status_paid');

// Añadir el nuevo estado a lista de estados de WooCommerce
function wc_add_paid_order_statuses($order_statuses) {
    $order_statuses['wc-paid'] = _x('Pagado', 'Order status', 'woocommerce');
    return $order_statuses;
}
add_filter('wc_order_statuses', 'wc_add_paid_order_statuses');

// API PARA CAMBIAR A ESTADO Pagado cuando se ha completado la orden en PayB
add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/update_order_status', array(
		'methods' => 'POST',
        'callback' => 'handle_update_order_status',
        'permission_callback' => '__return_true' // Asegúrate de implementar una autenticación adecuada en producción
    ));
});

function handle_update_order_status(WP_REST_Request $request) {
    $origin_order_id = $request->get_param('origin_order_id');
    $origin_site_id = $request->get_param('origin_site_id');
    if (is_multisite()) {
        switch_to_blog($origin_site_id); // Cambiar al blog del sitio de origen
    }

    // Intentar actualizar el estado de la orden
    $order = wc_get_order($origin_order_id);
    if ($order) {
        $order->update_status('paid', 'Orden actualizada a Pagado via API.', true);
        if (is_multisite()) {
            restore_current_blog(); // Volver al sitio original si es multisite
        }
        return new WP_REST_Response('Orden actualizada a Pagado', 200);
    }

    if (is_multisite()) {
        restore_current_blog(); // Asegurarse de restaurar en caso de cualquier falla
    }
    return new WP_REST_Response('Orden no encontrada', 404);
}

// API DE EJEMPLO
add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/soloprueba', array(
		'methods' => 'POST',
        'callback' => 'test',
        'permission_callback' => '__return_true' // Asegúrate de implementar una autenticación adecuada en producción
    ));
});

function test(){
	//depu('si2');
    $new_status = $request->get_param('new_status');
	//depu($new_status);
}

function get_stephan_pay_option($option) {
    $options = get_option('stephan_pay_configuration', false);
    if (is_array($options) && array_key_exists($option, $options)) {
		$retorno = str_replace('[[','<',$options[$option]);
		$retorno = str_replace(']]','>',$retorno);
        return $options[$option];
    } else {
        return false;
    }
}
