<?php
/*
 * Código para insertar columna shop order en listado de ordenes
 * 
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Agrega una columna personalizada en la tabla de pedidos
add_filter('manage_edit-shop_order_columns', 'agregar_columna_personalizada_pedidos');
function agregar_columna_personalizada_pedidos($columns) {
    $columns['product_info'] = __('Shop Order', 'textdomain');
    return $columns;
}

// Rellena la columna personalizada con información sobre los productos
add_action('manage_shop_order_posts_custom_column', 'mostrar_informacion_producto_columna', 10, 2);
function mostrar_informacion_producto_columna($column, $post_id) {
    if ('product_info' === $column) {
        $order = wc_get_order($post_id);
        $items = $order->get_items();
        $info_producto = '';
        //print_r($items );
        foreach ($items as $item) {
            $info_producto .= $item['name'] . '<br>';
        }

        echo $info_producto;
    }
}


