<?php
/*
 * Funcion de configuracion para payb
 * version 1.1
 * Fecha: 17 de mayo de 2024
 * Actualizado: 12 de febrero de 2025
 * Cambios: Configuracion de personalizacion de logo
 * Desarrollado por : Arturo
 * PayB
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Añadir menú en la parte de administración
function payb_admin_menu() {
    add_menu_page(
        'Configuración Pasarela PayB',
        'Configuración Pasarela PayB',
        'manage_options',
        'payb-settings',
        'payb_settings_page',
        'dashicons-admin-generic',
        20
    );
}
add_action('admin_menu', 'payb_admin_menu');
// Diseño de la pagina 
function payb_settings_page() {
    ?>
	<div class="wrap">
        <h1>Configuración Pasarela PayB</h1>
        <h2 class="nav-tab-wrapper">
            <!-- <a href="#tab-urls" class="nav-tab" data-tab="tab-urls">URLs</a>
            <a href="#tab-countries" class="nav-tab" data-tab="tab-countries">Países</a> -->
            <a href="#tab-other" class="nav-tab nav-tab-active" data-tab="tab-other">P&aacute;gina Producto</a>
            <a href="#tab-translations" class="nav-tab" data-tab="tab-translations">Traducciones</a>
            <a href="#tab-customize" class="nav-tab" data-tab="tab-customize">Personalizar logo trustami trustpilot</a>
        </h2>
        <div id="tab-urls" class="tab-content">
            <?php payb_settings_urls_content(); ?>
        </div>
        <div id="tab-countries" class="tab-content">
            <?php payb_settings_countries_content(); ?>
        </div>
        <div id="tab-other" class="tab-content active">
            <?php payb_settings_other_content(); ?>
        </div>

		<div id="tab-translations" class="tab-content">
			<?php payb_settings_translations(); ?>
		</div>
		<div id="tab-customize" class="tab-content">
			<?php payb_settings_customize(); ?>
		</div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tabs = document.querySelectorAll('.nav-tab');
            var tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(function(tab) {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    tabs.forEach(function(t) { t.classList.remove('nav-tab-active'); });
                    tabContents.forEach(function(tc) { tc.classList.remove('active'); });

                    tab.classList.add('nav-tab-active');
                    document.querySelector(tab.getAttribute('href')).classList.add('active');
                });
            });
        });
    </script>
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
    <?php
}
function payb_settings_urls_content() {
    $data = get_option('payb_settings_urls', array());
    ?>
    <h2>Configuración de URLs de los Shops</h2>
	<p>Esta asociacion de url con un sufijo, sirve para asignar dinámicamente el nombre a un producto creado automáticamente desde una tienda externa.</p>
	<p>Por ejemplo, para una orden que proviene de winandoffice.com, el producto se creará conteniendo el sufijo D1 (que es la configuración inicial)</p>
    <form method="post" action="admin-post.php">
        <input type="hidden" name="action" value="save_custom_settings_urls">
        <?php wp_nonce_field('save_custom_settings_urls_nonce'); ?>
        <table id="custom-url-table" class="widefat fixed">
            <thead>
                <tr>
                    <th class="manage-column">URL</th>
                    <th class="manage-column">Sufijo</th>
                    <th class="manage-column"></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $row): ?>
                    <tr>
                        <td><input type="text" name="urls[]" value="<?php echo esc_attr($row['url']); ?>" /></td>
                        <td><input type="text" name="suffixes[]" value="<?php echo esc_attr($row['suffix']); ?>" /></td>
                        <td><button type="button" class="button remove-row">-</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <button type="button" id="add-row" class="button">+</button>
        <button type="submit" class="button button-primary">Guardar</button>
    </form>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var addRowButton = document.getElementById('add-row');
            var tableBody = document.querySelector('#custom-url-table tbody');

            addRowButton.addEventListener('click', function() {
                var newRow = document.createElement('tr');
                newRow.innerHTML = '<td><input type="text" name="urls[]" /></td><td><input type="text" name="suffixes[]" /></td><td><button type="button" class="button remove-row">-</button></td>';
                tableBody.appendChild(newRow);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
    <?php
}
function payb_settings_countries_content() {
    $data = get_option('payb_settings_countries', array());
    ?>
    <h2>Configuración de Países</h2>
	<p>Esta asociacion de pais con un sufijo, sirve para asignar dinámicamente el nombre a un producto creado automáticamente desde una tienda externa.</p>
	<p>Por ejemplo, para una orden que proviene de cualquier shop que tenga como path 'deutschland', el producto se creará conteniendo el sufijo DEU (que es la configuración inicial)</p>
    <form method="post" action="admin-post.php">
        <input type="hidden" name="action" value="save_custom_settings_countries">
        <?php wp_nonce_field('save_custom_settings_countries_nonce'); ?>
        <table id="custom-country-table" class="widefat fixed">
            <thead>
                <tr>
                    <th class="manage-column">País</th>
                    <th class="manage-column">Sufijo</th>
                    <th class="manage-column"></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $row): ?>
                    <tr>
                        <td><input type="text" name="countries[]" value="<?php echo esc_attr($row['country']); ?>" /></td>
                        <td><input type="text" name="suffixes[]" value="<?php echo esc_attr($row['suffix']); ?>" /></td>
                        <td><button type="button" class="button remove-row">-</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <button type="button" id="add-row-country" class="button">+</button>
        <button type="submit" class="button button-primary">Guardar</button>
    </form>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var addRowButtonCountry = document.getElementById('add-row-country');
            var tableBodyCountry = document.querySelector('#custom-country-table tbody');
            addRowButtonCountry.addEventListener('click', function() {
                var newRow = document.createElement('tr');
newRow.innerHTML = '<td><input type="text" name="countries[]" /></td><td><input type="text" name="suffixes[]" /></td><td><button type="button" class="button remove-row">-</button></td>';
                tableBodyCountry.appendChild(newRow);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>

    <?php
}
function payb_settings_other_content() {
    $background_image_id = get_option('payb_background_image_id', '');
    $background_image_url = $background_image_id ? wp_get_attachment_url($background_image_id) : '';
    $message_in_product = get_option('payb_message_in_product', '');
    ?>
    <h2>Otra Configuración</h2>
    <form method="post" action="admin-post.php">
        <input type="hidden" name="action" value="save_custom_settings_other">
        <?php wp_nonce_field('save_custom_settings_other_nonce'); ?>
        <table class="form-table">
            <tr>
                <th scope="row"><label for="background_image_id">Imagen de fondo para productos creados</label></th>
                <td>
                    <input type="hidden" id="background_image_id" name="background_image_id" value="<?php echo esc_attr($background_image_id); ?>">
                    <button type="button" class="button" id="upload_image_button">Seleccionar imagen</button>
                    <div id="image_preview" style="width:300px;margin-top: 10px;background-color:#e3e3e3;box-shadow: 12px 12px 2px 1px rgba(167, 163, 163, .5);padding:15px;text-align:center">
                        <?php if ($background_image_url): ?>
                            <img src="<?php echo esc_url($background_image_url); ?>" style="max-width: 200px;">
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="message_in_product">Mensaje para la pagina de producto</label></th>
                <td>
                    <textarea style="width:350px;height:100px;" id="message_in_product" name="message_in_product" ><?php echo esc_attr($message_in_product); ?></textarea>
					<h5 style="width:350px;margin:0px;">Este texto debería tenér su correspondiente traducción en la pestaña <i>Traducciones</i></h5>
                </td>
            </tr>
        </table>
        <button type="submit" class="button button-primary">Guardar</button>
    </form>
    <?php
}

function payb_settings_translations(){
	$translations = get_option('payb_settings_translations', array()); 
	?>
    <form method="post" action="admin-post.php">
        <input type="hidden" name="action" value="save_custom_settings_translations">
		<?php wp_nonce_field('save_custom_translations_nonce'); ?>
		<table id="translations-table" class="widefat fixed">
			<thead>
				<tr>
					<th class="manage-column" width="100px">Idioma</th>
					<th class="manage-column">Cadena a traducir</th>
					<th class="manage-column">Cadena traducida</th>
					<th class="manage-column"></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($translations as $lang => $translations): ?>
					<?php foreach ($translations as $key => $value): ?>
						<tr>
							<td><input type="text" name="translations_lang[]" value="<?php echo esc_attr($lang); ?>" style="width:100%" /></td>
							<td><textarea  name="translations_key[]" style="width:100%"><?php echo esc_attr($key); ?></textarea></td>
							<td><textarea type="text" name="translations_value[]" style="width:100%"><?php echo esc_attr($value); ?></textarea></td>
							<td><button type="button" class="button remove-row">-</button></td>
						</tr>
					<?php endforeach; ?>
				<?php endforeach; ?>
			</tbody>
		</table>
		<button type="button" id="add-translation-row" class="button">+</button>
		<button type="submit" class="button button-primary">Guardar</button>
	</form>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var addRowButtonTranslation = document.getElementById('add-translation-row');
            var tableBodyTranslation = document.querySelector('#translations-table tbody');
            addRowButtonTranslation.addEventListener('click', function() {
                var newRowTranslation = document.createElement('tr');
newRowTranslation.innerHTML = '<td><input type="text" name="translation_lang[]" style="width:100%"/></td><td><textarea  name="translations_key[]" style="width:100%"></textarea></td><td><textarea type="text" name="translations_value[]" style="width:100%"></textarea></td><td><button type="button" class="button remove-row">-</button></td>';
                tableBodyTranslation.appendChild(newRowTranslation);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
	<?php
}


function payb_settings_customize(){
	$customize = get_option('payb_settings_customize', array()); 
	?>
    <form method="post" action="admin-post.php">
        <input type="hidden" name="action" value="save_custom_settings_customize">
		<?php wp_nonce_field('save_custom_customize_nonce'); ?>
		<table id="customize-table" class="widefat fixed">
			<thead>
				<tr>
					<th class="manage-column">Sitio URL</th>
					<th class="manage-column">Elemento</th>
					<th class="manage-column">Contenido</th>
					<th class="manage-column"></th>
				</tr>
			</thead>
			<tbody>

				<?php foreach ($customize as $url => $customize1): ?>
					<?php foreach ($customize1 as $elemento => $contenido): ?>
						<tr>
							<td><input type="text" name="customize_url[]" value="<?php echo esc_attr($url); ?>" style="width:100%" /></td>
							<td><input type="text" name="customize_elemento[]" value="<?php echo esc_attr($elemento); ?>" style="width:100%" /></td>
							<td><input type="text" name="customize_contenido[]" value="<?php echo esc_attr($contenido); ?>" style="width:100%" /></td>
							<td><button type="button" class="button remove-row">-</button></td>
						</tr>
					<?php endforeach; ?>
				<?php endforeach; ?>
			</tbody>
		</table>
		<button type="button" id="add-customize-row" class="button">+</button>
		<button type="submit" class="button button-primary">Guardar</button>
	</form>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var addRowButtonCustomize = document.getElementById('add-customize-row');
            var tableBodyCustomize = document.querySelector('#customize-table tbody');
            addRowButtonCustomize.addEventListener('click', function() {
                var newRowCustomize = document.createElement('tr');
newRowCustomize.innerHTML = '<td><input type="text" name="customize_url[]" style="width:100%"/></td><td><input type="text" name="customize_elemento[]" value="" style="width:100%" /></td><td><input type="text" name="customize_contenido[]" value="" style="width:100%" /></td><td><button type="button" class="button remove-row">-</button></td>';
                tableBodyCustomize.appendChild(newRowCustomize);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
	<?php
}

function enqueue_media_uploader() {
    wp_enqueue_media();
}
add_action('admin_enqueue_scripts', 'enqueue_media_uploader');


function save_custom_settings_urls() {
    check_admin_referer('save_custom_settings_urls_nonce');
    if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }

    if (isset($_POST['urls']) && isset($_POST['suffixes'])) {
        $urls = array_map('sanitize_text_field', $_POST['urls']);
        $suffixes = array_map('sanitize_text_field', $_POST['suffixes']);
        
        $data = array();
        for ($i = 0; $i < count($urls); $i++) {
            if (!empty($urls[$i]) && !empty($suffixes[$i])) {
                $data[] = array(
                    'url' => $urls[$i],
                    'suffix' => $suffixes[$i]
                );
            }
        }

        update_option('payb_settings_urls', $data);
    }

    wp_redirect(admin_url('admin.php?page=payb-settings&tab=urls&status=1'));
    exit;
}
add_action('admin_post_save_custom_settings_urls', 'save_custom_settings_urls');

function save_custom_settings_countries() {
    check_admin_referer('save_custom_settings_countries_nonce');
    if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }

    if (isset($_POST['countries']) && isset($_POST['suffixes'])) {
        $countries = array_map('sanitize_text_field', $_POST['countries']);
        $suffixes = array_map('sanitize_text_field', $_POST['suffixes']);
        
        $data = array();
        for ($i = 0; $i < count($countries); $i++) {
            if (!empty($countries[$i]) && !empty($suffixes[$i])) {
                $data[] = array(
                    'country' => $countries[$i],
                    'suffix' => $suffixes[$i]
                );
            }
        }

        update_option('payb_settings_countries', $data);
    }

    wp_redirect(admin_url('admin.php?page=payb-settings&tab=countries&status=1'));
    exit;
}
add_action('admin_post_save_custom_settings_countries', 'save_custom_settings_countries');

function save_custom_settings_other() {
    check_admin_referer('save_custom_settings_other_nonce');
    if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }

    if (isset($_POST['background_image'])) {
        $background_image = sanitize_text_field($_POST['background_image']);
        update_option('payb_background_image', $background_image);
    }
    if (isset($_POST['background_image_id'])) {
        $background_image_id = intval($_POST['background_image_id']);
        update_option('payb_background_image_id', $background_image_id);
    }
    if (isset($_POST['message_in_product'])) {
        $message_in_product = $_POST['message_in_product'];
        update_option('payb_message_in_product', $message_in_product);
    }

    wp_redirect(admin_url('admin.php?page=payb-settings&tab=other&status=1'));
    exit;
}
add_action('admin_post_save_custom_settings_other', 'save_custom_settings_other');

function save_custom_settings_translations() {
    check_admin_referer('save_custom_translations_nonce');
    if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }
    $translations = array();
    if (isset($_POST['translations_lang']) && isset($_POST['translations_key']) && isset($_POST['translations_value'])) {
        for ($i = 0; $i < count($_POST['translations_lang']); $i++) {
            $lang = sanitize_text_field($_POST['translations_lang'][$i]);
            $key = ($_POST['translations_key'][$i]);
            $value = ($_POST['translations_value'][$i]);

            if (!empty($lang) && !empty($key) && !empty($value)) {
                if (!isset($translations[$lang])) {
                    $translations[$lang] = array();
                }
                $translations[$lang][$key] = stripslashes($value);
            }
        }
    }
    update_option('payb_settings_translations', $translations);
    wp_redirect(admin_url('admin.php?page=payb-settings&tab=countries&status=1'));
    exit;
}
add_action('admin_post_save_custom_settings_translations', 'save_custom_settings_translations');

function save_custom_settings_customize() {
    check_admin_referer('save_custom_customize_nonce');
    if (!current_user_can('manage_options')) {
        wp_die('No tienes permisos para realizar esta acción.');
    }
    $customize = array();
    if (isset($_POST['customize_url']) && isset($_POST['customize_elemento']) && isset($_POST['customize_contenido'])) {
        for ($i = 0; $i < count($_POST['customize_url']); $i++) {
            $url = sanitize_text_field($_POST['customize_url'][$i]);
            $elemento = ($_POST['customize_elemento'][$i]);
            $contenido = ($_POST['customize_contenido'][$i]);

            if (!empty($url) && !empty($elemento) && !empty($contenido)) {
                if (!isset($customize[$url])) {
                    $customize[$url] = array();
                }
                $customize[$url][$elemento] = stripslashes($contenido);
            }
        }
    }
    update_option('payb_settings_customize', $customize);
    wp_redirect(admin_url('admin.php?page=payb-settings&tab=countries&status=1'));
    exit;
}
add_action('admin_post_save_custom_settings_customize', 'save_custom_settings_customize');

function initialize_default_urls() {
    if (get_option('payb_settings_urls') === false) {
		$default_urls = array(
			array('url' => 'winandoffice.com', 'suffix' => 'S1'),
			array('url' => 'gamecardshop.com', 'suffix' => 'S2'),
			array('url' => 'softwarelizenzexpress.de', 'suffix' => 'S3'),
			array('url' => 'softwarelicenses.net', 'suffix' => 'S4'),
			array('url' => 'digilicenses.com', 'suffix' => 'S5'),
			array('url' => 'winandoffice.de', 'suffix' => 'S6'),
			array('url' => 'tech-licenses.com', 'suffix' => 'S7'),
			array('url' => 'keyshop.windowsandoffice.com', 'suffix' => 'S8'),
			array('url' => 'technikmarkt-aschaffenburg.de', 'suffix' => 'S9'),
			array('url' => 'winandoffice-keys.com', 'suffix' => 'S10'),
			array('url' => 'officeandwindows.com', 'suffix' => 'S11'),
			array('url' => 'arturo.winandoffice.com', 'suffix' => 'ART')
		);
        update_option('payb_settings_urls', $default_urls);
    }
}
add_action('admin_init', 'initialize_default_urls');

function initialize_default_countries() {
    if (get_option('payb_settings_countries') === false) {
		$default_countries = array(
			array('country' => 'deutschland', 'suffix' => 'DEU'),
			array('country' => 'deutsch', 'suffix' => 'DE'),
			array('country' => 'usa', 'suffix' => 'US'),
			array('country' => 'germany', 'suffix' => 'GE'),
			array('country' => 'spain', 'suffix' => 'SP'),
			array('country' => 'france', 'suffix' => 'FR'),
			array('country' => 'italy', 'suffix' => 'IT'),
			array('country' => 'italiano', 'suffix' => 'ITA'),
			array('country' => 'austria', 'suffix' => 'AU'),
			array('country' => 'switzerland', 'suffix' => 'SW')
		);
        update_option('payb_settings_countries', $default_countries);
    }
}
add_action('admin_init', 'initialize_default_countries');

// Configuración inicial
function initialize_default_server_translations() {
    if (get_option('payb_settings_translations') === false) {

    $traducciones = [
        'en' => [
			'Please, reenter your email.' => 'Please reenter your email*',
			'Email address' => 'Email address',
			'Name' => 'Full Name',
			'Address' => 'Address',
			'Email' => 'Email',
			'Phone' => 'Phone',
			'Country' => 'Country',
			'City' => 'City',
			'Billing Information' => '',
			'Order' => 'Order',
			'Your bill' => '',
			'Complete payment' => 'Complete payment',
			'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!' => 'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!',
			'Total Amount' => 'Total Amount',
			'Nameless' => 'Nameless',
			'Pay the bill' => 'Pay the Bill',
        ],
        'es' => [
			'Please, reenter your email.' => 'Por favor, vuelve a introducir tu correo electrónico.',
			'Email address' => 'Direccion de correo electr&oacutenico',
			'Name' => 'Nombre',
			'Address' => 'Direcci&oacute;n',
			'Email' => 'Corr&eacute;o Electr&oacute;nico',
			'Phone' => 'Tel&eacute;fono',
			'Country' => 'Pa&iacute;s',
			'City' => 'Ciudad',
			'Billing Information' => 'Información de facturación',
			'Order' => 'Orden',
			'Your bill' => 'Su factura',
			'Complete payment' => 'Completa tu pago',
			'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!' => 'Hola {nombre}, Estos son los datos de pago de tu factura. Su producto ya ha sido enviado a su correo electrónico anteriormente. Esperamos que lo estés disfrutando. ¡Completa el proceso de pago!',
			'Total Amount' => 'Total importe',
			'Nameless' => '',
 			'Pay the bill' => 'Pagar la factura',
       ],
        'it' => [
			'Please, reenter your email.' => 'Per favore, inserisci nuovamente la tua email.',
			'Email address' => 'Indirizzo e-mail',
			'Name' => 'Nome e cognome',
			'Address' => 'Indirizzo',
			'Email' => 'E-mail',
			'Phone' => 'Telefono',
			'Country' => 'Paese',
			'City' => 'Città',
			'Billing Information' => 'Informazioni di fatturazione',
			'Order' => 'Ordine',
			'Your bill' => 'Il tuo conto',
 			'Complete payment' => 'Pagamento completo',
			'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!' => 'Ciao {nombre}, questi sono i dettagli di pagamento della tua fattura. Il tuo prodotto è già stato inviato alla tua email in precedenza. Ci auguriamo che ti stia divertendo. Si prega di completare la procedura di pagamento!',
			'Total Amount' => 'Importo totale',
			'Nameless' => 'Senza nome',
			'Pay the bill' => 'Pagare il conto',
       ],
        'de' => [ 
			'Please, reenter your email.' => 'Bitte geben Sie Ihre E-Mail-Adresse erneut ein.',
			'Email address' => 'E-Mail-Adresse',
			'Name' => 'Vollständiger Name',
			'Address' => 'Adresse',
			'Email' => 'Email',
			'Phone' => 'Telefon',
			'Country' => 'Land',
			'City' => 'Stadt',
			'Billing information' => 'Abrechnungsdaten',
			'Order' => 'Bestellung',
			'Your bill' => 'Deine Rechnung',
			'Complete payment' => 'Zahlung abschliessen',
			'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!' => 'Hallo {nombre}, Dies sind die Zahlungsdetails für Ihre Rechnung. Ihr Produkt wurde bereits zuvor an Ihre E-Mail-Adresse gesendet. Wir hoffen, dass es Ihnen gefällt. Bitte schließen Sie den Bestellvorgang ab!',
			'Total Amount' => 'Gesamtmenge',
			'Nameless' => 'Namenlos',
 			'Pay the bill' => 'Rechnung bezahlen',
       ],
        'fr' => [
			'Please, reenter your email.' => "S'il vous plaît, entrez à nouveau votre email.",
			'Email address' => 'Adresse e-mail',
			'Name' => 'Nom et prénom',
			'Address' => 'Adresse',
			'Email' => 'E-mail',
			'Phone' => 'Téléphone',
			'Country' => 'Pays',
			'City' => 'Ville',
			'Billing Information' => 'Informations de facturation',
			'Order' => 'Commande',
			'Your bill' => 'Votre facture',
			'Complete payment' => 'Paiement complet',
			'Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!' => 'Bonjour {nombre},Voici les détails de paiement de votre facture. Votre produit a déjà été envoyé à votre adresse e-mail précédemment. Nous espérons que vous l’appréciez. Veuillez terminer le processus de paiement !',
			'Total Amount' => 'Montant total',
			'Nameless' => 'Sans nom',
			'Pay the bill' => "Payer l'addition",
        ],
        // Agrega más idiomas y traducciones según sea necesario
    ];


	    update_option('payb_settings_translations', $traducciones);
    }
}
add_action('admin_init', 'initialize_default_server_translations');
