<?php
/*
 * Funciones para modificar paginas producto y checkout
 * version 1.1
 * Fecha: 11 de abril de 2024
 * Actualizado: 12 de febrero de 2025
 * Desarrollado por : Arturo
 * PayB
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Cambiar el texto del botón de compra
function new_cambiar_texto_boton_compra() {
    return ___('Pay the bill'); // Cambia 'Nuevo Texto' por el texto que desees
}
add_filter('woocommerce_product_single_add_to_cart_text', 'new_cambiar_texto_boton_compra');

// Modificar el título del producto en la página de producto
function new_cambiar_titulo_producto($title) {
    global $post;
    
    if (is_product()) {
		// Obtener el valor del metadato '_mitexto'
		$mitexto = get_post_meta($post->ID, 'origen_order_number', true);
		// Verificar si el metadato tiene un valor y reemplazar el título del producto si es así
		if (!empty($mitexto)) {
			$title = ___('Order')."-".$mitexto;
		}
    }
    return $title;
}
add_filter('the_title', 'new_cambiar_titulo_producto');

// Modificar el nombre del boton PAY NOW en pagina checkout
function new_cambiar_texto_boton_pago($texto) {
    if (is_checkout()) {
        $texto = ___('Complete payment');
    }
    return $texto;
}
add_filter('woocommerce_order_button_text', 'new_cambiar_texto_boton_pago');

// Modificar el nombre de producto en la checkout page
function new_modificar_nombre_producto_carrito($product_name, $cart_item, $cart_item_key) {
    // Obtener el ID del producto
    $product_id = $cart_item['product_id'];
    
    // Obtener el valor del metadato 'origen_order_number' para el producto
    $origen_order_number = get_post_meta($product_id, 'origen_order_number', true);
    
    // Concatenar el metadato 'origen_order_number' con el nombre del producto
    if (!empty($origen_order_number)) {
        $product_name = ___('Order').'-'.$origen_order_number ;
    }
    
    return $product_name;
}
add_filter('woocommerce_cart_item_name', 'new_modificar_nombre_producto_carrito', 10, 3);

// Insertar origen_order_number como metadato en nueva order
// Función para copiar el metadato 'origen_order_number' de un producto a la orden
function new_guardar_origen_order_number_en_orden($order_id, $posted_data) {
    // Iterar a través de los ítems del carrito
    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
        // Obtener el producto
        $product = $cart_item['data'];

        // Comprobar si el producto tiene el metadato 'origen_order_number'
        $origen_order_number = get_post_meta($product->get_id(), 'origen_order_number', true);
        if (!empty($origen_order_number)) {
            // Guardar el metadato en la orden y salir del bucle
            update_post_meta($order_id, 'origen_order_number_order', $origen_order_number);
            break;
        }
    }
}
add_action('woocommerce_checkout_update_order_meta', 'new_guardar_origen_order_number_en_orden', 10, 2); 

// Eliminar ordenes anteriores para el mismo origen_order_number_order
function new_eliminar_ordenes_anteriores_con_mismo_origen_sql_puro($order_id, $posted_data) {
    global $wpdb; // Acceder al objeto global de la base de datos de WordPress
    // Obtener el metadato 'origen_order_number_order' de la orden actual directamente desde la base de datos
    $meta_value_query = $wpdb->prepare("
        SELECT meta_value
        FROM {$wpdb->prefix}postmeta
        WHERE post_id = %d AND meta_key = 'origen_order_number_order'
        LIMIT 1
    ", $order_id);
    $current_origen_order_number = $wpdb->get_var($meta_value_query);

    if (!empty($current_origen_order_number)) {
        // Preparar consulta SQL para buscar órdenes con el mismo 'origen_order_number_order' que no son la orden actual
        $query = $wpdb->prepare("
            SELECT post_id
            FROM {$wpdb->prefix}postmeta
            WHERE meta_key = 'origen_order_number_order' AND meta_value = %s AND post_id != %d
        ", $current_origen_order_number, $order_id);

        // Ejecutar la consulta
        $order_ids = $wpdb->get_col($query);

        // Iterar sobre los IDs de órdenes encontrados y eliminar las antiguas
        foreach ($order_ids as $found_order_id) {
            wp_delete_post($found_order_id, true); // Eliminar la orden permanentemente
        }
    }
}
add_action('woocommerce_checkout_update_order_meta', 'new_eliminar_ordenes_anteriores_con_mismo_origen_sql_puro', 10, 2);

// Cuando la orden se ha completado, borrar el producto asociado.
function new_eliminar_producto_al_completar_orden($order_id, $old_status, $new_status) {
    if ('completed' === $new_status) { // Verificar si el nuevo estado es 'completed'
        $order = wc_get_order($order_id); // Obtener la orden
        $items = $order->get_items(); // Obtener los ítems de la orden

        foreach ($items as $item) {
            $product_id = $item->get_product_id(); // Obtener el ID del producto
            if ($product_id) {
                //wp_delete_post($product_id, true); // Eliminar el producto permanentemente
				wp_trash_post($product_id); // Mover el producto a la papelera
            }
        }
    }
}
add_action('woocommerce_order_status_changed', 'new_eliminar_producto_al_completar_orden', 10, 3);

// Limpiar el carrito y la sesión cuando se carga la página de un producto
function new_limpiar_carrito_y_sesion_en_pagina_de_producto() {
    // Verificar si estamos en la página de un producto
    if (is_product()) {
        // Vaciar el carrito
        WC()->cart->empty_cart();

        // Limpiar la sesión
        WC()->session->set('last_added_product_id', '');
        WC()->session->set('last_added_product_qty', '');
    }
}
add_action('template_redirect', 'new_limpiar_carrito_y_sesion_en_pagina_de_producto');

// Autorellenar la información en la checkout page con información adicional del producto
function new_auto_fill_checkout_fields_based_on_product($input, $key) {
    // Verificar si el carrito contiene solo un tipo de producto
    $cart = WC()->cart->get_cart();
    if (count($cart) != 1) {
        return $input;
    }

    $item = reset($cart);
    $product = wc_get_product($item['product_id']);

    // Si el producto tiene el metadato 'full_name' y otros, úsalos para rellenar los campos
    if ($product && $product->get_meta('full_name')) {
        switch ($key) {
            case 'billing_first_name':
            case 'shipping_first_name':
                // Asumiendo que 'full_name' es solo el nombre, ajustar según sea necesario
                return $product->get_meta('full_name');

            case 'billing_email':
                return $product->get_meta('email');

            case 'billing_address_1':
            case 'shipping_address_1':
                return $product->get_meta('address');

            case 'billing_phone':
                return $product->get_meta('phone');
            case 'billing_country':
            case 'shipping_country':
                // Asegúrate de que el código del país está en formato ISO 3166-1 alfa-2 (ejemplo: 'US', 'GB')
                return $product->get_meta('country');
                //return 'BO';
        }
    }

    return $input;
}
add_filter('woocommerce_checkout_get_value', 'new_auto_fill_checkout_fields_based_on_product', 10, 2);

// En la nueva orden, insertar link a la orden en el shop origen
function new_add_order_note_with_link($order_id, $posted_data, $order) {
    $items = $order->get_items();
	
    foreach ($items as $item) { 
        $product = $item->get_product();
        $shop_url = $product->get_meta('origin_shop_url');
        $shop_name = $product->get_meta('origin_shop_name');
        $origin_order_id = $product->get_meta('origen_order_number');
        $origin_site_id = $product->get_meta('origin_site_id');
        $path = $product->get_meta('path');
       
        if (!empty($shop_url) && !empty($shop_name) && !empty($origin_order_id)) {
            //$link = rtrim($shop_url, '/').$shop_name. '/wp-admin/post.php?post=' . $origin_order_id.'&action=edit';  // Ajusta el 'path-to-order' según sea necesario
            //$link = rtrim($shop_url, '/').'/'.$shop_name. '/wp-admin/post.php?post=' . $origin_order_id.'&action=edit';  // Ajusta el 'path-to-order' según sea necesario
            $link = rtrim($shop_url, '/').'/wp-admin/post.php?post=' . $origin_order_id.'&action=edit';  // Ajusta el 'path-to-order' según sea necesario
            $note = "Orden origen en en el shop : <a href='{$link}'>{$shop_url} {$shop_name} Order #{$origin_order_id}</a>";
            $order->add_order_note($note);
			// guardamos los metadatos para comunicarnos luego con el shop origen y cambiar el estado de la orden origen
			update_post_meta($order_id,'origin_shop_url',$shop_url);
			update_post_meta($order_id,'origin_shop_name',$shop_name);
			update_post_meta($order_id,'origin_site_id',$origin_site_id);
			update_post_meta($order_id,'origin_order_id',$origin_order_id);
			update_post_meta($order_id,'path',$path);
			
        }
    }
}
add_action('woocommerce_checkout_order_processed', 'new_add_order_note_with_link', 10, 3);

// Informar al shop origen cuando se ha pagado en la pasarela de pago para que cambie el estado de la orden origen a 'pagado'
function new_send_order_info_to_origin_shop($order_id) {
    // Obtener la orden
    $order = wc_get_order($order_id);

    // Recuperar metadatos necesarios de la orden
    $origin_order_id = $order->get_meta('origin_order_id');
    $origin_site_id = $order->get_meta('origin_site_id');
    $origin_shop_url = $order->get_meta('origin_shop_url');
    //$origin_shop_name = $order->get_meta('origin_shop_name');
    //$origin_shop_name = 'USA';
    $origin_path = $order->get_meta('path')<>''?$order->get_meta('path').'/':'';

    // Verificar que tengamos todos los datos necesarios
    if (!empty($origin_order_id) && !empty($origin_site_id) && !empty($origin_shop_url) ) {
        //$api_url = rtrim($origin_shop_url, '/') . '/' . trim($origin_shop_name, '/') . '/api/update_order_status';
		// Construir la URL de la API del sitio origen
		$api_url = rtrim($origin_shop_url, '/') . '/' . trim($origin_path, '/') . 'wp-json/custom/v1/update_order_status';
        // Cuerpo de la petición
        $body = json_encode([ 
            'origin_order_id' => $origin_order_id,
            'origin_site_id' => $origin_site_id,
            'new_status' => 'pagado'
        ]);

        // Opciones de la petición HTTP
        $args = [
            'body'        => $body,
            'headers'     => [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer YOUR_ACCESS_TOKEN' // Si es necesario
            ],
            'timeout'     => '5',
            'redirection' => '5',
            'httpversion' => '1.0',
            'blocking'    => true,
            'sslverify'   => false, // En entornos de producción es mejor ponerlo en true
        ];

        // Enviar la petición POST
        $response = wp_remote_post($api_url, $args);

        // Opcional: Manejar la respuesta
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            error_log("Hubo un error al enviar la petición: $error_message");
        } else {
            $response_body = wp_remote_retrieve_body($response);
            error_log("Respuesta recibida: $response_body");
        }
    }
}
//add_action('woocommerce_order_status_completed', 'new_send_order_info_to_origin_shop');

// Quitar el selector de cantidad de la pagina de producto
function new_custom_remove_all_quantity_fields( $return, $product ) {
    return true;
}
add_filter( 'woocommerce_is_sold_individually', 'new_custom_remove_all_quantity_fields', 10, 2 );

// Establece la cookie basada en el metadato 'country' cuando se carga un producto
function new_set_language_cookie_based_on_country() {
    if (is_product()) {
        global $post;
        $country = get_post_meta($post->ID, 'country', true);
        $locale = get_post_meta($post->ID, 'locale', true);
		if(empty($locale)){
			switch ($country) {
				case 'BR':
					setcookie('site_language', 'pt_BR', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
				case 'IT':
					setcookie('site_language', 'it_IT', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
				case 'DE':
					setcookie('site_language', 'de_DE', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
				case 'CD': //Congo frances
				case 'FR':
					setcookie('site_language', 'fr_FR', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
				case 'BO':
				case 'ES':
					setcookie('site_language', 'es_ES', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
				case 'EN':
				default:
					setcookie('site_language', 'en_US', time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
					break;
			}
		}else{
			setcookie('site_language', $locale, time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
		}

    }
}
add_action('template_redirect', 'new_set_language_cookie_based_on_country');

// Cambia el locale basado en la cookie
function new_change_locale_based_on_cookie($locale) {
    if (isset($_COOKIE['site_language'])) {
        $locale = sanitize_text_field($_COOKIE['site_language']);
    }
    return $locale;
}
//add_filter('locale', 'new_change_locale_based_on_cookie', 10);

// Cambia el locale basado en la cookie para el usuario actual
function new_change_locale_for_user() {
    if (isset($_COOKIE['site_language'])) {
        $locale = sanitize_text_field($_COOKIE['site_language']);
        unload_textdomain('woocommerce');
        switch ($locale) {
            case 'it_IT':
            case 'de_DE':
            case 'fr_FR':
            case 'es_ES':
            case 'en_US':
                //load_textdomain('woocommerce', WP_LANG_DIR . '/woocommerce/woocommerce-' . $locale . '.mo');
                $ruta_lenguaje = WP_LANG_DIR . '/plugins/woocommerce-' . $locale . '.mo';
                load_textdomain('woocommerce', $ruta_lenguaje);
                break;
        }
    }
}
//add_action('init', 'new_change_locale_for_user');

// Recarga el textdomain basado en la cookie
function new_reload_textdomain_based_on_cookie() {
    if (isset($_COOKIE['site_language'])) {
        $locale = sanitize_text_field($_COOKIE['site_language']);
        unload_textdomain('woocommerce');
        switch ($locale) {
            case 'it_IT':
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-it_IT.mo');
                break;
            case 'de_DE':
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-de_DE.mo');
                break;
            case 'fr_FR':
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-fr_FR.mo');
                break;
            case 'es_ES':
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-es_ES.mo');
                break;
            case 'en_US':
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-en_US.mo');
            default:
                load_textdomain('woocommerce', WP_LANG_DIR . '/plugins/woocommerce-'.$locale.'.mo');
                break;
        }
    }
}
//add_action('wp', 'new_reload_textdomain_based_on_cookie');

// Funcion para traducir pocas cadenas 
if (!function_exists('___')) {
	function ___($cadena) {
		if (isset($_COOKIE['site_language'])) {
			$locale = sanitize_text_field($_COOKIE['site_language']);
		}else{
			$locale = get_locale();
		}
		$idioma = substr($locale, 0, 2);
		// Arreglo de traducciones
		$traducciones = get_option('payb_settings_translations');
		// Verificar si el idioma y la cadena existen en el arreglo de traducciones
		if (isset($traducciones[$idioma][$cadena])) {
			return $traducciones[$idioma][$cadena];
		}

		// Si no se encuentra la traducción, devolver la cadena original
		return $cadena;
	}
}
