<?php
/*
 * Código para insertar una imagen de producto automaticamente
 * cuando se crea un producto nuevo
 * 
*/

/*
 * LA SOBREPOSICION DE IMAGEN SE ENCUENTRA EN EL TEMPLATE single-product/product-image.php
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Agregar nueva pestaña en la sección 'Product data' 
function new_custom_product_data_tab( $tabs ) {
    $tabs['custom_tab'] = array(
        'label'    => __( 'Información Adicional', 'text-domain' ),
        'target'   => 'custom_tab_data',
        'class'    => array( 'show_if_simple', 'show_if_variable' ),
    );
    return $tabs;
}
add_filter( 'woocommerce_product_data_tabs', 'new_custom_product_data_tab' );

// Agregar contenido a la pestaña
function new_custom_product_data_fields() {
    ?>
    <div id='custom_tab_data' class='panel woocommerce_options_panel'>
        <div class='options_group'>
            <?php
            // Campo para Nro. de orden de origen
            woocommerce_wp_text_input( array(
                'id'          => 'origen_order_number',
                'label'       => __( 'Nro. de Orden de Origen', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Introduce el número de orden de origen.', 'text-domain' )
            ) );

            // Campo para Nombre Completo
            woocommerce_wp_text_input( array(
                'id'          => 'full_name',
                'label'       => __( 'Nombre Completo', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Introduce el nombre completo.', 'text-domain' )
            ) );
            // Campo para Email
            woocommerce_wp_text_input( array(
                'id'          => 'email',
                'label'       => __( 'Email', 'text-domain' ),
                'placeholder' => '',
                'type'        => 'email',
                'desc_tip'    => 'true',
                'description' => __( 'Introduce la dirección de correo electrónico.', 'text-domain' )
            ) );

            // Campo para Teléfono
            woocommerce_wp_text_input( array(
                'id'          => 'phone',
                'label'       => __( 'Teléfono', 'text-domain' ),
                'placeholder' => '',
                'type'        => 'text',
                'desc_tip'    => 'true',
                'description' => __( 'Introduce el número de teléfono.', 'text-domain' )
            ) );

            // Campo para Dirección
            woocommerce_wp_textarea_input( array(
                'id'          => 'address',
                'label'       => __( 'Dirección', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Introduce la dirección.', 'text-domain' )
            ) );
            // Origin shop url
            woocommerce_wp_text_input( array(
                'id'          => 'origin_shop_url',
                'label'       => __( 'Url de shop origen', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Este campo se rellena automáticamente.', 'text-domain' ),
			    'custom_attributes' => array(
					'readonlyno' => 'readonly'  // Hace el campo de solo lectura
				)
            ) );
            // Origin shop name
            woocommerce_wp_text_input( array(
                'id'          => 'origin_shop_name',
                'label'       => __( 'Nombre del shop origen', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Este campo se rellena automaticamente.', 'text-domain' ),
			    'custom_attributes' => array(
					'readonlyno' => 'readonly'  // Hace el campo de solo lectura
				)
            ) );
            // Origin shop name
            woocommerce_wp_text_input( array(
                'id'          => 'origin_site_id',
                'label'       => __( 'Id del multisite de origen', 'text-domain' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Este campo se rellena automaticamente.', 'text-domain' ),
			    'custom_attributes' => array(
					'readonlyno' => 'readonly'  // Hace el campo de solo lectura
				)
            ) );
            // Idioma
            /*woocommerce_wp_text_input( array(
                'id'          => 'country',
                'label'       => 'Idioma',
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => 'El idioma del cliente.',
            ) );*/
            woocommerce_wp_text_input( array( // Text Field type
                'id'          => 'country',
                'label'       => __( 'Pais', 'woocommerce' ),
                'description' => __( 'El c&oacute;digo de país en formato ISO 3166 (Ej.: IT)', 'woocommerce' ),
                'desc_tip'    => true,
            ) );
            woocommerce_wp_text_input( array( // Text Field type
                'id'          => 'locale',
                'label'       => __( 'Codigo de localizaci&oacute;n', 'woocommerce' ),
                'description' => __( 'Codigo de localización (Local code) en fomato: it_IT, es_Bo, us_US, etc.', 'woocommerce' ),
                'desc_tip'    => true,
            ) );
            // Moneda
            /*woocommerce_wp_text_input( array(
                'id'          => 'currency',
                'label'       => 'Moneda',
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => 'Moneda del cliente.',
            ) );*/


            woocommerce_wp_select( array( // Text Field type
                'id'          => 'currency',
                'label'       => __( 'Moneda', 'woocommerce' ),
                'description' => __( 'currency', 'woocommerce' ),
                'desc_tip'    => true,
                'options'     => array(
                    ''        => __( 'Select currency', 'woocommerce' ),
                    'EUR'    => 'EUR',
                    'GBP' => 'GBP',
                    'USD' => 'USD',
                    'CHF' => 'CHF',
                    'CAD' => 'CAD',
                    'AUD' => 'AUD',
                )
            ) );

			// path
            /*woocommerce_wp_text_input( array(
                'id'          => 'path',
                'label'       => 'Path',
                'placeholder' => '',
                'desc_tip'    => 'Ruta',
                'description' => 'Ruta del sitio origen.',
            ) );*/

             ?>
        </div>
    </div>
    <?php
}

// Hook en init para asegurar que todas las acciones se han registrado antes de intentar removerlas
add_action( 'init', 'replace_custom_product_data_fields' );

function replace_custom_product_data_fields() {
    // Verificar si la función custom_product_data_fields está definida y enganchada
    if ( has_action( 'woocommerce_product_data_panels', 'custom_product_data_fields' ) ) {
        // Remover la acción existente
        remove_action( 'woocommerce_product_data_panels', 'custom_product_data_fields' );
		remove_action( 'woocommerce_process_product_meta', 'save_custom_product_data_fields' );
    }

    // Añadir la nueva acción
    add_action( 'woocommerce_product_data_panels', 'new_custom_product_data_fields' );
	add_action( 'woocommerce_process_product_meta', 'new_save_custom_product_data_fields' );
}

// Guardar datos de los campos personalizados al guardar el producto
function new_save_custom_product_data_fields( $post_id ) {
    // Guardar Nro. de orden de origen
    $origen_order_number = isset( $_POST['origen_order_number'] ) ? sanitize_text_field( $_POST['origen_order_number'] ) : '';
    update_post_meta( $post_id, 'origen_order_number', $origen_order_number );
    // Guardar Nombre Completo
    $full_name = isset( $_POST['full_name'] ) ? sanitize_text_field( $_POST['full_name'] ) : '';
    update_post_meta( $post_id, 'full_name', $full_name );
    // Guardar Email
    $email = isset( $_POST['email'] ) ? sanitize_email( $_POST['email'] ) : '';
    update_post_meta( $post_id, 'email', $email );
    // Guardar Teléfono
    $phone = isset( $_POST['phone'] ) ? $_POST['phone'] : '9';
    update_post_meta( $post_id, 'phone', $phone );
    // Guardar Dirección
    $address = isset( $_POST['address'] ) ? $_POST['address'] : 'xxx';
    update_post_meta( $post_id, 'address', $address );
    // Guardar country
    $country = isset( $_POST['country'] ) ? sanitize_textarea_field( $_POST['country'] ) : '';
    update_post_meta( $post_id, 'country', $country );
    // Guardar locale
    $locale = isset( $_POST['locale'] ) ? sanitize_textarea_field( $_POST['locale'] ) : '';
    update_post_meta( $post_id, 'locale', $locale );
    // Guardar moneda
    $currency = isset( $_POST['currency'] ) ? sanitize_textarea_field( $_POST['currency'] ) : '';
    update_post_meta( $post_id, 'currency', $currency );
}
// Verificar si la función custom_product_data_fields está definida y enganchada
//add_action( 'woocommerce_process_product_meta', 'new_save_custom_product_data_fields' );

// Establecer todos los productos como virtuales al guardar
function new_set_product_virtual_on_save($post_id, $post, $update) {
    // Verifica si es un autoguardado o una revisión
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE || wp_is_post_revision($post_id)) {
        return;
    }

    // Verifica los permisos del usuario
    if (!current_user_can('edit_product', $post_id)) {
        return;
    }

    // Asegurarse de que es un producto
    if ('product' !== $post->post_type) {
        return;
    }

    $product = wc_get_product($post_id);
    if (!$product) return;

    // Establecer el producto como virtual
    $product->set_virtual('yes');

    // Guardar los cambios
    $product->save(); 
}
//add_action('save_post_product', 'new_set_product_virtual_on_save', 10, 3);

// Obtener metadatos del producto al agregar al carrito
function new_obtener_metadatos_al_agregar_al_carrito($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data) {
    // Obtener los datos que necesitas almacenar en metadatos del producto
	$origen_order_number = get_post_meta($product_id, 'origen_order_number',true);
	$full_name = get_post_meta($product_id, 'full_name',true);
	$mi_email = get_post_meta($product_id, 'email',true);
	$mi_phone = get_post_meta($product_id, 'phone',true);
	$mi_address = get_post_meta($product_id, 'address',true);
    // Guardar los datos en el carrito como metadatos
    WC()->session->set('origen_order_number', $origen_order_number);
    WC()->session->set('full_name', $full_name);
    WC()->session->set('mi_email', $mi_email);
    WC()->session->set('mi_phone', $mi_phone);
    WC()->session->set('mi_address', $mi_address);
}
//add_action('woocommerce_add_to_cart', 'new_obtener_metadatos_al_agregar_al_carrito', 10, 6);

// Llenar automáticamente los campos de checkout con los datos del producto 
function new_llenar_campos_checkout_con_metadatos($checkout_fields) {
    $checkout_fields['billing']['billing_full_name']['default'] = WC()->session->get('full_name');
    $checkout_fields['billing']['billing_email']['default'] = WC()->session->get('mi_email');
    $checkout_fields['billing']['billing_phone']['default'] = WC()->session->get('mi_phone');
    //$checkout_fields['billing']['billing_address_1']['default'] = WC()->session->get('mi_address');
    $checkout_fields['billing']['billing_address_1']['default'] = 'mi dirección'; 
    // Agrega aquí los demás campos según sea necesario
    // Agregar origen_orden_number a las notas del pedido
    $origen_orden_number = WC()->session->get('origen_orden_number');
    if (!empty($origen_orden_number)) {
        $checkout_fields['order']['order_comments']['default'] = 'Origen Orden Number: ' . $origen_orden_number;
    }

    return $checkout_fields;
}
//add_filter('woocommerce_checkout_fields', 'new_llenar_campos_checkout_con_metadatos');

// CARGAMOS LOS METADATOS DEL PRODUCTO EN UN SHORTCODE PARA MOSTRAR EN DESCRIPCION 
function new_de_los_metadatos(){
	$product_id = get_the_ID();
	$origen_order_number = get_post_meta($product_id, 'origen_order_number',true);
	$full_name = $full_name_empty = get_post_meta($product_id, 'full_name',true);
	$email = get_post_meta($product_id, 'email',true);
	$phone = get_post_meta($product_id, 'phone',true);
	$address = get_post_meta($product_id, 'address',true);
	$salida = '
	<div class="descorta">
	<p><b>{label-name}:</b> {name}</p>
	<p><b>{label-email}:</b> {email}</p>
	<p><b>{label-address}:</b> {address}</p>
	<p><b>{label-phone}:</b> {phone}</p>
	<p class="box-message">{mensaje}</p>
	</div>
	';
	if(empty($full_name)){
		$full_name = ___('Nameless');
		$full_name_empty = '';
	}
	if(empty($address)){
		$salida = str_replace('<p><b>{label-address}:</b> {address}</p>','',$salida);
	}else{
		$salida = str_replace('{label-address}',___('Address'),$salida);
		$salida = str_replace('{address}',$address,$salida);
	}
	if(empty($phone)){
		$salida = str_replace('<p><b>{label-phone}:</b> {phone}</p>','',$salida);
	}else{
		$salida = str_replace('{label-phone}',___('Phone'),$salida);
		$salida = str_replace('{phone}',$phone,$salida);
	}
	$salida = str_replace('{label-name}',___('Name'),$salida);
	$salida = str_replace('{label-email}',___('Email'),$salida);
	$salida = str_replace('{name}',$full_name,$salida);
	$salida = str_replace('{email}',$email,$salida);
	$mensaje123 = ___("Hello {nombre},These are the payment details for your invoice. Your product has already been sent to your email previously. We hope you are enjoying it. Please complete the checkout process!");
	$mensaje = ___(get_option('payb_message_in_product'));
	$mensaje = str_replace('{nombre}',$full_name_empty,$mensaje);
	$salida = str_replace('{mensaje}',$mensaje,$salida);
	return $salida;
}
add_shortcode('info','new_de_los_metadatos');

//remove_action('woocommerce_after_single_product_summary',10);


// CAMBIAMOS EL LOGO SEGUN EL SHOP DE DONDE VENGA EL PEDIDO Y SI TENEMOS CONFIGURADO EL LOGO

add_action('template_redirect', function() {
    // Verificar si estamos en la página de un producto
    if (is_product()) {
        global $post;

        // Obtener el ID del producto actual
        $product_id = $post->ID;

        // Obtener el metadato origin_shop_url del producto
        $origin_shop_url = get_domain_from_url(get_post_meta($product_id, 'origin_shop_url', true));
        // Obtener la opción de configuración
        $payb_settings_customize = get_option('payb_settings_customize', [
            'url' => '',
            'elemento' => ['logo' => '']
        ]);
        // Extraer los valores de la opción
        //$custom_url = $payb_settings_customize['url'];
        $custom_logo_url = $payb_settings_customize[$origin_shop_url]['logo'];


        // Verificar si origin_shop_url contiene parcialmente payb_settings_customize['url']
        //if (!empty($origin_shop_url) && strpos($origin_shop_url, $custom_url) !== false) {
        if (!empty($custom_logo_url)) {

           // Cambiar el logo del shop al proporcionado
add_filter('get_custom_logo', function($html) use ($custom_logo_url) {
    // Construir el HTML del nuevo logo
    return sprintf(
        '<a href="%1$s" class="custom-logo-link" rel="home"><img src="%2$s" class="custom-logo" alt="Logo"></a>',
        esc_url(home_url('/')),
        esc_url($custom_logo_url)
    );
}, 5); // Baja prioridad

            // Confirmación para debug (opcional)
            error_log("El logo del shop ha sido actualizado a: " . $custom_logo_url);
        } else {
            error_log("No hubo coincidencia parcial entre origin_shop_url y payb_settings_customize[url].");
        }
    }

});


function get_domain_from_url($url) {
    // Parsear la URL para obtener sus componentes
    $parsed_url = parse_url($url);

    // Verificar si la URL tiene un host (el dominio)
    if (!empty($parsed_url['host'])) {
        return $parsed_url['host'];
    }

    // Si no hay host, devolver vacío o manejar error
    return '';
}

