<?php 
/*
 * WAO UPDATE. LOGICA PARA LA ACTUALIZACION DEL PLUGIN
 * https://rudrastyh.com/wordpress/self-hosted-plugin-update.html
*/
defined( 'ABSPATH' ) || exit;

add_filter('woocommerce_analytics_report_orders_query_args', 'add_category_filter_to_revenue_report', 10, 2);
function add_category_filter_to_revenue_report($args, $request) {
    if (isset($request['categories'])) {
        $args['categories'] = $request['categories'];
    }
    return $args;
}

add_filter('woocommerce_analytics_clauses_join_orders', 'add_category_join_to_revenue_report', 10, 2);
function add_category_join_to_revenue_report($clauses, $context) {
    if ($context->get_report() === 'revenue') {
        $clauses[] = "LEFT JOIN {$context->db->prefix}term_relationships AS tr ON tr.object_id = {$context->table}.product_id";
        $clauses[] = "LEFT JOIN {$context->db->prefix}term_taxonomy AS tt ON tr.term_taxonomy_id = tt.term_taxonomy_id AND tt.taxonomy = 'product_cat'";
    }
    return $clauses;
}

add_filter('woocommerce_analytics_clauses_where_orders', 'add_category_where_to_revenue_report', 10, 2);
function add_category_where_to_revenue_report($clauses, $context) {
    if ($context->get_report() === 'revenue' && !empty($context->query->get('categories'))) {
        $categories = implode(',', array_map('absint', (array) $context->query->get('categories')));
        $clauses[] = "AND tt.term_id IN ({$categories})";
    }
    return $clauses;
}

function enqueue_custom_admin_scripts_analitycs() {
    //echo 'asdas';
    wp_register_script(
        'custom-analytics-filters', 
        plugin_dir_url(__FILE__) . 'classes/custom-analytics-filters.js', 
        array('wp-data', 'wc-admin-reports'), 
        '1.0', 
        false, true
    );
    wp_enqueue_script( 'custom-analytics-filters' );
}
add_action('admin_enqueue_scripts', 'enqueue_custom_admin_scripts_analitycs', 50);

