<?php
/* 
Plugin Name: WAO Promo box
Plugin URI: https://rusdev.com/ 
Description: Plugin to insert into single products promo discount with a promo. 
Version: 1.0.5
Author: Rusland Rojas
Author URI: https://rusdev.com/ 
License: GPLv2 or later 
Text Domain: promobox
*/


// Agregar un menú en la sección de ajustes
defined( 'ABSPATH' ) || exit;
// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/** 
* Define constants 
*/
if ( ! defined( 'WAOPROMOBOX_PLUGIN__VERSION' ) ) {
	define( 'WAOPROMOBOX_PLUGIN__VERSION', '1.0.5' );
}


add_action('init', function() {
    $data_promobox = get_option( 'wao_promobox_options' );
    $hook = 'woocommerce_single_product_summary';
    if(isset($data_promobox['promoboxposition'])) {
        $hook = $data_promobox['promoboxposition'];
    }
    $numberPosition = 20;
    if(isset($data_promobox['promoboxpositionnumber'])) {
        $numberPosition = $data_promobox['promoboxpositionnumber'];
    }
    add_action($hook, 'wao_promo_box_func', $numberPosition);
});

include plugin_dir_path(__FILE__) . 'admin/admin_menu_promobox.php';
include('waolm-update.php');

function wao_promo_box_func() {
    $data_promobox = get_option( 'wao_promobox_options' );
    $data_promobox_main = get_blog_option( get_main_site_id(), 'wao_promobox_options' );
    $arrayCategories = explode(",", $data_promobox['categorypromobox']);

    $efectpromobox_final = $data_promobox['efectpromobox']? $data_promobox['efectpromobox']: $data_promobox_main['efectpromobox'];
    $data_promobox_final = $data_promobox['datepromobox']? $data_promobox['datepromobox']: $data_promobox_main['datepromobox'];
    $enableclockpromobox_final = $data_promobox['enableclockpromobox']? $data_promobox['enableclockpromobox'] : $data_promobox_main['enableclockpromobox'];
    

    if ( has_term( $arrayCategories, 'product_cat', get_the_ID() ) ) { 
        $img_promobox = '';
        if(isset($data_promobox['bgpromobox']) && $data_promobox['bgpromobox'] != '') {
            $img_promobox = 'background-image: url('.$data_promobox['bgpromobox'].');';
        }
        else {
            $img_promobox = 'background-image: url('.$data_promobox_main['bgpromobox'].');';
        }
        $img_right_promobox = '';
        if(isset($data_promobox['imagepromobox'])) {
            $img_right_promobox = $data_promobox['imagepromobox'];
        }

        $dayspromobox = !empty($data_promobox['dayspromobox'])? $data_promobox['dayspromobox'] : 'Days';
        $hourspromobox = !empty($data_promobox['hourspromobox'])? $data_promobox['hourspromobox'] : 'Hours';
        $minutespromobox = !empty($data_promobox['minutespromobox'])? $data_promobox['minutespromobox'] : 'Minutes';
        $secondspromobox = !empty($data_promobox['secondspromobox'])? $data_promobox['secondspromobox'] : 'Seconds';

        ?>
        <style>
            .container-card {
                max-width: 600px;
                padding: 30px 20px 25px;
                border-radius: 10px;
                color: white;
                background-position: center;
                background-size: 140% auto;
                text-align: center;
                margin-bottom: 10px;
                margin-right: auto;
                margin-left: auto;
            }
            .container-card h2 {
                margin: 0;
                color: white;
                text-transform: uppercase;
                font-size: 21px !important;
                font-weight: bold !important;
                margin-bottom: 10px;
                line-height: 1;
            }
            .container-card p {
                margin: 0;
            }
            .container-card .clok {
                display: flex;
                gap: 18px;
                justify-content: center;
                /* border: 1px dashed #fff; */
                padding: 5px 10px;
            }
            .container-card .clok--item {
                display: flex;
                flex-direction: column;
                justify-content: center;
                text-align: center;
            }
            .container-card .clok--item :nth-child(1) {
                font-size: 3.2em;
                font-weight: bold;
                line-height: 1;
            }
            .container-card .content {
                display: flex;
                padding: 10px 0 15px;
                justify-content: center;
            }
            .container-card .picture {
                display: flex;
                flex-direction: column-reverse;
            }
            .container-card img {
                width: 100%;
                bottom: 10px;
            }
            @media (max-width: 992px) {
                .container-card .clok--item :nth-child(1) {
                    font-size: 2em;
                
                }
                .container-card {
                    background-size: auto 140%;
                }
            }
            

            <?php if($data_promobox['classimagepromobox'] && (isset($data_promobox['activeimagepromobox']) && $data_promobox['activeimagepromobox'])): ?>
                <?=$data_promobox['classimagepromobox']?> {
                    position: relative;
                }
                <?=$data_promobox['classimagepromobox']?>:before {
                    content: '';
                    background-image: url(<?=$data_promobox['imagepromobox']?>);
                    position: absolute;
                    background-size: contain;
                    background-repeat: no-repeat;
                    top: 20px;
                    right: -80px;
                    width: 144px;
                    height: 70px;
                    transform: rotate(38deg);
                    <?=$data_promobox['styleimagepromobox']?>
                }
                @media (max-width: 1200px) {
                    <?=$data_promobox['classimagepromobox']?>:before {
                        <?=$data_promobox['stylemobimagepromobox']?>
                    }
                }
                @media (max-width: 992px) {
                    <?=$data_promobox['classimagepromobox']?>:before {
                        content:none;
                    }
                }

            <?php elseif($data_promobox_main['classimagepromobox'] && (isset($data_promobox_main['activeimagepromobox']) && $data_promobox_main['activeimagepromobox'])) : ?>
                <?=$data_promobox_main['classimagepromobox']?> {
                    position: relative;
                }
                <?=$data_promobox_main['classimagepromobox']?>:before {
                    content: '';
                    background-image: url(<?=$data_promobox_main['imagepromobox']?>);
                    position: absolute;
                    background-size: contain;
                    background-repeat: no-repeat;
                    top: 20px;
                    right: -80px;
                    width: 144px;
                    height: 70px;
                    transform: rotate(38deg);
                    <?=$data_promobox_main['styleimagepromobox']?>
                }
                @media (max-width: 1200px) {
                    <?=$data_promobox_main['classimagepromobox']?>:before {
                        <?=$data_promobox_main['stylemobimagepromobox']?>
                    }
                }
                @media (max-width: 992px) {
                    <?=$data_promobox_main['classimagepromobox']?>:before {
                        content:none;
                    }
                }
            <?php endif; ?>

        
        </style>
        <div class="container-card" style="<?=$img_promobox?>">
            <?php if($data_promobox['titlepromobox']): ?>
                <h2><?=$data_promobox['titlepromobox']?></h2>
            <?php endif; ?>

            <?php if($data_promobox_final && $enableclockpromobox_final): ?>
                <div class="content">
                    <div class="clok">
                        <div class="clok--item">
                            <span id="days"></span>
                            <span>
                                <?=$dayspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="hours"></span>
                            <span>
                                <?=$hourspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="minutes"></span>
                            <span>
                                <?=$minutespromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="seconds"></span>
                            <span>
                                <?=$secondspromobox?>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($data_promobox['descpromobox']): ?>
                <p><?=$data_promobox['descpromobox']?></p>
            <?php endif; ?>
        </div>
            <?php if($enableclockpromobox_final): ?>
                <canvas id="confetti" style="height: 0;"></canvas>
                <script src="https://cdn.jsdelivr.net/npm/js-confetti@latest/dist/js-confetti.browser.js"></script>
                <script>
                    const button = document.querySelector('#button');
                    const canvas = document.querySelector('#confetti');

                    const jsConfetti = new JSConfetti();
                    window.onload = function(e){ 
                        jsConfetti.addConfetti()
                    }
                </script>
            <?php endif; ?>

            <?php 
                if($data_promobox_final): ?>
                <script>
                    document.addEventListener('DOMContentLoaded', () => {
                        const DATE_TARGET = new Date('<?=$data_promobox_final?>'); // 11/29/2024 0:01 AM
                        console.log('>>>', DATE_TARGET);
                        const SPAN_DAYS = document.querySelector('span#days');
                        const SPAN_HOURS = document.querySelector('span#hours');
                        const SPAN_MINUTES = document.querySelector('span#minutes');
                        const SPAN_SECONDS = document.querySelector('span#seconds');
                        // Milliseconds for the calculations
                        const MILLISECONDS_OF_A_SECOND = 1000;
                        const MILLISECONDS_OF_A_MINUTE = MILLISECONDS_OF_A_SECOND * 60;
                        const MILLISECONDS_OF_A_HOUR = MILLISECONDS_OF_A_MINUTE * 60;
                        const MILLISECONDS_OF_A_DAY = MILLISECONDS_OF_A_HOUR * 24

                            
                        function updateCountdown() {
                            const NOW = new Date()
                            const DURATION = DATE_TARGET - NOW;
                            const REMAINING_DAYS = Math.floor(DURATION / MILLISECONDS_OF_A_DAY);
                            const REMAINING_HOURS = Math.floor((DURATION % MILLISECONDS_OF_A_DAY) / MILLISECONDS_OF_A_HOUR);
                            const REMAINING_MINUTES = Math.floor((DURATION % MILLISECONDS_OF_A_HOUR) / MILLISECONDS_OF_A_MINUTE);
                            const REMAINING_SECONDS = Math.floor((DURATION % MILLISECONDS_OF_A_MINUTE) / MILLISECONDS_OF_A_SECOND);
                            
                            SPAN_DAYS.textContent = REMAINING_DAYS;
                            SPAN_HOURS.textContent = REMAINING_HOURS;
                            SPAN_MINUTES.textContent = REMAINING_MINUTES;
                            SPAN_SECONDS.textContent = REMAINING_SECONDS;

                            if (DURATION > 0) {
                                SPAN_DAYS.textContent = REMAINING_DAYS;
                                SPAN_HOURS.textContent = REMAINING_HOURS;
                                SPAN_MINUTES.textContent = REMAINING_MINUTES;
                                SPAN_SECONDS.textContent = REMAINING_SECONDS;
                            } else{
                                SPAN_DAYS.textContent = 0;
                                SPAN_HOURS.textContent = 0;
                                SPAN_MINUTES.textContent = 0;
                                SPAN_SECONDS.textContent = 0;
                            }
                        }
                    
                        updateCountdown();
                        setInterval(updateCountdown, MILLISECONDS_OF_A_SECOND);
                    });
                </script>

            <?php endif; ?>
    <?php
    } //end check category
}

add_Action('wp_head','wao_promobox_css');
function wao_promobox_css() {
    $data_promobox = get_option( 'wao_promobox_options' );
    $data_promobox_main = get_blog_option( get_main_site_id(), 'wao_promobox_options' );

    $arrayCategories = explode(",", $data_promobox['categorypromobox']);
    $classPromoList = "";
    $classPromoListID = "";
    $classPromoListIDhome = "";
    $classPromoListIDhome2 = "";
    foreach($arrayCategories as $classAux) {
        $category = get_term_by( 'slug', '2024', 'product_cat' );
        $cat_id = $category->term_id;

        $classPromoList .= '.products .product.product_cat-'.$classAux.':before,';
        $classPromoListID .= '.products .product.product_cat-'.$cat_id.':before,';
        $classPromoListIDhome .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-".$classAux.".shoppingcart-grid-product:before,";
        $classPromoListIDhome2 .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-".$cat_id.".shoppingcart-grid-product:before,";
    }
    $classPromoList = substr($classPromoList, 0, -1);
    $classPromoListID = substr($classPromoListID, 0, -1);
    $classPromoListIDhome = substr($classPromoListIDhome, 0, -1);
    $classPromoListIDhome2 = substr($classPromoListIDhome2, 0, -1);
    //print_r($data_promobox_main);
    ?>
        <style>
            <?php if(isset($data_promobox['activeimagepromobox']) && $data_promobox['activeimagepromobox']): ?>
                    .products .product, 
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product {
                        position: relative;
                    }
                    <?=$classPromoList?>,
                    <?=$classPromoListID?>, 
                    <?=$classPromoListIDhome?>,
                    <?=$classPromoListIDhome2?> {
                        content: '';
                        background-image: url(<?=$data_promobox['imagepromobox']?>);
                        position: absolute;
                        background-size: contain;
                        background-repeat: no-repeat;
                        top: 0;
                        right: -15px;
                        width: 71px;
                        height: 70px;
                        transform: rotate(20deg);
                        z-index: 22; 
                        <?php if(isset($data_promobox['styleimagecatpromobox']) and $data_promobox['styleimagecatpromobox'] !='') : ?>
                            <?=$data_promobox['styleimagecatpromobox']?>
                        <?php endif; ?>
                    }
                    
                    .woocommerce .products .product a {
                        text-decoration: none;
                        overflow: hidden !important;
                        position: relative;
                    }
                    .woocommerce .products .product, .woocommerce-page .products .product {
                        overflow: visible !important;
                    }
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product .onsale,
                    .archive.woocommerce .products .product .onsale {
                        display: none !important;
                    }
            <?php elseif(isset($data_promobox_main['activeimagepromobox']) && $data_promobox_main['activeimagepromobox']): ?>
                    .products .product, 
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product {
                        position: relative;
                    }
                    <?=$classPromoList?>,
                    <?=$classPromoListID?>,
                    <?=$classPromoListIDhome ?>,
                    <?=$classPromoListIDhome2 ?> {
                        content: '';
                        background-image: url(<?=$data_promobox_main['imagepromobox']?>);
                        position: absolute;
                        background-size: contain;
                        background-repeat: no-repeat;
                        top: 0;
                        right: -15px;
                        width: 71px;
                        height: 70px;
                        transform: rotate(20deg);
                        z-index: 24; 
                        <?php if(isset($data_promobox_main['styleimagecatpromobox']) and $data_promobox_main['styleimagecatpromobox'] !='') : ?>
                            <?=$data_promobox_main['styleimagecatpromobox']?>
                        <?php endif; ?>
                    }
                    
                    .woocommerce .products .product a {
                        text-decoration: none;
                        overflow: hidden !important;
                        position: relative;
                    }
                    .woocommerce .products .product, .woocommerce-page .products .product {
                        overflow: visible !important;
                    }
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product .onsale,
                    .archive.woocommerce .products .product .onsale {
                        display: none !important;
                    }
            <?php endif; ?>
        </style>
    <?php
}
