<?php

/**
 * Class WOA_Settings_PromoBox
 *
 * Configure the plugin settings page.
 */
class WOA_Settings_PromoBox {

	/**
	 * Capability required by the user to access the My Plugin menu entry.
	 *
	 * @var string $capability
	 */
	private $capability = 'manage_options';

	/**
	 * Array of fields that should be displayed in the settings page.
	 *
	 * @var array $fields
	 */
	private $fields = [
		[
			'id' => 'promoboxposition',
			'label' => 'Position',
			'description' => '',
			'type' => 'select',
			'class' => 'global',
			'options' => [
				'woocommerce_single_product_summary' => 'woocommerce_single_product_summary',
				'woocommerce_after_add_to_cart_form' => 'woocommerce_after_add_to_cart_form',
			],
		],
		[
			'id' => 'promoboxpositionnumber', //categoria donde activar el box
			'label' => 'Position Number hook',
			'value' => '20',
			'description' => 'Recommeded 20',
			'type' => 'text',
			'class' => 'global',
		],
		[
			'id' => 'categorypromobox', //categoria donde activar el box
			'label' => 'Category Product',
			'value' => 'promo',
			'description' => '',
			'type' => 'text',
			'class' => 'global',
		],
		[
			'id' => 'titlepromobox',
			'label' => 'Title',
			'description' => '',
			'type' => 'text',
		],
		[
			'id' => 'descpromobox',
			'label' => 'Description',
			'description' => '',
			'type' => 'textarea',
		],
        [
			'id' => 'bgpromobox',
			'label' => 'Background image',
			'description' => '',
			'type' => 'url',
			'class' => 'global',
		],
		[
			'id' => 'efectpromobox', //enable disable clock into box
			'label' => 'Enable Efect Confetti',
			'description' => '',
			'type' => 'checkbox',
			'class' => 'global',
		],
		[
			'id' => 'enableclockpromobox', //enable disable clock into box
			'label' => 'Enable clock',
			'description' => '',
			'type' => 'checkbox',
			'class' => 'global',
		],
		[
			'id' => 'datepromobox', // Date in promo BOx
			'label' => 'Date',
			'description' => 'Example: 11/29/2024 0:01 AM',
			'type' => 'text',
			'class' => 'global',
		],
		[
			'id' => 'dayspromobox',
			'label' => 'Days Text',
			'description' => '',
			'type' => 'text',
		],
		[
			'id' => 'hourspromobox',
			'label' => 'Hours text',
			'description' => '',
			'type' => 'text',
		],
		[
			'id' => 'minutespromobox',
			'label' => 'Minutes text',
			'description' => '',
			'type' => 'text',
		],
		[
			'id' => 'secondspromobox',
			'label' => 'Seconds text',
			'description' => '',
			'type' => 'text',
		],
		[
			'id' => 'activeimagepromobox', // activar/desactivar sombrero sitios
			'label' => 'Enable/Disable image right in product',
			'description' => '',
			'type' => 'checkbox',
			'class' => 'global',
		],
		[
			'id' => 'classimagepromobox', 
			'label' => 'Class o ID to aply the image right',
			'description' => '<b>Shoppingcart: </b>.primary or #primary<br><b>Softa: </b>.col-xs-12.col-md-8.col-lg-9<br><b>XTORE: </b>.col-md-9.product-content.sidebar-position-right',
			'type' => 'text',
			'class' => 'global',
		],
		[
			'id' => 'imagepromobox', //  imagen sombrero sitios
			'label' => 'Image right in product',
			'description' => '',
			'type' => 'text',
			'class' => 'global',
		],
		[
			'id' => 'styleimagepromobox', //  imagen sombrero sitios
			'label' => 'Styles for image right product',
			'description' => '',
			'type' => 'textarea',
			'class' => 'global',
		],
		[
			'id' => 'stylemobimagepromobox', //  imagen sombrero sitios
			'label' => 'Styles for image right product(Mobile)',
			'description' => '',
			'type' => 'textarea',
			'class' => 'global',
		],
		[
			'id' => 'styleimagecatpromobox', //  imagen sombrero sitios
			'label' => 'Styles for image right product in shop',
			'description' => '',
			'type' => 'textarea',
			'class' => 'global',
		],
		[
			'id' => 'maestro_promobox', //  maestro
			'label' => 'Master Config',
			'description' => '(Use this config for all sites.)',
			'type' => 'checkbox',
			'value' => 1,
			'class' => 'global',
		],
	];

	/**
	 * The Plugin Settings constructor.
	 */

	

	function __construct() {
		add_action( 'admin_init', [$this, 'settings_init'] );
		add_action( 'admin_menu', [$this, 'options_page'] );
	}

	/**
	 * Register the settings and all fields.
	 */
	function settings_init() : void {

		// Register a new setting this page.
		register_setting( 'wao-promobox', 'wao_promobox_options');


		// Register a new section.
		add_settings_section(
			'wao-promobox-section',
			__( '', 'wao-promobox' ),
			[$this, 'render_section'],
			'wao-promobox'
		);


		/* Register All The Fields. */
		foreach( $this->fields as $field ) {
			// Register a new field in the main section.
			add_settings_field(
				$field['id'], /* ID for the field. Only used internally. To set the HTML ID attribute, use $args['label_for']. */
				__( $field['label'], 'wao-promobox' ), /* Label for the field. */
				[$this, 'render_field'], /* The name of the callback function. */
				'wao-promobox', /* The menu page on which to display this field. */
				'wao-promobox-section', /* The section of the settings page in which to show the box. */
				[
					'label_for' => $field['id'], /* The ID of the field. */
					'class' => 'wporg_row', /* The class of the field. */
					'field' => $field, /* Custom data for the field. */
				]
			);
		}
	}
	public function sanitize_segundoemail_options($input) {
		if (isset($input['maestro_promobox'])) {
			if(is_multisite()){
				$sites=get_sites();
				foreach($sites as $site){
					switch_to_blog($site->blog_id);
						update_option('wao_promobox_options',$input);
					restore_current_blog();
				}
			}
		}
		return $input;
	}

	/**
	 * Add a subpage to the WordPress Settings menu.
	 */
	function options_page() : void {
		add_menu_page(
			'Settings', /* Page Title */
			'WAO Promo Box', /* Menu Title */
			$this->capability, /* Capability */
			'wao-promobox', /* Menu Slug */
			[$this, 'render_options_page'], /* Callback */
			'dashicons-feedback', /* Icon */
			'2', /* Position */
		);
	}

	/**
	 * Render the settings page.
	 */
	function render_options_page() : void {

		// check user capabilities
		if ( ! current_user_can( $this->capability ) ) {
			return;
		}

		// add error/update messages

		// check if the user have submitted the settings
		// WordPress will add the "settings-updated" $_GET parameter to the url
		//print_r($_GET);

		if ( isset( $_GET['settings-updated'] ) ) {
			// add settings saved message with the class of "updated"
			add_settings_error( 'wporg_messages', 'wporg_message', __( 'Settings Saved', 'wao-promobox' ), 'updated' );
		}

		// show error/update messages
		settings_errors( 'wporg_messages' );
		?>
		<div class="wrap form-promo">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<h2 class="description"></h2>
			<form action="options.php" method="post">
				<?php
				/* output security fields for the registered setting "wporg" */
				settings_fields( 'wao-promobox' );
				/* output setting sections and their fields */
				/* (sections are registered for "wporg", each field is registered to a specific section) */
				do_settings_sections( 'wao-promobox' );
				/* output save settings button */
				submit_button( 'Save Settings' );
				?>
			</form>
		</div>
		<?php
	}

	/**
	 * Render a settings field.
	 *
	 * @param array $args Args to configure the field.
	 */
	function render_field( array $args ) : void {

		$field = $args['field'];

		// Get the value of the setting we've registered with register_setting()
		$options = get_option( 'wao_promobox_options' );
		$data_promobox_main = get_blog_option( get_main_site_id(), 'wao_promobox_options' );
		//$dataAux = 
		unset($data_promobox_main['titlepromobox']);
		unset($data_promobox_main['descpromobox']);
		unset($data_promobox_main['dayspromobox']);
		unset($data_promobox_main['hourspromobox']);
		unset($data_promobox_main['minutespromobox']);
		unset($data_promobox_main['secondspromobox']);
		//unset($data_promobox_main['maestro_promobox']);

		if (isset($options['maestro_promobox']) && $options['maestro_promobox']) {
			if(is_multisite()){
				$sites=get_sites();
				foreach($sites as $site){
					switch_to_blog($site->blog_id);
						$options2 = get_option( 'wao_promobox_options' );
						update_option('wao_promobox_options',array_merge($options2,$data_promobox_main));
					restore_current_blog();
				}
			}
		}

		?>
		<style>
			.form-promo input[type="text"],
			.form-promo input[type="url"], 
			.form-promo textarea {
				width: 50%;
			}
			.form-promo .global {
				border: 1px solid red;
			}
			.categorypromobox span:last-child {
				display:none;
			}
		</style>
		<?php

		switch ( $field['type'] ) {
			
			case "text": {
				$valueAux =  !empty($field['value'])? $field['value'] : '';
				if(isset( $options[ $field['id'] ] )) {
					$valueAux = esc_attr( $options[ $field['id'] ] );
				}
				if($field['id']  == 'categorypromobox') {
					echo '<p class="categorypromobox" style="margin-bottom: 10px;"><b>Categorias:</b> '.$this->get_categories_text().'</p>';
				}

				?>
				<input
					type="text"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo  $valueAux ?>"
					class="<?php echo esc_attr( $field['class'] ); ?>"
				>
				<p class="description">
					<?php echo ( $field['description']); ?>
				</p>
				<?php
				break;
			}

			case "checkbox": {
				$valueAux =  !empty($field['value'])? $field['value'] : '';
				?>
				<input
					type="checkbox"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					class="<?php echo esc_attr( $field['class'] ); ?>"
					value="1"
					<?php echo isset( $options[ $field['id'] ] ) ? ( checked( $options[ $field['id'] ], 1, false ) ) : ( '' ); ?>
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<script>
					<?php
					if ($valueAux) {
						echo 'document.getElementById("maestro_promobox").checked = false;';
					} 
					?>
				</script>
				<?php
				break;
			}

			case "textarea": {
				?>
				<textarea
					id="<?php echo esc_attr( $field['id'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					class="<?php echo esc_attr( $field['class'] ); ?>"
				><?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?></textarea>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "select": {
				?>
				<select
					id="<?php echo esc_attr( $field['id'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					class="<?php echo esc_attr( $field['class'] ); ?>"
				>
					<?php foreach( $field['options'] as $key => $option ) { ?>
						<option value="<?php echo $key; ?>" 
							<?php echo isset( $options[ $field['id'] ] ) ? ( selected( $options[ $field['id'] ], $key, false ) ) : ( '' ); ?>
						>
							<?php echo $option; ?>
						</option>
					<?php } ?>
				</select>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "password": {
				?>
				<input
					type="password"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					class="<?php echo esc_attr( $field['class'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?>"
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "wysiwyg": {
				wp_editor(
					isset( $options[ $field['id'] ] ) ? $options[ $field['id'] ] : '',
					$field['id'],
					array(
						'textarea_name' => 'wao_promobox_options[' . $field['id'] . ']',
						'textarea_rows' => 5,
					)
				);
				break;
			}

			case "email": {
				?>
				<input
					type="email"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					class="<?php echo esc_attr( $field['class'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?>"
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "url": {
				?>
				<input
					type="url"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					class="<?php echo esc_attr( $field['class'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?>"
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "color": {
				?>
				<input
					type="color"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					class="<?php echo esc_attr( $field['class'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?>"
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

			case "date": {
				?>
				<input
					type="date"
					id="<?php echo esc_attr( $field['id'] ); ?>"
					name="wao_promobox_options[<?php echo esc_attr( $field['id'] ); ?>]"
					value="<?php echo isset( $options[ $field['id'] ] ) ? esc_attr( $options[ $field['id'] ] ) : ''; ?>"
				>
				<p class="description">
					<?php esc_html_e( $field['description'], 'wao-promobox' ); ?>
				</p>
				<?php
				break;
			}

		}
	}


	/**
	 * Render a section on a page, with an ID and a text label.
	 *
	 * @since 1.0.0
	 *
	 * @param array $args {
	 *     An array of parameters for the section.
	 *
	 *     @type string $id The ID of the section.
	 * }
	 */
	function render_section( array $args ) : void {
		?>
		<p id="<?php echo esc_attr( $args['id'] ); ?>"><?php esc_html_e( '', 'wao-promobox' ); ?></p>
		<?php
	}

	function get_categories_text() {
		$res = '';
		$taxonomy     = 'product_cat';
		$orderby      = 'name';  
		$show_count   = 0;      // 1 for yes, 0 for no
		$pad_counts   = 0;      // 1 for yes, 0 for no
		$hierarchical = 1;      // 1 for yes, 0 for no  
		$title        = '';  
		$empty        = 0;

		$args = array(
				'taxonomy'     => $taxonomy,
				'orderby'      => $orderby,
				'show_count'   => $show_count,
				'pad_counts'   => $pad_counts,
				'hierarchical' => $hierarchical,
				'title_li'     => $title,
				'hide_empty'   => $empty
		);
		$all_categories = get_categories( $args );
		foreach ($all_categories as $cat) {
			if($cat->category_parent == 0) {
				$category_id = $cat->term_id;       
				$res .=  $cat->slug .' <span>|</span> ';

				$args2 = array(
						'taxonomy'     => $taxonomy,
						'child_of'     => 0,
						'parent'       => $category_id,
						'orderby'      => $orderby,
						'show_count'   => $show_count,
						'pad_counts'   => $pad_counts,
						'hierarchical' => $hierarchical,
						'title_li'     => $title,
						'hide_empty'   => $empty
				);
				$sub_cats = get_categories( $args2 );
				if($sub_cats) {
					foreach($sub_cats as $sub_category) {
						$res .=  $sub_category->slug.' <span>|</span> ';
					}
				}
			}
		}
		return $res;
	}

}

new WOA_Settings_PromoBox();

