<?php 
/*
 * WAO UPDATE. LOGICA PARA LA ACTUALIZACION DEL PLUGIN
 * https://rudrastyh.com/wordpress/self-hosted-plugin-update.html
 * Version optimizada
*/

function wao_promobox_Update( $res, $action, $args ){// Muestra el contenido de wiew details

	// do nothing if this is not about getting plugin information
	if( 'plugin_information' !== $action ) {
		return $res;
	}

	// do nothing if it is not our plugin
	if( plugin_basename( __DIR__ ) !== $args->slug ) {
		return $res;
	}
	// info.json is the file with the actual plugin information on your server
	$remote = wp_remote_get( 
		'https://download.winandoffice.com/Install/pluginWaoUpdates/wao-boxpromo/pluginwaosmversion.json', 
		array(
			'timeout' => 3,
			'headers' => array('Accept' => 'application/json') 
		)
	);

	// do nothing if we don't get the correct response from the server
	if(is_wp_error( $remote )|| 200 !== wp_remote_retrieve_response_code( $remote )|| empty( wp_remote_retrieve_body( $remote ))) {
		return $res;	
	}

	$remote = json_decode( wp_remote_retrieve_body( $remote ) );
	
	$res = new stdClass();
	$res->name = $remote->name;
	$res->slug = $remote->slug;
	$res->author = $remote->author;
	$res->author_profile = $remote->author_profile;
	$res->version = $remote->version;
	$res->tested = $remote->tested;
	$res->requires = $remote->requires;
	$res->requires_php = $remote->requires_php;
	$res->download_link = $remote->download_url;
	$res->trunk = $remote->download_url;
	$res->last_updated = $remote->last_updated;
	$res->sections = array(
		'description' => $remote->sections->description,
		'installation' => $remote->sections->installation,
		'changelog' => $remote->sections->changelog
		// you can add your custom sections (tabs) here
	);
	// in case you want the screenshots tab, use the following HTML format for its content:
	// <ol><li><a href="IMG_URL" target="_blank"><img src="IMG_URL" alt="CAPTION" /></a><p>CAPTION</p></li></ol>


	if( ! empty( $remote->sections->screenshots ) ) {
		$res->sections[ 'screenshots' ] = $remote->sections->screenshots;
	}

	$res->banners = array(
		'low' => $remote->banners->low,
		'high' => $remote->banners->high
	);
	
	return $res;

}

//add_filter( 'site_transient_update_plugins', 'waolm_push_update' );
 
function wao_promobox_push_update( $transient ){// Muestra que existe una actualizacion y ejecuta la actualizacion
 
	if ( empty( $transient->checked ) ) {
		return $transient;
	}
 
	$remote = wp_remote_get( 
		'https://download.winandoffice.com/Install/pluginWaoUpdates/wao-boxpromo/pluginwaosmversion.json',
		array(
			'timeout' => 3,
			'headers' => array(
				'Accept' => 'application/json'
			)
		)
	);
	if(is_wp_error( $remote )|| 200 !== wp_remote_retrieve_response_code( $remote )|| empty( wp_remote_retrieve_body( $remote ))) {
		return $transient;	
	}
	
	$remote = json_decode( wp_remote_retrieve_body( $remote ) );

	if($remote&& version_compare( WAOPROMOBOX_PLUGIN__VERSION, $remote->version, '<' )) {
		$res = new stdClass();
		$res->slug = $remote->slug;
		//$res->plugin = plugin_basename( __FILE__ ); // it could be just YOUR_PLUGIN_SLUG.php if your plugin doesn't have its own directory
		$res->plugin = "wao-boxpromo/wao-boxpromo.php";
		$res->new_version = $remote->version;
		$res->tested = $remote->tested;
		$res->package = $remote->download_url;
		$res->details_url = $remote->details_url;
		$transient->response[ $res->plugin ] = $res;
		
		//$transient->checked[$res->plugin] = $remote->version;
	}
 
	return $transient;

}

// Muestra link para 'View Details'
function custom_plugin_row_meta_wao_promobox($meta, $plugin_file, $plugin_data, $status) {
    // Reemplaza el enlace predeterminado con tu enlace personalizado
    if ($plugin_file === 'wao-boxpromo/wao-boxpromo.php') {
        $url = 'plugin-install.php?tab=plugin-information&plugin=wao-boxpromo&section=description&TB_iframe=true&width=772&height=839';
        $meta[] = '<a href="' . esc_url($url) . '" class="thickbox open-plugin-details-modal">' . esc_html__('View details', 'wao-licensemanager') . '</a>';
    }
    return $meta;
}
add_filter('plugin_row_meta', 'custom_plugin_row_meta_wao_promobox', 10, 4);

// Solo buscar actualizaciones cuando estamos en network/plugins.php
function promobox_include_update_logic_if_on_network_plugins_page() {
	$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    // Verifica si estamos en la página de plugins de la red 
    if ($path === '/wp-admin/network/plugin-install.php') {// Si estamos viendo el contenido de view details
		add_filter( 'plugins_api', 'wao_promobox_Update', 20, 4);
	}//||$path==='/wp-admin/network/update.php'||$path === '/wp-admin/network/upgrade.php'
    if ($path === '/wp-admin/network/plugins.php') {// La pagina de plugins, mostrar aviso de actualizacion disponible
		add_filter( 'site_transient_update_plugins', 'wao_promobox_push_update' );
    }
    if ($path === '/wp-admin/admin-ajax.php') {// Si se hizo clic en update now
		add_filter( 'site_transient_update_plugins', 'wao_promobox_push_update' );
    }
}
add_action('admin_init', 'promobox_include_update_logic_if_on_network_plugins_page');//

function promo_box_plugin_get_action() {
    $action = isset($_REQUEST['action'])?$_REQUEST['action']:null;
	if($action == 'update-plugin'){
		add_filter( 'site_transient_update_plugins', 'wao_promobox_push_update' );//update now (action)
	}
}
add_action('admin_init', 'promo_box_plugin_get_action');//clic en 'update now'
