(function($){

  // ===== Filtro por nombre + chips =====
  $(document).on('input', '#pnm-filter', function(){
    var q = $(this).val().toLowerCase();
    $('.pnm-plugin').each(function(){
      var name = $(this).find('.pnm-plugin-name').text().toLowerCase();
      $(this)[ name.indexOf(q) !== -1 ? 'show' : 'hide' ]();
    });
  });

  $(document).on('click', '.pnm-chip', function(e){
    e.preventDefault();
    var type = $(this).data('filter');
    $('.pnm-chip').removeClass('button-primary');
    $(this).addClass('button-primary');

    $('.pnm-plugin').each(function(){
      if (type === 'all') { $(this).show(); return; }
      var isActive = /Activo en red/.test($(this).find('.pnm-network-indicator').text());
      var show = (type === 'network_active' && isActive) || (type === 'network_inactive' && !isActive);
      $(this)[ show ? 'show' : 'hide' ]();
    });
  });

  // ===== Toggle botones (individual / red) =====
  $(document).on('click', '.pnm-toggle-btn, .pnm-toggle-network', function(e){
    e.preventDefault();

    var $btn = $(this);
    var $pluginBlock = $btn.closest('.pnm-plugin');
    var plugin = $pluginBlock.data('plugin');
    var isNetwork = $btn.hasClass('pnm-toggle-network');
    var $row = null;

    var action = $btn.data('action');
    var data = {
      action: 'pnm_toggle_plugin',
      nonce: pnm_ajax.nonce,
      plugin: plugin,
      action_type: action
    };

    if (!isNetwork) {
      $row = $btn.closest('.pnm-site-row');
      data.site_id = $row.data('site');
    }

    $btn.prop('disabled', true).text('Procesando...');

    $.post(pnm_ajax.ajax_url, data, function(response) {
      if (response.success && response.data && response.data.status) {
        var new_status = response.data.status;

        var new_action = (new_status === 'Activo') ?
            (isNetwork ? 'network_deactivate' : 'deactivate') :
            (isNetwork ? 'network_activate' : 'activate');

        var new_label = (new_status === 'Activo') ? 'Desactivar' : 'Activar';
        var new_class = (new_status === 'Activo') ? 'button-secondary' : 'button-primary';

        if (isNetwork) {
          $pluginBlock.find('.pnm-network-row .pnm-status').text(
            new_status === 'Activo' ? '🟢 Activo en red' : '🔴 No activo en red'
          );
          $pluginBlock.find('.pnm-network-indicator').text(
            new_status === 'Activo' ? '🟢 Activo en red' : '🔴 No activo en red'
          );
        } else {
          $row.find('.pnm-status').text(new_status);
        }

        $btn
          .data('action', new_action)
          .text(new_label)
          .removeClass('button-primary button-secondary')
          .addClass(new_class);

        // Recontar badges visibles
        updateBadgesCounts($pluginBlock);
      } else {
        alert('Error: ' + (response.data || 'acción no válida'));
      }

      $btn.prop('disabled', false);
    });
  });

  // ===== Lazy-load de estados cuando abres el acordeón =====
  function loadPluginStates($pluginBlock){
    var content = $pluginBlock.find('.pnm-accordion-content');
    if (content.attr('data-loaded') === '1') return;
    var plugin = $pluginBlock.data('plugin');
    $pluginBlock.addClass('pnm-loading');

    $.get(pnm_ajax.ajax_url, {
      action: 'wao_get_plugin_states',
      nonce: pnm_ajax.nonce,
      plugin: plugin
    }, function(resp){
      if(resp.success){
        var states = resp.data.states || {};
        $pluginBlock.find('.pnm-site-row').each(function(){
          var sid = $(this).data('site');
          var state = states[sid] || 'Inactivo';
          $(this).find('.pnm-status').text(state);
          var btn = $(this).find('.pnm-toggle-btn');
          var toActivate = (state !== 'Activo');
          btn
            .data('action', toActivate ? 'activate' : 'deactivate')
            .text(toActivate ? 'Activar' : 'Desactivar')
            .removeClass('button-primary button-secondary')
            .addClass(toActivate ? 'button-primary' : 'button-secondary')
            .prop('disabled', false);
        });
        // Badges
        $pluginBlock.find('.pnm-badge-active')
          .attr('data-count', resp.data.counts.active)
          .text('Activos: ' + resp.data.counts.active);
        $pluginBlock.find('.pnm-badge-inactive')
          .attr('data-count', resp.data.counts.inactive)
          .text('Inactivos: ' + resp.data.counts.inactive);

        content.attr('data-loaded','1');
      }else{
        alert('Error al cargar estados: ' + (resp.data || ''));
      }
      $pluginBlock.removeClass('pnm-loading');
    });
  }

  function updateBadgesCounts($pluginBlock){
    var active = 0, inactive = 0;
    $pluginBlock.find('.pnm-site-row .pnm-status').each(function(){
      if ($(this).text().trim() === 'Activo') active++; else inactive++;
    });
    $pluginBlock.find('.pnm-badge-active').attr('data-count', active).text('Activos: '+active);
    $pluginBlock.find('.pnm-badge-inactive').attr('data-count', inactive).text('Inactivos: '+inactive);
  }

  // ===== Acordeón open/close con aria-expanded y lazy-load =====
  document.querySelectorAll('.pnm-accordion-toggle').forEach(button => {
    button.addEventListener('click', () => {
      const content = button.nextElementSibling;
      const isOpen = content.style.display === 'block';
      document.querySelectorAll('.pnm-accordion-content').forEach(c => c.style.display = 'none');
      document.querySelectorAll('.pnm-accordion-toggle').forEach(b => b.setAttribute('aria-expanded','false'));
      if (!isOpen) {
        content.style.display = 'block';
        button.setAttribute('aria-expanded','true');
        loadPluginStates($(button).closest('.pnm-plugin'));
      }
    });
  });

})(jQuery);
