<?php
/* 
Plugin Name: WAO Promo box NEW
Plugin URI: https://rusdev.com/ 
Description: Plugin to insert into single products promo discount with a promo. 
Version: 1.1
Author: Rusland Rojas
Author URI: https://rusdev.com/ 
License: GPLv2 or later 
Text Domain: promobox
*/


if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/** 
* Define constants 
*/

define( 'WAO_PROMOBOX_PLUGIN__VERSION', '1.1' );
include('waolm-update.php');


add_action('network_admin_menu', 'add_my_netw_settings_page');
function add_my_netw_settings_page() {
  add_submenu_page(
       'settings.php',
       'Promo Box',
       'Promo Box',
       'manage_network_options',
       'wao-promobox-settings',
       'wao_form_promobox'
  );    
}

function wao_form_promobox(){
  	?>

	<h1 id="wao_pb_edit-site">Promo Box Settings</h1>
                
	<?php settings_errors(); ?>
	
	<?php
	if ( isset( $_GET['tab'] ) ) {
		$active_tab = $_GET['tab'];
	} 
	else {
		$active_tab = 'woocommerce_options';
	}
	?>
  	<style>
		.nav-tab {
			border: 1px solid #2196f338;
			background: #2196f338;
			color: #545454;
		}
		.nav-tab-wrapper, .wrap h2.nav-tab-wrapper, h1.nav-tab-wrapper {
			border-bottom: 1px solid #2196f3;
		}
		.nav-tab-active, .nav-tab-active:focus, .nav-tab-active:focus:active, .nav-tab-active:hover {
			border-bottom: 1px solid #2196f3;
			background: #2196f3;
			color: #fff;
			border-color: #2196f3;
		}
		.form-table h4 {
			margin-bottom: 0;
		}
		.form-table {    max-width: 1400px;}
		.form-table.form td {width: 25%;}
			.form-table td h2 {margin-bottom: -20px;}
			.form-table td input[type="text"], 
			.form-table td select, 
			.form-table td textarea {
			width: 100%;
			padding: 12px 20px;
			margin: 8px 0;
			display: inline-block;
			border: 1px solid #ccc;
			border-radius: 4px;
			box-sizing: border-box;
			}
			.form-table td textarea {
				height: 100px;
			}

			input[type=submit] {
			width: 100%;
			background-color: #4CAF50;
			color: white;
			padding: 14px 20px;
			margin: 8px 0;
			border: none;
			border-radius: 4px;
			cursor: pointer;
			}

			input[type=submit]:hover {
			background-color: #45a049;
			}
			.switch {
			position: relative;
			display: inline-block;
			width: 60px;
			height: 34px;
			}

			.switch input { 
			opacity: 0;
			width: 0;
			height: 0;
			}

			.slider {
			position: absolute;
			cursor: pointer;
			top: 0;
			left: 0;
			right: 0;
			bottom: 0;
			background-color: #ccc;
			-webkit-transition: .4s;
			transition: .4s;
			}

			.slider:before {
			position: absolute;
			content: "";
			height: 26px;
			width: 26px;
			left: 4px;
			bottom: 4px;
			background-color: white;
			-webkit-transition: .4s;
			transition: .4s;
			}

			input:checked + .slider {
			background-color: #2196F3;
			}

			input:focus + .slider {
			box-shadow: 0 0 1px #2196F3;
			}

			input:checked + .slider:before {
			-webkit-transform: translateX(26px);
			-ms-transform: translateX(26px);
			transform: translateX(26px);
			}

			/* Rounded sliders */
			.slider.round {
			border-radius: 34px;
			}

			.slider.round:before {
			border-radius: 50%;
		}
	</style>

  	<h2 class="nav-tab-wrapper">
		<a href="?page=<?php echo $_GET['page']; ?>&tab=woocommerce_options" class="nav-tab <?php echo $active_tab == 'woocommerce_options' ? 'nav-tab-active' : ''; ?>">Woocommerce Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=text_options" class="nav-tab <?php echo $active_tab == 'text_options' ? 'nav-tab-active' : ''; ?>">Box Content and Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=clock_options" class="nav-tab <?php echo $active_tab == 'clock_options' ? 'nav-tab-active' : ''; ?>">Clock Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=style_options" class="nav-tab <?php echo $active_tab == 'style_options' ? 'nav-tab-active' : ''; ?>">Style Options</a>
  	</h2>
  	<form action="<?php echo admin_url('admin-post.php?action=update_my_settings'); ?>" method="post" class="form-table">
    	<?php wp_nonce_field('wao_nonce'); ?>

		<?php if ( $active_tab == 'woocommerce_options' ) : ?>
			<input type="hidden" name="tab_section" value="woocommerce_options">
			<?php 
				$wao_pb_promoboxposition = get_site_option( 'wao_pb_promoboxposition' );
				$wao_pb_promoboxpositionnumber = get_site_option( 'wao_pb_promoboxpositionnumber' );
				$wao_pb_categorypromobox = get_site_option( 'wao_pb_categorypromobox' );
			?>
			<table class="form-table">
				<tr>
					<th scope="row"><h2>Position Woocommerce</h2></th>
					<td>
					<select id="wao_pb_promoboxposition" name="wao_pb_promoboxposition" >
							<option value="woocommerce_single_product_summary" <?php if($wao_pb_promoboxposition == 'woocommerce_single_product_summary') echo 'selected'; ?>>woocommerce_single_product_summary</option>
							<option value="woocommerce_after_add_to_cart_form" <?php if($wao_pb_promoboxposition == 'woocommerce_after_add_to_cart_form') echo 'selected'; ?>>woocommerce_after_add_to_cart_form</option>
					</select>
					</td>
				</tr>
				<tr>
					<th scope="row"><h2>Position Number hook</h2></th>
					<td>		
						<input type="text" id="wao_pb_promoboxpositionnumber" name="wao_pb_promoboxpositionnumber" value="<?php echo $wao_pb_promoboxpositionnumber ; ?>" >
						<p class="description">Recommeded 20</p>
					</td>
				</tr>
				<tr>
					<th scope="row"><h2>Category Product</h2></th>
					<td>
					<input type="text" id="wao_pb_categorypromobox" name="wao_pb_categorypromobox" value="<?php echo $wao_pb_categorypromobox ; ?>" class="">
						<p class="categorypromobox" style="margin-bottom: 10px;"><b>Categorias:</b> <?php echo get_categories_text();?></p>	
					</td>
				</tr>
			</table>
			
		<?php elseif ( $active_tab == 'text_options' ) : ?>
			<input type="hidden" name="tab_section" value="text_options">
			<?php 
				$wao_pb_titlepromobox_en = get_site_option( 'wao_pb_titlepromobox_en' );
				$wao_pb_titlepromobox_es = get_site_option( 'wao_pb_titlepromobox_es' );
				$wao_pb_titlepromobox_de = get_site_option( 'wao_pb_titlepromobox_de' );
				$wao_pb_titlepromobox_it = get_site_option( 'wao_pb_titlepromobox_it' );
				$wao_pb_titlepromobox_fr = get_site_option( 'wao_pb_titlepromobox_fr' );

				$wao_pb_descpromobox_en = get_site_option( 'wao_pb_descpromobox_en' );
				$wao_pb_descpromobox_es = get_site_option( 'wao_pb_descpromobox_es' );
				$wao_pb_descpromobox_de = get_site_option( 'wao_pb_descpromobox_de' );
				$wao_pb_descpromobox_it = get_site_option( 'wao_pb_descpromobox_it' );
				$wao_pb_descpromobox_fr = get_site_option( 'wao_pb_descpromobox_fr' );

				$wao_pb_bgpromobox = get_site_option( 'wao_pb_bgpromobox' );
			?>
			<table class="form-table form">
				<tr>
					<td colspan="3"><h2>Titles:</h2></td>
				</tr>
				<tr>
					<td>
						<h4>English:</h4> 
						<input type="text" id="wao_pb_titlepromobox_en" name="wao_pb_titlepromobox_en" value="<?php echo $wao_pb_titlepromobox_en; ?>" class="">
					</td>
					<td>
						<h4>Spanish:</h4> 
						<input type="text" id="wao_pb_titlepromobox_es" name="wao_pb_titlepromobox_es" value="<?php echo $wao_pb_titlepromobox_es; ?>" class="">
					</td>
					<td>
						<h4>German:</h4> 
						<input type="text" id="wao_pb_titlepromobox_de" name="wao_pb_titlepromobox_de" value="<?php echo $wao_pb_titlepromobox_de; ?>" class="">
					</td>
				</tr>
				<tr>
					<td>
						<h4>Italian:</h4> 
						<input type="text" id="wao_pb_titlepromobox_it" name="wao_pb_titlepromobox_it" value="<?php echo $wao_pb_titlepromobox_it; ?>" class="">
					</td>
					<td>
						<h4>French:</h4> 
						<input type="text" id="wao_pb_titlepromobox_fr" name="wao_pb_titlepromobox_fr" value="<?php echo $wao_pb_titlepromobox_fr; ?>" class="">
						</td>
					<td>
					</td>
				</tr>

				<tr>
					<td colspan="3"><h2>Description:</h2></td>
				</tr>
				<tr>
					<td>
						<h4>English:</h4> 
						<input type="text" id="wao_pb_descpromobox_en" name="wao_pb_descpromobox_en" value="<?php echo $wao_pb_descpromobox_en; ?>" class="">
					</td>
					<td>
						<h4>Spanish:</h4> 
						<input type="text" id="wao_pb_descpromobox_es" name="wao_pb_descpromobox_es" value="<?php echo $wao_pb_descpromobox_es; ?>" class="">
					</td>
					<td>
						<h4>German:</h4> 
						<input type="text" id="wao_pb_descpromobox_de" name="wao_pb_descpromobox_de" value="<?php echo $wao_pb_descpromobox_de; ?>" class="">
					</td>
				</tr>
				<tr>
					<td>
						<h4>Italian:</h4> 
						<input type="text" id="wao_pb_descpromobox_it" name="wao_pb_descpromobox_it" value="<?php echo $wao_pb_descpromobox_it; ?>" class="">
					</td>
					<td>
						<h4>French:</h4> 
						<input type="text" id="wao_pb_descpromobox_fr" name="wao_pb_descpromobox_fr" value="<?php echo $wao_pb_descpromobox_fr; ?>" class="">
						</td>
					<td>
					</td>
				</tr>
				
				<tr>
					<td colspan="3"><h2>Background:</h2></td>
				</tr>
				<tr>
					<td colspan="3"><input type="text" id="wao_pb_bgpromobox" name="wao_pb_bgpromobox" value="<?php echo $wao_pb_bgpromobox; ?>" class=""></td>
				</tr>
			</table>

		<?php elseif ( $active_tab == 'clock_options' ) : ?>
			<input type="hidden" name="tab_section" value="clock_options">
			<?php 
				$wao_pb_enableclockpromobox = get_site_option( 'wao_pb_enableclockpromobox' );
				$wao_pb_renewclockpromobox = get_site_option( 'wao_pb_renewclockpromobox' );
				$wao_date_promobox = get_site_option( 'wao_date_promobox' );
			?>
			<table class="form-table auto">
				<tr>
					<th><h2>Enable clock:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_enableclockpromobox != '' && $wao_pb_enableclockpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_enableclockpromobox" name="wao_pb_enableclockpromobox"  value="1" <?php echo $is_checked?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>
				<tr>
					<th><h2>Renew clock by day:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_renewclockpromobox != '' && $wao_pb_renewclockpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_renewclockpromobox" name="wao_pb_renewclockpromobox"  value="1" onChange="handleChange(this)" <?php echo $is_checked?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>

				<tr>
					<th colspan=""><h2>Date:</h2></th>
					<td colspan=""><input type="text" id="wao_date_promobox" name="wao_date_promobox" value="<?php echo $wao_date_promobox; ?>" class="">
					<p class="description">Example: MM/DD/YYYY 0:01 AM</p></td>
				</tr>
			</table>

		<?php elseif ( $active_tab == 'style_options' ) : ?>
			<input type="hidden" name="tab_section" value="style_options">
			<?php 
				$wao_pb_enableconfetipromobox = get_site_option( 'wao_pb_enableconfetipromobox');
				$wao_pb_showrightpromobox = get_site_option( 'wao_pb_showrightpromobox');
				$wao_pb_urlrightpromobox = get_site_option( 'wao_pb_urlrightpromobox');
				$wao_pb_idrightpromobox =  get_site_option( 'wao_pb_idrightpromobox');
				$wao_pb_stylerightpromobox = get_site_option( 'wao_pb_stylerightpromobox');
				$wao_pb_stylemobrightpromobox = get_site_option( 'wao_pb_stylemobrightpromobox');
				$wao_pb_styleshoppromobox = get_site_option( 'wao_pb_styleshoppromobox');
			?>
			<table class="form-table auto">
				<tr>
					<th><h2>Enable Confeti:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_enableconfetipromobox != '' && $wao_pb_enableconfetipromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_enableconfetipromobox" name="wao_pb_enableconfetipromobox" value="1" <?php echo $is_checked?> >
							<span class="slider round"></span>
						</label>
					</td>
				</tr>
				<tr>
				<th><h2>Image right show in product?</h2></th> 
					<td>
						<?php $is_checked_2 = ( $wao_pb_showrightpromobox != '' && $wao_pb_showrightpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_showrightpromobox" name="wao_pb_showrightpromobox"  value="1" <?php echo $is_checked_2?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>

				<tr>
					<th><h2>Image right URL in product</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_urlrightpromobox" name="wao_pb_urlrightpromobox" value="<?php echo $wao_pb_urlrightpromobox; ?>" class=""></td>
				</tr>

				<tr>
					<th><h2>Class o ID to aply the image right	</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_idrightpromobox" name="wao_pb_idrightpromobox" value="<?php echo $wao_pb_idrightpromobox; ?>" class=""></td>
				</tr>
				
				<tr>
					<th colspan=""><h2>Styles for image right product:</h2></th>
					<td colspan=""><textarea id="wao_pb_stylerightpromobox" name="wao_pb_stylerightpromobox"><?php echo $wao_pb_stylerightpromobox; ?></textarea></td>
				</tr>
				<tr>
					<th colspan=""><h2>Styles for image right product(mobile):</h2></th>
					<td colspan=""><textarea id="wao_pb_stylemobrightpromobox" name="wao_pb_stylemobrightpromobox"><?php echo $wao_pb_stylemobrightpromobox; ?></textarea></td>
				</tr>
				<tr>
					<th colspan=""><h2>Styles for image right product in shop:</h2></th>
					<td colspan=""><textarea id="wao_pb_styleshoppromobox" name="wao_pb_styleshoppromobox"><?php echo $wao_pb_styleshoppromobox; ?></textarea></td>
				</tr>
			</table>

		<?php endif; ?>
					
      	<p class="submit">
          	<button type="submit" name="wao_pb_add_ip_restriction" class="button button-primary">Save</button>
      	</p>
  </form>
  <script>
	<?php if (  $wao_pb_renewclockpromobox != '' && $wao_pb_renewclockpromobox == 1 ) : ?>
		document.getElementById('wao_date_promobox').readOnly = true;
	<?php endif; ?>

	function handleChange(e) {
		if(e.id == 'wao_pb_renewclockpromobox') {
			if(e.checked == true) {
				document.getElementById('wao_date_promobox').readOnly = true;
			}
			else {		
				document.getElementById('wao_date_promobox').readOnly = false;
			}
		}

	}
  </script>
  <?php
}




add_action('admin_post_update_my_settings',  'update_my_settings');
function update_my_settings(){     
  	check_admin_referer('wao_nonce');
  	if(!current_user_can('manage_network_options')) wp_die('FU');

	//tab1
  	if( isset( $_POST['wao_pb_promoboxposition'] ) )
  		update_site_option( 'wao_pb_promoboxposition', sanitize_text_field($_POST['wao_pb_promoboxposition']) );

	if( isset( $_POST['wao_pb_promoboxpositionnumber'] ) )
		update_site_option( 'wao_pb_promoboxpositionnumber', sanitize_text_field($_POST['wao_pb_promoboxpositionnumber']) );

	if( isset( $_POST['wao_pb_categorypromobox'] ) ) {
		update_site_option( 'wao_pb_categorypromobox', sanitize_text_field($_POST['wao_pb_categorypromobox']) );
	}

	//tab2
	if( isset( $_POST['wao_pb_titlepromobox_en'] ) ) {
		update_site_option( 'wao_pb_titlepromobox_en', sanitize_text_field($_POST['wao_pb_titlepromobox_en']) );
	}

	if( isset( $_POST['wao_pb_titlepromobox_es'] ) ) {
		update_site_option( 'wao_pb_titlepromobox_es', sanitize_text_field($_POST['wao_pb_titlepromobox_es']) );
	}

	if( isset( $_POST['wao_pb_titlepromobox_de'] ) ) {
		update_site_option( 'wao_pb_titlepromobox_de', sanitize_text_field($_POST['wao_pb_titlepromobox_de']) );
	}

	if( isset( $_POST['wao_pb_titlepromobox_it'] ) ) {
		update_site_option( 'wao_pb_titlepromobox_it', sanitize_text_field($_POST['wao_pb_titlepromobox_it']) );
	}
	if( isset( $_POST['wao_pb_titlepromobox_fr'] ) ) {
		update_site_option( 'wao_pb_titlepromobox_fr', sanitize_text_field($_POST['wao_pb_titlepromobox_fr']) );
	}

	if( isset( $_POST['wao_pb_descpromobox_en'] ) ) {
		update_site_option( 'wao_pb_descpromobox_en', sanitize_text_field($_POST['wao_pb_descpromobox_en']) );
	}

	if( isset( $_POST['wao_pb_descpromobox_es'] ) ) {
		update_site_option( 'wao_pb_descpromobox_es', sanitize_text_field($_POST['wao_pb_descpromobox_es']) );
	}

	if( isset( $_POST['wao_pb_descpromobox_de'] ) ) {
		update_site_option( 'wao_pb_descpromobox_de', sanitize_text_field($_POST['wao_pb_descpromobox_de']) );
	}

	if( isset( $_POST['wao_pb_descpromobox_it'] ) ) {
		update_site_option( 'wao_pb_descpromobox_it', sanitize_text_field($_POST['wao_pb_descpromobox_it']) );
	}

	if( isset( $_POST['wao_pb_descpromobox_fr'] ) ) {
		update_site_option( 'wao_pb_descpromobox_fr', sanitize_text_field($_POST['wao_pb_descpromobox_fr']) );
	}

	if( isset( $_POST['wao_pb_bgpromobox'] ) ) {
		update_site_option( 'wao_pb_bgpromobox', sanitize_text_field($_POST['wao_pb_bgpromobox']) );
	}
		

	//tab3 clock_options
	if((isset( $_POST['tab_section'] ) && $_POST['tab_section'] == 'clock_options')) {
		if( isset( $_POST['wao_pb_enableclockpromobox'] )  ) {
			update_site_option( 'wao_pb_enableclockpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_enableclockpromobox', 0 );
		}
	
		if( isset( $_POST['wao_pb_renewclockpromobox'] )  ) {
			update_site_option( 'wao_pb_renewclockpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_renewclockpromobox', 0 );
		}
		if( isset( $_POST['wao_date_promobox'] ) ) {
			update_site_option( 'wao_date_promobox', sanitize_text_field($_POST['wao_date_promobox']) );
		}
	}
	


	//tab4 style_options
	if((isset( $_POST['tab_section'] ) && $_POST['tab_section'] == 'style_options') ) {
		if( isset( $_POST['wao_pb_enableconfetipromobox'] ) ) {
			update_site_option( 'wao_pb_enableconfetipromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_enableconfetipromobox', 0 );
		}
	
		if( isset( $_POST['wao_pb_showrightpromobox'] ) ) {
			update_site_option( 'wao_pb_showrightpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_showrightpromobox', 0 );
		}
		if( isset( $_POST['wao_pb_urlrightpromobox'] ) ) {
			update_site_option( 'wao_pb_urlrightpromobox', sanitize_text_field($_POST['wao_pb_urlrightpromobox']) );
		}
	
		if( isset( $_POST['wao_pb_idrightpromobox'] ) ) {
			update_site_option( 'wao_pb_idrightpromobox', sanitize_text_field($_POST['wao_pb_idrightpromobox']) );
		}
		if( isset( $_POST['wao_pb_stylerightpromobox'] ) ) {
			update_site_option( 'wao_pb_stylerightpromobox', sanitize_text_field($_POST['wao_pb_stylerightpromobox']) );
		}
		if( isset( $_POST['wao_pb_stylemobrightpromobox'] ) ) {
			update_site_option( 'wao_pb_stylemobrightpromobox', sanitize_text_field($_POST['wao_pb_stylemobrightpromobox']) );
		}
		if( isset( $_POST['wao_pb_styleshoppromobox'] ) ) {
			update_site_option( 'wao_pb_styleshoppromobox', sanitize_text_field($_POST['wao_pb_styleshoppromobox']) );
		}
	}
	

	$redirect = '';
	if( isset( $_POST['tab_section'] ) ) {
		$redirect = '&tab='.$_POST['tab_section'];
	}	


  	wp_redirect(admin_url('network/settings.php?page=wao-promobox-settings'.$redirect));
  	exit;  
}


function get_categories_text() {
	$res = '';
	$taxonomy     = 'product_cat';
	$orderby      = 'name';  
	$show_count   = 0;      // 1 for yes, 0 for no
	$pad_counts   = 0;      // 1 for yes, 0 for no
	$hierarchical = 1;      // 1 for yes, 0 for no  
	$title        = '';  
	$empty        = 0;

	$args = array(
			'taxonomy'     => $taxonomy,
			'orderby'      => $orderby,
			'show_count'   => $show_count,
			'pad_counts'   => $pad_counts,
			'hierarchical' => $hierarchical,
			'title_li'     => $title,
			'hide_empty'   => $empty
	);
	$all_categories = get_categories( $args );
	foreach ($all_categories as $cat) {
		if($cat->category_parent == 0) {
			$category_id = $cat->term_id;       
			$res .=  $cat->slug .' <span>|</span> ';

			$args2 = array(
					'taxonomy'     => $taxonomy,
					'child_of'     => 0,
					'parent'       => $category_id,
					'orderby'      => $orderby,
					'show_count'   => $show_count,
					'pad_counts'   => $pad_counts,
					'hierarchical' => $hierarchical,
					'title_li'     => $title,
					'hide_empty'   => $empty
			);
			$sub_cats = get_categories( $args2 );
			if($sub_cats) {
				foreach($sub_cats as $sub_category) {
					$res .=  $sub_category->slug.' <span>|</span> ';
				}
			}
		}
	}
	return $res;
}


add_action('init', function() {
    $wao_pb_promoboxposition = get_site_option('wao_pb_promoboxposition');
	$wao_pb_promoboxpositionnumber = get_site_option('wao_pb_promoboxpositionnumber');
    $hook = 'woocommerce_single_product_summary';
    if($wao_pb_promoboxposition) {
        $hook = $wao_pb_promoboxposition;
    }
    $numberPosition = 20;
    if(isset($wao_pb_promoboxpositionnumber)) {
        $numberPosition = $wao_pb_promoboxpositionnumber;
    }
    add_action($hook, 'wao_promobox_func', $numberPosition);
});



function wao_promobox_func() {
	//tab1
	$wao_pb_promoboxposition = get_site_option( 'wao_pb_promoboxposition' );
	$wao_pb_promoboxpositionnumber = get_site_option( 'wao_pb_promoboxpositionnumber' );
	$wao_pb_categorypromobox = get_site_option( 'wao_pb_categorypromobox' );

	//tab2
	$wao_pb_titlepromobox_en = get_site_option( 'wao_pb_titlepromobox_en' );
	$wao_pb_titlepromobox_es = get_site_option( 'wao_pb_titlepromobox_es' );
	$wao_pb_titlepromobox_de = get_site_option( 'wao_pb_titlepromobox_de' );
	$wao_pb_titlepromobox_it = get_site_option( 'wao_pb_titlepromobox_it' );
	$wao_pb_titlepromobox_fr = get_site_option( 'wao_pb_titlepromobox_fr' );

	$wao_pb_descpromobox_en = get_site_option( 'wao_pb_descpromobox_en' );
	$wao_pb_descpromobox_es = get_site_option( 'wao_pb_descpromobox_es' );
	$wao_pb_descpromobox_de = get_site_option( 'wao_pb_descpromobox_de' );
	$wao_pb_descpromobox_it = get_site_option( 'wao_pb_descpromobox_it' );
	$wao_pb_descpromobox_fr = get_site_option( 'wao_pb_descpromobox_fr' );

	$wao_pb_bgpromobox = get_site_option( 'wao_pb_bgpromobox' );


	//tab3
	$wao_pb_enableclockpromobox = get_site_option( 'wao_pb_enableclockpromobox' );
	$wao_pb_renewclockpromobox = get_site_option( 'wao_pb_renewclockpromobox' );
	$wao_date_promobox = get_site_option( 'wao_date_promobox' );

	//tab4
	$wao_pb_enableconfetipromobox = get_site_option( 'wao_pb_enableconfetipromobox');
	$wao_pb_showrightpromobox = get_site_option( 'wao_pb_showrightpromobox');
	$wao_pb_urlrightpromobox = get_site_option( 'wao_pb_urlrightpromobox');
	$wao_pb_idrightpromobox =  get_site_option( 'wao_pb_idrightpromobox');
	$wao_pb_stylerightpromobox = get_site_option( 'wao_pb_stylerightpromobox');
	$wao_pb_stylemobrightpromobox = get_site_option( 'wao_pb_stylemobrightpromobox');
	$wao_pb_styleshoppromobox = get_site_option( 'wao_pb_styleshoppromobox');


   	$arrayCategories = explode(",", $wao_pb_categorypromobox);
 
    
    if ( has_term( $arrayCategories, 'product_cat', get_the_ID() ) ) { 
        $img_promobox = '';
        if(isset($wao_pb_bgpromobox) && $wao_pb_bgpromobox != '') {
            $img_promobox = 'background-image: url('.$wao_pb_bgpromobox.');';
        }
        else {
            $img_promobox = 'background-image: url('.$data_promobox_main['bgpromobox'].');';
        }
        $img_right_promobox = '';
        if(isset($wao_pb_urlrightpromobox)) {
            $img_right_promobox = $wao_pb_urlrightpromobox;
        }

        $dayspromobox = 'Days';
        $hourspromobox = 'Hours';
        $minutespromobox = 'Minutes';
        $secondspromobox =  'Seconds';

		$idioma = substr(get_locale(),0,2);
		$titleBox = $wao_pb_titlepromobox_en;
		$contentBox = $wao_pb_descpromobox_en;
		switch ($idioma){
			case 'de':
					$dayspromobox = 'Tage';
					$hourspromobox = 'Stunden';
					$minutespromobox = 'Minuten';
					$secondspromobox =  'Sekunden';
					$titleBox = $wao_pb_titlepromobox_de;
					$contentBox = $wao_pb_descpromobox_de;
				break;
			case 'es':
					$dayspromobox = 'Dias';
					$hourspromobox = 'Horas';
					$minutespromobox = 'Minutos';
					$secondspromobox =  'Segundos';
					$titleBox = $wao_pb_titlepromobox_es;
					$contentBox = $wao_pb_descpromobox_es;
				break;
			case 'fr':
					$dayspromobox = 'Jours';
					$hourspromobox = 'Heures';
					$minutespromobox = 'Minutes';
					$secondspromobox =  'Secondes';
					$titleBox = $wao_pb_titlepromobox_it;
					$contentBox = $wao_pb_descpromobox_it;
				break;
			case 'it':
					$dayspromobox = 'Giorni';
					$hourspromobox = 'Ore';
					$minutespromobox = 'Minuti';
					$secondspromobox =  'Secondi';
					$titleBox = $wao_pb_titlepromobox_it;
					$contentBox = $wao_pb_descpromobox_it;
				break;
			default:
				$titleBox = $wao_pb_titlepromobox_en;
				$contentBox = $wao_pb_descpromobox_en;
		}

        ?>
        <style>
            .container-card {
                max-width: 600px;
                padding: 30px 20px 25px;
                border-radius: 10px;
                color: white;
                background-position: center;
                background-size: 140% auto;
                text-align: center;
                margin-bottom: 10px;
                margin-right: auto;
                margin-left: auto;
            }
            .container-card h2 {
                margin: 0;
                color: white;
                text-transform: uppercase;
                font-size: 21px !important;
                font-weight: bold !important;
                margin-bottom: 10px;
                line-height: 1;
            }
            .container-card p {
                margin: 0;
            }
            .container-card .clok {
                display: flex;
                gap: 18px;
                justify-content: center;
                /* border: 1px dashed #fff; */
                padding: 5px 10px;
            }
            .container-card .clok--item {
                display: flex;
                flex-direction: column;
                justify-content: center;
                text-align: center;
            }
            .container-card .clok--item :nth-child(1) {
                font-size: 3.2em;
                font-weight: bold;
                line-height: 1;
            }
            .container-card .content {
                display: flex;
                padding: 10px 0 15px;
                justify-content: center;
            }
            .container-card .picture {
                display: flex;
                flex-direction: column-reverse;
            }
            .container-card img {
                width: 100%;
                bottom: 10px;
            }
            @media (max-width: 992px) {
                .container-card .clok--item :nth-child(1) {
                    font-size: 2em;
                
                }
                .container-card {
                    background-size: auto 140%;
                }
            }
            

            <?php if($wao_pb_showrightpromobox != '' && $wao_pb_showrightpromobox == 1): ?>
                <?=$wao_pb_idrightpromobox?> {
                    position: relative;
                }
                <?=$wao_pb_idrightpromobox?>:before {
                    content: '';
                    background-image: url(<?=$wao_pb_urlrightpromobox?>);
                    position: absolute;
                    background-size: contain;
                    background-repeat: no-repeat;
                    top: 20px;
                    right: -80px;
                    width: 144px;
                    height: 70px;
                    transform: rotate(38deg);
                    <?=$wao_pb_stylerightpromobox?>
                }
                @media (max-width: 1200px) {
                    <?=$wao_pb_idrightpromobox?>:before {
                        <?=$wao_pb_stylemobrightpromobox?>
                    }
                }
                @media (max-width: 992px) {
                    <?=$wao_pb_idrightpromobox?>:before {
                        content:none;
                    }
                }
            <?php endif; ?>

        
        </style>
        <div class="container-card" style="<?=$img_promobox?>">
            <?php if($titleBox): ?>
                <h2><?php echo $titleBox?></h2>
            <?php endif; ?>

            <?php if($wao_pb_enableclockpromobox != '' && $wao_pb_enableclockpromobox == 1): ?>
                <div class="content">
                    <div class="clok">
                        <div class="clok--item">
                            <span id="days"></span>
                            <span>
                                <?=$dayspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="hours"></span>
                            <span>
                                <?=$hourspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="minutes"></span>
                            <span>
                                <?=$minutespromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="seconds"></span>
                            <span>
                                <?=$secondspromobox?>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($contentBox): ?>
                <p><?=$contentBox?></p>
            <?php endif; ?>
        </div>
            <?php if($wao_pb_enableconfetipromobox != '' && $wao_pb_enableconfetipromobox == 1): ?>
                <canvas id="confetti" style="height: 0;"></canvas>
                <script src="https://cdn.jsdelivr.net/npm/js-confetti@latest/dist/js-confetti.browser.js"></script>
                <script>
                    const button = document.querySelector('#button');
                    const canvas = document.querySelector('#confetti');

                    const jsConfetti = new JSConfetti();
                    window.onload = function(e){ 
                        jsConfetti.addConfetti()
                    }
                </script>
            <?php endif; ?>

            <?php 
                if($wao_date_promobox): ?>
                <script>
                    document.addEventListener('DOMContentLoaded', () => {
                        var today = new Date();
                        var dd = String(today.getDate()).padStart(2, '0');
                        var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
                        var yyyy = today.getFullYear();
                        today = mm + '/' + dd + '/' + yyyy + ' 11:59 PM';
                     

                        <?php if($wao_pb_renewclockpromobox != '' && $wao_pb_renewclockpromobox == 1): ?>
                            const DATE_TARGET = new Date(today); // 11/29/2024 0:01 AM
                        <?php else : ?>
                            const DATE_TARGET = new Date('<?=$wao_date_promobox?>'); // 11/29/2024 0:01 AM
                        <?php endif; ?>


                        const SPAN_DAYS = document.querySelector('span#days');
                        const SPAN_HOURS = document.querySelector('span#hours');
                        const SPAN_MINUTES = document.querySelector('span#minutes');
                        const SPAN_SECONDS = document.querySelector('span#seconds');
                        // Milliseconds for the calculations
                        const MILLISECONDS_OF_A_SECOND = 1000;
                        const MILLISECONDS_OF_A_MINUTE = MILLISECONDS_OF_A_SECOND * 60;
                        const MILLISECONDS_OF_A_HOUR = MILLISECONDS_OF_A_MINUTE * 60;
                        const MILLISECONDS_OF_A_DAY = MILLISECONDS_OF_A_HOUR * 24

                            
                        function updateCountdown() {
                            const NOW = new Date()
                            const DURATION = DATE_TARGET - NOW;
                            const REMAINING_DAYS = Math.floor(DURATION / MILLISECONDS_OF_A_DAY);
                            const REMAINING_HOURS = Math.floor((DURATION % MILLISECONDS_OF_A_DAY) / MILLISECONDS_OF_A_HOUR);
                            const REMAINING_MINUTES = Math.floor((DURATION % MILLISECONDS_OF_A_HOUR) / MILLISECONDS_OF_A_MINUTE);
                            const REMAINING_SECONDS = Math.floor((DURATION % MILLISECONDS_OF_A_MINUTE) / MILLISECONDS_OF_A_SECOND);
                            
                            SPAN_DAYS.textContent = REMAINING_DAYS;
                            SPAN_HOURS.textContent = REMAINING_HOURS;
                            SPAN_MINUTES.textContent = REMAINING_MINUTES;
                            SPAN_SECONDS.textContent = REMAINING_SECONDS;

                            if (DURATION > 0) {
                                SPAN_DAYS.textContent = REMAINING_DAYS;
                                SPAN_HOURS.textContent = REMAINING_HOURS;
                                SPAN_MINUTES.textContent = REMAINING_MINUTES;
                                SPAN_SECONDS.textContent = REMAINING_SECONDS;
                            } else{
                                SPAN_DAYS.textContent = 0;
                                SPAN_HOURS.textContent = 0;
                                SPAN_MINUTES.textContent = 0;
                                SPAN_SECONDS.textContent = 0;
                            }
                        }
                    
                        updateCountdown();
                        setInterval(updateCountdown, MILLISECONDS_OF_A_SECOND);
                    });
                </script>

            <?php endif; ?>
    <?php
    } //end check category
}

add_Action('wp_head','wao_promobox_css_new');
function wao_promobox_css_new() {

	$wao_pb_categorypromobox = get_site_option( 'wao_pb_categorypromobox' );

	//tab4
	//$wao_pb_enableconfetipromobox = get_site_option( 'wao_pb_enableconfetipromobox');
	$wao_pb_showrightpromobox = get_site_option( 'wao_pb_showrightpromobox');
	$wao_pb_urlrightpromobox = get_site_option( 'wao_pb_urlrightpromobox');
	$wao_pb_idrightpromobox =  get_site_option( 'wao_pb_idrightpromobox');
	$wao_pb_stylerightpromobox = get_site_option( 'wao_pb_stylerightpromobox');
	$wao_pb_stylemobrightpromobox = get_site_option( 'wao_pb_stylemobrightpromobox');
	$wao_pb_styleshoppromobox = get_site_option( 'wao_pb_styleshoppromobox');


    //$data_promobox = get_option( 'wao_promobox_options' );

    $arrayCategories = explode(",", $wao_pb_categorypromobox);
    $classPromoList = "";
    $classPromoListID = "";
    $classPromoListIDhome = "";
    $classPromoListIDhome2 = "";
    foreach($arrayCategories as $classAux) {
        $category = get_term_by( 'slug', '2024', 'product_cat' );
        $cat_id = $category->term_id;

        $classPromoList .= '.products .product.product_cat-'.$classAux.':before,';
        $classPromoListID .= '.products .product.product_cat-'.$cat_id.':before,';
        $classPromoListIDhome .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-".$classAux.".shoppingcart-grid-product:before,";
        $classPromoListIDhome2 .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-".$cat_id.".shoppingcart-grid-product:before,";
    }
    $classPromoList = substr($classPromoList, 0, -1);
    $classPromoListID = substr($classPromoListID, 0, -1);
    $classPromoListIDhome = substr($classPromoListIDhome, 0, -1);
    $classPromoListIDhome2 = substr($classPromoListIDhome2, 0, -1);
    ?>
        <style id="test123456">
            <?php if($wao_pb_showrightpromobox != '' && $wao_pb_showrightpromobox == 1): ?>
                    .products .product, 
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product {
                        position: relative;
                    }
                    <?=$classPromoList?>,
                    <?=$classPromoListID?>, 
                    <?=$classPromoListIDhome?>,
                    <?=$classPromoListIDhome2?> {
                        content: '';
                        background-image: url(<?=$wao_pb_urlrightpromobox?>);
                        position: absolute;
                        background-size: contain;
                        background-repeat: no-repeat;
                        top: 0;
                        right: -15px;
                        width: 71px;
                        height: 70px;
                        transform: rotate(20deg);
                        z-index: 22; 
                        <?php if(isset($wao_pb_styleshoppromobox) and $wao_pb_styleshoppromobox !='') : ?>
                            <?=$wao_pb_styleshoppromobox?>
                        <?php endif; ?>
                    }
                    
                    .woocommerce .products .product a {
                        text-decoration: none;
                        overflow: hidden !important;
                        position: relative;
                    }
                    .woocommerce .products .product, .woocommerce-page .products .product {
                        overflow: visible !important;
                    }
                    .product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product .onsale,
                    .archive.woocommerce .products .product .onsale {
                        display: none !important;
                    }
            <?php endif; ?>
        </style>
    <?php
}
