<?php
/* 
Plugin Name: WAO Promo box NEW
Plugin URI: https://rusdev.com/ 
Description: Plugin to insert into single products promo discount with a promo. 
Version: 1.4
Author: Rusland Rojas
Author URI: https://rusdev.com/ 
Requires at least: 5.0
Tested up to: 6.8.2
Requires PHP: 7.1
License: GPLv2 or later 
Text Domain: promobox
*/


if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/** 
* Define constants 
*/

define( 'WAO_PROMOBOX_PLUGIN__VERSION', '1.4' );
include('waolm-update.php');



add_action( 'admin_enqueue_scripts', 'mw_enqueue_color_picker' );
function mw_enqueue_color_picker( $hook_suffix ) {
    // Cargar solo en la página del plugin si lo deseas:
    if ( isset($_GET['page']) && $_GET['page'] === 'wao-promobox-settings' ) {
        // Estilos y scripts necesarios
        wp_enqueue_style( 'wp-color-picker' );

        // Tu archivo JS personalizado (para usar color picker, etc.)
        wp_enqueue_script(
            'my-script-handle',
            plugins_url( 'script.js', __FILE__ ),
            array( 'wp-color-picker' ),
            false,
            true
        );

        // Tu archivo CSS con estilos del admin
        wp_enqueue_style(
            'wao-promobox-admin-style',
            plugins_url( 'wao-promobox-admin.css', __FILE__ ),
            array(),
            '1.0.0'
        );
    }
}



add_action('network_admin_menu', 'add_my_netw_settings_page');
function add_my_netw_settings_page() {
  add_submenu_page(
       'settings.php',
       'Promo Box',
       'Promo Box',
       'manage_network_options',
       'wao-promobox-settings',
       'wao_form_promobox'
  );    
}

function wao_form_promobox(){
  	?>

	<h1 id="wao_pb_edit-site">Promo Box Settings</h1>
                
	<?php settings_errors(); ?>
	
	<?php
	if ( isset( $_GET['tab'] ) ) {
		$active_tab = $_GET['tab'];
	} 
	else {
		$active_tab = 'woocommerce_options';
	}
	?>
  	



  	<h2 class="nav-tab-wrapper">
		<a href="?page=<?php echo $_GET['page']; ?>&tab=woocommerce_options" class="nav-tab <?php echo $active_tab == 'woocommerce_options' ? 'nav-tab-active' : ''; ?>">Woocommerce Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=text_options" class="nav-tab <?php echo $active_tab == 'text_options' ? 'nav-tab-active' : ''; ?>">Box Content and Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=clock_options" class="nav-tab <?php echo $active_tab == 'clock_options' ? 'nav-tab-active' : ''; ?>">Clock Options</a>
		<a href="?page=<?php echo $_GET['page']; ?>&tab=style_options" class="nav-tab <?php echo $active_tab == 'style_options' ? 'nav-tab-active' : ''; ?>">Style Options</a>
  	</h2>
  	<form action="<?php echo admin_url('admin-post.php?action=update_my_settings'); ?>" method="post" class="form-table">
    	<?php wp_nonce_field('wao_nonce'); ?>

		<?php if ( $active_tab == 'woocommerce_options' ) : ?>
			<input type="hidden" name="tab_section" value="woocommerce_options">
			<?php 
				$wao_pb_promoboxposition = get_site_option( 'wao_pb_promoboxposition' );
				$wao_pb_promoboxpositionnumber = get_site_option( 'wao_pb_promoboxpositionnumber' );
				$wao_pb_categorypromobox = get_site_option( 'wao_pb_categorypromobox' );
			?>
			<table class="form-table">
				<tr>
					<th scope="row"><h2>Position Woocommerce</h2></th>
					<td>
					<select id="wao_pb_promoboxposition" name="wao_pb_promoboxposition" >
							<option value="woocommerce_single_product_summary" <?php if($wao_pb_promoboxposition == 'woocommerce_single_product_summary') echo 'selected'; ?>>woocommerce_single_product_summary</option>
							<option value="woocommerce_after_add_to_cart_form" <?php if($wao_pb_promoboxposition == 'woocommerce_after_add_to_cart_form') echo 'selected'; ?>>woocommerce_after_add_to_cart_form</option>
					</select>
					</td>
				</tr>
				<tr>
					<th scope="row"><h2>Position Number hook</h2></th>
					<td>		
						<input type="text" id="wao_pb_promoboxpositionnumber" name="wao_pb_promoboxpositionnumber" value="<?php echo $wao_pb_promoboxpositionnumber ; ?>" >
						<p class="description">Recommeded 20</p>
					</td>
				</tr>
				<tr>
					<th scope="row"><h2>Category Product</h2></th>
					<td>
					<input type="text" id="wao_pb_categorypromobox" name="wao_pb_categorypromobox" value="<?php echo $wao_pb_categorypromobox ; ?>" class="">
						<p class="categorypromobox" style="margin-bottom: 10px;"><b>Categorias:</b> <?php echo get_categories_text();?></p>	
					</td>
				</tr>
			</table>
			
		<?php elseif ( $active_tab == 'text_options' ) : ?>
			<input type="hidden" name="tab_section" value="text_options">
			
			<?php
				$languages = ['en', 'es', 'de', 'it', 'fr', 'nl', 'fi', 'da', 'nb', 'sv'];
				$fields = ['titlepromobox', 'descpromobox'];

				// Cargar dinámicamente los valores de título y descripción para cada idioma
				foreach ( $languages as $lang ) {
					foreach ( $fields as $field ) {
						$key = "wao_pb_{$field}_{$lang}";
						$$key = get_site_option( $key );
					}
				}

// Background (campo único)
$wao_pb_bgpromobox = get_site_option( 'wao_pb_bgpromobox' );
			?>
 <?php
		$languages = [
	'en' => 'English',
	'es' => 'Spanish',
	'de' => 'German',
	'it' => 'Italian',
	'fr' => 'French',
	'fi' => 'Finland',
	'nb' => 'Noruega',
	'sv' => 'Suecia',
	'da' => 'Dinamarca',
	'nl' => 'Dutch' // mejor "Dutch" en vez de "Neetherland"
	];
 ?>

<table class="form-table form">
	<tr>
		<th>Idioma</th>
		<th>Título</th>
		<th>Descripción</th>
	</tr>

	<?php foreach ( $languages as $code => $label ) : 
		$title_key = "wao_pb_titlepromobox_$code";
		$desc_key  = "wao_pb_descpromobox_$code";
		$title_val = esc_attr( $$title_key ?? '' );
		$desc_val  = esc_attr( $$desc_key ?? '' );
	?>
	<tr>
		<td><strong><?php echo esc_html($label); ?></strong></td>
		<td><input type="text" id="<?php echo esc_attr($title_key); ?>" name="<?php echo esc_attr($title_key); ?>" value="<?php echo $title_val; ?>" /></td>
		<td><input type="text" id="<?php echo esc_attr($desc_key); ?>" name="<?php echo esc_attr($desc_key); ?>" value="<?php echo $desc_val; ?>" /></td>
	</tr>
	<?php endforeach; ?>

	<tr>
		<th colspan="3"><h2>Background Image (URL):</h2></th>
	</tr>
	<tr>
		<td colspan="3">
			<input type="text" id="wao_pb_bgpromobox" name="wao_pb_bgpromobox" value="<?php echo esc_attr($wao_pb_bgpromobox); ?>" style="width:100%;" />
		</td>
	</tr>
</table>



		<?php elseif ( $active_tab == 'clock_options' ) : ?>
			<input type="hidden" name="tab_section" value="clock_options">
			<?php 
				$wao_pb_enableclockpromobox = get_site_option( 'wao_pb_enableclockpromobox' );
				$wao_pb_renewclockpromobox = get_site_option( 'wao_pb_renewclockpromobox' );
				$wao_date_promobox = get_site_option( 'wao_date_promobox' );
			?>
			<table class="form-table auto">
				<tr>
					<th><h2>Enable clock:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_enableclockpromobox != '' && $wao_pb_enableclockpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_enableclockpromobox" name="wao_pb_enableclockpromobox"  value="1" <?php echo $is_checked?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>
				<tr>
					<th><h2>Renew clock by day:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_renewclockpromobox != '' && $wao_pb_renewclockpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_renewclockpromobox" name="wao_pb_renewclockpromobox"  value="1" onChange="handleChange(this)" <?php echo $is_checked?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>

				<tr>
					<th colspan=""><h2>Date:</h2></th>
					<td colspan=""><input type="text" id="wao_date_promobox" name="wao_date_promobox" value="<?php echo $wao_date_promobox; ?>" class="">
					<p class="description">Example: MM/DD/YYYY 0:01 AM</p></td>
				</tr>
			</table>

		<?php elseif ( $active_tab == 'style_options' ) : ?>
			<input type="hidden" name="tab_section" value="style_options">
			<?php 
				$wao_pb_enableconfetipromobox = get_site_option( 'wao_pb_enableconfetipromobox');
				$wao_pb_showrightpromobox = get_site_option( 'wao_pb_showrightpromobox');
				$wao_pb_urlrightpromobox = get_site_option( 'wao_pb_urlrightpromobox');
				$wao_pb_idrightpromobox =  get_site_option( 'wao_pb_idrightpromobox');
				$wao_pb_title_color =  get_site_option( 'wao_pb_title_color');
				$wao_pb_content_color =  get_site_option( 'wao_pb_content_color');
				$wao_pb_stylerightpromobox = get_site_option( 'wao_pb_stylerightpromobox');
				$wao_pb_stylemobrightpromobox = get_site_option( 'wao_pb_stylemobrightpromobox');
				$wao_pb_styleshoppromobox = get_site_option( 'wao_pb_styleshoppromobox');
			?>
			<table class="form-table auto">
				<tr>
					<th><h2>Enable Confeti:</h2></th> 
					<td>
						<?php $is_checked = (  $wao_pb_enableconfetipromobox != '' && $wao_pb_enableconfetipromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_enableconfetipromobox" name="wao_pb_enableconfetipromobox" value="1" <?php echo $is_checked?> >
							<span class="slider round"></span>
						</label>
					</td>
				</tr>
				<tr>
				<th><h2>Image right show in product?</h2></th> 
					<td>
						<?php $is_checked_2 = ( $wao_pb_showrightpromobox != '' && $wao_pb_showrightpromobox == 1 ) ? 'checked': ''; ?>
						<label class="switch">
							<input type="checkbox" id="wao_pb_showrightpromobox" name="wao_pb_showrightpromobox"  value="1" <?php echo $is_checked_2?>>
							<span class="slider round"></span>
						</label>
					</td>
				</tr>

				<tr>
					<th><h2>Image right URL in product</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_urlrightpromobox" name="wao_pb_urlrightpromobox" value="<?php echo $wao_pb_urlrightpromobox; ?>" class=""></td>
				</tr>

				<tr>
					<th><h2>Class o ID to aply the image right	</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_idrightpromobox" name="wao_pb_idrightpromobox" value="<?php echo $wao_pb_idrightpromobox; ?>" class=""></td>
				</tr>
				
				<tr>
					<th><h2>Title Color</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_title_color" name="wao_pb_title_color" value="<?php echo $wao_pb_title_color; ?>"  class="my-color-field" data-default-color="#effeff" ></td>
				</tr>
				<tr>
					<th><h2>Content Color</h2></th>
					<td colspan="3"><input type="text" id="wao_pb_content_color" name="wao_pb_content_color" value="<?php echo $wao_pb_content_color; ?>"  class="my-color-field" data-default-color="#effeff" ></td>
				</tr>
				
				<tr>
					<th><h2>Background Size of Box:</h2></th>
					<td colspan="3">
					
					<?php $wao_pb_bg_size_box = get_site_option('wao_pb_bg_size_box', 'auto'); //// Obtener valor desde la base de datos o usar 'auto' como predeterminado ?>
						<select name="wao_pb_bg_size_box" id="wao_pb_bg_size_box">
							<option value="auto" <?php if($wao_pb_bg_size_box == 'auto') echo 'selected';?>>Auto</option>
							<option value="contain" <?php if($wao_pb_bg_size_box == 'contain') echo 'selected';?>>Contain</option>
							<option value="cover" <?php if($wao_pb_bg_size_box == 'cover') echo 'selected';?>>Cover</option>
						</select>
					</td>
				</tr>

				<tr>
					<th colspan=""><h2>Styles for image right product:</h2></th>
					<td colspan=""><textarea id="wao_pb_stylerightpromobox" name="wao_pb_stylerightpromobox"><?php echo $wao_pb_stylerightpromobox; ?></textarea></td>
				</tr>
				<tr>
					<th colspan=""><h2>Styles for image right product(mobile):</h2></th>
					<td colspan=""><textarea id="wao_pb_stylemobrightpromobox" name="wao_pb_stylemobrightpromobox"><?php echo $wao_pb_stylemobrightpromobox; ?></textarea></td>
				</tr>
				<tr>
					<th colspan=""><h2>Styles for image right product in shop:</h2></th>
					<td colspan=""><textarea id="wao_pb_styleshoppromobox" name="wao_pb_styleshoppromobox"><?php echo $wao_pb_styleshoppromobox; ?></textarea></td>
				</tr>
			</table>

		<?php endif; ?>
					
      	<p class="submit">
          	<button type="submit" name="wao_pb_add_ip_restriction" class="button button-primary">Save</button>
      	</p>
  </form>
  
  
  
  
	<?php $wao_pb_renewclockpromobox = get_site_option('wao_pb_renewclockpromobox'); ?>
	<script>
			<?php if ( !empty($wao_pb_renewclockpromobox) && $wao_pb_renewclockpromobox == 1 ) : ?>
				document.getElementById('wao_date_promobox').readOnly = true;
			<?php endif; ?>
		
			function handleChange(e) {
				if (e.id === 'wao_pb_renewclockpromobox') {
					document.getElementById('wao_date_promobox').readOnly = e.checked;
				}
			}
	</script>
  <?php
}




add_action('admin_post_update_my_settings',  'update_my_settings');
function update_my_settings(){     
  	check_admin_referer('wao_nonce');
  	if(!current_user_can('manage_network_options')) wp_die('FU');

	//tab1
  	if( isset( $_POST['wao_pb_promoboxposition'] ) )
  		update_site_option( 'wao_pb_promoboxposition', sanitize_text_field($_POST['wao_pb_promoboxposition']) );

	if( isset( $_POST['wao_pb_promoboxpositionnumber'] ) )
		update_site_option( 'wao_pb_promoboxpositionnumber', sanitize_text_field($_POST['wao_pb_promoboxpositionnumber']) );

	if( isset( $_POST['wao_pb_categorypromobox'] ) ) {
		update_site_option( 'wao_pb_categorypromobox', sanitize_text_field($_POST['wao_pb_categorypromobox']) );
	}

	//tab2 salva todo el contenido de los textos
	$languages = ['en', 'es', 'de', 'it', 'fr', 'nl', 'fi', 'da', 'nb', 'sv'];
	$fields = ['titlepromobox', 'descpromobox'];

	foreach ( $languages as $lang ) {
		foreach ( $fields as $field ) {
			$key = "wao_pb_{$field}_{$lang}";
			if ( isset( $_POST[$key] ) ) {
				update_site_option( $key, sanitize_text_field( $_POST[$key] ) );
			}
		}
	}

	// Background field (único)
	if ( isset( $_POST['wao_pb_bgpromobox'] ) ) {
		update_site_option( 'wao_pb_bgpromobox', sanitize_text_field( $_POST['wao_pb_bgpromobox'] ) );
	}

		

	//tab3 clock_options
	if((isset( $_POST['tab_section'] ) && $_POST['tab_section'] == 'clock_options')) {
		if( isset( $_POST['wao_pb_enableclockpromobox'] )  ) {
			update_site_option( 'wao_pb_enableclockpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_enableclockpromobox', 0 );
		}
	
		if( isset( $_POST['wao_pb_renewclockpromobox'] )  ) {
			update_site_option( 'wao_pb_renewclockpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_renewclockpromobox', 0 );
		}
		if( isset( $_POST['wao_date_promobox'] ) ) {
			update_site_option( 'wao_date_promobox', sanitize_text_field($_POST['wao_date_promobox']) );
		}
	}
	


	//tab4 style_options
	if((isset( $_POST['tab_section'] ) && $_POST['tab_section'] == 'style_options') ) {
		if( isset( $_POST['wao_pb_enableconfetipromobox'] ) ) {
			update_site_option( 'wao_pb_enableconfetipromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_enableconfetipromobox', 0 );
		}
	
		if( isset( $_POST['wao_pb_showrightpromobox'] ) ) {
			update_site_option( 'wao_pb_showrightpromobox', 1 );
		}
		else {
			update_site_option( 'wao_pb_showrightpromobox', 0 );
		}
		if( isset( $_POST['wao_pb_urlrightpromobox'] ) ) {
			update_site_option( 'wao_pb_urlrightpromobox', sanitize_text_field($_POST['wao_pb_urlrightpromobox']) );
		}
		if( isset( $_POST['wao_pb_title_color'] ) ) {
			update_site_option( 'wao_pb_title_color', sanitize_text_field($_POST['wao_pb_title_color']) );
		}
		if( isset( $_POST['wao_pb_content_color'] ) ) {
			update_site_option( 'wao_pb_content_color', sanitize_text_field($_POST['wao_pb_content_color']) );
		}
		if( isset( $_POST['wao_pb_bg_size_box'] ) ) {
			update_site_option( 'wao_pb_bg_size_box', sanitize_text_field($_POST['wao_pb_bg_size_box']) );
		}

		if( isset( $_POST['wao_pb_idrightpromobox'] ) ) {
			update_site_option( 'wao_pb_idrightpromobox', sanitize_text_field($_POST['wao_pb_idrightpromobox']) );
		}
		if( isset( $_POST['wao_pb_stylerightpromobox'] ) ) {
			update_site_option( 'wao_pb_stylerightpromobox', sanitize_text_field($_POST['wao_pb_stylerightpromobox']) );
		}
		
		if( isset( $_POST['wao_pb_stylemobrightpromobox'] ) ) {
			update_site_option( 'wao_pb_stylemobrightpromobox', sanitize_text_field($_POST['wao_pb_stylemobrightpromobox']) );
		}
		if( isset( $_POST['wao_pb_styleshoppromobox'] ) ) {
			update_site_option( 'wao_pb_styleshoppromobox', sanitize_text_field($_POST['wao_pb_styleshoppromobox']) );
		}
	}
	

	$redirect = '';
	if( isset( $_POST['tab_section'] ) ) {
		$redirect = '&tab='.$_POST['tab_section'];
	}	


  	wp_redirect(admin_url('network/settings.php?page=wao-promobox-settings'.$redirect));
  	exit;  
}

function get_categories_text() {
	$taxonomy     = 'product_cat';
	$args = array(
		'taxonomy'     => $taxonomy,
		'orderby'      => 'name',
		'hide_empty'   => 0,
		'hierarchical' => 1,
	);

	$all_categories = get_categories( $args );
	$slugs = [];

	foreach ( $all_categories as $cat ) {
		$slugs[] = $cat->slug;
	}

	return implode(', ', $slugs);
}



add_action('init', function() {
    $wao_pb_promoboxposition = get_site_option('wao_pb_promoboxposition');
	$wao_pb_promoboxpositionnumber = get_site_option('wao_pb_promoboxpositionnumber');
    $hook = 'woocommerce_single_product_summary';
    if($wao_pb_promoboxposition) {
        $hook = $wao_pb_promoboxposition;
    }
    $numberPosition = 20;
    if(isset($wao_pb_promoboxpositionnumber)) {
        $numberPosition = $wao_pb_promoboxpositionnumber;
    }
    add_action($hook, 'wao_promobox_func', $numberPosition);
});



function wao_promobox_func() {
	//tab1
	$wao_pb_promoboxposition = get_site_option( 'wao_pb_promoboxposition' );
	$wao_pb_promoboxpositionnumber = get_site_option( 'wao_pb_promoboxpositionnumber' );
	$wao_pb_categorypromobox = get_site_option( 'wao_pb_categorypromobox' );

	//tab2
	$languages = ['en', 'es', 'de', 'it', 'fr', 'nl', 'fi', 'da', 'nb', 'sv'];
	$fields = ['titlepromobox', 'descpromobox'];
	foreach ( $languages as $lang ) {
		foreach ( $fields as $field ) {
			$key = "wao_pb_{$field}_{$lang}";
			$$key = get_site_option( $key );
		}
	}
	$wao_pb_bgpromobox = get_site_option( 'wao_pb_bgpromobox' );


	//tab3
	$wao_pb_enableclockpromobox = get_site_option( 'wao_pb_enableclockpromobox' );
	$wao_pb_renewclockpromobox = get_site_option( 'wao_pb_renewclockpromobox' );
	$wao_date_promobox = get_site_option( 'wao_date_promobox' );

	//tab4
	$wao_pb_enableconfetipromobox = get_site_option( 'wao_pb_enableconfetipromobox');
	$wao_pb_showrightpromobox = get_site_option( 'wao_pb_showrightpromobox');
	$wao_pb_urlrightpromobox = get_site_option( 'wao_pb_urlrightpromobox');
	$wao_pb_idrightpromobox =  get_site_option( 'wao_pb_idrightpromobox');
	$wao_pb_title_color =  get_site_option( 'wao_pb_title_color');
	$wao_pb_content_color =  get_site_option( 'wao_pb_content_color');
	$wao_pb_stylerightpromobox = get_site_option( 'wao_pb_stylerightpromobox');
	$wao_pb_bg_size_box = get_site_option( 'wao_pb_bg_size_box');
	$wao_pb_stylemobrightpromobox = get_site_option( 'wao_pb_stylemobrightpromobox');
	$wao_pb_styleshoppromobox = get_site_option( 'wao_pb_styleshoppromobox');


   	$arrayCategories = explode(",", $wao_pb_categorypromobox);
 
    
    if ( has_term( $arrayCategories, 'product_cat', get_the_ID() ) ) { 
        $img_promobox = '';
        if(isset($wao_pb_bgpromobox) && $wao_pb_bgpromobox != '') {
            $img_promobox = 'background-image: url('.$wao_pb_bgpromobox.');';
        }
        else {
            $img_promobox = 'background-image: url('.$data_promobox_main['bgpromobox'].');';
        }
        $img_right_promobox = '';
        if(isset($wao_pb_urlrightpromobox)) {
            $img_right_promobox = $wao_pb_urlrightpromobox;
        }

        $dayspromobox = 'Days';
        $hourspromobox = 'Hours';
        $minutespromobox = 'Minutes';
        $secondspromobox =  'Seconds';

		$idioma = substr(get_locale(),0,2);
		$titleBox = $wao_pb_titlepromobox_en;
		$contentBox = $wao_pb_descpromobox_en;
		$idioma = substr(get_locale(), 0, 2);

// Mapeo de traducciones y variables
$traducciones = [
    'de' => [
        'days' => 'Tage', 'hours' => 'Stunden', 'minutes' => 'Minuten', 'seconds' => 'Sekunden',
        'title' => $wao_pb_titlepromobox_de,
        'desc'  => $wao_pb_descpromobox_de
    ],
    'es' => [
        'days' => 'Días', 'hours' => 'Horas', 'minutes' => 'Minutos', 'seconds' => 'Segundos',
        'title' => $wao_pb_titlepromobox_es,
        'desc'  => $wao_pb_descpromobox_es
    ],
    'fr' => [
        'days' => 'Jours', 'hours' => 'Heures', 'minutes' => 'Minutes', 'seconds' => 'Secondes',
        'title' => $wao_pb_titlepromobox_fr,
        'desc'  => $wao_pb_descpromobox_fr
    ],
    'nl' => [
        'days' => 'Dagen', 'hours' => 'Uren', 'minutes' => 'Minuten', 'seconds' => 'Seconden',
        'title' => $wao_pb_titlepromobox_nl,
        'desc'  => $wao_pb_descpromobox_nl
    ],
    'it' => [
        'days' => 'Giorni', 'hours' => 'Ore', 'minutes' => 'Minuti', 'seconds' => 'Secondi',
        'title' => $wao_pb_titlepromobox_it,
        'desc'  => $wao_pb_descpromobox_it
    ],
    'en' => [
        'days' => 'Days', 'hours' => 'Hours', 'minutes' => 'Minutes', 'seconds' => 'Seconds',
        'title' => $wao_pb_titlepromobox_en,
        'desc'  => $wao_pb_descpromobox_en
    ],
	'da' => [
        'days' => 'Dage' , 'hours' => 'Timer', 'minutes' => 'Minutter', 'seconds' => 'Sekunder',
        'title' => $wao_pb_titlepromobox_da,
        'desc'  => $wao_pb_descpromobox_da
    ],
	'nb' => [
        'days' => 'Dager', 'hours' => 'Timer', 'minutes' => 'Minutter', 'seconds' => 'Sekunder',
        'title' => $wao_pb_titlepromobox_nb,
        'desc'  => $wao_pb_descpromobox_nb
    ],
	'sv' => [
        'days' => 'Dagar', 'hours' => 'Timmar', 'minutes' => 'Minuter', 'seconds' => 'Sekunder',
        'title' => $wao_pb_titlepromobox_sv,
        'desc'  => $wao_pb_descpromobox_sv
    ],
	'fi' => [
        'days' => 'Päivät', 'hours' => 'Tunnit', 'minutes' => 'Minuutit', 'seconds' => 'Sekunnit',
        'title' => $wao_pb_titlepromobox_fi,
        'desc'  => $wao_pb_descpromobox_fi
    ]
];

// Usar inglés como fallback si no existe el idioma
	$data = $traducciones[$idioma] ?? $traducciones['en'];

// Asignación final
	$dayspromobox    = $data['days'];
	$hourspromobox   = $data['hours'];
	$minutespromobox = $data['minutes'];
	$secondspromobox = $data['seconds'];
	$titleBox        = $data['title'];
	$contentBox      = $data['desc'];


        ?>
        <style>
            .container-card {
				margin-top: 12px;
                max-width: 600px;
                padding: 5px 5px 5px;
                border-radius: 10px;
                color: white;
                background-position: center;
                background-size: 140% auto;
                text-align: center;
                margin-bottom: 10px;
                margin-right: auto;
                margin-left: auto;
				color: <?php echo $wao_pb_content_color; ?>;
				background-size: <?php echo $wao_pb_bg_size_box; ?>;
            }
            .container-card h2 {
                margin: 0;
                color: white;
                text-transform: uppercase;
                font-size: 21px !important;
                font-weight: bold !important;
                margin-bottom: 10px;
                line-height: 1;
				color: <?php echo $wao_pb_title_color; ?>
            }
            .container-card p {
                margin: 0;
            }
            .container-card .clok {
                display: flex;
                gap: 18px;
                justify-content: center;
                /* border: 1px dashed #fff; */
                padding: 5px 5px;
            }
            .container-card .clok--item {
                display: flex;
                flex-direction: column;
                justify-content: center;
                text-align: center;
            }
            .container-card .clok--item :nth-child(1) {
                font-size: 3.2em;
                font-weight: bold;
                line-height: 1;
            }
            .container-card .content {
                display: flex;
                padding: 5px 0 5px;
                justify-content: center;
            }
            .container-card .picture {
                display: flex;
                flex-direction: column-reverse;
            }
            .container-card img {
                width: 100%;
                bottom: 10px;
            }
            @media (max-width: 992px) {
                .container-card .clok--item :nth-child(1) {
                    font-size: 2em;
                
                }
            }
            

            <?php if($wao_pb_showrightpromobox != '' && $wao_pb_showrightpromobox == 1): ?>
                <?=$wao_pb_idrightpromobox?> {
                    position: relative;
                }
                <?=$wao_pb_idrightpromobox?>:before {
                    content: '';
                    background-image: url(<?=$wao_pb_urlrightpromobox?>);
                    position: absolute;
                    background-size: contain;
                    background-repeat: no-repeat;
                    top: 20px;
                    right: -80px;
                    width: 144px;
                    height: 70px;
                    transform: rotate(38deg);
                    <?=$wao_pb_stylerightpromobox?>
                }
                @media (max-width: 1200px) {
                    <?=$wao_pb_idrightpromobox?>:before {
                        <?=$wao_pb_stylemobrightpromobox?>
                    }
                }
                @media (max-width: 992px) {
                    <?=$wao_pb_idrightpromobox?>:before {
                        content:none;
                    }
                }
            <?php endif; ?>

        
        </style>
        <div class="container-card" style="<?=$img_promobox?>">
            <?php if($titleBox): ?>
                <h2><?php echo $titleBox?></h2>
            <?php endif; ?>

            <?php if($wao_pb_enableclockpromobox != '' && $wao_pb_enableclockpromobox == 1): ?>
                <div class="content">
                    <div class="clok">
                        <div class="clok--item">
                            <span id="days"></span>
                            <span>
                                <?=$dayspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="hours"></span>
                            <span>
                                <?=$hourspromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="minutes"></span>
                            <span>
                                <?=$minutespromobox?>
                            </span>
                        </div>
                        <div class="clok--item">
                            <span id="seconds"></span>
                            <span>
                                <?=$secondspromobox?>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($contentBox): ?>
                <p><?=$contentBox?></p>
            <?php endif; ?>
        </div>
            <?php if($wao_pb_enableconfetipromobox != '' && $wao_pb_enableconfetipromobox == 1): ?>
                <canvas id="confetti" style="height: 0;"></canvas>
                <script src="https://cdn.jsdelivr.net/npm/js-confetti@latest/dist/js-confetti.browser.js"></script>
                <script>
                    const button = document.querySelector('#button');
                    const canvas = document.querySelector('#confetti');

                    const jsConfetti = new JSConfetti();
                    window.onload = function(e){ 
                        jsConfetti.addConfetti()
                    }
                </script>
            <?php endif; ?>

            <?php 
                if($wao_date_promobox): ?>
               <script>
					document.addEventListener('DOMContentLoaded', () => {
						const now = new Date();
						const todayString = `${String(now.getMonth() + 1).padStart(2, '0')}/${String(now.getDate()).padStart(2, '0')}/${now.getFullYear()} 11:59 PM`;

						// Fecha objetivo
						const DATE_TARGET = new Date(<?= ($wao_pb_renewclockpromobox == 1) ? "todayString" : json_encode($wao_date_promobox) ?>);

						const SPAN_IDS = ['days', 'hours', 'minutes', 'seconds'];
						const SPANS = Object.fromEntries(SPAN_IDS.map(id => [id, document.getElementById(id)]));

						const MS = {
							second: 1000,
							minute: 1000 * 60,
							hour: 1000 * 60 * 60,
							day: 1000 * 60 * 60 * 24
						};

						function updateCountdown() {
							const now = new Date();
							const diff = DATE_TARGET - now;

							const timeLeft = {
								days: Math.floor(diff / MS.day),
								hours: Math.floor((diff % MS.day) / MS.hour),
								minutes: Math.floor((diff % MS.hour) / MS.minute),
								seconds: Math.floor((diff % MS.minute) / MS.second)
							};

							if (diff > 0) {
								for (const unit of SPAN_IDS) {
									SPANS[unit].textContent = timeLeft[unit];
								}
							} else {
								for (const unit of SPAN_IDS) {
									SPANS[unit].textContent = 0;
								}
							}
						}

						updateCountdown();
						setInterval(updateCountdown, MS.second);
					});
			</script>


            <?php endif; ?>
    <?php
    } //end check category
}

add_Action('wp_head','wao_promobox_css_new');
function wao_promobox_css_new() {
	$wao_pb_categorypromobox = get_site_option('wao_pb_categorypromobox');
	$wao_pb_showrightpromobox = get_site_option('wao_pb_showrightpromobox');
	$wao_pb_urlrightpromobox = get_site_option('wao_pb_urlrightpromobox');
	$wao_pb_idrightpromobox = get_site_option('wao_pb_idrightpromobox');
	$wao_pb_stylerightpromobox = get_site_option('wao_pb_stylerightpromobox');
	$wao_pb_stylemobrightpromobox = get_site_option('wao_pb_stylemobrightpromobox');
	$wao_pb_styleshoppromobox = get_site_option('wao_pb_styleshoppromobox');

	$arrayCategories = explode(",", $wao_pb_categorypromobox);
	$classPromoList = "";
	$classPromoListID = "";
	$classPromoListIDhome = "";
	$classPromoListIDhome2 = "";

	foreach ($arrayCategories as $classAux) {
		$category = get_term_by('slug', '2024', 'product_cat');

		if ($category && !is_wp_error($category)) {
			$cat_id = $category->term_id;

			$classPromoList .= '.products .product.product_cat-' . $classAux . ':before,';
			$classPromoListID .= '.products .product.product_cat-' . $cat_id . ':before,';
			$classPromoListIDhome .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-" . $classAux . ".shoppingcart-grid-product:before,";
			$classPromoListIDhome2 .= ".product-widget-wrap .shoppingcart-grid-widget-wrap .product.product_cat-" . $cat_id . ".shoppingcart-grid-product:before,";
		}
	}

	$classPromoList = rtrim($classPromoList, ',');
	$classPromoListID = rtrim($classPromoListID, ',');
	$classPromoListIDhome = rtrim($classPromoListIDhome, ',');
	$classPromoListIDhome2 = rtrim($classPromoListIDhome2, ',');

	?>
	<style id="test123456">
	<?php if ($wao_pb_showrightpromobox == 1): ?>
		.products .product, 
		.product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product {
			position: relative;
		}
		<?= $classPromoList ?>,
		<?= $classPromoListID ?>,
		<?= $classPromoListIDhome ?>,
		<?= $classPromoListIDhome2 ?> {
			content: '';
			background-image: url(<?= esc_url($wao_pb_urlrightpromobox) ?>);
			position: absolute;
			background-size: contain;
			background-repeat: no-repeat;
			top: 0;
			right: -15px;
			width: 71px;
			height: 70px;
			transform: rotate(20deg);
			z-index: 22;
			<?php if (!empty($wao_pb_styleshoppromobox)) echo $wao_pb_styleshoppromobox; ?>
		}
		.woocommerce .products .product a {
			text-decoration: none;
			overflow: hidden !important;
			position: relative;
		}
		.woocommerce .products .product,
		.woocommerce-page .products .product {
			overflow: visible !important;
		}
		.woocommerce ul.products li.product .onsale,
		.product-widget-wrap .shoppingcart-grid-widget-wrap .shoppingcart-grid-product .onsale,
		.archive.woocommerce .products .product .onsale {
			display: none !important;
		}
	<?php endif; ?>
	</style>
	<?php
}
