<?php
/** 
* Class to send keys on customer email 
* @package WAOLM 
* Version corregida 1.5 
*	- Solo muestra version si el producto es variable.
*	- El correo de processing order verifica stock y depacho automatico, por si 
*     crea una variable _dispatchnow y actualiza el estado a completed
*   - Al cambiar el estado a completed, se activa el correo, el mismo verifica si el metadato
*     _dispatchnow es yes, entonces ejecuta el despacho automatico.
*	- Actualizacion menor: En despacho automático, usa post_title (Linea 239)
* Version corregida 1.4 (09-09-2024)
* 	- Combos habilitado para 3 productos
* Version corregida 1.5 (14-02-2025)
* 	- Se inserta una Order Actions 'Procesar despacho automatico'
*	- Se revisa el conteo de llaves quemadas.
*/
/** 
* CONTIENE DOS HOOKS
* - custom_woocommerce_auto_complete_paid_order	(1 sola funcion)
* - woocommerce_email_customer_details (8 funciones)
* - columna nueva en orders
* 
*/

// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}


// LOGICA PARA REPROCESAR DESPACHO AUTOMÁTICO CUANDO NO SE ENVIO POR CUALQUIER MOTIVO.
// Agregar una nueva acción al widget "Order Actions"
add_filter( 'woocommerce_order_actions', function( $actions ) {
    $actions['procesar_despacho_automatico'] = __( 'Procesar despacho automático', 'textdomain' );
    return $actions;
});
// Ejecutar la función cuando se seleccione la acción personalizada
add_action( 'woocommerce_order_action_procesar_despacho_automatico', function( $order ) {
    if ( $order instanceof WC_Order ) {
        $order_id = $order->get_id();

        // Llamar a la función personalizada
        fill_table_keys( $order_id, $order );

        // Reenviar el correo de "Processing Order"
        $mailer = WC()->mailer();
        $emails = $mailer->get_emails();

        if ( isset( $emails['WC_Email_Customer_Completed_Order'] ) ) {
            $emails['WC_Email_Customer_Completed_Order']->trigger( $order_id );
        }
    }
});

add_action( 'woocommerce_new_order', 'fill_table_keys', 10, 2 );
add_action( 'woocommerce_email_order_details', 'auto_dispatch_table', 5, 4 );
/*https://www.businessbloomer.com/woocommerce-add-extra-content-order-email/*/
      
//////////////////////////////////AQUI EMPIEZAN LAS FUNCIONES/////////////////////////////////////////////////
function fill_table_keys($order_id, $order) {
	global $wpdb;
	$despachartodo=TRUE;
	$actualizarstock=TRUE;
	$options = get_option( '_waolm_options' );
	$url_manuals_1=$options['urlmanuals'];
	$customer_email=$order->get_billing_email();
	$totalitem=0;
	$items=0;
	$envio=array();
    $tolerancia = isset($options['tolerancia']) ? $options['tolerancia'] : 1; // valor por defecto 5

	//////////////////
	//bucle de ITEMS de la ORDER
	//////////////////
	$i=0;//para bucle de items
	$j=0;//para blucle de combo
	$razon=$accion="";
	foreach( $order->get_items() as $item_id => $item ) {
		if($item->get_type()=='line_item'){
			$items++;
$depu[]="Items".$items; 
			$product_id_1 = $item->get_product_id();
			$autodispatch=get_post_meta($product_id_1,'_autodispatch_option',true);
			if($autodispatch<>'yes'){//aqui poner un if is_set
					$despachartodo=FALSE;
					$razon = "Despacho autom&aacute;tico no activo para uno o mas productos!";
					$accion = "Activar el despacho autom&aacute;tico para los productos, si la pol&iacute;tica de la empresa lo permite.";
			}else{
				
				$quantity = $item->get_quantity();
				//las claves son cargadas para el producto raiz, no para las  variaciones
				//las variaciones solo sirven para descontar el stock
				$variation_id = $item->get_variation_id();
				$variation=1;
				if($variation_id==0){
						$variation_id=$product_id_1;
						$muestraversion[$items]=false;
						$variation=1;
				}else{
						$muestraversion[$items]=true;
						$variation=obtenervariacion($variation_id);//funcion local producto es 1pc, 2pc, etc
				}
				if(escombo($product_id_1)){//funcion local, pregunta si _combos_option del producto = One, two, three o four
						$productoscombo=combos($product_id_1);//funcion local, si el producto en order es combo, jala los skus
						$l=0;
				}else{
						unset($productoscombo);
						$productoscombo[0]=get_post_meta($product_id_1,'_sku',true);
				}
				//////////////////
				//bucle de COMBOS
				//////////////////
				$j=0;//para bucle de combo
				if(!empty($productoscombo)){//el producto es combo pero no se ha configurado
					foreach($productoscombo as $product_sku){
$depu[]= "SKU:".$product_sku;
							//verificar si se configuraron todos los skus del combo
							if($product_sku=='0' OR empty($product_sku)){
								$razon = "Uno o mas productos del combo NO est&aacute;n seleccionados.";
								$accion = "Despache en forma manual y revise la configuración del producto combo. As&iacute;gne los productos correspondientes.";
								$despachartodo=FALSE;
								break;
							}
							//verificar si el cliente ya recibio llaves
							if(tiene_orden($customer_email,$product_sku)){
								$despachartodo=FALSE;
								$razon="Cliente antiguo. Revisar llaves y despachar manualmente!";
								$accion = "Despache en forma manual teniendo cuidado de no enviar llaves repetidas al cliente.";
							}
							//////////////////
							//bucle PRODUCT_ID
							//////////////////
							$despachados=0;
							$cuantas=cuantasllaves($product_sku,$variation);//Tengo por ejemplo 3 llaves con mas activaciones que variaciones
							$totalitem+=$quantity;
							$tp=$wpdb->prefix;	
							//dado sku, hallar id del producto en la tienda cliente. Para busqueda de nombre amigable
							//$combo_id = product_id_por_sku($product_sku);
							$combo_id = $wpdb->get_var($wpdb->prepare("SELECT P.ID FROM {$tp}posts AS P INNER JOIN {$tp}postmeta AS M ON P.ID = M.post_id WHERE P.post_type = 'product' AND P.post_status = 'publish' AND M.meta_key = '_sku' AND M.meta_value = %s LIMIT 1", $product_sku));

							if($cuantas >= $quantity){ /// cuantas llaves existen en total con activaciones > variation 
									$tiene_quemadas=0;
									$priority=1;
									// Cargar tabla con llaves para sku $quantity no es funcional, devolvera tabla con todas las llaves
									$todaslasfilas=lasllaves($product_sku,$variation,$quantity,$priority);
$depu[]['todas antes']=$todaslasfilas;
								// INICIO
									$llavesquemadas=isset($options['llavesquemadas'])?$options['llavesquemadas']:"";
									if($llavesquemadas=='on'){
$depu[]="llavesquemadas:".$options['llavesquemadas'];									
$depu[]="tolerancia:".$tolerancia;									
										// Bucle para identificar llaves que ya tiene el cliente
										// Si encuentra, borrar fila de array
										$valoresbuscados=email_vs_key($customer_email, $product_sku);
										$conteo = array_count_values( $valoresbuscados ); //devuelve array asociativo con clave valor (clave es la llave y valor el numero de veces que esta)
$depu[]="conteo".$conteo;
										foreach($todaslasfilas as $index => $fila){
											if (in_array($fila->skey, $valoresbuscados)) { //si encuentra coincidencias 
												if ( isset( $conteo[$fila->skey] ) && $conteo[$fila->skey] > $tolerancia ) { //si hay coincidencia y ademas es mayor que la tolerancia
													unset($todaslasfilas[$index]); // Eliminar la fila si se encuentra el valor buscado
													$tiene_quemadas = 1;
												}
											}
										}// fin foreach buscar llaves que ya tiene el cliente
$depu[]="todas despues".$todaslasfilas;
									}//fin $tienellavesquemadasactivado
								//FIN

									if(count($todaslasfilas)>=$quantity){ // Si hay mas filas de llaves que la cantidad solicitada
										// Cambiar nombres si se tiene configurado nombre amigable
										$new_name = $wpdb->get_var($wpdb->prepare('SELECT post_title FROM ' . $tp . 'posts WHERE ID = %d', $combo_id));
										for($k = 0; $k < count($todaslasfilas); $k++){
											if(!empty($new_name)){
												$todaslasfilas[$k]->productname=$new_name; // Cambiar productname si se tiene configurado
											}//Nombre amigable configurado en producto
											$todaslasfilas[$k]->variation=$variation;
										}
										$filasaenviar = array_slice($todaslasfilas, 0, $quantity); // de todas las llaves disponibles, dejamos las n primeras
										$despachados+=count($filasaenviar,1);// 1 para recursivo
										$tiene_quemadas=0;
									}else{// Si han menos llaves que las solicitadas, despachar todo a falso. Sin embargo if para la razon
									// Si se supo que el cliente ya tiene llave quemada, proseguir envio (o #llaves > que lo configurado)
										if($tiene_quemadas){
											$keysfallidas.=$product_sku."|";
											$razon = "Cliente ya posee mismas llaves para (".$keysfallidas.")";
											$accion = "Verifique que llaves ya recibi&oacute; el cliente y enviele una llave nueva. Configure cantidad permitida de llaves repetidas";
											$despachartodo=FALSE;
										}else{ // Esto significa que de hecho NO HABIA LA CANTIDAD DE LLAVES QUE EL CLIENTE SOLICITO
											$despachartodo = FALSE;
											$razon = "Uno o mas productos (".$product_sku.") no tienen el stock necesario!";
											$accion = "Despache en forma manual y aseg&uacute;rese que estos productos cuenten con activaciones suficientes!";
										}
									}
									$envio[] = $filasaenviar;
							}//if cuantas > quantity END
							$j++;
							//////////////////////
							//bucle PRODUCT_ID END
							//////////////////////
							$esd_links[$product_sku]=$url_manuals_1.get_post_meta($combo_id,'_download_link',true);
					}
				}else{//if empty productoscombo
					$razon = "Uno o mas productos del combo no est&aacute;n seleccionados.";
					$accion = "Despache en forma manual y revise la configuración del producto combo. As&iacute;gne los productos correspondientes.";
					$despachartodo=FALSE;
				}//if empty productoscombo
				$i++;
				//////////////////
				//bucle de COMBOS END
				//////////////////
			}//fin de si autodispatch <> yes
		}//fin de si line_item
	}//foreach BUCLE DE ITEMS END
	//////////////////
	//bucle de ITEMS de la ORDER END
	//////////////////
	if($despachartodo){
			update_post_meta($order_id,'_dispatchnow','yes');// Visto bueno para enviar las llaves en completed order
			$salida = $actualizarstock?latabla($envio, $esd_links, $muestraversion):'';// Devuelve las llaves en un template html
			$actualizarstock&&update_post_meta($order_id,'_esd_links',$esd_links);// actualiza los links referenciados por sku en un serializado
			$actualizarstock&&update_post_meta($order_id,'_keys',$envio);// actualiza las llaves en un campo serializado
			update_table_waolm_dispatched_keys($envio,$customer_email,$order_id);
			$actualizarstock&&update_post_meta($order_id,'_table_keys',htmlentities($salida));// actualiza las llaves en su template html
   }else{
			update_post_meta($order_id,'_depu',$depu);
			update_post_meta($order_id,'_dispatchnow','no');// no se hara despacho automatico
	}//if despachar END
	update_post_meta($order_id,'_razon',$razon);// guardamos el motivo por el que no se realizó el despacho
	update_post_meta($order_id,'_accion',$accion);// sugiere una accion a realizar
//	$order->add_order_note($depu, false);
//update_option($depu);
}//function END 

function auto_dispatch_table( $order, $sent_to_admin, $plain_text, $email ) {
        if ( $email->id == 'customer_processing_order' ) {
			$order_id=$order->get_id();
			$dispatchnow=get_post_meta($order_id,'_dispatchnow');
			if($dispatchnow[0]=="yes"){
				$order->update_status( 'completed' );
			}
        } // customer_processing_order END
        if ( $email->id == 'customer_completed_order' ) {
                $order_id=$order->get_id();
                $dispatchnow=get_post_meta($order_id,'_dispatchnow');
				/*if ( $order instanceof WC_Order ) {
					// Obtener el correo electrónico del cliente
					$customer_email = $order->get_billing_email();
				}*/
                //////////////////
                // GRAN IF 
                //////////////////
                if($dispatchnow[0]=="yes"){
					$salida = "";
					$table_keys=get_post_meta($order_id,'_table_keys');
					$_keys=get_post_meta($order_id,'_keys');
					if (!empty($table_keys)){
							$table_keys=get_post_meta($order_id,'_table_keys');
							$salida = html_entity_decode($table_keys[0]);
					}//if empty  envio END
					echo $salida;
					//update_table_waolm_dispatched_keys($_keys,$customer_email,$order_id);
					update_post_meta($order_id,'llaves_enviadas','yes');
                }//if dispatchno=yes END
                //////////////////
                // GRAN IF END
                //////////////////
        }//$email->id == 'customer_completed_order'  END
}//function END

function latabla($envio,$esd_links,$muestraversion){
	$template = template();
	$filas = "";
	$k=0;
	foreach($envio as $prod){
			$parimpar='par';
			$template_link = '<tr class="plink" style="font-style: italic;"><td colspan=3 style="border-top: solid 1px #e5e5e5;border-bottom: solid 1px #e5e5e5;"><p>{download_link}&nbsp;<a href="{link}" target="_blank"> {producto}</a></td></tr>';
			foreach($prod as $fila){
				$template_fila ='<tr class={parimpar}><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{nro}</td><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{producto}</td><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{llave}</td></tr>';
				$parimpar=$parimpar=="par"?"impar":"par";
				$k++;
				if(isset($muestraversion[$k])&&$muestraversion[$k]){//Undefined array key 2 in waolm-insert-keys-on-customer-email.php on line 307
					$fila->productname.="<p class='pversion' style='font-size:small;'>Version: ".$fila->variation." PC.</p>";
				}
				activaciones($fila->skey,$fila->product_sku,$fila->variation,$fila->nro);
				$template_fila = str_replace('{parimpar}',$parimpar,$template_fila);
				$template_fila = str_replace('{nro}',$fila->nro,$template_fila);
				$template_fila = str_replace('{producto}',$fila->productname,$template_fila);
				$template_fila = str_replace('{llave}',$fila->skey,$template_fila);
				$filas .= $template_fila;
			}// foreach END
			$template_link = str_replace('{download_link}',__( 'Download Link:', 'waolicensemanager' ),$template_link);
			$template_link = str_replace('{link}',$esd_links[$fila->product_sku],$template_link);
			$template_link = str_replace('{producto}',$fila->productname,$template_link);
			$filas .= $template_link;
	}
	$template = str_replace('{titulo}',__( 'Your Software Activation Keys', 'waolicensemanager'),$template);
	$template = str_replace('{tit_nro}',__( 'Nr.', 'waolicensemanager' ),$template);
	$template = str_replace('{tit_product}',__( 'Product', 'waolicensemanager' ),$template);
	$template = str_replace('{tit_key}',__( 'Key', 'waolicensemanager' ),$template);
	$template = str_replace('{filas}',$filas,$template);
	return $template;
}

function lasllaves($product_sku,$variation,$quantity,$priority){ // consulta sobre cpt licenses en servidor. Requiere switch_to_blog
	$external_server=get_waolm_client_option('externalserver');
	if(empty($external_server)){//tenemos servidor local obtener información mediante mysql
		return json_decode(lasllaves_server_local($product_sku,$variation,$quantity,$priority));
	}else{//servidor es externo. Obtener datos mediante json.
		$external_server=waolm_url($external_server);//formatea https://...../
		$external_server.="jsonwaolm?action=thekeys&product_sku=".$product_sku."&variation=".$variation."&quantity=".$quantity."&priority=".$priority; // url de la pagina que queremos obtener  
		$url_content = '';  
		$file = @fopen($external_server, 'r');  
		if($file){  
		//if(false){  
			while(!feof($file)) {  
				$url_content .= @fgets($file, 4096);  
			}
			$lasllaves=json_decode(trim(strip_tags($url_content)));//devolvera llaves decodificadas en array
		}  
		return $lasllaves;
	}//fin de external_server
}//function END

function activaciones($skey,$product_sku,$variation,$nro){ // consulta sobre cpt licenses en servidor. Requiere switch_to_blog
	$external_server=get_waolm_client_option('externalserver');
	if(empty($external_server)){//tenemos servidor local obtener información mediante mysql
		$ret = activaciones_server_local($skey,$product_sku,$variation,$nro);
		return $ret;
	}else{//servidor es externo. Obtener datos mediante json.
		$external_server=waolm_url($external_server);//formatea https://...../
		$external_server.="jsonwaolm?action=activations&skey=".$skey."&product_sku=".$product_sku."&variation=".$variation; // url de la pagina que queremos obtener  
		$url_content = '';  
		$file = @fopen($external_server, 'r');  
		if($file){  
		//if(false){  
			while(!feof($file)) {  
				$url_content .= @fgets($file, 4096);  
			}
			$retorno=trim(strip_tags($url_content));//true or false
		}  
		return $retorno;
	}//fin de external_server
	
}//function actualiza END

function escombo($post_id){ // consulta sobre producto en local
	$combos_option = get_post_meta($post_id,'_combos_option');
	if(empty($combos_option)||$combos_option[0]=='One'){
		return FALSE;
	}else{
		
		return TRUE;
	}
}// function escombo END 

function combos($post_id){ // consulta sobre producto en local
	$combo_products = get_post_meta($post_id,'_combo_products',true);
	return $combo_products;
}//function combos END

function obtenervariacion($variation_id){ // consulta sobre producto variable en local
	global $wpdb;
	$q="SELECT menu_order FROM {$wpdb->prefix}posts WHERE ID = {$variation_id}";
	$var=$wpdb->get_var($q);

	$var = $wpdb->get_var(
		$wpdb->prepare(
			"SELECT menu_order FROM {$wpdb->prefix}posts WHERE ID = %d",
			$variation_id
		)	
	);



	return $var[0]; 
} 

function cuantasllaves($product_sku,$variation){ // consulta sobre cpt licenses en servidor. Requiere switch_to_blog
	$external_server=get_waolm_client_option('externalserver');
	if(empty($external_server)){//tenemos servidor local obtener información mediante mysql
		return cuantas_llaves_server_local($product_sku,$variation);
	}else{//servidor es externo. Obtener datos mediante json.
		$external_server=waolm_url($external_server);//formatea https://...../
		$external_server.="jsonwaolm?sku=".$sku."&action=howmanykeys&product_sku=".$product_sku."&variation=".$variation; // url de la pagina que queremos obtener  
		$url_content = '';  
		$file = @fopen($external_server, 'r');  
		if($file){  
		//if(false){  
		  while(!feof($file)) {  
			$url_content .= @fgets($file, 4096);  
		  }
		  $cuantas=strip_tags($url_content);//esto devolvera un simple numero
		  fclose ($file);  
		}  
		return trim($cuantas);
	}//fin de external_server
}

function nodespachar(){}

function tiene_orden($customer_email,$product_sku){
	return false;
	//ver si este correo ya fue despachado
    global $wpdb;
	$q="SELECT DISTINCT M.meta_value
		FROM wp_posts P, wp_postmeta M
		WHERE P.ID = M.post_id
		  AND P.post_status = 'wc-completed'
		  AND P.post_type = 'shop_order'
		  AND M.meta_key = '_billing_email'";
	$emails=$wpdb->get_results($q);
	if(is_bool(array_search($customer_email,$emails))){return true;}else{return false;} 
}

function new_waolicensemanager_column( $columns = array() ) {
    // Add new columns
    $columns['waolicensemanager-status'] = 'AD';
    return $columns;
}

function waolicensemanager_column_content( $column ) {
    //global $the_order; // you can use the global WP_Order object here
	global $post; // is also available here
 
    if( $column == 'waolicensemanager-status' ) {

		$autodispatch=get_post_meta($post->ID, '_autodispatch_option',true);

//		$server=get_post_meta($the_order->ID, 'waolicensemanager_server');
	
	if(!empty($autodispatch)&&$autodispatch=="yes"){
			echo "<c style='color:green'>YES</c>";
		}else{
			//echo "no";
		}
        // do stuff, ex: get_post_meta( $post->ID, 'key', true );

    }

}
add_filter( 'manage_edit-product_columns','new_waolicensemanager_column');
add_action( 'manage_product_posts_custom_column' , 'waolicensemanager_column_content' );	

 // Con copia a admin  
function bbloomer_order_completed_email_add_cc_bcc( $headers, $email_id, $order ) {
    if ('customer_completed_order'==$email_id){
		$adm_email=get_option('admin_email');
        $headers .= "Cc: Copia para admin <".$adm_email.">\r\n"; // delete if not needed
    }
    return $headers;
}
add_filter( 'woocommerce_email_headers', 'bbloomer_order_completed_email_add_cc_bcc', 9999, 3 );

// Template HTML para las llaves y links
function template(){
	$template = '
	<hr><h2>{titulo}</h2>
	<table class="td tablekeys" cellspacing="0" cellpadding="6" style="width: 100%; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_nro}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_product}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_key}</th>
			</tr>
		</thead>
		<tbody>
		{filas}
		</tbody>
	</table>
	<br><hr>
	';
	return $template;
}

// Adaptado para guardar todo en tabla centralizada (site=1)
function update_table_waolm_dispatched_keys($envio,$customer_email,$order_id) {
    global $wpdb;
    //$table_name = $wpdb->prefix . 'waolm_dispatched_keys';
	$order = wc_get_order( $order_id );
    $table_name = 'wp_waolm_dispatched_keys';//la tabla reside en site_id=1
	$site_url = get_option('home');;
    if ($envio) {
        foreach ($envio as $key_data) {
            if (is_array($key_data)) {
                foreach ($key_data as $key_object) {
                    if (is_object($key_object)) {
                        $sku = $key_object->product_sku;
                        $product_name = $key_object->productname;
                        $key = $key_object->skey;
						$date = $order->get_date_created()->format('Y-m-d');
						$site_id = is_multisite()?get_current_blog_id():1; // En un entorno multisite de WordPress
						$wpdb->insert(
							$table_name,
							array(
								'sku' => $sku,
								'product_name' => $product_name,
								'customer_email' => $customer_email,
								'order_id' => $order_id,
								'key' => $key,
								'date' => $date,      // Usando la fecha obtenida del pedido
								'site_id' => $site_id, // Usando el ID del sitio actual
								'site_url' => $site_url
							),
							array(
								'%s',  // Para 'sku'
								'%s',  // Para 'product_name'
								'%s',  // Para 'customer_email'
								'%d',  // Para 'order_id'
								'%s',  // Para 'key'
								'%s',  // Para 'date' (si es una cadena de fecha en formato 'Y-m-d')
								'%d',   // Para 'site_id'
								'%s'	// Para 'site_ulr'
							)
						);//wpdb->insert
                    }
                }
            }
        }
    }
}

function email_vs_key($customer_email, $sku) {
	// Evaluar si $customer_email ya compro una $vkey
    global $wpdb;
    // Preparar la consulta de manera segura
    $query = $wpdb->prepare(
        "SELECT `key` AS skey FROM wp_waolm_dispatched_keys WHERE customer_email = %s AND `sku` = %s", 
        $customer_email, 
        $sku
    );
wdepu('*');
wdepu($query);
    $retorno = $wpdb->get_col($query);
wdepu(implode('*',$retorno));
    return $retorno;
}

function get_purchased_keys_by_email($customer_email) {
	// Obtener todas las llaves que compró $customer_email
    global $wpdb;
    // Preparar la consulta de manera segura
    $query = $wpdb->prepare(
        "SELECT * FROM wp_waolm_dispatched_keys WHERE customer_email = %s", 
        $customer_email 
    );
    // Ejecutar la consulta y obtener los resultados
    $results = $wpdb->get_results($query);
    // Array para almacenar los resultados finales
    $response = array();
    // Verificar si se encontraron resultados
    if ( !empty($results) ) {
        foreach ( $results as $row ) {
            // Mapear los resultados a un formato de array específico
			if(is_multisite()){
				$order_site = get_site($row->site_id);
				if ($order_site) {
					$site_url = get_site_url($row->site_id);
				} else {
					$site_url = get_option('home');
				}
			}else{
				$site_url = get_option('home');
			}
            $response[] = array(
                'Fecha'    => $row->date,         // Columna 'date' de la base de datos
                'Producto' => $row->product_name, // Columna 'product_name' de la base de datos
                'Llave'    => $row->key,          // Columna 'key' de la base de datos
                'Orden'    => $row->order_id,     // Columna 'order_id' de la base de datos
                'Sku'      => $row->sku,           // Columna 'sku' de la base de datos
                'Site'      => $row->site_id,       // Columna 'site_id' de la base de datos
                'Siteurl'      => $site_url   		// Construido a partir de site_id
            );
        }
    } else {
        // Manejo del caso en que no se encuentren resultados
        //echo 'No se encontraron resultados para el correo electrónico y la clave proporcionados.';
    }
    // Devolver el array de respuesta
    return $response;
}



//////////////////////////////////AQUI TERMINAN LAS FUNCIONES/////////////////////////////////////////////////

