<?php
/*
 * Menu de configuracion de wao license manager
 * Version 3.0: Configuracion con pestañas. Incluye templates. Opcion de desactivar muestra de llaves en thank you page. Pestaña de migración (La migración aún pendiente)
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function wao_settings_page(){
	if(soy_waolm_servidor()){
		$url=get_option('home')."/wp-admin/edit.php?post_type=licensemanagerwao&page=waolm_config";
	}else{
		$url=get_option('home')."/wp-admin/admin.php?page=waolm_config";
	}
	$url="options.php";
	laspestanias();
	?>
	<form action="<?php echo $url;?>" method="post">
		<?php 
		settings_fields( '_waolm_options' ); //Llamamos a la seccion de configuracion definida con register_setting()
		?>
        <div id="tab-url" class="tab-content active">
			<?php do_settings_sections( 'waolm_fields' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-templates" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_template' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-migration" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_migrate' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-checkout" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_checkout' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
		<input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
		<hr>
	</form>
	<?php
	cerrarlaspestanias();
	elscript();
} // function wao_settings_page() END
//////REGISTRANDO LOS CAMPOS O VARIABLES EN LA BASE DE DATOS [PASO 1]
function waolm_register_settings() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Windows And Office License Manager Settings', 'waolm_section_text', 'waolm_fields' );
	// 								$id, 			           $title,                                              $callback, 				$page, 			$section 	$args = array()
	add_settings_field( 'waolm_setting_urlmanuals', 'URL raiz para el enlace a manual de usuario y descargas', 'waolm_setting_urlmanuals', 'waolm_fields', 'waolm1_settings' );
	add_settings_field( 'waolm_setting_external_server', 'URL de un servidor externo', 'waolm_setting_external_server', 'waolm_fields', 'waolm1_settings' );
	add_settings_field( 'waolm_llavesquemadas', 'Activar verificacion de llaves quemadas', 'waolm_llavesquemadas', 'waolm_fields', 'waolm1_settings', array( 'class' => 'custom-background'));
    $waolm_options = get_option('_waolm_options');
    if(isset($waolm_options['llavesquemadas'])){
		add_settings_field( 'waolm_tolerancia', 'Tolerancia de llaves quemadas', 'waolm_tolerancia', 'waolm_fields', 'waolm1_settings', array( 'class' => 'custom-background') );
	}
	if(!soy_waolm_servidor()){
		add_settings_field( 'waolm_setting_server', 'Configure este pais como servidor', 'waolm_setting_server', 'waolm_fields', 'waolm1_settings' );
	}
	add_settings_field( 'waolm_setting_payments', 'Metodos de pago que se mostrar&aacute;n en la ThankYou Page', 'waolm_setting_payments', 'waolm_fields', 'waolm1_settings' );

}
function waolm_register_settings_template() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Templates', 'waolm_section_text', 'waolm_fields_template' );
	// 								$id, 			           $title,                                              $callback, 				$page, 			$section 	$args = array()

	add_settings_field( 'waolm_setting_email_template', 'Template para email', 'waolm_setting_email_template', 'waolm_fields_template', 'waolm1_settings' );
	add_settings_field( 'waolm_setting_checkout_template', 'Template para checkout page', 'waolm_setting_checkout_template', 'waolm_fields_template', 'waolm1_settings' );
	
}
function waolm_register_settings_migrate() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Estado de la migración', 'waolm_section_text', 'waolm_fields_migrate' );
	// 								$id, 			     $title,                               $callback, 				       $page, 			       $section 	$args = array()
	add_settings_field( 'waolm_setting_migrate_status', 'Estado de la migración de despachos', 'waolm_setting_migrate_status', 'waolm_fields_migrate', 'waolm1_settings' );
	
}
function waolm_register_settings_checkout() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título					$funcion titulo		 $página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Checkout Page', 'waolm_section_text', 'waolm_fields_checkout' );
	// 								$id, 			  $title,                                   $callback, 				     $page, 			      $section 	$args = array()
	add_settings_field( 'waolm_setting_on_checkout', 'Dejar de mostrar llaves en checkout', 'waolm_setting_on_checkout', 'waolm_fields_checkout', 'waolm1_settings' );
	
}
add_action( 'admin_init', 'waolm_register_settings' );
add_action( 'admin_init', 'waolm_register_settings_template' );
add_action( 'admin_init', 'waolm_register_settings_migrate' );
add_action( 'admin_init', 'waolm_register_settings_checkout' );
/////VALIDACION
function _waolm_options_validate( $input ) {
	$newinput['urlmanuals'] = trim( $input['urlmanuals'] );
	if ( ! preg_match( '/^[a-z0-9]{32}$/i', $newinput['urlmanuals'] ) ) {
	  $newinput['urlmanuals'] = '';
	}
	if (isset($input['soy_servidor'])&&$input['soy_servidor']=="S") {
		if(is_multisite()){
			update_blog_option(1,'_waolm_server_id',get_current_blog_id());
		}else{
			update_option('_waolm_server_id',1);
		}
	}else{
		if(!is_multisite()){
			delete_option('_waolm_server_id');
		}
	}
  //return $newinput;
  return $input;
}
/////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]
function waolm_section_text() {
  echo '<p>Configuracion de Parametros para WAO License Manager</p>';
}
function waolm_setting_urlmanuals() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_urlmanuals' name='_waolm_options[urlmanuals]' type='text' style='width:400px;' value='".esc_attr( $options['urlmanuals'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.)</i> ";
}
function waolm_setting_external_server() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_externalserver' name='_waolm_options[externalserver]' type='text' style='width:400px;'  value='".esc_attr( $options['externalserver'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.) (Activar SOLO SI el servidor está en otra web. Caso contrario dejar en blanco)</i> ";
}
function waolm_tolerancia() {
    // Obtener la opción desde la base de datos
    $waolm_options = get_option('_waolm_options');
    // Asignar el valor de tolerancia (si no existe, se usa un valor por defecto)
    $tolerancia = isset($waolm_options['tolerancia']) ? $waolm_options['tolerancia'] : 5; // valor por defecto 5

    // Crear el input numérico con botones para incrementar y disminuir
    echo '<input type="number" id="waolm_tolerancia" name="_waolm_options[tolerancia]" value="' . esc_attr($tolerancia) . '" min="0" max="100" step="1">
	<i style="margin-left:20px;">(Nro de llaves repetidas que se tolera enviar al mismo cliente)</i>
    ';
}

function waolm_llavesquemadas(){
    $waolm_options = get_option('_waolm_options');
    $llavesquemadas = isset($waolm_options['llavesquemadas']) ? "checked" : ""; // valor por defecto 5
	echo '<input type="checkbox" id="waolm_llavesquemadas" name="_waolm_options[llavesquemadas]" '.$llavesquemadas.'>';
	echo '<i style="margin-left:20px;">(En cada orden nueva, verificar si el cliente ya recibio mismas llaves)</i>';
}

function waolm_setting_server(){ //siempre en multisite
	if(is_multisite()){
		$waolm_server_id=get_waolm_server_id();
		switch_to_blog($waolm_server_id);
			$blog_name=get_option( 'blogname' );
		restore_current_blog();
		if(get_current_blog_id()==$waolm_server_id){
			$checked1="checked";
			$checked2="";
			$message = "";
		}else{
			$checked1="";
			$checked2="checked";
			$message="<span style='color:gray;font-size:12px;font-style: italic;'>(Servidor configurado es: <b>".$blog_name.")</b></span>";
		}
		echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="S" '.$checked1.'><label for="waolm_server_id">Si</label>&nbsp;&nbsp;&nbsp;'; 
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="N" '.$checked2.'><label for="waolm_server_id">No</label>'; 
		echo "</span>&nbsp;&nbsp;".$message;
	}
}//fin de funcion waolm_setting_server
function waolm_setting_payments() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );
	$ultimo_metodo_de_pago = get_option('ultimo_metodo_de_pago');
	$default_payments = 'cod|ppec_paypal|ppcp|ppcp-gateway|stripe|stripe_googlepay|stripe_applepay|stripe_cc|amazon_payments_advanced|woosa_adyen_credit_card|woosa_adyen_googlepay|woosa_adyen_applepay|woosa_adyen_klarna|woosa_adyen_wechatpay|woosa_adyen_alipay|emerchantpay_checkout';

	if (!isset($options['payments']) || empty($options['payments'])) {
		$options['payments'] = $default_payments;
		// Actualizar la opción en la base de datos
		update_option('_waolm_options', $options);
		$options = get_option( '_waolm_options' );
	}

	echo "<textarea id='waolm_payments' name='_waolm_options[payments]' style='width:400px;height:70px;'>".esc_attr( $options['payments'] )."</textarea><i style='margin-left:20px;'>(Los m&eacute;todos de pago que se mostrar&aacute;n en la ThankYou Page)</i> ";
	echo "<p>Puede copiar varios de la siguiente lista deben estar separados por el caracter pipe (|)</p>";
	echo "<h5>".$default_payments."</h5>";
	echo "<h5>El &uacute;ltimo m&eacute;todo de pago utilizado fu&eacute;: <b>".$ultimo_metodo_de_pago."</b></h5>";

	
}
function waolm_setting_email_template() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );

	echo "<textarea id='waolm_email_template' name='_waolm_options[email_template]' style='width:50%;height:70px;'>".esc_attr( $options['email_template'] )."</textarea><i style='margin-left:20px;'>(Esto se adjunta a Completed email)</i> ";
}
function waolm_setting_checkout_template() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );

	echo "<textarea id='waolm_checkout_template' name='_waolm_options[checkout_template]' style='width:50%;height:70px;'>".esc_attr( $options['checkout_template'] )."</textarea><i style='margin-left:20px;'>(Esto se muestra en la checkout page si activado)</i> ";
}
function waolm_setting_migrate_status() {
    global $wpdb;
	$options = get_option( '_waolm_options' );
	$checked = isset($options['purgar_keys'])&&$options['purgar_keys']=='on'?'checked':'';
    
    // Obtener la cantidad de registros con la meta_key '_keys'
    $q = "SELECT COUNT(meta_value) FROM {$wpdb->postmeta} WHERE meta_key = '_keys'";
    $_keys = $wpdb->get_var($q);

    $q = "SELECT COUNT(meta_value) FROM {$wpdb->postmeta} WHERE meta_key = '_key_migrated'";
    $_keys_migrated = $wpdb->get_var($q);

	$sid = is_multisite()?get_current_blog_id():1;

    $q = "SELECT COUNT(ID) FROM wp_waolm_dispatched_keys WHERE site_id = {$sid}";
    $_keys_in_new_table = $wpdb->get_var($q);
	
    // Plantilla corregida con correcta asignación de variables
    $template = "<div style='border:solid 1px gray;padding:5px;border-radius:3px;background-color:#fcfefd;width:49%;'>
				<ul>
                    <li>Cantidad total de _keys: {$_keys}</li>
                    <li>Cantidad de _keys procesadas: {$_keys_migrated}</li>
                    <li>Cantidad de _keys en nueva tabla: {$_keys_in_new_table}</li>
                 </ul><hr>
				 <label for='purgar_keys'>Eliminar _keys de la tabla ordenes cuando completado.</label>
				 <input type='checkbox' {$checked} name='_waolm_options[purgar_keys]'><br>
				 <label for='forzar_keys'>Forzar la migraci&oacute;n. (Migrar al salvar)</label>
				 <input type='checkbox' ><br>
				 </div>";

    echo $template;
}
function waolm_setting_on_checkout() {
    $options = get_option('_waolm_options');
	$checked = $options['checkout_show_keys']=='on'?'checked':'';
    $template = "<input type='checkbox' id='waolm_checkout_show_keys' name='_waolm_options[checkout_show_keys]' {$checked}><label for='checkout_link'>Desactivar mostrar llaves en página checkout</label>";
    echo $template;
}




function waolm_url($url){ //esto ya hace lo que debe
	$url=str_replace('http://','',$url);
	$url=str_replace('https://','',$url);
	$url="https://".$url;
	if(substr($url, -1)<>'/'){
		$url=$url."/";
	}
	return $url;
}
// Almacenar como option el código del ultimo metodo de pago utilizado
function get_payment_method_at_checkout($order_id) {
    $order = wc_get_order($order_id);
    if ($order) {
        $payment_method = $order->get_payment_method();
        update_option('ultimo_metodo_de_pago',$payment_method);
    }
}
add_action('woocommerce_checkout_update_order_meta', 'get_payment_method_at_checkout');

function laspestanias(){
?>	
    <div class="wrap">
        <h1>Configuración de Despacho automatico</h1>
        <h2 class="nav-tab-wrapper">
            <a href="#tab-url" class="nav-tab nav-tab-active" data-tab="tab-url">General</a>
            <a href="#tab-templates" class="nav-tab" data-tab="tab-templates">Templates</a>
            <a href="#tab-migration" class="nav-tab" data-tab="tab-migration">Migracion</a>
            <a href="#tab-checkout" class="nav-tab" data-tab="tab-checkout">Checkout page</a>
            <!--<a href="#tab-translations" class="nav-tab" data-tab="tab-translations">Traducciones</a>-->
        </h2>
<?php }// fin pestañas
function cerrarlaspestanias(){
	echo "</div>";
}
function elscript(){
	?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tabs = document.querySelectorAll('.nav-tab');
            var tabContents = document.querySelectorAll('.tab-content');
            var addTranslationRowButton = document.getElementById('add-translation-row');
            var addUrlRowButton = document.getElementById('add-url-row');
            var translationsTableBody = document.querySelector('#translations-table tbody');
            var urlsTableBody = document.querySelector('#urls-table tbody');

            tabs.forEach(function(tab) {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    tabs.forEach(function(t) { t.classList.remove('nav-tab-active'); });
                    tabContents.forEach(function(tc) { tc.classList.remove('active'); });

                    tab.classList.add('nav-tab-active');
                    document.querySelector(tab.getAttribute('href')).classList.add('active');
                });
            });

            addTranslationRowButton.addEventListener('click', function() {
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="translations_lang[]" /></td>
                    <td><input type="text" name="translations_key[]" /></td>
                    <td><input type="text" name="translations_value[]" /></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;
                translationsTableBody.appendChild(newRow);

                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            addUrlRowButton.addEventListener('click', function() {
				var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="met_pago[]" /></td>
                    <td><input type="text" name="url[]" /></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;

                urlsTableBody.appendChild(newRow);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });


            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
 
<?php
 }// fin funcion elscript



function waolm_default_configuration() {
	$waolmoptions = get_option('_waolm_options');
	if(!isset($waolmoptions['email_template'])||empty($waolmoptions['email_template'])){
		$waolmoptions['email_template']='	<hr><h2>{titulo}</h2>
	<table class="td tablekeys" cellspacing="0" cellpadding="6" style="width: 100%; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_nro}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_product}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_key}</th>
			</tr>
		</thead>
		<tbody>
		{filas}
		</tbody>
	</table>
	<br><hr>';
	}
	if(!isset($waolmoptions['checkout_template'])||empty($waolmoptions['checkout_template'])){
		$waolmoptions['checkout_template']='<style>
	h2 {font-size:25px;}
	.tabla{width:100%;}
	.pname, .pversion {display:inline-block;padding-left:5px;}
	.pversion{text-decoration:underline;}
	.plink{height:40px;}
	.par{background-color:Gainsboro;height:25px;}
	.impar{background-color:white;height:25px;}
	.tablekeys thead tr{background-color:Gray;color:white;height:5px;}
	tr.plink td p{height:15px;}
	tr.impar td p{height:10px;margin-top:0px;margin-bottom:0px;}
	tr.par td p{height:10px;margin-top:0px;margin-bottom:0px;}
	.alert-message {display: flex;align-items: center;background-color:#EEEEEE;border:solid 1px gray;border-radius:5px;padding:10px}
	.exclamation-mark {font-size: 50px;color: #FF0000;margin-right: 30px;}
	.message-content {color:#D04848;font-size:18px;/* Estilos para tu mensaje */}
</style>

<div class="tabla">{tabla}</div>

<div class="alert alert-warning alert-white rounded"style="align-items: center;gap: 10px;width: 90%;background-color:#E7E7EE;border:solid 1px gray;border-radius:3px;padding:10px;">
	<div class="icon" style="display:inline;">
		<svg width="40px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M569.5 440C588 472 564.8 512 527.9 512H48.1c-36.9 0-60-40.1-41.6-72L246.4 24c18.5-32 64.7-32 83.2 0l239.9 416zM288 354c-25.4 0-46 20.6-46 46s20.6 46 46 46 46-20.6 46-46-20.6-46-46-46zm-43.7-165.3l7.4 136c.3 6.4 5.6 11.3 12 11.3h48.5c6.4 0 11.6-5 12-11.3l7.4-136c.4-6.9-5.1-12.7-12-12.7h-63.4c-6.9 0-12.4 5.8-12 12.7z"/></svg>
	</div>
	<div class="message-content2" style="display:inline;">{mensaje}</div>
</div>';
	}
    update_option('_waolm_options', $waolmoptions);
}
add_action('admin_init', 'waolm_default_configuration');
