<?php
/** 
* Plugin Name: WAO License Manager
* Description: Auto dispatch software keys at completed order email.(Envia correo completed a admin) 
* Version: 3.0.5
* Change Log: (Corregido: Duplica llaves al actualizar. Corregido: mostrar llaves solo cuando comprado. Modificado: uso de templates. Link de pago mudado a stephanpay plugin. Link de pago para stephanpay en la thankyoupage. Boton para actualizar llaves aun no enviadas en edicion de orden. La configuracion para mostrar llaves en la checkout page ahora en WAOLM Client Setting. Toda orden se acualiza a completed corregido. Funcion de actualizacion solo se dispara en la pagina de plugins de la red. Warnings corregidos. Cambio de logica en despacho automatico) 
* Author: Arturo Zubieta 
* Author URI: https://winandoffice.com/ 
* Text Domain: waolicensemanager
* WC requires at least: 3.2.0 
* WC tested up to: 3.3.0 
* License: GPL-2.0+ 
* License URI: https://www.gnu.org/licenses/gpl-2.0.txt 
*/

/* ESTRUCTURA DE LAS VARIABLES USADAS EN EL PLUGIN
 * wp_options
 * 	_waolm_server_id (se graba cuando el cliente activa soy_servidor. Por defecto será la 1)
 * 	_waolm_server_url (id) (es util? si tenemos 'home' o 'url' en options) ****** NOOOOO
 * 
 * wp_{server_id}_options
 * 	CPT waolm
 * 		waolm-ID
 * 		waolm-key (toda la información de las llaves por SKU)
 * 	_waolm_server_options
 * 		url_of_server_when_server_is_outside (only show 'home' option in configuration tab)
 * 		
 * 
 * wp_{client_id}_options
 * 	_waolm_options
 * 		i_am_server true:false:external_server	(convert this site to server or external server) *** actua sobre 1:_waolm_server_id 
 * 		url_of_external_server	(copy from configuration of server)(if configured, client will search keys there) *** si tiene url, se prioriza sobre _waolm_server_id ***
*/

// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/** 
* Define constants 
*/
if ( ! defined( 'WAOLM_PLUGIN_VERSION' ) ) {
	define( 'WAOLM_PLUGIN_VERSION', '3.0.5' );
}
if ( ! defined( 'WAOLM_PLUGIN_DIR_PATH' ) ) {
	define( 'WAOLM_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

function waolicensemanager_load_textdomain() {
    load_plugin_textdomain( 'waolicensemanager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'waolicensemanager_load_textdomain' );

if(soy_waolm_servidor()){
	include('waolm-server-functions.php');//FUNCIONES:waolicensemanager_init()->waolm-cpt.php->wao_settings_page()
	require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt.php' );
	add_action( 'plugins_loaded', 'waolicensemanager_init' );
}
if(soy_waolm_cliente()){
	require('waolm-client-functions.php');//FUNCIONES:waolm_pestanias_init;inserta_llave_en_thankyoupage();susllaves();
	require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-pestana-en-producto.php' );
	add_action( 'plugins_loaded', 'waolm_pestanias_init' );//Instancia de clase en waolm-client-functions.php
	include( 'classes/waolm-insert-keys-on-customer-email.php' );
}

/*
 * FUNCIONES GENERALES
 *
 */

function admin_style() {
echo "<style>.column-title {width:300px;}
	.order_details{border:solid 2px black!important; background-color:#eeeeee!important;}
	.waolm-config {padding:20px;margin:5px;background-color:GhostWhite;border:solid 1px blac;border-radius:15px;box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);}
	.waolmtitle {text-align:center;background-color:#e6f2ff;padding:30px;border:solid 1px white}	
</style>";
}
add_action('admin_enqueue_scripts', 'admin_style');

function soy_waolm_servidor(){
	//return true;
	if(is_multisite()){
		$current_blog_id=get_current_blog_id();
		if($current_blog_id==get_waolm_server_id()){
			return true;
		}else{
			return false;
		}
	}else{
		$waolm_options=get_option('_waolm_options');
		$i_am_server=$waolm_options['i_am_server'];
		if ($i_am_server=='S'){
			return true;
		}
	}
}

function get_waolm_server_option($option){//obtener _waolm_server_options[$option] 
	if (is_multisite()){
		$options=get_blog_option(get_waolm_server_id(),'_waolm_server_options');
	}else{
		$options=get_option('_waolm_server_options');
	}
	return $options[$option];
}

function get_waolm_client_option($option, $default=null){//obtener _waolm_options[$option] 
	$options=get_option('_waolm_options',array());
	return isset($options[$option])?$options[$option]:$default;
}

function get_waolm_server_key_information(){//obtener informacion de las llaves
}

function get_waolm_server_id(){//cambiar a 1 y obtener _waolm_server_id
	if(is_multisite()){
		return get_blog_option(1,'_waolm_server_id');
	}else{
		return get_option('_waolm_server_id'); //valores: x, 1, 0
	}
}

function get_server_prefix(){//cambiar a 1, obtener _waolm_server_id y devolver prefix adecuado
	if(is_multisite()){
		$prefix = get_blog_option(1,'_waolm_server_id');
		if ($prefix=1){
			return 'wp_';
		}else{
			return 'wp_'.$prefix.'_';
		}
	}else{
		return 'wp_';
	}
}

function soy_waolm_cliente(){
	return true;
}


function wdepu($valor){
	if (substr($valor,0,1)=="*"){
		update_option('_depu',str_replace('*','',$valor));
	}else{
		$old_valor = get_option('_depu');
		$new_valor = $old_valor."|".$valor;
		update_option('_depu', $new_valor);
	}
}

// Lógica de actualizacion del plugin
include('waolm-update.php');
// Metodo principal que busca e inserta llaves en el correo del cliente
include ("classes/waolm-llavesclientemetabox.php");
// Muestra metabox para ver que llaves ya compro el cliente por email
include ("classes/waolm-susllaves-en-edit-order.php");
// Muestra la pagina de configuracion 
include ("classes/waolm-settings-page.php");
//include ("classes/waolm-settings-page1.php");
// Funcionalidad de migracion de metadato _keys a tabla 
include ("classes/waolm-migrate.php"); 

