<?php
/** 
* Class to create custom post type wao license manager 
* @package WAOLM 
*/

/** 
* Create new post type for autodispatched keys 
* consta de tres funciones
* - autodipatch_post_type (crea el post type Keys)
* - personalizar_columnas  (crea las columnas en la parte del listado)
* - personalizar_contenidos (lee los valores desde post_meta y los plasma en la tabla)
* - ordenamiento
* --- keys_sortable_columns
* --- keys_load
* --- my_sort_keys
* - registro de metaboxes para la vista de edicion o adicion
* --- waolm_register_meta_boxes
* --- waolm_output_meta_box
* --- waolm_save_meta_boxes
* @since 1.2.0 
*/

// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}
if( ! class_exists( 'WAOLM_CPT' ) ) {
    class WAOLM_CPT {
        public function __construct() {
        }
        public function init() {
			/// Creacion del custom post type licensemanagerwao
			add_action('init', array( $this, 'autodipatch_post_type'));
			/// Personalizacion de columnas
			add_filter( 'manage_licensemanagerwao_posts_columns', array( $this, 'personalizar_columnas') );
			/// Cargar contenidos en la tabla
			add_action( 'manage_licensemanagerwao_posts_custom_column', array( $this, 'personalizar_contenidos'), 10, 2);
			/// Ordenacion de columna
			add_filter( 'manage_edit-licensemanagerwao_sortable_columns', array( $this, 'keys_sortable_columns') );
			add_action( 'load-edit.php', array( $this, 'keys_load') );
			/// Salvar la informacion
			add_action('save_post', array( $this, 'waolm_save_meta_boxes'));
			/// Colocar un input select en la fila de filtros del listado CPT
			add_action('restrict_manage_posts',array( $this, 'location_filtering'),10);
			/// Mantener el filtrado realizado mediante un input select en el listado CPT
			add_filter( 'parse_query', array( $this, 'filter_request_query') , 10);
			/// Agregar metaboxes en la pantalla de edicion del CPT
			add_action('add_meta_boxes', array( $this, 'waolm_register_meta_boxes'));
			/// Submenú de configuracion
			add_action( 'admin_menu', array( $this, 'mi_submenu') );
			//add_filter( 'wp_statuses_get_registered_post_types', $this->restrict_statuses_for_licensemanagerwao, 10, 2 );
			//add_filter( 'wp_insert_post_data', $this->insert_using_custom_status, 10, 2 );
			add_filter('post_row_actions', array($this,'quita_opciones_view_waolm'), 10, 2);
		}
//////////////////////////////////AQUI EMPIEZAN LAS FUNCIONES/////////////////////////////////////////////////

	function insert_using_custom_statusX( $data = array(), $postarr = array() ) {

		if ( empty( $postarr['publish'] ) ) {
			return $data;
		}

		if ( 'licensemanagerwao' !== $data['post_type'] ) {
			return $data;
		}

		if ( ! empty( $postarr['_wp_statuses_status'] ) && in_array( $postarr['_wp_statuses_status'], array(
			'Active',
			'Inactive',
		), true ) ) {
			$data['post_status'] = sanitize_key( $postarr['_wp_statuses_status'] );

		// Default status for the licensemanagerwao Post Type is assigned.
		} else {
			$data['post_status'] = 'Publish';
		}

		return $data;
	}

	function restrict_statuses_for_licensemanagerwaoX( $post_types = array(), $status_name = '' ) {
		if ( 'Active' === $status_name || 'Inactive' === $status_name ) {
			return $post_types;
		}
		// All other statuses (eg: Publish, Private...) won't be applied to tickets
		return array_diff( $post_types, array( 'licensemanagerwao' ) );
	}

/*
 ______              _                           ______                    _______                
(_____ \            (_)       _                 (_____ \            _     (_______)               
 _____) )_____  ____ _  ___ _| |_ _____  ____    _____) )__   ___ _| |_       _ _   _ ____  _____ 
|  __  /| ___ |/ _  | |/___|_   _) ___ |/ ___)  |  ____/ _ \ /___|_   _)     | | | | |  _ \| ___ |
| |  \ \| ____( (_| | |___ | | |_| ____| |      | |   | |_| |___ | | |_      | | |_| | |_| | ____|
|_|   |_|_____)\___ |_(___/   \__)_____)_|      |_|    \___/(___/   \__)     |_|\__  |  __/|_____)
              (_____|                                                          (____/|_|          
*/
	function autodipatch_post_type()
	{
		$args = array(
			'public' => true,
			'labels' => array(
				'name' => 'WAO License Manager',
				'singular_name' => 'Key',
				'all_items' => 'All Keys',
				'add_new' => 'Add new Key',
				'add_new_item' => 'Add new Key',
				'edit_item' => 'Edit Key',
				'new_item' => 'New Key',
				'view_item' => 'View Key',
				'search_items' => 'Search Keys',
				'not_found' => 'Keys not found',
				'not_found_in_trash' => 'Keys not found in trash'
			),
			'menu_position' => 12,
			'capability_type' => 'post', 
			'menu_icon' => 'dashicons-products',
			'supports' => array( 'title'	 )
			
		);
		register_post_type('licensemanagerwao', $args);
	//funciones para modificar los estados
	/*register_post_status( 'Active', array(
		'label'                     => _x( 'Active', 'post status label', 'licensemanagerwao' ),
		'public'                    => true,
		'label_count'               => _n_noop( 'Active <span class="count">(%s)</span>', 'Resolved <span class="count">(%s)</span>', 'plugin-domain' ),
		'post_type'                 => array( 'licensemanagerwao' ), // Define one or more post types the status can be applied to.
		'show_in_admin_all_list'    => true,
		'show_in_admin_status_list' => true,
		'show_in_metabox_dropdown'  => true,
		'show_in_inline_dropdown'   => true,
		'dashicon'                  => 'dashicons-yes',
	) );
	register_post_status( 'Inactive', array(
		'label'                     => _x( 'Inactive', 'post status label', 'licensemanagerwao' ),
		'public'                    => true,
		'label_count'               => _n_noop( 'Invalid <span class="count">(%s)</span>', 'Invalids <span class="count">(%s)</span>', 'plugin-domain' ),
		'post_type'                 => array( 'licensemanagerwao' ), // Define one or more post types the status can be applied to.
		'show_in_admin_all_list'    => true,
		'show_in_admin_status_list' => true,
		'show_in_metabox_dropdown'  => true,
		'show_in_inline_dropdown'   => true,
		'dashicon'                  => 'dashicons-dismiss',
	) );*/
	}// function register_new_post_type END
/*
 ______                                   _  _                                 _                               
(_____ \                                 | |(_)                               | |                              
 _____) )____  ____ ___  ___  ____  _____| | _ _____ _____  ____     ____ ___ | | _   _ ____  ____  _____  ___ 
|  ____/ ___ |/ ___)___)/ _ \|  _ \(____ | || (___  |____ |/ ___)   / ___) _ \| || | | |    \|  _ \(____ |/___)
| |    | ____| |  |___ | |_| | | | / ___ | || |/ __// ___ | |      ( (__| |_| | || |_| | | | | | | / ___ |___ |
|_|    |_____)_|  (___/ \___/|_| |_\_____|\_)_(_____)_____|_|       \____)___/ \_)____/|_|_|_|_| |_\_____(___/ 
                                                                                                               
*/
	function personalizar_columnas( $columns ) 
	{
		$columns1 = array(
		  //'Key' => __( 'Key', 'waolicensemanager' ),
		  'Product' => __( 'Product', 'waolicensemanager' ),
		  'Activations' => __( 'Activations', 'waolicensemanager' ),
		  'Dispatched' => __( 'Dispatched', 'waolicensemanager' ),
		  'Status' => __( 'Status', 'waolicensemanager' ),
		  'Priority' => __( 'Priority', 'waolicensemanager' ),
		  'Sku' => __( 'SKU', 'waolicensemanager' )
		);
		//  'Rotation' => __( 'Rotation', 'waolicensemanager' ),
		$columns=array_merge($columns, $columns1);
	  return $columns;
	}//function personalizar columna END
	function personalizar_contenidos( $column, $post_id ) 
	{
	  $info = get_post_meta($post_id);
	  $info1 = get_post($post_id);
	  switch ($column)
	  {
		case 'Key':
			echo $info['_key'][0];
		  break;
		case 'Product':
			//$pro=get_post($info['_product'][0]);
			//echo $pro->post_name;
			$prod_id = $info['_product'][0];
			$waolm_sku = $info['_waolm_sku'][0];
			// Verificar que las variables no estén vacías
			if (!empty($prod_id) && !empty($waolm_sku)) {
				$product_query = new WC_Product_Query(array('include' => array($prod_id)));
				$products = $product_query->get_products();
				if (!empty($products)) {
					$product = reset($products); // Obtener el primer producto del resultado
					if ($product->get_sku() === $waolm_sku) {
						echo $info['_product_name'][0];
					} else {
						echo '<p style="color:red;">SKU no coincide para <b>'.$info['_product_name'][0].'</b></p>';
					}
				} else {
					echo '<p style="color:red;">ID no coincide para <b>'.$info['_product_name'][0].'. El producto es VIRTUAL?</b></p>';
				}
			} else {
				echo '<p style="color:red;">ID o SKU vacíos para <b>'.$info['_product_name'][0].'</b></p>';
			}
//			echo $info['_product_name'][0];
		  break;
		case 'Activations':
			echo $info['_activations'][0];
		  break;
		case 'Dispatched':
			echo $info['_dispatched'][0];
		  break;
		case 'Status':
			$valor=$info1->post_status=='publish'?'Active':'Inactive';
			echo $valor;
			//echo $info1->post_status;
		  break;
		case 'Priority':
			//echo $info['_priority'][0];//muestra el metavalor
			echo $info1->menu_order;//muestra menu_order de posts
		  break;
		case 'Sku':
			echo $info['_waolm_sku'][0];
		  break;
	  }
	}//function personalizar contenidos END
	function keys_sortable_columns( $columns ) 
	{
	 $columns['Product'] = 'Product';
	 $columns['Priority'] = 'Priority';
	 return $columns;
	}//function keys sortable columns END
	/* Only run our customization on the 'edit.php' page in the admin. */
	function keys_load() 
	{
	 add_filter( 'request', array( $this, 'my_sort_keys') );
	}//function keys load END 
	/* Sorts  licensemanagerwao. */
	function my_sort_keys( $vars ) 
	{

		/* Check if we're viewing the 'licensemanagerwao' post type. */
		if ( isset( $vars['post_type'] ) && 'licensemanagerwao' == $vars['post_type'] ) {
			/* Check if 'orderby' is set to 'Product'. */
			if ( isset( $vars['orderby'] ) && 'Product' == $vars['orderby'] ) {
				/* Merge the query vars with our custom variables. */
				$vars = array_merge(
				$vars,
				array(
					 'meta_key' => '_product_name',
					 'orderby' => '_product_name'
					)
					//meta_value_num
				);
			}

			/* Check if 'orderby' is set to 'Priority'. */
			if ( isset( $vars['orderby'] ) && 'Priority' == $vars['orderby'] ) {
				/* Merge the query vars with our custom variables. */
				$vars = array_merge(
				$vars,
				array(
					 'meta_key' => '_priority',
					 'orderby' => '_priority'
					)
				);
			}

		}
	 return $vars; 
	}//function my sort keys END		
	/// COLOCAR UN INPUT SELECT EN LA FILA DE FILTROS DEL LISTADO DE CPT
	function location_filtering($post_type)
	{
		if('licensemanagerwao' !== $post_type){
		  return; //filter your post
		}
		$selected = '';
		$request_attr = 'my_products';
		if ( isset($_REQUEST[$request_attr]) ) {
		  $selected = $_REQUEST[$request_attr];
		}
		//get unique values of the meta field to filer by.
		$meta_key = '_product';
		global $wpdb;
		$result = $wpdb->get_results( 
			$wpdb->prepare( "
				SELECT DISTINCT M.meta_value AS prod, N.meta_value AS productname
					FROM {$wpdb->prefix}posts P 
						LEFT JOIN {$wpdb->prefix}postmeta M ON P.ID = M.post_id AND M.meta_key = '%s' 
						LEFT JOIN {$wpdb->prefix}postmeta N ON P.ID = N.post_id AND N.meta_key = '_product_name'
					WHERE P.post_type = 'licensemanagerwao'
					  AND P.post_status IN ('publish')
					ORDER BY productname", 
				$meta_key
			) 
		);
	   //build a  custom dropdown list of values to filter by
		echo '<select id="my_products" name="my_products">';
		echo '<option value="0">' . __( 'Show all products', 'my-custom-domain' ) . ' </option>';
		foreach($result as $location){
		  //$select = ($org->ID == $selected) ? ' selected="selected"':'';
		  $select = ($location->prod == $selected) ? ' selected="selected"':'';
		  echo '<option value="'.$location->prod.'"'.$select.'>' . $location->productname . ' </option>';
		}
		echo '</select>';
	  }
	/// next we need to ensure the admin query returns the correct set of filtered posts by hooking onto the ‘parse_query’ filter
	function filter_request_query($query)
	{
		//modify the query only if it admin and main query.
		if( !(is_admin() AND $query->is_main_query()) ){ 
		  return $query;
		}
		//we want to modify the query for the targeted custom post and filter option
		if( !('licensemanagerwao' === $query->query['post_type'] AND isset($_REQUEST['my_products']) ) ){
		  return $query;
		}
		//for the default value of our filter no modification is required
		if(0 == $_REQUEST['my_products']){
		  return $query;
		}

		//List posts this user is "tagged" in (B).
		$query->set('meta_key', '_product');
		$query->set('meta_value', $_REQUEST['my_products']);
		$query->set('meta_compare', 'LIKE');
		
		return $query;
	}
/*
 _______                                                                _                           
(_______)                                                     _        | |                          
 _______  ____  ____ _____  ____ _____  ____    ____  _____ _| |_ _____| |__   ___ _   _ _____  ___ 
|  ___  |/ _  |/ ___) ___ |/ _  (____ |/ ___)  |    \| ___ (_   _|____ |  _ \ / _ ( \ / ) ___ |/___)
| |   | ( (_| | |   | ____( (_| / ___ | |      | | | | ____| | |_/ ___ | |_) ) |_| ) X (| ____|___ |
|_|   |_|\___ |_|   |_____)\___ \_____|_|      |_|_|_|_____)  \__)_____|____/ \___(_/ \_)_____|___/ 
        (_____|           (_____|                                                                   
 * 2.1.-Agrega los meta boxes para el Custom Post Type licensemanagerwao
 * https://developer.wordpress.org/reference/functions/add_meta_box/
 */
function waolm_register_meta_boxes()
{
	add_meta_box('Key-Information', 'Key Information', array( $this, 'waolm_output_meta_box'), 'licensemanagerwao', 'normal', 'high');
}
/**
 * 2.2 Genera el contenido que hay que mostrar dentro del meta box
 * @param WP_Post $post WordPress Post object
 */
function waolm_output_meta_box($post)
{
	// Los campos se graban en la base de datos con un subrayado bajo como prefijo
	// WP indica así por defecto que son campos metas
	$key = get_post_meta($post->ID, '_key', true);
	$product = get_post_meta($post->ID, '_product', true);
	$activations = get_post_meta($post->ID, '_activations', true);
	$dispatched = get_post_meta($post->ID, '_dispatched', true);
	$status = get_post_status($post->ID);
	$priority = get_post_meta($post->ID, '_priority', true);
	wp_nonce_field( 'graba_licensemanagerwao', 'licensemanagerwao_nonce' );
	$sino=true;
	$clase="";
	$estilo="margin-left:50px;width:200px;";
 
		$args = array(
			'numberposts'	=> -1,
			'post_type'		=> 'product',
			'post_status'	=> 'publish',
			'orderby'		=> 'post_name',
			'order'			=>	'ASC'
		);
		$productos = get_posts( $args );
		$ids = array_column($productos, 'ID');
		$names = array_column($productos, 'post_name');
		// $skus = array_column($productos, '_sku');
		$prods1=array('-1'=>'Configure!');
		$prods2 = array_combine($ids, $names);
		$prods = $prods1 + $prods2;
		//update_option("_depu",$prods);
		woocommerce_wp_select(
			array(
				'id'		=> 'product',
				'label'		=> __( 'Product', 'waolicensemanager' ),
				'wrapper_class'	=> $clase,
				'style'		=> "margin-left:68px;width:400px;",
				'value'		=> $product,
				'options'	=>	$prods,
				'desc_tip'	=> $sino,
				'description'	=> __( 'Product that correspond this key.', 'waolicensemanager' )
			)
		);

/*<input text activations>*/    
		woocommerce_wp_text_input(
			array(
				'id'		=> 'activations',
				'label'		=> __( 'Activations', 'waolicensemanager' ),
				'wrapper_class'	=> $clase,
				'style'		=> "margin-left:50px;width:400px;",
				'type'		=> 'number',
				'value'		=> esc_attr($activations),
				'desc_tip'	=> $sino,
				'description'	=> __( 'Number of total activations for this key.', 'waolicensemanager' )
			)
		);

/*<input text dispatched>*/    
		woocommerce_wp_text_input(
			array(
				'id'		=> 'dispatched',
				'label'		=> __( 'Dispatched', 'waolicensemanager' ),
				'wrapper_class'	=> $clase,
				'style'		=> "margin-left:50px;width:400px;",
				'type'		=> 'number',
				'value'		=> esc_attr($dispatched),
				'desc_tip'	=> $sino,
				'custom_attributes' => array('readonly' => 'readonly'),
				'description'	=> __( 'Number of activations done for this key.', 'waolicensemanager' )
			)
		);
/*<input text priority>*/    
		woocommerce_wp_text_input(
			array(
				'id'		=> 'priority',
				'label'		=> __( 'Priority', 'waolicensemanager' ),
				'wrapper_class'	=> $clase,
				'style'		=> "margin-left:72px;width:400px;",
				'type'		=> 'number',
				'value'		=> esc_attr($priority),
				'desc_tip'	=> $sino,
				'description'	=> __( 'Priority', 'waolicensemanager' )
			)
		);
/*<select status>*/
		if($status <> "publish"){$status="draft";}
		$estados['publish']="Active";
		$estados['draft']="Inactive";
		woocommerce_wp_select(
			array(
				'id'		=> 'status',
				'label'		=> __( 'Status', 'waolicensemanager' ),
				'wrapper_class'	=> $clase,
				'style'		=> "margin-left:75px;width:400px;",
				'value'		=> $status,
				'options'	=>	$estados,
				'desc_tip'	=> $sino,
				'description'	=> __( 'Select the status.', 'waolicensemanager' )
			)
		);



}
/**
 _______             _                                            _                           
(_______)           | |                                 _        | |                          
 _   ___  ____ _____| |__  _____  ____    ____  _____ _| |_ _____| |__   ___ _   _ _____  ___ 
| | (_  |/ ___|____ |  _ \(____ |/ ___)  |    \| ___ (_   _|____ |  _ \ / _ ( \ / ) ___ |/___)
| |___) | |   / ___ | |_) ) ___ | |      | | | | ____| | |_/ ___ | |_) ) |_| ) X (| ____|___ |
 \_____/|_|   \_____|____/\_____|_|      |_|_|_|_____)  \__)_____|____/ \___(_/ \_)_____|___/ 
 * 2.3 Graba los campos del formulario del meta box
 * @param int $post_id Post ID
 * @return bool|int
 */
function waolm_save_meta_boxes($post_id)
{
	// Comprueba que el nonce es correcto para evitar ataques CSRF
	if ( !isset($_POST['licensemanagerwao_nonce']) || ! wp_verify_nonce( $_POST['licensemanagerwao_nonce'], 'graba_licensemanagerwao') ) {
		return $post_id;
	}

	// Comprueba que el tipo de post es licensemanagerwaos
	if ('licensemanagerwao' != $_POST['post_type']) {
		return $post_id;
	}

	// Comprueba que el usuario actual tiene permiso para editar esto
	if (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}

	// Ahora puedes grabar los datos con tranquilidad
	// Observa que cuando vienen del formulario los campos meta no vienen con el prefijo subrayado bajo pero cuando los grabas en el post hay que poner el prefijo, igual que cuando los leías del post
	$key = get_post_meta($post->ID, '_key', true);
	$product = get_post_meta($post->ID, '_product', true);
	$activations = get_post_meta($post->ID, '_activations', true);
	$dispatched = get_post_meta($post->ID, '_dispatched', true);
	//$rotation = get_post_meta($post->ID, '_rotation', true);
	$priority = get_post_meta($post->ID, '_priority', true);

	//$key = sanitize_text_field($_POST['key']);
	//update_post_meta($post_id, '_key', $key);
	$product = sanitize_text_field($_POST['product']);
	update_post_meta($post_id, '_product', $product);
	$sku=get_post_meta($product,'_sku',true);
	update_post_meta($post_id, '_waolm_sku', $sku);
	$product_name = get_post( $product );
	update_post_meta($post_id, '_product_name', $product_name->post_name);//mejor post_title??? antes post_name
	$activations = sanitize_text_field($_POST['activations']);
	update_post_meta($post_id, '_activations', $activations);
	$dispatched = sanitize_text_field($_POST['dispatched']);
	update_post_meta($post_id, '_dispatched', $dispatched);

	//esto ya no sera necesario ....
	$priority = sanitize_text_field($_POST['priority']);
	update_post_meta($post_id, '_priority', $priority);

	$status = sanitize_text_field($_POST['status']);
	global $wpdb;
	$q="UPDATE {$wpdb->prefix}posts SET post_status = '{$status}', menu_order = '{$priority}' WHERE ID = {$post_id}";
	echo $q;
	$wpdb->get_var($q);
	return true;
}
/*
 _______                 _                                                               _                  
(_______)               (_)                                                          _  (_)                 
 _____ _   _ ____   ____ _  ___  ____  _____  ___     ___  ____  _____  ____ _____ _| |_ _ _   _ _____  ___ 
|  ___) | | |  _ \ / ___) |/ _ \|  _ \| ___ |/___)   / _ \|  _ \| ___ |/ ___|____ (_   _) | | | (____ |/___)
| |   | |_| | | | ( (___| | |_| | | | | ____|___ |  | |_| | |_| | ____| |   / ___ | | |_| |\ V // ___ |___ |
|_|   |____/|_| |_|\____)_|\___/|_| |_|_____|___/    \___/|  __/|_____)_|   \_____|  \__)_| \_/ \_____(___/ 
                                                          |_|                                               
*/
// Agrega un submenú de configuración
// PARAMETROS: 
// add_submenu_page( string $parent_slug, string $page_title, string $menu_title, 
// string $capability, string $menu_slug, callable $callback = '', int|float $position = null ):string|false
function mi_submenu(){
//                    parent_slug                             page_title            menu_title       capability   	   menu_slug         callback              position 
	add_submenu_page('edit.php?post_type=licensemanagerwao','WAOLM License Manager','WAOLM Client Setting','manage_options','waolm_config','wao_settings_page');//funcion comun en waolicensemanager.php

}
function quita_opciones_view_waolm($actions, $post)
{
    if ($post->post_type=='licensemanagerwao')
    {
        //$actions['duplicate'] = '<a href="#" title="" rel="permalink">Duplicate</a>';
		unset($actions['view']);
		unset($actions['inline hide-if-no-js']); 
	}
	//borraantiguospaypals();
	return $actions;
}

//////////////////////////////////AQUI TERMINAN LAS FUNCIONES/////////////////////////////////////////////////
    }// fin de clase
}// fin de si existe clase
///FIN DE CLASE
