<?php
defined( 'ABSPATH' ) or die;

if(isset($_REQUEST['action'])){
	$action = $_REQUEST['action'];
	switch($action){
		case 'givememykeys':
			add_shortcode('jsonwaolm', 'return_server_keys');
			break;
		case 'givemecomboproducts':
			add_shortcode('jsonwaolm', 'return_products_combo');
			break;
		case 'howmanykeys':
			add_shortcode('jsonwaolm', 'cuantas_llaves_server');
			break;
		case 'thekeys':
			add_shortcode('jsonwaolm', 'lasllaves_server');
			break;
		case 'activations':
			add_shortcode('jsonwaolm', 'activations_server');
			break;
	}
}

/// Instanciar clase CPT waolicensemanager
function waolicensemanager_init() {
	if ( is_admin() ) {
		// Create new custom type
		$WAOLM_CPT = new WAOLM_CPT();
		$WAOLM_CPT->init();
		}
}

function return_server_keys(){
	//preguntar si es pagina x * ya está en el switch case
	//recibir el _sku * listo
	$sku=$_REQUEST['sku'];
	//hacer un select de las llaves por _sku
	//antes, cambiar a server
	if(is_multisite()){
		switch_to_blog(get_waolm_server_id());
	}
		$args = array(
				'numberposts'	=> -1,
				'meta_key'		=> '_waolm_sku',
				'meta_value'	=> $sku,
				'post_type'		=> 'licensemanagerwao',
				'status'		=> 'publish',
				'orderby'		=> 'menu_order',
				'order'			=> 'ASC',
			);

	$lasllaves=get_posts($args);
	$retorno=array();
	$i=0;
	
	foreach ($lasllaves as $llave){
		$fila[$i]->id = $llave->ID;
		$fila[$i]->clave = $llave->post_title;
		$fila[$i]->product = get_post_meta($llave->ID,'_product_name',true);
		$fila[$i]->activations = get_post_meta($llave->ID,'_activations',true);
		$fila[$i]->dispatched = get_post_meta($llave->ID,'_dispatched',true);
		$fila[$i]->status = $llave->post_status=='publish'?'Active':'Inactive';
		//$fila[$i]->priority = get_post_meta($llave->ID,'_priority',true);
		$fila[$i]->priority = $llave->menu_order;
		$retorno[]=$fila[$i++];
	}
	if(is_multisite()){
		restore_current_blog();
	}
	
	echo json_encode($retorno);
	//preparar respuesta json
	//insertar la respuesta en una page con shortcode
}
function return_products_combo(){
	if(is_multisite()){
		switch_to_blog(get_waolm_server_id());
	}
	global $wpdb;
	$q="SELECT ID, post_title 
		FROM {$wpdb->prefix}posts
		WHERE post_type = 'product'
		   AND post_status = 'publish'
		   AND ID IN (
			SELECT M.meta_value
				FROM {$wpdb->prefix}posts P, {$wpdb->prefix}postmeta M
				WHERE P.post_type = 'licensemanagerwao'
				  AND P.post_status = 'publish'
				  AND P.ID = M.post_id
				  AND M.meta_key = '_product'
			);";
	$resultados=$wpdb->get_results($q);
	$retorno=array();
	$i=0;
	$fila[$i]->sku=0;
	$fila[$i]->post_title="Sin producto";
	$retorno[]=$fila[$i++];
	foreach ($resultados as $res){
		$fila[$i]->sku = get_post_meta($res->ID,'_sku',true);//_sku porque estamos en producto
		$fila[$i]->post_title = $res->post_title;
		//$fila[$i]->post_title = $q;
		$retorno[]=$fila[$i++];
	}
	if(is_multisite()){
		restore_current_blog();
	}
	echo json_encode($retorno);
	//preparar respuesta json
	//insertar la respuesta en una page con shortcode
}
function cuantas_llaves_server($product_sku,$variation){ // consulta sobre cpt licenses en servidor. Requiere switch_to_blog
	if(isset($_REQUEST['product_sku'])){$product_sku=$_REQUEST['product_sku'];}
	if(isset($_REQUEST['variation'])){$variation=$_REQUEST['variation'];}
	if(is_multisite()){
		switch_to_blog(get_waolm_server_id());
	}
	global $wpdb;
	$q="SELECT COUNT(meta_value)
		FROM {$wpdb->prefix}postmeta
		WHERE meta_key = '_activations'
		  AND meta_value >= {$variation}
		  AND post_id IN (
			SELECT post_id
				FROM {$wpdb->prefix}postmeta
				WHERE meta_key = '_waolm_sku'
				  AND meta_value = '{$product_sku}')"; 
	  
	$var=$wpdb->get_var($q);
	if(is_multisite()){
		restore_current_blog();
	}
	//$salida = $var[0]>0?$var[0]:1; 
	$salida = $var[0]; 
	echo trim($salida);
}
function lasllaves_server(){ // consulta sobre cpt licenses en servidor. Requiere switch_to_blog
	if(isset($_REQUEST['product_sku'])){$product_sku=$_REQUEST['product_sku'];}
	if(isset($_REQUEST['variation'])){$variation=$_REQUEST['variation'];}
	if(isset($_REQUEST['priority'])){$priority=$_REQUEST['priority'];}
	if(isset($_REQUEST['quantity'])){$quantity=$_REQUEST['quantity'];}

	if(is_multisite()){
		switch_to_blog(get_waolm_server_id());
	}
	global $wpdb;
	$margen=5;
	$q="SET @numero=0";
	$s = $wpdb->get_var($q);	  
	$q="
	SELECT  P.menu_order AS nro, P.ID AS keyid, P.post_title AS skey, Q.meta_value AS productname, P.menu_order AS priority, M.meta_value AS product_sku
		FROM {$wpdb->prefix}posts P 
		LEFT JOIN {$wpdb->prefix}postmeta M ON P.ID = M.post_id AND M.meta_key = '_waolm_sku' 
		LEFT JOIN {$wpdb->prefix}postmeta N ON P.ID = N.post_id AND N.meta_key = '_activations'
		LEFT JOIN {$wpdb->prefix}postmeta Q ON P.ID = Q.post_id AND Q.meta_key = '_product_name'
		WHERE P.post_type = 'licensemanagerwao'
		  AND P.post_status = 'publish'
		  AND M.meta_value = '{$product_sku}'
		  AND N.meta_value >= {$variation}
		  AND P.menu_order >= {$priority}
		ORDER BY priority
		LIMIT {$quantity}";  
	$r = $wpdb->get_results($q);	  
	if(is_multisite()){
		restore_current_blog();
	}
	echo json_encode($r);
}//function END
function activations_server(){
	if(isset($_REQUEST['skey'])){$skey=$_REQUEST['skey'];}
	if(isset($_REQUEST['product_sku'])){$product_sku=$_REQUEST['product_sku'];}
	if(isset($_REQUEST['variation'])){$variation=$_REQUEST['variation'];}
	$retorno=1;
	if(is_multisite()){
		switch_to_blog(get_waolm_server_id());
	}
	global $wpdb;
	$tp=$wpdb->prefix;	
	$q="SELECT P.ID
		FROM ".$tp."posts P, ".$tp."postmeta M
		WHERE P.ID = M.post_id
		  AND P.post_title = '".$skey."'
		  AND P.post_type = 'licensemanagerwao'
		  AND P.post_status = 'publish'
		  AND M.meta_key = '_waolm_sku'
		  AND M.meta_value = '".$product_sku."'";
	$waolmkey_id=$wpdb->get_var($q);
	$nuevo = get_post_meta($waolmkey_id, '_activations');
	$nuevo = (int)$nuevo[0] - $variation;
	if(!update_post_meta($waolmkey_id, '_activations',$nuevo)){$retorno=0;}

	$nuevo = get_post_meta($waolmkey_id, '_dispatched');
	$nuevo = (int)$nuevo[0] + $variation;
	if(!update_post_meta($waolmkey_id, '_dispatched',$nuevo)){$retorno=0;}
	if(is_multisite()){
		restore_current_blog();
	}
	echo $retorno;
}

function copia_template(){
	//$origen="/var/www/clients/client1/web9/web/wp-content/plugins/waolicensemanager/classes/waolm_template.php";
	$origen=plugin_dir_path( __FILE__ )."classes/waolm_template.php";
	$destino=get_theme_root()."/".get_template()."/waolm_template.php";
	if(!file_exists($destino)){
		if (!copy($origen,$destino)) {
			$depu[] = "Error";
		}
	}
}
//copia_template();
function crea_waolm_page(){
	$args = array(
		'post_type' =>	'page',
		'title'	=> 'jsonwaolm'
	);
	//	'status'	=> 'publish'
	$my_posts = get_posts( $args );
	if(empty($my_posts))
	{
		$parametros=array(
		'ID'=>'',
		'post_author'=>$user->ID,
		'post_content'=>'[jsonwaolm]',
		'post_title'=>'jsonwaolm',
		'post_name'=>'jsonwaolm',
		'post_status'=>'publish',
		'post_type'=>'page'
		);
		$post_id = wp_insert_post($parametros);
		add_post_meta($post_id, '_wp_page_template', 'waolm_template.php', true);
	}// Fin de empty
}
//add_action( 'admin_init', 'crea_waolm_page' );
