<?php
// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Asegúrate de incluir WP_List_Table si no está cargado
if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class WAOLicenseManager_List_Table extends WP_List_Table {

    public function get_columns() {
         //   'id'           => 'ID',
        return [
            'cb'           => '<input type="checkbox" />',
            '_key'         => 'Clave',
            'product'      => 'Producto',
            'product_name' => 'Nombre del producto',
            'activations'  => 'Activaciones',
            'dispatched'   => 'Despachado',
            'priority'     => 'Prioridad',
            'waolm_sku'    => 'SKU',
        ];
    }

    public function column_cb($item) {
        return sprintf('<input type="checkbox" name="id[]" value="%s" />', $item['id']);
    }

	public function column__key($item) {
		//$edit_url   = admin_url('admin.php?page=waolm_licensemanager_admin&action=edit&id=' . $item['id']);
		$edit_url = network_admin_url('admin.php?page=waolm_licensemanager_admin&action=edit&id=' . $item['id']);
		/*$delete_url = wp_nonce_url(
			admin_url('admin.php?page=waolm_licensemanager_admin&action=delete&id=' . $item['id']),
			'waolm_delete_key_' . $item['id']
		);*/
		$delete_url = wp_nonce_url(
			network_admin_url('admin.php?page=waolm_licensemanager_admin&action=delete&id=' . $item['id']),
			'waolm_delete_key_' . $item['id']
		);
		$draft_url  = wp_nonce_url(network_admin_url('admin.php?page=waolm_licensemanager_admin&action=draft&id=' . $item['id']), 'waolm_draft_' . $item['id']);
		$actions = [
			'edit'   => sprintf('<a href="%s">Editar</a>', esc_url($edit_url)),
			'draft'  => '<a href="' . esc_url($draft_url) . '">Despublicar</a>',
			'delete' => sprintf('<a href="%s" onclick="return confirm(\'¿Seguro que deseas eliminar esta clave?\')">Eliminar</a>', esc_url($delete_url)),
		];

		return sprintf(
			'<strong><a href="%1$s">%2$s</a></strong> %3$s',
			esc_url($edit_url),
			esc_html($item['_key']),
			$this->row_actions($actions)
		);
	}

    public function column_default($item, $column_name) {
        switch ($column_name) {
            case 'id':
            case '_key':
            case 'product':
            case 'product_name':
            case 'activations':
            case 'priority':
            case 'waolm_sku':
                return esc_html($item[$column_name]);
            case 'dispatched':
                //return $item[$column_name] ? 'Sí' : 'No';
                return $item[$column_name];
            default:
                return print_r($item, true);
        }
    }

	public function prepare_items() {
		global $wpdb;
		$table_name = $wpdb->base_prefix . 'waolicensemanager_keys';

		$per_page     = 20;
		$current_page = $this->get_pagenum();
		$offset       = ($current_page - 1) * $per_page;

		$search         = isset($_REQUEST['s']) ? trim($_REQUEST['s']) : '';
		$filter_product = isset($_REQUEST['filter_product']) ? trim($_REQUEST['filter_product']) : '';
		$filter_status  = isset($_REQUEST['filter_status']) ? trim($_REQUEST['filter_status']) : '';

		// Construcción dinámica del WHERE
		$where = 'WHERE 1=1';
		$params = [];

		if ($search !== '') {
			$like = '%' . $wpdb->esc_like($search) . '%';
			$where .= " AND (_key LIKE %s OR waolm_sku LIKE %s OR product_name LIKE %s)";
			array_push($params, $like, $like, $like);
		}

		if ($filter_product !== '') {
			$where .= " AND product_name = %s";
			$params[] = $filter_product;
		}

		if ($filter_status !== '') {
			$where .= " AND status = %s";
			$params[] = $filter_status;
		}

		// Consulta total de elementos
		$sql_count = "SELECT COUNT(*) FROM $table_name $where";
		$total_items = $params
			? $wpdb->get_var($wpdb->prepare($sql_count, ...$params))
			: $wpdb->get_var($sql_count);

		// Consulta de datos con paginación
		$sql_data = "SELECT * FROM $table_name $where ORDER BY id DESC LIMIT %d OFFSET %d";
		$params[] = $per_page;
		$params[] = $offset;

		$this->items = $params
			? $wpdb->get_results($wpdb->prepare($sql_data, ...$params), ARRAY_A)
			: $wpdb->get_results($wpdb->prepare($sql_data, $per_page, $offset), ARRAY_A);

		// Paginación
		$this->set_pagination_args([
			'total_items' => $total_items,
			'per_page'    => $per_page,
			'total_pages' => ceil($total_items / $per_page),
		]);

		$this->_column_headers = [$this->get_columns(), [], [], 'id'];
	}

	public function extra_tablenav_borrar($which) {
		if ($which !== 'top') return;

		global $wpdb;
		$table_name = $wpdb->base_prefix . 'waolicensemanager_keys';

		$current_product = isset($_GET['filter_product']) ? sanitize_text_field($_GET['filter_product']) : '';
		$current_status  = isset($_GET['filter_status']) ? sanitize_text_field($_GET['filter_status']) : '';

		echo '<div class="alignleft actions">';

		// Obtener product_name únicos desde la tabla
		$product_names = $wpdb->get_col("SELECT DISTINCT product_name FROM $table_name ORDER BY product_name ASC");

		// Filtro por nombre del producto
		echo '<select name="filter_product">';
		echo '<option value="">Todos los productos</option>';
		foreach ($product_names as $product_name) {
			$selected = ($current_product === $product_name) ? 'selected' : '';
			echo "<option value='" . esc_attr($product_name) . "' $selected>" . esc_html($product_name) . "</option>";
		}
		echo '</select>';

		// Filtro por status
		$statuses = ['publish' => 'Publicado', 'draft' => 'Borrador', 'pending' => 'Pendiente', 'private' => 'Privado'];
		echo '<select name="filter_status">';
		echo '<option value="">Todos los estados</option>';
		foreach ($statuses as $key => $label) {
			$selected = ($current_status === $key) ? 'selected' : '';
			echo "<option value='" . esc_attr($key) . "' $selected>$label</option>";
		}
		echo '</select>';

		submit_button('Filtrar', 'button', '', false);

		echo '</div>';
	}

	public function extra_tablenav($which) {
		if ($which !== 'top') return;

		$current_product = isset($_GET['filter_product']) ? sanitize_text_field($_GET['filter_product']) : '';
		$current_status  = isset($_GET['filter_status']) ? sanitize_text_field($_GET['filter_status']) : '';

		echo '<div class="alignleft actions">';

		// Filtro por nombre del producto
		$product_names = $this->get_unique_product_names();
		echo '<select name="filter_product">';
		echo '<option value="">Todos los productos</option>';
		foreach ($product_names as $product_name) {
			$selected = ($current_product === $product_name) ? 'selected' : '';
			echo "<option value='" . esc_attr($product_name) . "' $selected>" . esc_html($product_name) . "</option>";
		}
		echo '</select>';

		// Filtro por estado
		$statuses = $this->get_unique_statuses();
		echo '<select name="filter_status">';
		echo '<option value="">Todos los estados</option>';
		foreach ($statuses as $status) {
			$selected = ($current_status === $status) ? 'selected' : '';
			echo "<option value='" . esc_attr($status) . "' $selected>" . esc_html($status) . "</option>";
		}
		echo '</select>';

		submit_button('Filtrar', 'button', '', false);

		echo '</div>';
	}

	protected function get_bulk_actions() {
		return [
			'delete'     => 'Eliminar',
			'set_publish' => 'Marcar como Publicado',
			'set_draft'   => 'Marcar como Borrador',
		];
	}

	public function process_bulk_action() {
		if (empty($_REQUEST['_wpnonce']) || !wp_verify_nonce($_REQUEST['_wpnonce'], 'bulk-' . $this->_args['plural'])) {
			return;
		}

		$action = $this->current_action();
		$ids = isset($_REQUEST['id']) ? array_map('intval', (array) $_REQUEST['id']) : [];

		if (empty($ids)) {
			return;
		}

		global $wpdb;
		$table = $wpdb->base_prefix . 'waolicensemanager_keys';
		switch ($action) {
			case 'delete':
				$placeholders = implode(',', array_fill(0, count($ids), '%d'));
				$wpdb->query($wpdb->prepare("DELETE FROM $table WHERE id IN ($placeholders)", ...$ids));
				break;

			case 'set_draft':
				$placeholders = implode(',', array_fill(0, count($ids), '%d'));
				$wpdb->query($wpdb->prepare("UPDATE $table SET status = 'draft' WHERE id IN ($placeholders)", ...$ids));
				break;

			case 'set_publish':
				$placeholders = implode(',', array_fill(0, count($ids), '%d'));
				$wpdb->query($wpdb->prepare("UPDATE $table SET status = 'publish' WHERE id IN ($placeholders)", ...$ids));
				break;
		}
	}

	private function get_unique_statuses() {
		global $wpdb;
		$table = $wpdb->base_prefix . 'waolicensemanager_keys';
		return $wpdb->get_col("SELECT DISTINCT status FROM $table ORDER BY status ASC");
	}

	private function get_unique_product_names() {
		global $wpdb;
		$table = $wpdb->base_prefix . 'waolicensemanager_keys';
		return $wpdb->get_col("SELECT DISTINCT product_name FROM $table WHERE product_name != '' ORDER BY product_name ASC");
	}

} // fin de clase

function waolm_render_licensemanager_admin_page() {
    $table = new WAOLicenseManager_List_Table();
	$table->process_bulk_action(); // <-- Este debe ir primero
    $table->prepare_items();

	if (isset($_GET['action'], $_GET['id']) && $_GET['action'] === 'draft') {
		$id = intval($_GET['id']);
		if (wp_verify_nonce($_GET['_wpnonce'], 'waolm_draft_' . $id)) {
			global $wpdb;
			$table = $wpdb->base_prefix . 'waolicensemanager_keys';
			$wpdb->update($table, ['status' => 'draft'], ['id' => $id]);
			wp_safe_redirect(network_admin_url('admin.php?page=waolm_licensemanager_admin'));
			exit;
		}
	}



    $action = isset($_GET['action']) ? sanitize_key($_GET['action']) : '';

    if ($action === 'add') {
        waolm_render_add_form();
    } elseif ($action === 'edit' && !empty($_GET['id'])) {
        waolm_render_edit_form((int) $_GET['id']);
    } elseif ($action === 'delete' && !empty($_GET['id'])) {
        waolm_handle_delete((int) $_GET['id']);
    } else {
		echo '<div class="wrap">';
		echo '<h1 class="wp-heading-inline">Licencias WAO License Manager</h1>';
		$add_url = network_admin_url('admin.php?page=waolm_licensemanager_admin&action=add');
		echo '<a href="' . esc_url($add_url) . '" class="button button-primary">Añadir nueva clave</a>';

		echo '<form method="get">';
		echo '<input type="hidden" name="page" value="waolm_licensemanager_admin" />';
		$table->search_box('Buscar licencia', 'search_id');
		echo '</form>';

		echo '<form method="post">';
		$table->display();
		echo '</form>';
		echo '</div>';

	}
}

// Form de adicion de keys
function waolm_render_add_form() {
    if (!current_user_can('edit_others_products')) {
        wp_die(__('No tienes permisos suficientes para acceder a esta página.'));
    }

    global $wpdb;
    $table = 'wp_waolicensemanager_keys';

    // Procesar guardado
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['_wpnonce']) && check_admin_referer('waolm_add_key')) {
        $wpdb->insert($table, [
            '_key'         => sanitize_text_field($_POST['_key']),
            'product'      => intval($_POST['product']),
            'product_name' => sanitize_text_field($_POST['product_name']),
            'activations'  => intval($_POST['activations']),
            'dispatched'   => intval($_POST['dispatched']),
            'priority'     => intval($_POST['priority']),
            'waolm_sku'    => sanitize_text_field($_POST['waolm_sku']),
        ]);

        wp_redirect(network_admin_url('admin.php?page=waolm_licensemanager_admin'));
        exit;
    }

    // Obtener productos del sitio 1
    $products = [];
    switch_to_blog(1);
    $args = [
        'post_type'      => 'product',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        'fields'         => 'ids',
        'meta_query'     => [
            'relation' => 'AND',
            [
                'key'   => '_autodispatch_option',
                'value' => 'yes',
            ],
            [
                'key'   => '_combos_option',
                'value' => 'One',
            ],
        ]
    ];
    $product_ids = get_posts($args);
    foreach ($product_ids as $product_id) {
        $products[$product_id] = [
            'title' => get_the_title($product_id),
            'sku'   => get_post_meta($product_id, '_sku', true),
        ];
    }
    restore_current_blog();

    // Construir opciones del combo
    $product_options_html = '';
    foreach ($products as $id => $info) {

        $product_options_html .= '<option value= "' . esc_html($info['title']) . '" value1="' . esc_attr($id) . '" data-sku="' . esc_attr($info['sku']) . '">' . esc_html($info['title']) . '</option>';


    }

    $form_action = esc_url(network_admin_url('admin.php?page=waolm_licensemanager_admin&action=add'));
    $nonce_field = wp_nonce_field('waolm_add_key', '_wpnonce', true, false);

    echo waolm_license_form_template([], $product_options_html, $form_action, $nonce_field, false);
}
// Form de edicion de keys
function waolm_render_edit_form($id) {
    if (!current_user_can('edit_others_products')) {
        wp_die(__('No tienes permisos suficientes para acceder a esta página.'));
    }

    global $wpdb;
    $table = $wpdb->base_prefix . 'waolicensemanager_keys';

    $data = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $id), ARRAY_A);
    if (!$data) {
        echo '<div class="notice notice-error"><p>No se encontró la clave con ese ID.</p></div>'.$id;
        return;
    }

    // Guardar cambios
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['_wpnonce']) && check_admin_referer('waolm_edit_key')) {
        $wpdb->update($table, [
            '_key'         => sanitize_text_field($_POST['_key']),
            'product'      => intval($_POST['product']),
            'product_name' => sanitize_text_field($_POST['product_name']),
            'activations'  => intval($_POST['activations']),
            'dispatched'   => intval($_POST['dispatched']),
            'priority'     => intval($_POST['priority']),
            'waolm_sku'    => sanitize_text_field($_POST['waolm_sku']),
            'status'       => $_POST['status']=='publish'?'publish':'draft',
        ], ['id' => $id]);

        wp_redirect(network_admin_url('admin.php?page=waolm_licensemanager_admin'));
        exit;
    }

    // Obtener productos del sitio 1
    $products = [];
    switch_to_blog(1);
    $args = [
        'post_type'      => 'product',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        'fields'         => 'ids',
        'meta_query'     => [
            'relation' => 'AND',
            [
                'key'   => '_autodispatch_option',
                'value' => 'yes',
            ],
            [
                'key'   => '_combos_option',
                'value' => 'One',
            ],
        ]
    ];
    $product_ids = get_posts($args);
    foreach ($product_ids as $product_id) {
        $products[$product_id] = [
            'title' => get_the_title($product_id),
            'sku'   => get_post_meta($product_id, '_sku', true),
        ];
    }
    restore_current_blog();

    // Construir opciones del combo
    $product_options_html = '';
    foreach ($products as $id_prod => $info) {
        $selected = ($id_prod == $data['product']) ? ' selected' : '';
        $product_options_html .= '<option value= "' . esc_html($info['title']) . '" value1="' . esc_attr($id_prod) . '" data-sku="' . esc_attr($info['sku']) . '"' . $selected . '>' . esc_html($info['title']) . '</option>';
    }

    $form_action = esc_url(network_admin_url('admin.php?page=waolm_licensemanager_admin&action=edit&id=' . $id));
    $nonce_field = wp_nonce_field('waolm_edit_key', '_wpnonce', true, false);

    echo waolm_license_form_template($data, $product_options_html, $form_action, $nonce_field, true,$id);
}
// Template de añadir y editar
function waolm_license_form_template($data = [], $product_options_html = '', $form_action = '', $nonce_field = '', $is_edit = false,$id=0) {
    // Fallbacks por si faltan valores
    $defaults = [
        '_key'        => '',
        'product'     => '',
        'product_name'=> '',
        'waolm_sku'   => '',
        'activations' => 100,
        'dispatched'  => 0,
        'priority'    => 1,
        'status'      => 'publish',
    ];
    $data = array_merge($defaults, $data);
	$status = $data['status']=='publish'?'checked':'';
    $cancel_url = esc_url(network_admin_url('admin.php?page=waolm_licensemanager_admin'));
	$id_input=$is_edit?'<input type="hidden" name="id" value="'.$id.'">':'';
    $template = '
    <div class="wrap">
        <h1>' . ($is_edit ? 'Editar clave' : 'Añadir nueva clave') . '</h1>
        <form method="post" action="' . $form_action . '" onsubmit="return waolmSyncProductSelection();">
            ' . $nonce_field . '
            <input type="hidden" name="product" id="product" value="{product}">
				{id_input}
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="_key">Clave</label></th>
                    <td><input name="_key" type="text" id="_key" class="regular-text" value="{_key}" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="product_name">Producto</label></th>
                    <td>
                        <select name="product_name" id="product_name" class="regular-text" onchange="waolmSyncProductSelection()">
                            <option value="">Selecciona un producto...</option>
                            ' . $product_options_html . '
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="waolm_sku">SKU</label></th>
                    <td><input name="waolm_sku" type="text" id="waolm_sku" class="regular-text" value="{waolm_sku}" readonly></td>
                </tr>
                <tr>
                    <th scope="row"><label for="activations">Activaciones</label></th>
                    <td><input name="activations" type="number" id="activations" class="small-text" value="{activations}"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="dispatched">Despachado</label></th>
                    <td><input name="dispatched" type="number" id="dispatched" class="small-text" value="{dispatched}"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="priority">Prioridad</label></th>
                    <td><input name="priority" type="number" id="priority" class="small-text" value="{priority}"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="priority">Published</label></th>
                    <td><input name="status" type="checkbox" {status} id="status" value="publish"></td>
                </tr>
            </table>
            <p class="submit">
                <button type="submit" class="button-primary">' . ($is_edit ? 'Guardar cambios' : 'Guardar clave') . '</button>
                <a href="' . $cancel_url . '" class="button">Cancelar</a>
            </p>
        </form>
    </div>

    <script>
    function waolmSyncProductSelection() {
        var select = document.getElementById("product_name");
        var hiddenInput = document.getElementById("product");
        var skuInput = document.getElementById("waolm_sku");

        var selectedOption = select.options[select.selectedIndex];
        hiddenInput.value = selectedOption.getAttribute("value1") || "";
        skuInput.value = selectedOption.getAttribute("data-sku") || "";

        return true;
    }

    document.addEventListener("DOMContentLoaded", function() {
        waolmSyncProductSelection();
    });
    </script>';

    return str_replace(
        ['{_key}', '{product}', '{waolm_sku}', '{activations}', '{dispatched}', '{priority}','{status}','{id_input}'],
        [
            esc_attr($data['_key']),
            esc_attr($data['product']),
            esc_attr($data['waolm_sku']),
            esc_attr($data['activations']),
            esc_attr($data['dispatched']),
            esc_attr($data['priority']),
            esc_attr($status),
			$id_input,
        ],
        $template
    );
}
// Funcion de borrado
function waolm_handle_delete($id) {
    if (!current_user_can('edit_others_products')) {
        wp_die(__('No tienes permisos suficientes para realizar esta acción.'));
    }

    if (!isset($_GET['_wpnonce']) || !wp_verify_nonce($_GET['_wpnonce'], 'waolm_delete_key_' . $id)) {
        wp_die(__('El enlace de borrado no es válido o ha expirado.'));
    }

    global $wpdb;
    $table = $wpdb->base_prefix . 'waolicensemanager_keys';

    $wpdb->delete($table, ['id' => $id]);

    wp_redirect(network_admin_url('admin.php?page=waolm_licensemanager_admin'));
    exit;
}


// Registro del menu

function waolm_network_menu() {
	if ( ! is_network_admin() ) {
		return;
	}
	
	// Menú principal
	add_menu_page(
		'WAO License Manager',         // Título de la página 
		'WAO License Manager',         // Título del menú
		'edit_others_products',                // Capacidad requerida
		'waolm_licensemanager_admin',             // Slug del menú
		'waolm_render_licensemanager_admin_page',        // Callback de la página (listado)
		'dashicons-admin-network',            // Ícono
		6                                // Posición
	);

	// Submenú "Add New Key"
	add_submenu_page(
		'waolm_licensemanager_admin',             // Parent slug
		'Add New Key',                   // Título de la página
		'Add New Key',                   // Título del menú
		'edit_others_products',                // Capacidad requerida
		'waolm-network-cpt-new',         // Slug
		'waolm_render_add_form'         // Callback para la nueva key
	);

	// Submenú "Server Settings"
    add_submenu_page(
        'waolm_licensemanager_admin',  // slug del menú principal
        'Server settings',  // Título de la página
        'Server Settings',  // Título del menú
        'edit_others_products', // Capacidad necesaria para ver este menú
        'waolm_server_config',   // Slug del submenú
        'waolm_server_config_page1' // Función que renderiza la página del submenú
    );


}

add_action( 'network_admin_menu', 'waolm_network_menu' );

// PAGINA DE CONFIGURACION DEL SERVER

function waolm_server_config_page1() {
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'api';
    waolm_save_network_options();
	?>
    <div class="wrap">
        <h2>Configuración WAOLM License Manager</h2>
        <h2 class="nav-tab-wrapper">
            <a href="?page=waolm_server_config&tab=server_config" class="nav-tab <?php echo $active_tab == 'server_config' ? 'nav-tab-active' : ''; ?>">Server Configuración</a>
			<?php if(current_user_can('manage_network_options')){?>
            <a href="?page=waolm_server_config&tab=api" class="nav-tab <?php echo $active_tab == 'api' ? 'nav-tab-active' : ''; ?>">API</a>
			<?php } ?>
        </h2>

        <?php if ($active_tab == 'server_config') : pestana_server_config() ?>
        <?php else : pestana_api();?>
        <?php endif; ?>
    </div>
    <?php
}
// guardar las opciones
function waolm_save_network_options() {
    if (isset($_POST['submit'])) {
        check_admin_referer('waolm_update_api_key');
        if (isset($_POST['waolm_server_api_key'])) {
			$options['waolm_server_api_key']=$_POST['waolm_server_api_key'];
            $x=is_multisite()?update_blog_option(1,'_waolm_server_options', $options):update_option('_waolm_server_options', $options);
        }
    }
}

function pestana_api(){
	if(!current_user_can('manage_network_options')){return;}
	$template ='
            <form method="post" action="">
				{nonce_field}
                <h3>API</h3>
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="waolm_server_api_key">API Server Access Key</label></th>
                        <td>
                            <input type="text" id="waolm_server_api_key" name="waolm_server_api_key" value="{server_api_key}" class="regular-text">
                            <button type="button" onclick="generateApiKey()">Generar</button>
                        </td>
                    </tr>
                </table>
				<div>{boton}</div>
            </form>
            <script>
            function generateApiKey() {
                var result = "";
                var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
                var charactersLength = characters.length;
                for (var i = 0; i < 15; i++) {
                    result += characters.charAt(Math.floor(Math.random() * charactersLength));
                }
                document.getElementById("waolm_server_api_key").value = result;
            }
            </script>
	';
	$waolm_server_options = is_multisite()?get_blog_option(1,'_waolm_server_options',[]):get_option('_waolm_server_options',[]);
	$waolm_server_api_key=isset($waolm_server_options['waolm_server_api_key'])?$waolm_server_options['waolm_server_api_key']:""; 
	//$boton = submit_button('Guardar Cambiosss', 'primary', 'submit', true); 
	$boton = '<input type="submit" name="submit" id="submit" class="button button-primary" value="Guardar Cambios">';

	$template = str_replace("{nonce_field}",wp_nonce_field("waolm_update_api_key"),$template);
	$template = str_replace("{server_api_key}",$waolm_server_api_key,$template);
	$template = str_replace("{boton}",$boton,$template);

	echo $template;
}


function pestana_server_config(){
	$mensaje = "Para futuras versiones. :)";
	$template ='
            <form method="post" action="">
				{nonce_field}
                <h3>AUN NADA QUE CONFIGURAR</h3>
				<p>{mensaje}</p>
            </form>
	';
	$template = str_replace("{nonce_field}",wp_nonce_field("waolm_update_api_key"),$template);
	$template = str_replace("{mensaje}",$mensaje,$template);

	echo $template;
}