<?php
/** 
* Plugin Name: WAO License Manager
* Description: Auto dispatch software keys at completed order email.(Envia correo completed a admin) 
* Version: 4.0.0
* Date: 2025.08.10
* Change Log: (Nuevas tablas y migración. Cambio de disparador para despacho automatico. Inserta en productos metadato _download_link a partir de idioma y sku, Funcion waolm_generate_download_links 
 Corregido: No genera link de descarga cuando no se configuro producto. Duplica llaves al actualizar. Corregido: mostrar llaves solo cuando comprado. Modificado: uso de templates. Link de pago mudado a stephanpay plugin. Link de pago para stephanpay en la thankyoupage. Boton para actualizar llaves aun no enviadas en edicion de orden. La configuracion para mostrar llaves en la checkout page ahora en WAOLM Client Setting. Toda orden se acualiza a completed corregido. Funcion de actualizacion solo se dispara en la pagina de plugins de la red. Warnings corregidos. Cambio de logica en despacho automatico) 
* Author: Arturo Zubieta 
* Author URI: https://winandoffice.com/ 
* Text Domain: waolicensemanager
* WC requires at least: 3.2.0 
* WC tested up to: 3.3.0 
* License: GPL-2.0+ 
* License URI: https://www.gnu.org/licenses/gpl-2.0.txt 
*/

/* ESTRUCTURA DE LAS VARIABLES USADAS EN EL PLUGIN
 *	SERVER:	wp_options[_waolm_server_options]
 *		- API
 *			apiserverkey
 *	SERVER:	wp_options[_waolm_client_options]
 *		- General
 *			s:10:"urlmanuals";s:31:"https://esd.dl-winandoffice.com";
 *			s:8:"payments";s:257:"cod|ppec_paypal";
 *			s:14:"llavesquemadas";s:0:"";
 *			s:10:"tolerancia";s:0:"";
 *			s:6:"new_to";s:22:"artux@winandoffice.com";
 *			s:11:"purgar_keys";s:0:"";
 *		- Migracion
 *		- Checkout page
 *			s:18:"thankyou_show_keys";s:0:"";
 *		- API client setting
 *			s:14:"external_server_on";s:2:"on";
 *			s:14:"externalserver";s:32:"https://arturo.winandoffice.com/";
 *			s:10:"api_client";s:15:"7YPUdHRqgcuPXrU";	 
 *	CLIENT:wp_xx_options[_waolm_options]
 *		- Templates
 *			s:14:"email_template";s:511:"<hr><h2>{titulo}</h2>";
 *			s:17:"checkout_template";s:1927:"<style>"; 
*/

// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'WAOLM_PLUGIN_VERSION' ) ) {
	define( 'WAOLM_PLUGIN_VERSION', '4.0.0' );
}
if ( ! defined( 'WAOLM_PLUGIN_DIR_PATH' ) ) {
	define( 'WAOLM_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

// CARGAR IDIOMAS  
function waolicensemanager_load_textdomain() {
    load_plugin_textdomain( 'waolicensemanager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'waolicensemanager_load_textdomain' );

include("waolm-update.php"); // Logica de actualización
include ("classes/waolm-migrate.php");  // Funciones de migración
include ("classes/waolm-migration-cron.php"); // Funciones de migración cron

if(is_multisite()){ 
	if (function_exists('paso1_concluido')){
		if(paso1_concluido()){
			require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt-table.php' );
		}else{
			require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt-network.php' ); // CPT en network
		}
	}else{
		require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt-table.php' );
	}

	include ("classes/waolm-client-settings-network.php"); // config de cliente en network
	include ("classes/waolm-client-settings-site.php"); // config de cliente en site
}else{
	include ("classes/waolm-cpt.php"); // CPT en local (antiguo)
	include ("classes/waolm-client-settings-nomultisite.php"); // Server y client config local (antiguo)
}

include ("classes/waolm-insert-keys-on-customer-email.php"); // El motor del plugin
include ("classes/waolm-llavesclientemetabox.php"); 
include ("classes/waolm-susllaves-en-edit-order.php");
include ("classes/waolm-tests.php");  
include ("classes/waolm-keys-on-thankyou-page.php");

if(migracion_final_concluida()){
	include ("classes/waolm_querys_new.php"); 
	organizar_waolm_options_1();
}else{
	include ("classes/waolm_querys.php"); 
}

// Bloque para instanciar pestanias de automatic dispatch en producto
require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-pestana-en-producto.php' );

add_action( 'plugins_loaded', 'waolm_pestanias_init' );//Instancia de clase en waolm-client-functions.php
function waolm_pestanias_init() {
	if ( is_admin() ) {
		$WAOLM_Pestania = new WAOLM_Pestania();
		$WAOLM_Pestania->init();
	}
}

// funciones de ayuda
function wdepu($valor){
	$depu = get_option('_depu',[]);
	$depu[] = $valor;
	update_option('_depu',$depu);
}

function organizar_waolm_options_0(){
	$migrar = get_waolm_client_option('ya_migro_options');
	if($migrar=="xxx"){
		$waolm_options = is_multisite()?get_blog_option(1,"_waolm_options"):get_option("_waolm_options");
		foreach($waolm_options as $name => $option){
			if ($name == "email_template"){
				$new_options["email_template"] = $option;
			}
			if ($name == "checkout_template"){
				$new_options["checkout_template"] = $option;
			}
			if ($name == "payments"){ 
				$new_options["payments"] = $option;
			}
			if ($name == "urlmanuals"){
				$new_options["urlmanuals"] = $option;
			}
		}
		is_multisite()?update_blog_option(1,"_waolm_client_options",$new_options):update_option("_waolm_client_options",$new_options);

		$client_options = is_multisite()?get_blog_option(1,'_waolm_migration'):get_option('_waolm_migration');
		$client_options['ya_migro_options']=1;
		is_multisite()?update_blog_option(1,"_waolm_migration",$client_options):update_option("_waolm_migration",$client_options);
	}
}
function organizar_waolm_options_1(){
	$server_id = is_multisite()?get_blog_option(1,"_waolm_server_id"):get_option("_waolm_server_id");
	if(isset($server_id)&&$server_id<>"xxx"){
		delete_option("_waolm_server_id");
		delete_option("_waolm_templates");
	}
}

function migracion_final_concluida(){

	if(version_compare( WAOLM_PLUGIN_VERSION, '4.0.0', '>=' )){
		if (function_exists('paso2_concluido')){
			return paso2_concluido();
		}else{
			return true; // si la version es superior y no existe es porque ya se elimino migrate.php
		}
	}else{
		return false; // si la version es menor y no existe, es porque la migració ni se ejecutó
	}
	//return paso3_concluido(); // en waolm-migrate.php
}
