<?php
/*
 * AGREGAR CAJA METABOX EN ORDER EDIT PARA MOSTRAR LLAVES COMPRADAS POR EL CLIENTE
 * 2024-03-01
 * v1
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


function agregar_1metabox_llaves() {
    add_meta_box(
        'llaves_cliente', // ID único del metabox
        'Llaves compradas por este cliente', // Título del metabox
        'mostrar_contenido_metabox', // Función para mostrar el contenido
        'shop_order', // Tipo de post (en este caso, orden)
        'normal', // Contexto (normal, side, advanced) 
        'high' // Prioridad (high, default, low)
    );
}
add_action('add_meta_boxes', 'agregar_1metabox_llaves');

function mostrar_contenido_metabox($post) {
    $order_id = $post->ID;
    $order = wc_get_order($order_id);
    $customer_email = $order->get_billing_email();
    echo '<div style="text-align:center;"><button id="mostrar-llaves" type="button" data-email="' . esc_attr($customer_email) . '" class="button">Mostrar las llaves </button></div>';
    echo '<div id="tabla-llaves"></div>';
}


function cargar_jquery_en_admin() {
    wp_enqueue_script('jquery');
}

function insertar_codigo_en_footer() {
    // Verifica si estamos en la página de edición de una orden
    global $pagenow;
    if ($pagenow === 'post.php' && isset($_GET['post']) && get_post_type($_GET['post']) === 'shop_order') {
		$rutafile = plugin_dir_url(__FILE__).'classes/waolm-obtener-datos.php'
        ?>
<style>
	#tabla-llaves table{
		max-width:100%;
		margin:auto;
		text-align: center;
	}
	#tabla-llaves td{
		padding:0!important;
		width:100%!important;
		font-size:11px;
	}
	.fecha{height:40px;vertical-align: middle!important;}
	.nomproducto{text-transform: uppercase;font-weight: bold;vertical-align: middle!important;}
	.llave{font-weight: bold;vertical-align: middle!important;}
	.orden{vertical-align: middle!important;text-align:center;}
	.sku{vertical-align: middle!important;}
	.tfecha{width:50px;text-align:center!important;}
	.tnomproducto{width:250px;text-align:center!important;}
	.tllave{width:200px;text-align:center!important;}
	.torden{width:50px;text-align:center!important;}
	.tsku{width:50px;text-align:center!important;}
</style>
<script>
jQuery(document).ready(function($) {
    $('#mostrar-llaves').on('click', function() {
        var customerEmail = $(this).data('email'); // Obtiene el correo electrónico del atributo data-email
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>', // URL correcta
            type: 'POST',
            data: {
                action: 'obtener_datos_llaves', // Asegúrate de pasar la acción aquí
                email: customerEmail, // Envía el correo electrónico como parte de los datos
                // cualquier otro dato que necesites enviar
            },
            success: function(data) {
                // Tu código para manejar la respuesta 
                // Construye la tabla con los datos recibidos wp-list-table 
				var template1 = '<br><table  class="widefat fixed striped"><thead><tr><th class="tfecha">Fecha</th><th class="tnomproducto">Producto</th><th class="tllave">Llave</th><th class="torden">&Oacute;rden</th><th class="tsku">SKU</th><th class="tsku">SITE</th></tr></thead><tbody>{filas}</tbody></table>';
				var template2 = '<tr><td class="fecha">{fecha}</td><td class="nomproducto">{nomproducto}</td><td class="llave">{llave}</td><td class="orden">{orden}</td><td class="sku">{sku}</td><td class="sku">{site_id}</td></tr>';
				//sku_ant =  data[0].nombre_producto;

				var tr = "";
				var trs = "";

                for (var i = 0; i < data.length; i++) {
					tr = template2.replace('{llave}',data[i].Llave);
					tr = tr.replace('{fecha}',data[i].Fecha);
					tr = tr.replace('{nomproducto}',data[i].Producto);
					//data[i].sku = data[i].sku === null ? "-" : data[i].sku;
					//ruta = '<?php echo get_option("home");?>/wp-admin/post.php?post=' + data[i].Orden + '&action=edit';
					ruta = data[i].Siteurl + '/wp-admin/post.php?post=' + data[i].Orden + '&action=edit';
					linkorden = '<a href="'+ ruta +'" target="_blank">' + data[i].Orden + '</a>';
					tr = tr.replace('{orden}',linkorden);
					tr = tr.replace('{sku}',data[i].Sku);
					tr = tr.replace('{site_id}',data[i].Site);
					trs += tr;
                }
                tablaHtml = template1.replace('{filas}',trs);

                // Inserta la tabla en el div #tabla-llaves
                $('#tabla-llaves').html(tablaHtml);
            },
            error: function() { 
                alert('Error al obtener los datos');
            }
        });
    });
});
</script> 
 
        <?php
    }
}
add_action('admin_footer', 'insertar_codigo_en_footer');

// Para usuarios logueados
add_action('wp_ajax_obtener_datos_llaves', 'manejar_peticion_ajax');

function manejar_peticion_ajax() {
    // Aquí manejas la petición y devuelves los datos. Por ejemplo:
	$customer_email = isset($_POST['email']) ? sanitize_email($_POST['email']) : '';
	// Funcion en waolm-insert-keys-on-customer-email.php
	$retorno = get_keys_purchased_by_email($customer_email);

    wp_send_json($retorno);
    wp_die();
}


