<?php
if ( ! defined('ABSPATH') ) exit;

/** Helpers **/
function waolm_base_table( $suffix ) {
    global $wpdb;
    return $wpdb->base_prefix . ltrim($suffix, '_');
}
function waolm_db_table_exists( $table ) {
    global $wpdb;
    return $wpdb->get_var( $wpdb->prepare("SHOW TABLES LIKE %s", $table) ) === $table;
}
function waolm_force_table_collate( $table, $collate = 'utf8mb4_general_ci' ) {
    global $wpdb;
    if ( waolm_db_table_exists($table) ) {
        // Fuerza charset + collate. No falla si ya coincide.
        $wpdb->query( "ALTER TABLE `{$table}` CONVERT TO CHARACTER SET utf8mb4 COLLATE {$collate}" );
    }
}

/**
 * INSTALACIÓN
 * - Crea las tablas con tus funciones existentes.
 * - Fuerza collation utf8mb4_general_ci en todas.
 */
function waolm_plugin_install_tables() {
    // 1) Crear tablas con tus funciones
    if ( function_exists('waolm_create_table_waolicensemanager_keys') ) waolm_create_table_waolicensemanager_keys_1();
    if ( function_exists('waolm_create_table_waolm_dispatched_keys') )   waolm_create_table_waolm_dispatched_keys_1();
    if ( function_exists('waolm_create_table_waolm_rel_orders') )        waolm_create_table_waolm_rel_orders_1();
    if ( function_exists('waolm_create_table_waolm_rel_orders_keys') )   waolm_create_table_waolm_rel_orders_keys_1();
    if ( function_exists('waolm_products_install_table_network') )       waolm_products_install_table_network(); // wp_waolm_product

    // 2) Forzar collation en todas las tablas recién creadas (por si el entorno no lo respetó)
    $tables = [
        waolm_base_table('waolicensemanager_keys'),
        waolm_base_table('waolm_dispatched_keys'),
        waolm_base_table('waolm_rel_orders'),
        waolm_base_table('waolm_rel_orders_keys'),
        waolm_base_table('waolm_product'),
    ];
    foreach ( $tables as $t ) {
        waolm_force_table_collate( $t, 'utf8mb4_general_ci' );
    }
}

/**
 * ACTUALIZACIÓN
 * - Convertir a utf8mb4_general_ci:
 *   wp_waolicensemanager_keys, wp_waolm_product, wp_waolm_rel_orders, wp_waolm_rel_orders_keys
 * - Borrar tabla wp_waolm_dispatched_keys (si existe).
 */
function waolm_plugin_upgrade_schema() {
    global $wpdb;

    // 1) Forzar collation en las 4 tablas indicadas
    $to_convert = [
        waolm_base_table('waolicensemanager_keys'),
        waolm_base_table('waolm_product'),
        waolm_base_table('waolm_rel_orders'),
        waolm_base_table('waolm_rel_orders_keys'),
    ];
    foreach ( $to_convert as $t ) {
        waolm_force_table_collate( $t, 'utf8mb4_general_ci' );
    }

    // 2) Borrar tabla no usada
    $t_dispatched = waolm_base_table('waolm_dispatched_keys');
    if ( waolm_db_table_exists($t_dispatched) ) {
        $wpdb->query( "DROP TABLE IF EXISTS `{$t_dispatched}`" );
    }
}

 /*——— Ejemplos de enganche (opcional) ———*/
register_activation_hook( __FILE__, 'waolm_plugin_install_tables' );
add_action('admin_init', 'waolm_plugin_upgrade_schema'); // o controla por versión


// DESDE AQUI YO

function waolm_create_table_waolicensemanager_keys_1() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolicensemanager_keys';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde el blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['table_wp_waolicensemanager_keys_created'])) return;

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        _key TEXT NOT NULL,
        product BIGINT NOT NULL,
        product_name VARCHAR(255),
        activations INT DEFAULT 0,
        dispatched INT DEFAULT 0,
        priority INT DEFAULT 0,
        waolm_sku VARCHAR(100),
        status VARCHAR(20) DEFAULT 'publish',
        PRIMARY KEY (id),
        KEY product (product),
        KEY waolm_sku (waolm_sku),
        KEY status (status)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['table_wp_waolicensemanager_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_dispatched_keys_1() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_dispatched_keys';
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        sku VARCHAR(100),
        product_name VARCHAR(255),
        customer_email VARCHAR(255),
        order_id BIGINT NOT NULL,
        `key` TEXT NOT NULL,
        date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        site_id INT NOT NULL,
        site_url VARCHAR(255) NOT NULL,
        PRIMARY KEY (id),
        KEY order_id (order_id),
        KEY site_id (site_id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	$sql_drop = "DROP TABLE $table_name";
    dbDelta($sql_drop);
    dbDelta($sql);
	
    // Obtener opción desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    $migration['table_wp_waolm_dispatched_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_rel_orders_1() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_rel_orders';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['wp_waolm_rel_orders_created'])) return; 

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        order_id BIGINT NOT NULL,
        customer_email VARCHAR(255) NOT NULL,
        site_id INT NOT NULL,
        site_url VARCHAR(255) NULL,
        date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        sended TINYINT(1),
        PRIMARY KEY (id),
        KEY order_id (order_id),
        KEY customer_email (customer_email)
    ) $charset_collate;";
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['wp_waolm_rel_orders_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_rel_orders_keys_1() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_rel_orders_keys';
    $orders_table = $wpdb->base_prefix . 'waolm_rel_orders';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['wp_waolm_rel_orders_keys_created'])) return;

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        rel_order_id BIGINT UNSIGNED NOT NULL,
        sku VARCHAR(100),
        product_name VARCHAR(255),
        `key` TEXT NOT NULL,
        dispatched TINYINT(1) DEFAULT 0,
        priority INT DEFAULT 0,
        PRIMARY KEY (id),
        KEY rel_order_id (rel_order_id),
        CONSTRAINT fk_rel_order_id FOREIGN KEY (rel_order_id) REFERENCES $orders_table(id) ON DELETE CASCADE
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['wp_waolm_rel_orders_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}


