<?php
/**
 * Class WAO Segundo email settings file.
 * (linea 62 se valida si es multisite)
 * @package waosegundoemail\Emails 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\OAuth;
// Import Google OAuth 2.0 provider
use League\OAuth2\Client\Provider\Google;
use League\OAuth2\Client\Grant\RefreshToken;
// Load Composer's autoloader

if ( ! class_exists( 'wao_segundo_correo_config', false ) ) :

	class SegundoEmailSettings {
		var $message ="";
		var $message_test ="";

		private $allowedHtml = array(
			'input'  => array(
				'type'             => array(),
				'id'               => array(),
				'name'             => array(),
				'value'            => array(),
				'class'            => array(),
				'style'            => array(),
				'data-attached-to' => array()
			),
			'textarea'  => array(
				'id'               => array(),
				'name'             => array(),
				'value'            => array(),
				'class'            => array(),
				'style'            => array(),
				'disabled'         => false,
				'data-attached-to' => array(),
			),
			/*'select' => array(
				'id'    => array(),
				'name'  => array(),
				'value' => array(),
				'class' => array(),
			),
			'option' => array(
				'value'    => array(),
				'selected' => array(),
			),*/
		);
	

		public function __construct() {
			
			add_action('admin_menu', array($this, 'add_segundoemail_menu')); 
			add_action('admin_init', array($this, 'register_segundoemail_settings'));
			add_action('woocommerce_admin_order_data_after_billing_address', array($this, 'correo2enviado')); //Inserta un testigo en pagina order
			


			if(isset($_GET['page']) && $_GET['page'] == "segundoemail_settings") {
				add_action('admin_enqueue_scripts', [$this, 'wao_segundo_correo_sheet']); 
			}

			add_action( 'wp_ajax_process_wao_email', [$this,'process_wao_email'] );
			add_action( 'wp_ajax_nopriv_process_wao_email', [$this,'process_wao_email'] ); // Allow non-logged in users to like
		}
		
		public function wao_segundo_correo_sheet($hook){
			//first register sthe style sheet and then enqueue
			wp_register_style( 'wao_segundo_bootstrap_css', URL_WAO_MAIL. 'admin/css/bootstrap.min.css', false, '1.0.0' );
			wp_enqueue_style( 'wao_segundo_bootstrap_css' );

			wp_register_style( 'wao_segundo_email_css', URL_WAO_MAIL. 'admin/css/wao_segundo_email_css.css', false, '1.0.0' );
			wp_enqueue_style( 'wao_segundo_email_css' );

			wp_enqueue_script( "wao_segundo_bootstrap_js", URL_WAO_MAIL . 'admin/js/bootstrap.bundle.js', array(), '1.0.0' );
			wp_enqueue_script( "wao_segundo_correo_js", URL_WAO_MAIL . 'admin/js/wao_segundo_email.js', array(), '1.0.5' );

			wp_localize_script( 'wao_segundo_correo_js', 'wao_object', 
				array( 
					'ajax_url' => admin_url( 'admin-ajax.php' ),
					'nonce' => wp_create_nonce('wao-segundo-correo-nonce')
				)
			);
		}


		public function process_wao_email() {
			check_ajax_referer( 'wao-segundo-correo-nonce', 'nonce' );  // Check the nonce.
			$email_test = (isset($_POST['email_test']) && $_POST['email_test'] != '')? filter_var($_POST['email_test'], FILTER_SANITIZE_EMAIL):'';
			$res = "";
			if ($email_test && $resAux = $this->test_smtp_settings($email_test)){
				$res = $resAux;
			}else{
				$res ="Revise la configuracion de SMTP! O LAS CLAVES DE GOOGLE";
				$res = $resAux;
			}
			echo $res;
			wp_die(); 
		}



		public function add_segundoemail_menu() {
//                        title		             menutit	     	   capacidad	        slug		funcion			 			logo 	   pos
//	add_menu_page('WAO Marketing system', 'WAOLM Marketing System', 'manage_options','waoem_config','waoem_ordenes_no_completadas',$waoem_logo, 14);

			add_menu_page(
				'Alternate Email Settings',
				'Alternate Email',
				'manage_options',
				'segundoemail_settings',
				array($this, 'render_segundoemail_settings_page'),
				'dashicons-email',
				9
			);
		}
		//Dibujamos completamente los tabs y agregamos la option de test
		public function render_segundoemail_settings_page() {
			?>
			<div class="container">
				<h2 class="h2 mt-3">Alternate email configuration.</h2>
				<p>This configuration applies to sending the completed order email from another SMTP</p>
				<form method="post" action="options.php">
					<?php settings_fields('segundoemail_options_group'); ?>

					<ul class="nav nav-tabs" id="myTab" role="tablist">
						<li class="nav-item mb-0" role="presentation">
							<button class="nav-link active" id="settings-tab" data-bs-toggle="tab" data-bs-target="#settings" type="button" role="tab" aria-controls="settings" aria-selected="true">Settings</button>
						</li>
						<li class="nav-item mb-0" role="presentation">
							<button class="nav-link" id="test-tab" data-bs-toggle="tab" data-bs-target="#test" type="button" role="tab" aria-controls="test" aria-selected="false">Test Email</button>
						</li>
					</ul>
					<div class="tab-content" id="myTabContent">
						<div class="tab-pane fade show active" id="settings" role="tabpanel" aria-labelledby="settings-tab">
							<div class="mt-3">
								<?php do_settings_sections('segundoemail_settings'); ?>
							</div>
						</div>
						<div class="tab-pane fade" id="test" role="tabpanel" aria-labelledby="test-tab">
							<div class="mt-3">
								<?php do_settings_sections('segundoemail_settings_test'); ?>
							</div>
						</div>
					</div>
					<?php submit_button(); ?>
				</form>

			</div>
			<?php
		}


		public function register_segundoemail_settings() {
			register_setting('segundoemail_options_group', 'segundoemail_options', array($this, 'sanitize_segundoemail_options'));

			$this->configSection();
			$this->testSection();
		}

		private function configSection() {
			add_settings_section('segundoemail_section', '2do SMTP configuration ', array($this, 'segundoemail_section_callback'), 'segundoemail_settings');

			add_settings_field('activo', 'Activate', array($this, 'activo_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('host', 'Host', array($this, 'host_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('username', 'Username', array($this, 'username_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('password', 'Password', array($this, 'password_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('smtptipo', 'SMTP Type', array($this, 'smtptipo_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('google_smtp', 'Google SMTP', array($this, 'google_smtp_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('client_id', 'Client ID', array($this, 'client_id_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('client_secret', 'Client Secret', array($this, 'client_secret_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('token_google', 'Token Google', array($this, 'token_google_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			add_settings_field('redirect_url_google', 'Redirect Url', array($this, 'redirect_url_google_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			
			add_settings_field('port', 'Port', array($this, 'port_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			//
			if(is_multisite()){
				add_settings_field('maestro', 'Master Config', array($this, 'maestro_field_callback'), 'segundoemail_settings', 'segundoemail_section');
			}
		}

		private function testSection() {
			add_settings_section(
				'segundoemail_section_test', 
				'Email test', 
				array($this, 'segundoemail_section_test_callback'), 
				'segundoemail_settings_test'
			);
	
			add_settings_field(
				'segundoemail__server_input',
				__( 'Email Test URL', 'segundo_correo' ),
				[ $this, 'textCallBack' ],
				'segundoemail_settings_test',
				'segundoemail_section_test',
				[ 'id' => 'woa_email_test', 'required' => "required", 'default' => "rusland.rojas@gmail.com"]
			);


			add_settings_field(
				'segundoemail__server_area',
				__( 'Email Test Result', 'segundo_correo' ),
				[ $this, 'textCallBackArea' ],
				'segundoemail_settings_test',
				'segundoemail_section_test',
				[ 'id' => 'segundoemail__server_area', 'required' => "required", 'disabled'=> true ]
			);

			add_settings_field(
				'testbutton', 
				'Test Configuration', 
				array($this, 'test_button_callback'), 
				'segundoemail_settings_test', 
				'segundoemail_section_test'
			);
			
		}

		public function segundoemail_section_test_callback(){
			echo $this->message_test;
		}

		public function segundoemail_section_callback(){
			echo $this->message;
		}

		public function sanitize_segundoemail_options($input) {
			$sanitized_input = array();

			if (isset($input['activo'])) {
				$sanitized_input['activo'] = sanitize_text_field($input['activo']);
			}

			if (isset($input['host'])) {
				$sanitized_input['host'] = sanitize_text_field($input['host']);
			}

			if (isset($input['username'])) {
				$sanitized_input['username'] = sanitize_text_field($input['username']);
			}

			if (isset($input['password'])) {
				$sanitized_input['password'] = sanitize_text_field($input['password']);
			}

			if (isset($input['smtptipo'])) {
				$sanitized_input['smtptipo'] = sanitize_text_field($input['smtptipo']);
			}
			if (isset($input['google_smtp'])) {
				$sanitized_input['google_smtp'] = sanitize_text_field($input['google_smtp']);
			}
			if (isset($input['client_id'])) {
				$sanitized_input['client_id'] = sanitize_text_field($input['client_id']);
			}
			if (isset($input['client_secret'])) {
				$sanitized_input['client_secret'] = sanitize_text_field($input['client_secret']);
			}
			if (isset($input['token_google'])) {
				$sanitized_input['token_google'] = sanitize_text_field($input['token_google']);
			}
			if (isset($input['redirect_url_google'])) {
				$sanitized_input['redirect_url_google'] = sanitize_text_field($input['redirect_url_google']);
			}

			if (isset($input['port'])) {
				$sanitized_input['port'] = intval($input['port']);
			}

			if (isset($input['segundoemail__server_input'])) {
				$sanitized_input['segundoemail__server_input'] = sanitize_text_field($input['segundoemail__server_input']);
			}

			if (isset($input['maestro'])) {
				if(is_multisite()){
					$sites=get_sites();
					foreach($sites as $site){
						switch_to_blog($site->blog_id);
							update_option('segundoemail_options',$sanitized_input);
						restore_current_blog();
					}
				}
			}
			return $sanitized_input;
		}
		
		public function test_button_callback() {
			echo '<button name="wao_test_smtp" id="wao_test_smtp" class="button button-secondary">
					<span class="text-initial">Send Test</span>
					<div class="spinner-border" role="status">
  						<span class="sr-only"></span>
					</div>
				</button>';
		}
		public function activo_field_callback() {
			$options = get_option('segundoemail_options');
			$checkd = isset($options['activo'])&&$options['activo']==1?"checked ":"";
			echo '<input type="checkbox" class="form-control" name="segundoemail_options[activo]" '.$checkd.'value="1">';
		}

		public function host_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control" name="segundoemail_options[host]" value="' . esc_attr($options['host'] ?? '') . '">';
		}

		public function username_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control" name="segundoemail_options[username]" value="' . esc_attr($options['username'] ?? '') . '">';
		}

		public function password_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="password" class="form-control" name="segundoemail_options[password]" value="' . esc_attr($options['password'] ?? '') . '">';
		}

		public function google_smtp_field_callback() {
			$options = get_option('segundoemail_options');
			$checkd = isset($options['google_smtp'])&&$options['google_smtp']==1?"checked ":"";
			echo '<input type="checkbox" class="form-control" id="google_smtp" name="segundoemail_options[google_smtp]" '.$checkd.'value="1">';
		}

		public function client_id_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control google-smtp" name="segundoemail_options[client_id]" value="' . esc_attr($options['client_id'] ?? '') . '">';
		}
		
		public function client_secret_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control google-smtp" name="segundoemail_options[client_secret]" value="' . esc_attr($options['client_secret'] ?? '') . '">';
		}

		public function token_google_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control google-smtp" name="segundoemail_options[token_google]" value="' . esc_attr($options['token_google'] ?? '') . '"><br>';
			echo '<a href="#" class="button button-primary account-activate">Oath Google</a>';
		}

		public function redirect_url_google_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="text" class="form-control google-smtp" name="segundoemail_options[redirect_url_google]" value="'.home_url().'/wp-admin/admin.php?page=segundoemail_settings" disabled>';
		}


		public function smtptipo_field_callback() {
			$options = get_option('segundoemail_options');
			$smtptipo = isset($options['smtptipo']) ? $options['smtptipo'] : '';
			echo '<select class="form-control" name="segundoemail_options[smtptipo]">
				<option value="ssl" ' . selected($smtptipo, 'ssl', false) . '>SSL</option>
				<option value="tls" ' . selected($smtptipo, 'tls', false) . '>TLS</option>
			</select>';
		}

		public function port_field_callback() {
			$options = get_option('segundoemail_options');
			echo '<input type="number" class="form-control" name="segundoemail_options[port]" value="' . esc_attr($options['port'] ?? '') . '">';
		}

		public function maestro_field_callback() {
			echo '<input type="checkbox" class="form-control" name="segundoemail_options[maestro]"  value="1">(Use this config for all sites.)';
		}

		function send_smtp_email( $phpmailer ) {
			
		}
		function set_my_mail_content_type() {
			return "text/html";
		}
		
		function test_smtp_settings($email_test) {
			$phpmailerResult = '';
			try{
				$segundoemail_options = get_option( 'segundoemail_options' );
				// Gmail API credentials
				$clientId = $segundoemail_options['client_id'];
				$clientSecret = $segundoemail_options['client_secret'];
				$email = $segundoemail_options['username'];
				$refreshToken = '1//06c3a_x-lRwb0CgYIARAAGAYSNwF-L9IrzLELOL19RT9zML5I1R2KVliiHPDBKCsK84j-gBVoSoywc04LmBKyfIVcVdZFLhn_7jU';
				$send_to = $email_test;


				$mail = new PHPMailer();
				$mail->isSMTP();
				//$mail->SMTPDebug = SMTP::DEBUG_SERVER;
				$mail->Host = 'smtp.gmail.com';
				$mail->Port = 465;
				$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
				$mail->SMTPAuth = true;

				$mail->AuthType = 'XOAUTH2';
				$provider = new Google(
					[
						'clientId' => $clientId,
						'clientSecret' => $clientSecret,
						'redirectUri'  => 'https://softwarelizenzexpress.de/?wao=google-redirect',
						'accessType'   => 'offline',
					]
				);



				$mail->setOAuth(
					new OAuth(
						[
							'provider' => $provider,
							'clientId' => $clientId,
							'clientSecret' => $clientSecret,
							'refreshToken' => $refreshToken,
							'userName' => $email,
						]
					)
				);

				$mail->setFrom($email, 'Test');
				$mail->addAddress($send_to);
				$mail->Subject = 'Test Message';
				$mail->CharSet = PHPMailer::CHARSET_UTF8;
				$mail->Body = 'Here is the message with <strong>HTML content</strong>';
				$mail->AltBody = 'This is a plain-text message body';
				$mail->IsHTML(true);

				

				//send the message, check for errors
				if (!$mail->send()) {
					$phpmailerResult = 'Mailer Error: ' . $mail->ErrorInfo;
				} else {
					$phpmailerResult = 'Message sent!';
				}
			}
			catch(Exception $e) {
				// TODO(developer) - handle error appropriately
				$phpmailerResult = 'Message: ' .$e->getMessage();
			}
			

			return $phpmailerResult;
		}

		// In theme's functions.php or plug-in code:

		function wpse27856_set_content_type(){
			return "text/html";
		}
		


		function correo2enviado($order){
			$order_id=$order->get_id();
			$email2 = get_post_meta($order_id,'email2sent',true)?"<span class='dashicons dashicons-yes' style='color:green;'></span>":"<span class='dashicons dashicons-no' style='color:red;'></span>";
			echo "<div style='background-color:#fff;border:solid #d7cad2 1px;border-radius:5px;padding:5px;margin-bottom:5px;width:98%'><i class='fas fa-envelope'></i>&nbsp;Se envio 2do correo por smtp alternativo?: ".$email2."</div>";
		}



		// - - - - - - - - - - - - - - METODOS PARA CONSTRUIR INPUTS, TEXTAREAS, SELECTS
		public function textCallBack( $args ) {
			$id        = isset( $args['id'] ) ? esc_attr( $args['id'] ) : '';
			$required  = isset( $args['required'] ) ? esc_attr( $args['required'] ) : '';
			$className = isset( $args['className'] ) ? esc_attr( $args['className'] ) : '';
			$options = get_option('segundoemail_options');
			$value     = isset($args['default'] ) ? esc_attr( $args['default'] ) : $options['id'];
			
			$html = '<input id="' . $id . '" class="form-control ' . $className . '" ' . $required . ' name="wao_segundo_test[' . $id . ']" type="text" size="40" value="' . $value . '">';
			echo wp_kses( $html, $this->allowedHtml );
		}
		public function textCallBackArea( $args ) {
			$id        = isset( $args['id'] ) ? esc_attr( $args['id'] ) : '';
			$required  = isset( $args['required'] ) ? esc_attr( $args['required'] ) : '';
			$className = isset( $args['className'] ) ? esc_attr( $args['className'] ) : '';
			$value     = isset( $args['default'] ) ? esc_attr( $args['default'] ) : $this->message;

			$disabled  = isset( $args[ 'disabled' ] ) && $args[ 'disabled' ]==1 ? 'disabled' : '';
	
			$html = '<textarea id="' . $id . '" class="form-control ' . $className . '" ' . $required . ' name="wao_segundo_test[' . $id . ']" '.$disabled.'>' . $value . '</textarea>';
			echo wp_kses( $html, $this->allowedHtml );
		}
		public function selectCallBack( $args ) {
			$options = get_option( 'plugnmeet_settings' );
			$id            = isset( $args['id'] ) ? esc_attr( $args['id'] ) : '';
			$value         = isset( $options[ $id ] ) ? esc_attr( $options[ $id ] ) : $args['default'];
			$selectOptions = $args['options'];
			$html = '<select id="' . $args['id'] . '" name="plugnmeet_settings[' . $id . ']" value="' . $value . '">';
			foreach ( $selectOptions as $option ) {
				if ( $value === $option ) {
					$html .= '<option value="' . $option . '" selected>' . $option . '</option>';
				} else {
					$html .= '<option value="' . $option . '" >' . $option . '</option>';
				}
			}
			$html .= '</select>';
			echo wp_kses( $html, $this->allowedHtml );
		}
	}

endif;
