<?php
/*
 * ENTRADA DEL NUEVO PLUGIN PAYPAL 
 * V 2.0 2024.11.11 Se queda solo lo necesario
 * paypal-receiver para paymentes ppcp
*/

defined( 'ABSPATH' ) || exit; 

///MENU PAYPAL///
{
	$GLOBALS['estilo']='
	<style>
		.contenedor{padding:20px;margin:5px;background-color:GhostWhite;border:solid 1px gray;border-radius:15px;box-shadow:2px 2px 2px 1px rgba(0, 0, 0, 0.2)}
		p {font-size:18px;}
		.contenedor input{width:300px;}
		.contenedor th{width:120px;text-align:left;}
		.cambios{}
		table.minimalistBlack {
		  border: 3px solid #000000;
		  width: 100%;
		  text-align: left;
		  border-collapse: collapse;
		}
		table.minimalistBlack td, table.minimalistBlack th {
		  border: 1px solid #000000;
		  padding: 5px 4px;
		}
		table.minimalistBlack tbody td {
		  font-size: 13px;
		}
		table.minimalistBlack thead {
		  background: #CFCFCF;
		  background: -moz-linear-gradient(top, #dbdbdb 0%, #d3d3d3 66%, #CFCFCF 100%);
		  background: -webkit-linear-gradient(top, #dbdbdb 0%, #d3d3d3 66%, #CFCFCF 100%);
		  background: linear-gradient(to bottom, #dbdbdb 0%, #d3d3d3 66%, #CFCFCF 100%);
		  border-bottom: 3px solid #000000;
		}
		table.minimalistBlack thead th {
		  font-size: 15px;
		  font-weight: bold;
		  color: #000000;
		  text-align: left;
		}
		table.minimalistBlack tfoot {
		  font-size: 14px;
		  font-weight: bold;
		  color: #000000;
		  border-top: 3px solid #000000;
		}
		table.minimalistBlack tfoot td {
		  font-size: 14px;
		}
		.mensajes{border-radius:3px;background-color:#FFFFEC;}
		.mensajes ul{padding-left:10px;list-style-type:circle;margin-left:10px;}
		.rojito{color:red;}
		.nomostrar {display:disabled;}
	</style>
	';
	$GLOBALS['estilowidget']="
	<style> 
		widget1{
		}
		.widget1 th {
			text-align:center;border-bottom:solid 1px Gainsboro;font-weight:ligther;font-family:Gergia, sans-serif;color:gray;font-size:12px;
		}
		.widget1 td {
			border-bottom:solid 1px Gainsboro;
		}
		.widget2 td {
			border-bottom:none;
		}
		.textoligero{
			color:gray;font-size:13px;font-style:italic;
		}
		.textomedio{
			color:SteelBlue;font-size:15px;font-style:italic;background-color:#f4f6f6
		}
		.textofuerte{
			font-size:16px;
		}
		.boton_yes{
			background-color:E9F5F0;border:solid 1px YellowGreen; border-radius:10px;color:YellowGreen;font-size:11px;
		}
		.boton_no{
			background-color:LightPink;border:solid 1px Crimson; border-radius:10px;color:Crimson;font-size:11px;width:35px;text-align:center;
		}
		.reset{
			font-size:11px;color:Crimson;cursor:pointer; 
		}
		.ifhidden{
			display:none;
		}
		.ifshow{
			display:block;
		}
		.alto{
			height:40px;
			vertical-align:middle;
		}
	</style>
	";
}
{

// Registrar el menú de administración
function registrar_menu_paypals() {
		$pplogo="data:image/svg+xml;base64,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";


    add_menu_page(
        'Paypals',
        'Paypals',
        'manage_options',
        'paypals_menu',
        'mostrar_pagina_paypals',
		$pplogo,
		10
    );

    // Añadir submenús
    add_submenu_page(
        'paypals_menu',
        'Instrucciones',
        'Instrucciones',
        'manage_options',
        'paypals_instrucciones',
        'mostrar_pagina_instrucciones'
    );

    add_submenu_page(
        'paypals_menu',
        'Configuracion',
        'Configuracion',
        'manage_options',
        'paypals_configuracion',
        'mostrar_pagina_configuracion'
    );

    add_submenu_page(
        'paypals_menu',
        'Historial de cambios',
        'Historial de cambios',
        'manage_options',
        'paypals_historial',
        'mostrar_pagina_historial'
    );
}
//add_action('admin_menu', 'registrar_menu_paypals');

// Función para mostrar la página principal de Paypals
function mostrar_pagina_paypals() {
    $template = '
	{estilo}
	<div class="contenedor">
		<h1>¡Bienvenido a Paypals!</h1>
		<p>El plugin paypals ha cambiado!</p>
		<p>Para ver como obtener los datos para el nuevo plugin, vea las instrucciones.</p>
	</div>
	';
	$template=str_replace("{estilo}",$GLOBALS['estilo'],$template);
    echo $template;
}

// Función para mostrar la página de Instrucciones
function mostrar_pagina_instrucciones() {
	$template = '
	{estilo}
	<div class="contenedor" style="width:60%;margin:auto;margin-top:150px;">
	<h1 style="text-align:center;">Instrucciones</h1>
	<hr>
	<p>Como obtener usuario de paypal para el plugin <b>Paypal Payments</b></p>
	<dl>
		<dt>Obtener email (Live Email address)</dt>
		<dd><ul><li>Usamos el email de la cuenta paypal.</li></ul></dd>
		<dt>Live Merchan Id</dt>
		<dd>
			<ul>
			<li>Ingresamos al siguiente link: <a  target="_blank" href="https://www.paypal.com/businessmanage/account/aboutBusiness">https://www.paypal.com/businessmanage/account/aboutBusiness</a></li>
			<li>Obtenemos el <b>Id. del comercio de PayPal (Ej:4WQBHH38VQE8G)</b></li>
			</ul>
		</dd>
		<dt>Live Client Id y Live Secret Key</dt>
		<dd>
			<ul>
			<li>Ingresamos al siguiente link: <a target="_blank"  href="https://developer.paypal.com/dashboard/applications/live">https://developer.paypal.com/dashboard/applications/live</a></li>
			<li>Si no existe una cuenta ya creada, debemos crear una</li>
			<li>Le asignamos un nombre que nos permita identificarlo facilmente(Ej:shop4-pais)</li>
			<li>Del listado de cuentas, seleccionamos la que acabamos de crear y podemos copiar el <b>Client Id</b> y el <b>Secret Key</b></li>
			<li></li>
			<li></li>
			</ul>
		<dt>Color de Paypal</dt>
		<dd>
			<ul>
				<li>Esta opcion es propia de nuestra administración.</li>
				<li>Seleccionar de la lista desplegable, el color correspondiente.</li>
		</dd>
	</dl>
	</div>
	';
    // Agrega más pasos según sea necesario
	$template=str_replace("{estilo}",$GLOBALS['estilo'],$template);
    echo $template;
}

// Función para mostrar la página de Configuración
function mostrar_pagina_configuracion() {
    // Obtener las opciones actuales
    // Procesar y guardar la configuración al enviar el formulario
	$mensajes=array();
    if (isset($_POST['guardar_configuracion'])) {
        // Actualizar las opciones con los valores del formulario
        //$options['mensaje'] = sanitize_text_field($_POST['mensaje']);
        $options['excluidos'] = sanitize_text_field($_POST['excluidos']);
        $options['nro_dias'] = intval($_POST['nro_dias']); // Convertir a entero
        //$options['fecha_final'] = sanitize_text_field($_POST['fecha_final']);

        // Actualizar las opciones en la base de datos
        if(update_option('_paypalnew_options', $options)){
			$mensajes[]="Guardado con &eacute;xito :)";
		}else{
			$mensajes[]="Ups!, algo ha fallado :(";
			//var_dump(update_option('_paypalnew_options', $options));
		}
		//update_option('_paypalnew_options', $options);
    }

    $options = get_option('_paypalnew_options', array());
	if(empty($options)){
		$options = array('excluidos'=>'manuals','nro_dias'=>'25');
		update_option('_paypalnew_options',$options);
	}
	$template='
    {estilo}
	<div class="contenedor" style="width:60%;margin:auto;margin-top:150px;">
	<h1 style="text-align:center;">Configuración</h1>
	{mensajes}
	<hr>
    <form method="post" action="">
	<table style="margin:auto">
		<!--<tr>
			<th><label for="mensaje">Mensaje:</label></th>
			<td><input type="text" name="mensaje" value="{mensaje}" /></td>
		</tr>-->
		<tr class="{nomostrar}">
			<th><label for="excluidos">Excluidos:</label></th>
			<td><input type="text" name="excluidos" value="{excluidos}" /></td>
		</tr>
		<tr class="{nomostrar}">
			<th><label for="nro_dias">Nro. de días:</label></th>
			<td><input type="number" name="nro_dias" value="{nro_dias}" /><br>(Que se muestra en los widgets de dashboard cuando esta configurado.)</td>
		</tr>
		<!--<tr>
			<th><label for="fecha_final">Fecha final:</label></th>
			<td><input type="date" name="fecha_final" value="{fecha_final}" /></td>
		</tr>-->
		<tr style="height:50px;">
			<td></th>
			<td><input type="submit" name="guardar_configuracion" style="background-color:#9ADE7B;border-radius:3px;" value="Guardar" /></td>
		</tr>
	</table>
    </form>
	</div>
	';
	if(is_multisite()&&get_current_blog_id()==1){
		$template=str_replace("{nomostrar}","",$template);
	}else{
		$template=str_replace("{nomostrar}","nomostrar",$template);
	}
	
	$msjs = mensajes($mensajes);
	$template=str_replace("{mensajes}",$msjs,$template);
	$template=str_replace("{estilo}",$GLOBALS['estilo'],$template);
	//$template = str_replace("{mensaje}", esc_attr($options['mensaje']), $template);
	$template = str_replace("{excluidos}", esc_attr($options['excluidos']), $template);
	$template = str_replace("{nro_dias}", esc_attr($options['nro_dias']), $template);
	//$template = str_replace("{fecha_final}", esc_attr($options['fecha_final']), $template);
	echo $template;
}

// Función para mostrar la página de Historial de cambios
function mostrar_pagina_historial() {
	//$historialx = array (array('user'=>'arturozubieta@gmail.com','date'=>'2023-12-01','allsales'=>'150.00'));
	//$today = date('Y-m-d H:i:s');
	//$historialx = get_option("pp_history");
	//$historialx[]=array('user'=>'pedro@nada.com','date'=>$today,'allsales'=>'22.15');
	//update_option("pp_history",$historialx);
	$linea=""; 
	$historial = get_option("pp_history",array());
	foreach($historial as $tr){
		$linea .= '<tr><td>'.$tr['user'].'</td><td>'.$tr['date'].'</td><td>'.$tr['allsales'].'</td></tr>';
	}
    $template =  '
    {estilo}
	<div class="contenedor" style="width:60%;margin:auto;margin-top:150px;">
	<h1 style="text-align:center;">Historial de cambios</h1>
	<hr>
	<div>Esta tabla muestra los paypals que fueron cambiados, en que fecha (de salida) y con cuanto dinero (aproximado).</div><br>
	<table class="minimalistBlack">
		<thead>
		<tr>
			<th>Paypal User</th>
			<th>Changed date</th>
			<th>Total sales</th>
		</tr>
		</thead>
		<tbody>
		{datos}
		</tbody>
	</table>
	</div>
	';
	$template=str_replace("{estilo}",$GLOBALS['estilo'],$template);
	$template = str_replace("{datos}",$linea,$template);
    echo $template;
}
	
}

///AGREGAR UN INPUT PARA COLOR A CONFIGURACION DE PAYPAL SEGUN PLUGIN///
{

function agregar_contenido_personalizado_payments() {
    // Verificar si estamos en la página de configuración de PayPal en WooCommerce
    if (isset($_GET['page']) && $_GET['page'] === 'wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'checkout' && 
		isset($_GET['section']) && $_GET['section'] === 'ppcp-gateway' && isset($_GET['ppcp-tab']) && $_GET['ppcp-tab'] === 'ppcp-connection') {
		if(isset($_POST['paypal_color'])){
			update_option('pp_color',$_POST['paypal_color']);
		}
		
		if(isset($_POST['ppcp']['merchant_email_production'])){
			cuando_cambia_paypal_user($_POST['ppcp']['merchant_email_production']);
		}
		$selyellow="";
		$selgreen="";
		$color=get_option('pp_color');
		switch($color){case 'yellow':$selyellow='selected';break;case 'green':$selgreen='selected';break;}
		$html='<th><label for=paypal_color>Color de PayPal1:</label></th><td><select name=paypal_color id=paypal_color><option value=red  >Red</option><option value=yellow '.$selyellow.' >Yellow</option><option value=green '.$selgreen.' >Green</option></select></td>';
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Obtener el elemento tr por su id
                var trElement = document.getElementById('field-merchant_email_sandbox');
                // Verificar si el elemento tr existe antes de agregar el div
                if (trElement) {
                    // Crear un nuevo div
                    var nuevoDiv = document.createElement('tr');
                    nuevoDiv.innerHTML = '<?php echo $html; ?>';
                    // Insertar el nuevo div antes del elemento tr
                    trElement.parentNode.insertBefore(nuevoDiv, trElement);
                }
            });
        </script>
        <?php
    }
}

function agregar_contenido_personalizado_checkout() {
    // Verificar si estamos en la página de configuración de PayPal en WooCommerce
    if (isset($_GET['page']) && $_GET['page'] === 'wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'checkout' && 
		isset($_GET['section']) && $_GET['section'] === 'ppec_paypal') {
		if(isset($_POST['paypal_color'])){
			update_option('pp_color',$_POST['paypal_color']);
		}
		if(isset($_POST['woocommerce_ppec_paypal_api_username'])){
			$u = str_replace("_api1.","@",$_POST['woocommerce_ppec_paypal_api_username']);
			cuando_cambia_paypal_user($u);
		}
		$selyellow="";
		$selgreen="";
		$color=get_option('pp_color');
		switch($color){case 'yellow':$selyellow='selected';break;case 'green':$selgreen='selected';break;}
		$html='<tr><th style="text-align:left;width:330px;"><label for=paypal_color>Color de PayPal2:</label></th><td><select name=paypal_color id=paypal_color><option value=red  >Red</option><option value=yellow '.$selyellow.' >Yellow</option><option value=green '.$selgreen.' >Green</option></select></td></tr>';
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Obtener el elemento tr por su id
                var trElement = document.getElementById('woocommerce_ppec_paypal_paypal_hosted_settings');
                // Verificar si el elemento tr existe antes de agregar el div
                if (trElement) {
                    // Crear un nuevo div
                    var nuevoDiv = document.createElement('table');
                    nuevoDiv.innerHTML = '<?php echo $html; ?>';
                    // Insertar el nuevo div antes del elemento tr
                    trElement.parentNode.insertBefore(nuevoDiv, trElement);
                }
            });
        </script>
        <?php
    }
}

function agregar_contenido_personalizado_gateway() {
    // Verificar si estamos en la página de configuración de PayPal en WooCommerce
    if (isset($_GET['page']) && $_GET['page'] === 'wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'checkout' && 
		isset($_GET['section']) && $_GET['section'] === 'ppcp_api') {
		if(isset($_POST['paypal_color'])){
			update_option('pp_color',$_POST['paypal_color']);
		}
		if(isset($_POST['pp_paypal_receiver'])){
			//update_option("pp_current_user",$newuser);
			cuando_cambia_paypal_user($_POST['pp_paypal_receiver']);
		}
		$selyellow="";
		$selgreen="";
		$color=get_option('pp_color');
		$pp_paypal_receiver=get_option('pp_current_user');
		switch($color){case 'yellow':$selyellow='selected';break;case 'green':$selgreen='selected';break;}
		$html='<table class="form-table"><tr valign="top"><th scope="row" class="titledesc"><label for=paypal_color>Color de PayPal3:</label></th><td class="forminp"><select name=paypal_color id=paypal_color><option value=red  >Red</option><option value=yellow '.$selyellow.' >Yellow</option><option value=green '.$selgreen.' >Green</option></select></td></tr><tr valign="top"><th scope="row" class="titledesc"><label for="pp_paypal_receiver">Email<span class="woocommerce-help-tip" tabindex="0" aria-label="Importante! Este dato se mostrar&aacute; en el widget."></span></label></th><td class="forminp"><input class="input-text regular-input" type="text" name="pp_paypal_receiver" id="pp_paypal_receiver" style="" value="'.$pp_paypal_receiver.'" placeholder=""><span style="margin-left:5px;font-size:12px;color:gray;">Importante colocar este dato!</span></td></tr></table>';
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Obtener el elemento tr por su id
                var h3Element = document.getElementById('woocommerce_ppcp_api_title');
                // Verificar si el elemento tr existe antes de agregar el div
                if (h3Element) {
                    // Crear un nuevo div
                    nuevoDiv = '<?php echo $html; ?>';
                    // Insertar el nuevo div antes del elemento tr
                    //h3Element.parentNode.insertBefore(nuevoDiv, h3Element);
					h3Element.insertAdjacentHTML('afterend', nuevoDiv);
                }
            });
        </script>
        <?php
    }
}

switch (get_paypal_payment_method()){
	case "payments":
		add_action('admin_footer', 'agregar_contenido_personalizado_payments');
		break;
	case "checkout":
		add_action('admin_footer', 'agregar_contenido_personalizado_checkout');
		break;
	case "gateway":
		add_action('admin_footer', 'agregar_contenido_personalizado_gateway');///EL ULTIMO GRITO
		break;
}
	
}

///CREAR WIDGET DE RED///
{
if(is_multisite()){
	//add_action('wp_network_dashboard_setup','agregar_widget_red');
}//add_action('wp_dashboard_setup','dcms_agregar_widget');
function agregar_widget_red(){
	wp_add_dashboard_widget('id_mi_widget','Active Paypals for all sites','mostrar_widget_red');
}
function mostrar_widget_red(){
	$sites = get_sites(array('archived' => 0));
	$excluidos = get_paypalsnew_option('excluidos');
	if(is_bool($excluidos)){
		$excluidos="ninguno";
		update_paypalsnew_option("nro_dias",25);
		update_paypalsnew_option("excluidos","manuals");
	}
	$excluded = explode("|",$excluidos);
	foreach ( $sites as $site ) {
		switch_to_blog( $site->blog_id );
		$excluded_site = false;
		$url = get_option('home');
		foreach ($excluded as $exclude) {
			if (strpos($url, $exclude) !== false) {
				$excluded_site = true;
				break;
			}
		}
		if(!$excluded_site){
			unset($fil);
			$fil = array();
			$fil['url'] = $url;
			$fil['ppmethod']=get_paypal_payment_method();
			$fil['xdias'] = get_paypalsnew_option('nro_dias');
			switch($fil['ppmethod']){
				case "payments":
					$option = get_option('woocommerce-ppcp-settings');
					$fil['user'] = $option['merchant_email'];
					$fil['colorspan'] = paypal_color_span(get_option('pp_color','red'));
					$fil['nombreplugin'] = "Paypal payments";
					//$fil['link'] = $url.'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp-gateway';
					//$fil['link'] = $url.'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp-gateway&ppcp-tab=ppcp-connection';
					break;
				case "checkout":
					$option = get_option('woocommerce_ppec_paypal_settings');
					$olduser = $option['api_username'];
					$fil['user'] = str_replace("_api1.","@",$olduser);
					$fil['colorspan'] = paypal_color_span(get_option('pp_color','red'));
					$fil['nombreplugin'] = "Paypal Checkout";
					//$fil['link'] = $url.'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppec_paypal';
					break;
				case "gateway":
					//$option = get_option('woocommerce_ppec_paypal_settings');
					$fil['user'] = get_option('pp_current_user','configurar!');
					$fil['colorspan'] = paypal_color_span(get_option('pp_color','red'));
					$fil['nombreplugin'] = "Payment Plugin for Paypal";
					break;
				case "nomethod":
					$fil['user']="NO USER";
					$fil['colorspan'] = paypal_color_span('x');
					$fil['nombreplugin'] = "No Plugin active";
					//$fil['link'] = '#';
			}
			//$fil['xdiassales']=xdiasfromoptions($fil['xdias'], $fil['user']);
			$fil['todaysales']=get_option('pp_todaysales',0);
			$filas[]=$fil;
		}
		restore_current_blog();
	}// fin de for sites
	$filashtml="";  
	foreach($filas as $fila){
		$template1='
		<tr>
		<td width="10%" style="font-size:20px;">{iconmethod}</td>
		<td>
		<span style="padding-top:5px;padding-bottom:5px;display:inline-block;" class="textofuerte"><a href="{wpadmin}">{site}</a></span>
		<table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#ebedef">
		<tbody>
			<tr align="center" style="background-color:#F5F5F5">
				<th width="44%">Data</th>
				<th width="55%">Value</th>
			</tr>
			<tr align="left">
				<td>{link}Paypal plugin{/link}</td>
				<td><div style="text-align:center">{link}{paymentmethod}{/link}</div></td>
			</tr>
			<tr align="left">
				<td>Paypal user</td>
				<td style=""><div style="text-align:center;border:solid 1px #A0C49D;border-radius:3px;padding:3px;text-decoration:none;background-color:#F7FFE5"><a>{user}</a></div></td>
			</tr>
			<tr align="left">
				<td>Today sales</td>
				<td><div style="text-align:center">{todaysales}</div></td>
			</tr>
		</tbody>
		</table>
		</td>
		</tr>
		';
		switch ($fila['ppmethod']){
			case 'checkout':
					$link = $fila['url'].'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppec_paypal';
					$a = '<a target="_blank" href="'.$link.'">';
					$template1 = str_replace("{link}",$a,$template1);
					$template1 = str_replace("{/link}",'</a>',$template1);
				break;
			case 'payments':
					$link = $fila['url'].'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp-gateway&ppcp-tab=ppcp-connection';
					$a = '<a target="_blank" href="'.$link.'">';
					$template1 = str_replace("{link}",$a,$template1);
					$template1 = str_replace("{/link}",'</a>',$template1);
				break;
			case 'gateway': 
					$link = $fila['url'].'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp_api';
					$a = '<a target="_blank" href="'.$link.'">';
					$template1 = str_replace("{link}",$a,$template1);
					$template1 = str_replace("{/link}",'</a>',$template1);
				break;
			default:
					$template1 = str_replace("{link}",'',$template1);
					$template1 = str_replace("{/link}",'',$template1);
				
		}
		$template1=str_replace("{site}",$fila['url'],$template1);
		//$template1=str_replace("{siteid}",$fila->site_id,$template1);
		$template1=str_replace("{wpadmin}",$fila['url']."/wp-admin/",$template1);
		$template1=str_replace("{paymentmethod}",$fila['nombreplugin'],$template1);
		$template1=str_replace("{iconmethod}",$fila['colorspan'],$template1);
		$template1=str_replace("{user}",$fila['user'],$template1);
		$template1=str_replace("{xdias}",$fila['xdias'],$template1);
		//$template1=str_replace("{xdayssales}",$fila['xdiassales'],$template1);
		$template1=str_replace("{todaysales}",$fila['todaysales'],$template1);
		$filashtml.=$template1;
	} 
	$template = '{estilo}
		<table class="widget1">
			<tbody>
				<tr>
					<th width="10%" style="border-bottom:solid 1px black;">COLOR</th>
					<th width="89%" style="border-bottom:solid 1px black;">INFORMATION</th>
				</tr>
				{datos}
			</tbody>
		</table>
	';
	$template = str_replace("{estilo}",$GLOBALS['estilowidget'],$template);
	$template = str_replace("{datos}",$filashtml,$template);
	//$template = str_replace("{test}",$excluded[1],$template);
	echo $template;
}
	
}
///CREAR WIDGET DE PAIS///
{
//Accion Hook por pais
//add_action('wp_dashboard_setup','agregar_widget_pais');

//Agregar Widget por pais
function agregar_widget_pais(){
	wp_add_dashboard_widget('id_mi_widget','Active Paypal for this site','mostrar_widget_pais');
}

//Mostrar Widget por pais
function mostrar_widget_pais(){
	$ppmethod=get_paypal_payment_method();
	if($ppmethod<>'nomethod'){
		$template='
		<table class="widget1">
			<tbody>
				<tr>
					<th width="10%" style="border-bottom:solid 1px black;">COLOR</th>
					<th width="89%" style="border-bottom:solid 1px black;">INFORMATION</th>
				</tr>
				<tr>
				<td width="10%" style="font-size:20px;">{iconmethod}</td>
				<td>
				<span style="padding-top:5px;padding-bottom:5px;display:inline-block;" class="textofuerte"><a href="{wpadmin}">{site}</a></span>
				<table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#ebedef">
				<tbody>
					<tr align="center" style="background-color:#F5F5F5">
						<th width="44%">Data</th>
						<th width="55%">Value</th>
					</tr>
					<tr align="left">
						<td>{link}Paypal plugin{/link}</td>
						<td><div style="text-align:center">{link}{paymentmethod}{/link}</div></td>
					</tr>
					<tr align="left">
						<td>Paypal user</td>
						<td style=""><div style="text-align:center;border:solid 1px #A0C49D;border-radius:3px;padding:3px;text-decoration:none;background-color:#F7FFE5">{user}</div></td>
					</tr>
					<tr align="left">
						<td>Today sales</td>
						<td><div style="text-align:center">{todaysales}</div></td>
					</tr>
				</tbody>
				</table>
				</td>
				</tr>
			</tbody>
		</table>
		';

		switch ($ppmethod){
			case 'checkout':
					$link = get_option('home').'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppec_paypal';
					$a = '<a target="_blank" href="'.$link.'">';
					$template = str_replace("{link}",$a,$template);
					$template = str_replace("{/link}",'</a>',$template);
					$template = str_replace("{paymentmethod}",'Paypal Checkout',$template);
				break;
			case 'payments':
					$link = get_option('home').'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp-gateway&ppcp-tab=ppcp-connection';
					$a = '<a target="_blank" href="'.$link.'">';
					$template = str_replace("{link}",$a,$template);
					$template = str_replace("{/link}",'</a>',$template);
					$template = str_replace("{paymentmethod}",'Paypal Payments',$template);
				break;
			case 'gateway':
					$link = get_option('home').'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ppcp_api';
					$a = '<a target="_blank" href="'.$link.'">';
					$template = str_replace("{link}",$a,$template);
					$template = str_replace("{/link}",'</a>',$template);
					$template = str_replace("{paymentmethod}",'Payment plugin for Paypal',$template);
				break;
			default:
					$template = str_replace("{link}",'',$template);
					$template = str_replace("{/link}",'',$template);
					$template = str_replace("{paymentmethod}",'No active method',$template);
		}

		$template = str_replace("{site}",get_option('home'),$template);
		$template = str_replace("{wpadmin}",get_option('home')."/wp-admin",$template);
		$template = str_replace("{iconmethod}",paypal_color_span(get_option('pp_color','red')),$template);
		$template = str_replace("{user}",get_old_paypal_user(),$template);
		//$template = str_replace("{paymentmethod}",nombreplugin(),$template);
		$template = str_replace("{todaysales}",get_option('pp_todaysales',0),$template);
	}else{
		$template = '<div style=padding-bottom:10px;>Paypal payment method is not active:</div> 
				<div class="textomedio">Activate the paypal payment method to see it here</div>
				<hr>
				<div class="curtime"><span id="timestamp">Changed on: </span></div>
				<div style="text-align:right;"></div>
				</div>';
	}
	echo $template;
}	
	
}

///POR VENTA PAGADA POR PAYPAL INCREMENTAR LOS SUMADORES///
{
	
function actualizaventapaypal($order_id){
	$order = new WC_Order( $order_id );
	$payment_method = $order->get_payment_method();	
							//checkout		payments		gateway
	$metodos_admitidos=array("ppcp-gateway","ppec_paypal","ppcp");
	if (in_array($payment_method, $metodos_admitidos)) {
		$total = $order->get_total();
		//date_default_timezone_set('America/La_Paz');
		$lastsale = get_option('pp_lastsale',array());

		//Actualizamos DIA pp_todaysales
		if(empty($lastsale)){
			// por inicio, lastsale estará vacío
			update_option('pp_todaysales',$total);
		}else{
			if($lastsale['mday']==date('j')){ // aqui error Illegal string offset 'mday' CORREGIDO
				$monto = floatval(get_option('pp_todaysales',0));
				update_option('pp_todaysales',$monto+$total);
			}else{
				update_option('pp_todaysales',0);
			}
		}
		//Actualizamos MES _ppmonthsales
		if(empty($lastsale)){
			// por inicio, lastsale estará vacío
			update_option('pp_monthsales',$total);
		}else{
			if($lastsale['mon']==date('m')){ // aqui error Illegal string offset 'mday'
				$monto = floatval(get_option('pp_monthsales',0));
				update_option('pp_monthsales',$monto+$total);
			}else{
				update_option('pp_monthsales',0);
			}
		}
		//Actualizamos ALL 
		$monto = floatval(get_option('pp_allsales',0));
		update_option('pp_allsales',$monto+$total); //aqui error A non-numeric value encountered 
		update_option('pp_lastsale',getdate()); 
		
	}//fin de si metodo de pago es paypal

}

//add_action( 'woocommerce_order_status_completed', 'actualizaventapaypal'  );
	
}


///FUNCIONES COMUNES///
///POR ACTUALIZACION DE PAYPAL USER(Disparado por las funciones: agregar_contenido_personalizado_payments() o agregar_contenido_personalizado_checkout()
///- GUARDAR HISTORIAL EN wp_options pp_history
///- CEREAR LOS SUMADORES DE VENTAS
function cuando_cambia_paypal_user($newuser){
	//$olduser=get_old_paypal_user();
	$olduser=get_option('pp_current_user','*');
	if($newuser<>$olduser){
		$history = get_option("pp_history",array());
		$today = date('Y-m-d H:i:s');
		$history[]=array('user'=>$olduser,'date'=>$today,'allsales'=>get_option('pp_allsales'),'credentials'=>credentials());
		update_option("pp_history",$history);
		update_option("pp_allsales",0);
		update_option("pp_todaysales",0);
		update_option("pp_monthsales",0);
		update_option("pp_current_user",$newuser);
	}
}
function get_old_paypal_user(){
	$ppmethod=get_paypal_payment_method();
	switch($ppmethod){
		case "payments":
			$option = get_option('woocommerce-ppcp-settings');
			$olduser = $option['merchant_email'];
			break;
		case "checkout":
			$option = get_option('woocommerce_ppec_paypal_settings');
			$olduser = $option['api_username'];
			$olduser = str_replace("_api1.","@",$olduser);
			break;
		case "gateway":
			$olduser = get_option('pp_current_user');
			break;
		case "nomethod":
			$olduser = "NO USER";
	}
	return $olduser;
}
function get_paypalsnew_option($indice="nothing"){
	$option = get_option('_paypalnew_options',"");
	if(!isset($option[$indice])){
		return FALSE;
	}else{
		return $option[$indice];
	}
}
function get_paypalsnew1_option($indice="nothing"){
	$thissite = get_current_blog_id();
	switch_to_blog(1);
		$option = get_option('_paypalnew_options',"");
		if(!isset($option[$indice])){
			$retorno = FALSE;
		}else{
			$retorno = $option[$indice];
		}
	restore_current_blog();
	return $retorno;
}
function update_paypalsnew_option($indice,$valor){
	$option = get_option('_paypalnew_options');
	if(!is_bool($option[$indice])){
		$option[$indice]=$valor;
		if (update_option('_paypalnew_options',$option)){
			return TRUE;
		}else{
			return FALSE;
		}
	}else{
		return FALSE;
	}
}
function xdias($xdias, $paypalreceiver){
	$menos_dias="- ".$xdias." days";
	$fecha_actual = date("d-m-Y");
	$fecha_menos = strtotime($fecha_actual.$menos_dias);
	$args = array(
		'numberposts'	=>	-1,
		'post_type'     => 'shop_order',
		'post_status'   => 'wc-completed',
		'meta_query' => array(
			'relation' => 'AND',
			array(
				'key' => '_payment_method_title',
				'value' => 'PayPal',
				'compare' => 'LIKE'
			),
			array(
				'key'  => '_date_completed',
				'value'   => $fecha_menos,
				'compare' => '>'
			),			
			array(
				'key'  => 'paypal_receiver',
				'value'   => $paypalreceiver,
				'compare' => '='
			)			
		),
	); 
	$orders = get_posts($args);
	$total=0;
	foreach($orders as $order){
		$total+=get_post_meta($order->ID, '_order_total', true);
	}
	return $total;
}
function paypal_color_span($_ppcategory){
	$contenido = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
	switch ($_ppcategory){
		case 'red':
			$bcolor='Pink';
			$color='Crimson';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;";
			break;
		case 'green':
			$bcolor='#E9F5F0';
			$color='YellowGreen';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;";
			break;
		case 'yellow':
			$bcolor='LemonChiffon'; 
			$color='#FFA500';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;";
			break;
		case 'x':
			$bcolor='white'; 
			$color='red';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;color:".$color.";";
			$contenido = '&nbsp;&#x2716;&nbsp;';
			break;
		case '-':
			$bcolor='red'; 
			$color='white';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;color:".$color.";";
			$contenido = '&nbsp;&ndash;&nbsp;';
			break;
		default:
			$bcolor='white';
			$color='gray';
			$style="background-color:".$bcolor.";border:solid 1px ".$color."; border-radius:15px;font-size:32px;";
	}
	//return "<span style='background-color:".$color.";border-radius:5px;widht:15px;'>&nbsp;&nbsp;&nbsp;</span>";
	$retorno = "<span style='".$style."'>".$contenido."</span>&nbsp;&nbsp;";
	//$retorno='<span class="dashicons dashicons-shield-alt" style="'.$style.'"></span>';
	return $retorno;
}
function mensajes($mensajes){
	if(sizeof($mensajes)>0){
		$msjs = '<div class="mensajes"><ul>';
		foreach($mensajes as $mensaje){
			$msjs .= '<li>'.$mensaje.'</li>';
		}
		$msjs .= '</ul></div>';
		return $msjs;
	}else{
		return '';
	}
}
function credentials(){
	switch(get_paypal_payment_method()){
		case "payments":
			$info=get_option('woocommerce-ppcp-settings',array('merchant_email'=>'new','client_secret'=>'new','client_id'=>'new','merchant_id'=>'new',));
			$retorno['merchant_email']=$info['merchant_email'];
			$retorno['client_secret']=$info['client_secret'];
			$retorno['client_id']=$info['client_id'];
			$retorno['merchant_id']=$info['merchant_id'];
			break;
		case "checkout":
			$info=get_option('woocommerce_ppec_paypal_settings',array('api_username'=>'new','api_signature'=>'new','api_password'=>'new'));
			$retorno['api_username']=$info['api_username'];
			$retorno['api_signature']=$info['api_signature'];
			$retorno['api_password']=$info['api_password'];
			break;
		case "gateway":
			$info=get_option('woocommerce_ppcp_api_settings',array('client_id_production'=>'new','secret_key_production'=>'new','merchant_id_production'=>'new'));
			$retorno['email']=get_option('pp_current_user');
			$retorno['client_id_production']=$info['client_id_production'];
			$retorno['secret_key_production']=$info['secret_key_production'];
			$retorno['merchant_id_production']=$info['merchant_id_production'];
			break;
	}
	return $retorno;
}
function nombreplugin(){
	switch(get_paypal_payment_method()){
		case "payments":
			$retorno="Paypal Standard";
			break;
		case "checkout":
			$retorno="Paypal Checkout";
			break;
		case "gateway":
			$retorno="Payment plugin for Paypal";
			break;
		default:
			$retorno="No method active";
	}
	return $retorno;
}
