<?php 
/*
 * v2.1
 * REST API PARA REPORTES E INTERACCION CON MAILTRAIN
*/
defined( 'ABSPATH' ) || exit;
// Genera un archivo .csv con emails de clientes, nombres por pais
// Retorna la URL del archivo temporal, que sera borrado en un tiempo
function generacsv(){ 
	GLOBAL $wpdb;
	$final=array();
	$carpetaoculta = "rtYlmnqtVuIO";
	if (!is_dir($carpetaoculta)) {
		mkdir($carpetaoculta, 0777, true);
	}
	$nomcorto=str_replace("http://","",$_SERVER["SERVER_NAME"]);
	$nomcorto=str_replace("https://","",$nomcorto);
	$nomcorto=str_replace(".","-",$nomcorto);
	$aleatorio = md5(uniqid(rand(), true));
	$nomcorto=$carpetaoculta.'/customers-'.$aleatorio.'-'.$nomcorto.'-timo.csv';
//	$jsonfile = $carpetaoculta."/jsonfile.json";
	if(file_exists($nomcorto)){unlink($nomcorto);}
	$fp = fopen($nomcorto, 'w');
	$total=0;
	if(is_multisite()){
		$sites=get_sites(array('archived'=>0));
		$salida = array();
		foreach($sites as $site){
			$site_id=$site->id;
			$pref=$site_id==1?"wp_":"wp_".$site_id."_";
			$q="SELECT DISTINCT email, first_name, last_name, '".$site->domain."' as DOMAIN, '".$site->path."' as PATH, '*' as DELETED FROM ".$pref."wc_customer_lookup WHERE email <> ''";
			$r=$wpdb->get_results($q);
			//$final=array_merge($final, $r);
			$c=count($r);
			$total+=$c;
			//echo "* ".$q." - ".$c."<br>";
			// Loop through file pointer and a line 
			foreach ($r as $f) {
				$new_first_name=str_replace(",","_",$f->first_name);
				$new_last_name=str_replace(",","_",$f->last_name);
				$linea=$f->email.",".$new_first_name.",".$new_last_name.",".$f->DOMAIN.",".$f->PATH.",".$f->DELETED.PHP_EOL;
				$lineaa['email']=$f->email;
				$lineaa['fname']=$new_first_name;
				$lineaa['lname']=$new_last_name;
				$lineaa['domain']=$f->DOMAIN;
				$lineaa['path']=$f->PATH;
				$lineaa['deleted']=$f->DELETED;
				$salida[]=$lineaa;
				fputs($fp, $linea); 
			}
		}
	}else{
		$pref="wp_";

		$q="SELECT DISTINCT email, first_name, last_name, '".$site->domain."' as DOMAIN, '".$site->path."' as PATH, '*' as DELETED FROM ".$pref."wc_customer_lookup WHERE email <> ''";
		$r=$wpdb->get_results($q);
		$c=count($r);
		$total+=$c;
		foreach ($r as $f) {
			//$linea=$f->email.",".$f->DOMAIN.",".$f->PATH.",".$f->DELETED.PHP_EOL;
			$new_first_name=str_replace(",","_",$f->first_name);
			$new_last_name=str_replace(",","_",$f->last_name);
			$linea=$f->email.",".$new_first_name.",".$new_last_name.",".$f->DOMAIN.",".$f->PATH.",".$f->DELETED.PHP_EOL;
			fputs($fp, $linea); 
		}
	}
	fclose($fp);	
	update_tempfile_option("wao_tempfiles",$nomcorto);
	$url= "https://".$_SERVER["SERVER_NAME"]."/".$nomcorto;//'.$url.'
	$retorno = array('download' => $url, 'cuenta' => $total);
	return $retorno;
}
// Borrar archivo temporal creado por generacsv(), cada 1 minuto
function delete_tempfile_option($nombreopcion,$nminutos=1){
	//borrar temporales    
	//$nminutos = 5;//Tiempo de vida en minutos del archivo temporal
	$tempfiles = get_option($nombreopcion,[]);
    foreach ($tempfiles as $nomfile => $fechafile) {
		$tiempoActual = time();
        $rutaArchivo = ABSPATH.'/'.$nomfile; // Asegúrate de que la ruta sea correcta
        if ($tiempoActual - $fechafile > $nminutos * 60) { // Comprobar si han pasado $nminutos
            if (file_exists($rutaArchivo)) {
                unlink($rutaArchivo); // Borrar el archivo
                unset($tempfiles[$nomfile]); // Remover de la opción
				update_option($nombreopcion,$tempfiles); 
            }
        }
    }
}//fin delete_tempfile_option
delete_tempfile_option("wao_tempfiles");//Borrar temporales .csv creados para mailtrain
// Crear una API REST 'customers' que llame a 'generacsv' y devuelva en JSON la URL del archivo temporal creado
add_action('rest_api_init', function () {
    if (get_current_blog_id()===1) { // Reemplaza con el ID del sitio dominio4 
        register_rest_route('custom/v1', '/customers', [
            'methods' => 'GET',
            'callback' => 'customers_api',
            'permission_callback' => '__return_true',
        ]);
    }
});

function customers_api() {
    // 'generacsv()' devuelve un array con la información
    $retorno = generacsv();

    // Devolvemos la respuesta directamente, no es necesario json_encode
    return new WP_REST_Response($retorno, 200, ['Content-Type' => 'application/json']);
}
// Crear un shortcode para descargar correos de clientes (de todos los paises)
add_shortcode('customers','customers_html');
function customers_html(){
    if (!current_user_can('administrator')) {
        return '<p>Nothing here.</p>';
    } 
	$template = '
		<h2>Descarga de clientes de todas las tiendas</h2>
		<p>El archivo .csv contiene los correos de clientes por paises.</p>
		<p>Total correos descargados: {total}<p>
		<a href="{url}">Download</a>
	';
	$retornado = generacsv();
	$template=str_replace("{total}",$retornado['cuenta'],$template);
	$template=str_replace("{url}",$retornado['download'],$template);
	echo $template;
}

/*
* Reporte de clientes actuales, frecuentes, leales por paises 
*/
add_shortcode('reporte','reporte_potenciales');
function reporte_potenciales(){//funcion mejorada con totales y filtrando excluidos de la configuracion de paypals
    if (!current_user_can('administrator')) {
        return '<p>Nothing here.</p>';
    } 
	$template = '
		<style>
		/* Estilo para la tabla */
		.tablareporte {
			width: 100%; /* Ancho completo de la tabla */
			border-collapse: collapse; /* Colapsar bordes */
			margin: 20px 0; /* Margen superior e inferior */
			font-size: 16px; /* Tamaño de fuente */
			text-align: center; /* Centrar texto */
		}

		/* Estilo para las celdas de la tabla */
		.tablareporte th, 
		.tablareporte td {
			padding: 12px; /* Espaciado interno */
			border: 1px solid #ccc; /* Borde de las celdas */
		}

		/* Estilo para los encabezados */
		.tablareporte th {
			background-color: #777; /* Color de fondo gris oscuro */
			color: #fff; /* Color de texto blanco */
			font-weight: bold; /* Negrita */
		}

		/* Estilo para filas impares */
		.tablareporte tr:nth-child(odd) {
			background-color: #f2f2f2; /* Color de fondo gris claro */
		}

		/* Estilo para filas pares */
		.tablareporte tr:nth-child(even) {
			background-color: #ffffff; /* Color de fondo blanco */
		}

		/* Estilo para las celdas en la primera columna (opcional) */
		.tablareporte td:first-child {
			font-weight: bold; /* Negrita en la primera columna */
		}

		/* Estilo para la tabla en pantallas pequeñas */
		@media (max-width: 768px) {
			.tablareporte {
				font-size: 14px; /* Tamaño de fuente más pequeño */
			}
		}
		</style>
		<div style="text-align:center;text-decoration:underline;">
			<h2>REPORTE DE CLIENTES ACTUALES, FRECUENTES Y POTENCIALES DE ESTE DOMINIO POR PAISES</h2>
		</div>
		<table class="tablareporte">
			<tr>
				<th>SUB-DOMINIO</th>
				<th>ACTUALES</th>
				<th>FRECUENTES</th>
				<th>LEALES</th>
				<th>TOTAL</th>
			</tr>
			{filas}
		</table>		
		
	';
	$filasget = obtener_filas(); 
	$filasstr = '';
	$sumtotalactuales=$sumtotalfrecuentes=$sumtotalleales=$sumtotalfila=0;
	foreach($filasget as $fila){
		$template_fila = '<tr><td>{subdominio}</td><td>{totalactuales}</td><td>{totalfrecuentes}</td><td>{totalleales}</td><td>{totalfila}</td></tr>';
		$template_fila = str_replace('{subdominio}',$fila['dominio'],$template_fila);
		$template_fila = str_replace('{totalactuales}',$fila['actuales'],$template_fila);
		$template_fila = str_replace('{totalfrecuentes}',$fila['frecuentes'],$template_fila);
		$template_fila = str_replace('{totalleales}',$fila['leales'],$template_fila);
		$template_fila = str_replace('{totalfila}',$fila['totalfila'],$template_fila);
		$filasstr.=$template_fila;
		$sumtotalactuales+=$fila['actuales'];
		$sumtotalfrecuentes+=$fila['frecuentes'];
		$sumtotalleales+=$fila['leales'];
		$sumtotalfila+=$fila['totalfila'];
	}
	$template_fila = '<tr style="background-color:#777;color:white;"><td>TOTAL DOMINIO</td><td>{totalactuales}</td><td>{totalfrecuentes}</td><td>{totalleales}</td><td>{totalfila}</td></tr>';
	$template_fila = str_replace('{totalactuales}',$sumtotalactuales,$template_fila);
	$template_fila = str_replace('{totalfrecuentes}',$sumtotalfrecuentes,$template_fila);
	$template_fila = str_replace('{totalleales}',$sumtotalleales,$template_fila);
	$template_fila = str_replace('{totalfila}',$sumtotalfila,$template_fila);
	$filasstr.=$template_fila;
	$template = str_replace('{filas}',$filasstr,$template);
	echo $template;
}
function obtener_filas(){
	$retorno_filas=array();
	if(is_multisite()){
		$sitios=get_sites();
		$excluidos = get_waotiendas1_option('excluidos');
		if(is_bool($excluidos)||strlen($excluidos)==0){
			$excluidos="ninguno";
		}
		$excluded = explode("|",$excluidos);
		foreach ($sitios as $sitio){
			if(!excluded_site($sitio->blog_id,$excluded)){
				$prefix = "wp_";
				$prefix .= $sitio->blog_id==1?"":$sitio->blog_id."_";
				$subdominio = $sitio->domain.$sitio->path;
				$retorno_filas[] = obtener_filas_multisingle($prefix,$subdominio);
			}
		}
	}else{
		$prefix = "wp_";
		$subdominio = get_option('home');
		$retorno_filas=obtener_filas_multisingle($prefix,$subdominio);
	}
	return $retorno_filas;
}
function obtener_filas_multisingle($prefix,$subdominio){//funcion mejorada con totales y filtrando excluidos de la configuracion de paypals
	global $wpdb;
	$totalfila=0;
	$fila_tr['dominio'] = $subdominio;
	$q = "SELECT count(R.orders)
			FROM 
			(SELECT P.meta_value AS correo, count(P.meta_value) AS orders
			  FROM  ".$prefix."postmeta P
			  WHERE P.meta_key = '_billing_email' 
			GROUP BY P.meta_value
			ORDER BY orders DESC) R
			WHERE orders = 1;";
	$res = $wpdb->get_var($q);
	$totalfila+=$res;
	//$totalactuales+=$res;
	$fila_tr['actuales'] = $res;

	$q = "SELECT count(R.orders)
			FROM 
			(SELECT P.meta_value AS correo, count(P.meta_value) AS orders
			  FROM  ".$prefix."postmeta P
			  WHERE P.meta_key = '_billing_email' 
			GROUP BY P.meta_value
			ORDER BY orders DESC) R
			WHERE orders = 2;";
	$res = $wpdb->get_var($q);
	$totalfila+=$res;
	//$totalfrecuentes+=$res;
	$fila_tr['frecuentes'] = $res;
	$q = "SELECT count(R.orders)
			FROM 
			(SELECT P.meta_value AS correo, count(P.meta_value) AS orders
			  FROM  ".$prefix."postmeta P
			  WHERE P.meta_key = '_billing_email' 
			GROUP BY P.meta_value
			ORDER BY orders DESC) R
			WHERE orders > 2;";
	$res = $wpdb->get_var($q);
	$totalfila+=$res;
	//$totalisimo+=$totalfila;
	//$totalleales+=$res;
	$fila_tr['leales'] = $res;
	$fila_tr['totalfila'] = $totalfila;
	return $fila_tr;
}
// Crear una API REST 'tablapotenciales' que llame a 'obtener filas' y devuelva un JSON con potenciales por paises
add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/reporte', [
        'methods' => 'GET',
        'callback' => 'reporte_api',
        'permission_callback' => '__return_true', // Ajusta la seguridad según sea necesario
    ]);
});
function reporte_api(){
	$retorno = obtener_filas();
    // Devolvemos la respuesta directamente, no es necesario json_encode
    return new WP_REST_Response($retorno, 200, ['Content-Type' => 'application/json']);

}
// Falta la funcion shortcode para jalar mediante api la informacion de cada dominio y plasmarla en un solo reporte
add_shortcode('reporte_total','reporte_total');
function reporte_total(){
    if (!current_user_can('administrator')) {
        return '<p>Nothing here.</p>';
    } 

	$template = '
		<style>
		/* Estilo para la tabla */
		.tablareporte {
			width: 100%; /* Ancho completo de la tabla */
			border-collapse: collapse; /* Colapsar bordes */
			margin: 20px 0; /* Margen superior e inferior */
			font-size: 16px; /* Tamaño de fuente */
			text-align: center; /* Centrar texto */
		}

		/* Estilo para las celdas de la tabla */
		.tablareporte th, 
		.tablareporte td {
			padding: 12px; /* Espaciado interno */
			border: 1px solid #ccc; /* Borde de las celdas */
		}

		/* Estilo para los encabezados */
		.tablareporte th {
			background-color: #777; /* Color de fondo gris oscuro */
			color: #fff; /* Color de texto blanco */
			font-weight: bold; /* Negrita */
		}

		/* Estilo para filas impares */
		.tablareporte tr:nth-child(odd) {
			background-color: #f2f2f2; /* Color de fondo gris claro */
		}

		/* Estilo para filas pares */
		.tablareporte tr:nth-child(even) {
			background-color: #ffffff; /* Color de fondo blanco */
		}

		/* Estilo para las celdas en la primera columna (opcional) */
		.tablareporte td:first-child {
			font-weight: bold; /* Negrita en la primera columna */
		}

		/* Estilo para la tabla en pantallas pequeñas */
		@media (max-width: 768px) {
			.tablareporte {
				font-size: 14px; /* Tamaño de fuente más pequeño */
			}
		}
		</style>
		<div style="text-align:center;text-decoration:underline;">
			<h2>REPORTE DE CLIENTES ACTUALES, FRECUENTES Y POTENCIALES DE TODAS NUESTRAS TIENDAS</h2>
		</div>
		<table class="tablareporte">
			<tr>
				<th>SITIO</th>
				<th>ACTUALES</th>
				<th>FRECUENTES</th>
				<th>LEALES</th>
				<th>TOTAL</th>
			</tr>
			{filas}
		</table>		
		
	';
	$sitios=['https://shop.winandoffice.com','https://gamecardshop.com','https://softwarelizenzexpress.de','https://softwarelicenses.net','https://digilicenses.com','https://winandoffice.de','https://tech-licenses.com','https://keyshop.windowsandoffice.com','https://technikmarkt-aschaffenburg.de/','https://winandoffice-keys.com','https://officeandwindows.com','https://winandofficews.com'];
	$sumgenactuales = $sumgenfrecuentes = $sumgenleales = $sumgenfila = 0;
	foreach($sitios as $dominio){
		$remote_host = $dominio.'/wp-json/custom/v1/reporte/';
		$dominios=obtener_json_desde_otro_dominio($remote_host);
		//buclear subdominios y plasmarlos en una tabla.
		$sumtotalactuales=$sumtotalfrecuentes=$sumtotalleales=$sumtotalfila=0;
		if(is_array($dominios) && count($dominios) > 0) {
			foreach($dominios as $fila){
				$template_fila = '<tr><td>{subdominio}</td><td>{totalactuales}</td><td>{totalfrecuentes}</td><td>{totalleales}</td><td>{totalfila}</td></tr>';
				$template_fila = str_replace('{subdominio}',$fila['dominio'],$template_fila);
				$template_fila = str_replace('{totalactuales}',$fila['actuales'],$template_fila);
				$template_fila = str_replace('{totalfrecuentes}',$fila['frecuentes'],$template_fila);
				$template_fila = str_replace('{totalleales}',$fila['leales'],$template_fila);
				$template_fila = str_replace('{totalfila}',$fila['totalfila'],$template_fila);
				$filasstr.=$template_fila;
				$sumtotalactuales+=$fila['actuales'];
				$sumtotalfrecuentes+=$fila['frecuentes'];
				$sumtotalleales+=$fila['leales'];
				$sumtotalfila+=$fila['totalfila'];
			}
			$template_fila = '<tr style="background-color:#a1a1a1;color:white;"><td>TOTAL DOMINIO</td><td>{totalactuales}</td><td>{totalfrecuentes}</td><td>{totalleales}</td><td>{totalfila}</td></tr>';
			$template_fila = str_replace('{totalactuales}',$sumtotalactuales,$template_fila);
			$template_fila = str_replace('{totalfrecuentes}',$sumtotalfrecuentes,$template_fila);
			$template_fila = str_replace('{totalleales}',$sumtotalleales,$template_fila);
			$template_fila = str_replace('{totalfila}',$sumtotalfila,$template_fila);
			$filasstr.=$template_fila;
		}//if dominio
		$sumgenactuales+=$sumtotalactuales;
		$sumgenfrecuentes+=$sumtotalfrecuentes;
		$sumgenleales+=$sumtotalleales;
		$sumgenfila+=$sumtotalfila;
	}
	$template_fila = '<tr style="background-color:#777;color:white;"><td>TOTAL GENERAL</td><td>{totalactuales}</td><td>{totalfrecuentes}</td><td>{totalleales}</td><td>{totalfila}</td></tr>';
	$template_fila = str_replace('{totalactuales}',$sumgenactuales,$template_fila);
	$template_fila = str_replace('{totalfrecuentes}',$sumgenfrecuentes,$template_fila);
	$template_fila = str_replace('{totalleales}',$sumgenleales,$template_fila);
	$template_fila = str_replace('{totalfila}',$sumgenfila,$template_fila);
	$filasstr.=$template_fila;
	$template = str_replace('{filas}',$filasstr,$template); 
	echo $template;
	
}

function obtener_json_desde_otro_dominio($url) {
	// Hacer una solicitud GET al dominio externo
	$respuesta = wp_remote_get($url);
	// Verificar si la solicitud fall贸
	if (is_wp_error($respuesta)) {
		return 'Error: ' . $respuesta->get_error_message();
	}
	// Obtener el c贸digo de estado HTTP
	$codigo_http = wp_remote_retrieve_response_code($respuesta);
	// Verificar si la respuesta es exitosa (200 OK)
	if ($codigo_http !== 200) {
		return 'Error: C贸digo de respuesta ' . $codigo_http;
	}
	// Obtener el cuerpo de la respuesta (que es el JSON)
	$cuerpo = wp_remote_retrieve_body($respuesta);
	// Decodificar el JSON en un array asociativo
	$datos = json_decode($cuerpo, true);
	// Verificar si la decodificaci贸n fue exitosa
	if (json_last_error() !== JSON_ERROR_NONE) {
		return 'Error: No se pudo decodificar el JSON';
	}
	// Retornar los datos decodificados
	return $datos;
}
