<?php
// Agregar un menú en la sección de ajustes
defined( 'ABSPATH' ) || exit;

 
// Hook para agregar el menú de administración
add_action('admin_menu', 'wao_tiendas_menu');

function wao_tiendas_menu() {
    add_menu_page(
        'WAO Tiendas',
        'WAO Tiendas',
        'manage_options',
        'wao_tiendas',
        'wao_tiendas_page_content',
        'dashicons-store',
        6
    );
}

// Función para mostrar el contenido del menú
function wao_tiendas_page_content() {
    // Tabs
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'parametros_factura';
    ?>
    <div class="wrap">
        <h2>WAO Tiendas</h2>
        <h2 class="nav-tab-wrapper">
            <a href="?page=wao_tiendas&tab=parametros_factura" class="nav-tab <?php echo $active_tab == 'parametros_factura' ? 'nav-tab-active' : ''; ?>">Parámetros Factura</a>
            <a href="?page=wao_tiendas&tab=mailtrain_tracking" class="nav-tab <?php echo $active_tab == 'mailtrain_tracking' ? 'nav-tab-active' : ''; ?>">Mailtrain Tracking</a>
            <a href="?page=wao_tiendas&tab=configurar_widgets" class="nav-tab <?php echo $active_tab == 'configurar_widgets' ? 'nav-tab-active' : ''; ?>">Configurar Widgets de Red</a>
            <a href="?page=wao_tiendas&tab=textos_anadidos" class="nav-tab <?php echo $active_tab == 'textos_anadidos' ? 'nav-tab-active' : ''; ?>">Hooks</a>
        </h2>
        <?php
        switch ($active_tab) {
            case 'parametros_factura':
                wao_parametros_factura_content();
                break;
            case 'mailtrain_tracking':
                wao_mailtrain_tracking_content();
                break;
            case 'configurar_widgets':
                wao_configurar_widgets_content();
                break;
            case 'textos_anadidos':
                wao_textos_anadidos_content();
                break;
        }
    echo '</div>';
}

// Función para mostrar el contenido de 'Parámetros Factura'
function wao_parametros_factura_content() {
    $options = get_option('_invoices_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Guardar los valores en la opción
        $options = [
            'ustidnr' => sanitize_text_field($_POST['ustidnr']),
            'correo_factura' => sanitize_text_field($_POST['correo_factura']),
            'direccion_factura' => sanitize_text_field($_POST['direccion_factura']),
            'direccion2_factura' => sanitize_text_field($_POST['direccion2_factura']),
            'mspartner' => sanitize_text_field($_POST['mspartner']),
            'telefono' => sanitize_text_field($_POST['telefono']),
            'hra' => sanitize_text_field($_POST['hra']),
            'propietario' => sanitize_text_field($_POST['propietario']),
            'vertrag' => sanitize_text_field($_POST['vertrag']),
            'lizenzgeber' => sanitize_text_field($_POST['lizenzgeber']),
            'mostrar2factura' => sanitize_text_field($_POST['mostrar2factura']),
            'genverliz' => sanitize_text_field($_POST['genverliz'])
        ];
        update_option('_invoices_options', $options);
        echo '<div class="updated"><p>Parámetros guardados correctamente.</p></div>';
    }

    ?>
    <form method="post">
        <table class="form-table">
            <tr>
                <th><label for="ustidnr">USt-IdNr</label></th>
                <td><input type="text" name="ustidnr" id="ustidnr" value="<?php echo esc_attr($options['ustidnr'] ?? ''); ?>" /> Shortcode: [ustidrn]</td>
            </tr>
            <tr>
                <th><label for="correo_factura">Correo Factura</label></th>
                <td><input type="text" name="correo_factura" id="correo_factura" value="<?php echo esc_attr($options['correo_factura'] ?? ''); ?>" /> Shortcode: [correo]</td>
            </tr>
            <tr>
                <th><label for="direccion_factura">Dirección Factura</label></th>
                <td><textarea name="direccion_factura" id="direccion_factura"><?php echo esc_textarea($options['direccion_factura'] ?? ''); ?></textarea> Shortcode: [direccion]</td>
            </tr>
            <tr>
                <th><label for="direccion2_factura">Dirección 2 Factura</label></th>
                <td><textarea name="direccion2_factura" id="direccion2_factura"><?php echo esc_textarea($options['direccion2_factura'] ?? ''); ?></textarea> Shortcode: [direccion2]</td>
            </tr>
            <tr>
                <th><label for="mspartner">MS Partner</label></th>
                <td><input type="text" name="mspartner" id="mspartner" value="<?php echo esc_attr($options['mspartner'] ?? ''); ?>" /> Shortcode: [mspartner]</td>
            </tr>
            <tr>
                <th><label for="telefono">Teléfono</label></th>
                <td><input type="text" name="telefono" id="telefono" value="<?php echo esc_attr($options['telefono'] ?? ''); ?>" /> Shortcode: [telefono]</td>
            </tr>
            <tr>
                <th><label for="hra">HRA</label></th>
                <td><input type="text" name="hra" id="hra" value="<?php echo esc_attr($options['hra'] ?? ''); ?>" /> Shortcode: [hra]</td>
            </tr>
            <tr>
                <th><label for="propietario">Propietario</label></th>
                <td><input type="text" name="propietario" id="propietario" value="<?php echo esc_attr($options['propietario'] ?? ''); ?>" /> Shortcode: [propietario]</td>
            </tr>
            <tr>
                <th><label for="vertrag">Vertrag</label></th>
                <td><input type="text" name="vertrag" id="vertrag" value="<?php echo esc_attr($options['vertrag'] ?? ''); ?>" /> Shortcode: [vertrag]</td>
            </tr>
            <tr>
                <th><label for="lizenzgeber">Lizenzgeber</label></th>
                <td><input type="text" name="lizenzgeber" id="lizenzgeber" value="<?php echo esc_attr($options['lizenzgeber'] ?? ''); ?>" /> Shortcode: [lizenzgeber]</td>
            </tr>
            <tr>
                <th><label for="mostrar2factura">Mostrar la hoja 2 factura?</label></th>
                <td>
                    <input type="radio" name="mostrar2factura" value="S" <?php checked($options['mostrar2factura'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="mostrar2factura" value="N" <?php checked($options['mostrar2factura'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
            <tr>
                <th><label for="genverliz">Generar versión de licencia?</label></th>
                <td>
                    <input type="radio" name="genverliz" value="S" <?php checked($options['genverliz'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="genverliz" value="N" <?php checked($options['genverliz'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
        </table>
        <p><input type="submit" class="button button-primary" value="Guardar Cambios"></p>
    </form>
    <?php
}

// Función para 'Mailtrain Tracking'
function wao_mailtrain_tracking_content() {
    $options = get_option('_mtt_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $options['mailtraintracking'] = sanitize_text_field($_POST['mailtraintracking']);
        update_option('_mtt_options', $options);
        echo '<div class="updated"><p>Configuración guardada correctamente.</p></div>';
    }
    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
        <label for="mailtraintracking">Activar Mailtrain Tracking?</label>
        <input type="radio" name="mailtraintracking" value="S" <?php checked($options['mailtraintracking'] ?? '', 'S'); ?>> Sí
        <input type="radio" name="mailtraintracking" value="N" <?php checked($options['mailtraintracking'] ?? '', 'N'); ?>> No
        <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>
    </form>
	</div>
    <?php
}

// Función para 'Configurar Widgets de Red'
function wao_configurar_widgets_content() {
    $options = get_option('_waotiendas_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $options['excluidos'] = sanitize_text_field($_POST['excluidos']);
        update_option('_waotiendas_options', $options);
        echo '<div class="updated"><p>Configuración guardada correctamente.</p></div>';
    }
    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
        <label for="excluidos">Excluidos</label>
        <input type="text" name="excluidos" id="excluidos" style="width:500px" value="<?php echo esc_attr($options['excluidos'] ?? ''); ?>" placeholder="Excluir sitios como manuals, etc." />
		<i>Excluir sitios como <b>manuals</b>, etc</i>
       <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>
    </form>
	</div>
    <?php
}

// Función para 'Textos Añadidos'
function wao_textos_anadidos_content() {
    $options = get_option('_textos_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['textos'])) {
        $options = array_map(function($texto) {
            return [
                'texto' => $texto['texto'],
                'ubicacion' => sanitize_text_field($texto['ubicacion']),
                'prioridad' => sanitize_text_field($texto['prioridad']),
                'activo' => sanitize_text_field($texto['activo'])
            ];
        }, $_POST['textos']);
        update_option('_textos_options', $options);
        echo '<div class="updated"><p>Textos guardados correctamente.</p></div>';
    }

    ?>
    <form method="post">
        <table class="form-table" style="width:70%">
            <thead>
                <tr>
                    <th style="width:40%">Texto</th>
                    <th style="width:30%">Ubicación</th>
                    <th style="width:10%">Prioridad</th>
                    <th style="width:10%">Activo</th>
                    <th style="width:10%">Acciones</th>
                </tr>
            </thead>
            <tbody id="textos-rows">
                <?php foreach ($options as $index => $texto_data): ?>
                    <tr>
                        <td style="width:40%"><textarea cols="70" name="textos[<?php echo $index; ?>][texto]"><?php echo stripslashes($texto_data['texto']); ?></textarea></td>
                        <td style="width:30%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][ubicacion]" value="<?php echo esc_attr($texto_data['ubicacion']); ?>"></td>
						<td style="width:10%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][prioridad]" value="<?php echo esc_attr($texto_data['prioridad']); ?>"></td>
                        <td style="width:10%">
							<input style="width:10px;" type="checkbox" name="textos[<?php echo $index; ?>][activo]" value="S" <?php checked($texto_data['activo'], 'S'); ?>> Sí
                        </td>
                        <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <p><button type="button" class="button button-secondary" id="add-row">Incrementar fila</button></p>
        <p><input type="submit" class="button button-primary" value="Guardar"></p>
    </form>
    <script>
        document.getElementById('add-row').addEventListener('click', function() {
            const table = document.getElementById('textos-rows');
            const rowCount = table.rows.length;
            const newRow = table.insertRow();
            newRow.innerHTML = `
                <td style="width:40%"><textarea cols="70" name="textos[${rowCount}][texto]"></textarea></td>
                <td style="width:30%"><input style="width:100%;" type="text" name="textos[${rowCount}][ubicacion]"></td>
				<td style="width:10%"><input style="width:100%;" type="text" name="textos[${rowCount}][prioridad]"></td>
                <td style="width:10%">
					<input style="width:10px;" type="checkbox" name="textos[${rowCount}][activo]" value="S"> Sí
                </td>
                <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
            `;
            addDeleteFunctionality();
        });

        function addDeleteFunctionality() {
            document.querySelectorAll('.delete-row').forEach(button => {
                button.addEventListener('click', function() {
                    this.closest('tr').remove();
                });
            });
        }

        addDeleteFunctionality();
    </script>
    <?php
}


	add_shortcode( 'nombreshop', 'agreganombreshop' );
	//CARGA EL LA INFORMACIÓN COMO SHORTCODE
	add_shortcode( 'ustidnr', 'agregaustidnr' );
	add_shortcode( 'correo', 'agregacorreo' );
	add_shortcode( 'direccion', 'agregadireccion' );
	add_shortcode( 'direccion2', 'agregadireccion2' );
	add_shortcode( 'hra', 'agregahra' );
	add_shortcode( 'propietario', 'agregapropietario' );
	add_shortcode( 'mspartner', 'agregamspartner' );
	add_shortcode( 'telefono', 'agregatelefono' );
	add_action('woocommerce_admin_order_data_after_order_details','paypal1');//sale en edit de order
	add_shortcode( 'urltienda', 'urlTienda' );
	add_shortcode( 'vertrag', 'agregavertrag' );
	add_shortcode( 'lizenzgeber', 'agregalizenzgeber' );
	function agregaustidnr_init(){
		function agregaustidnr() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['ustidnr'];
		}
		function agregacorreo($attr) {
			$args = shortcode_atts( array(
					'eslink' => 's',
				), $attr );
			$options = get_option( '_invoices_options');
			if (!is_bool($options)) {
				if ($args['eslink']=="s"){
					return "<a href='mailto:".$options['correo_factura']."'>".$options['correo_factura']."</a>"; 
				}else{
					return $options['correo_factura'];
				}
			}else{return "none";}
		}
		function agregadireccion() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['direccion_factura'];
		}
		function agregadireccion2() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['direccion2_factura'];
		}
		function agregamspartner() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['mspartner'];
		}
		function agregatelefono() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['telefono'];
		}
		function agregahra() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['hra'];
		}
		function agregapropietario() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['propietario'];
		}
		function agreganombreshop() {
		  $options = get_option( 'wpo_wcpdf_settings_general' );
		  return is_bool($options)?"none":$options['shop_name']['default'];
		}
		function urlTienda($attr){
			$args = shortcode_atts( array(
					'eslink' => 's',
					'prtcl'  => 's',
				), $attr );
			$home = get_option( 'siteurl' );
			if ($args['prtcl']<>"s"){
				$home=str_replace("https://", "", $home);
				$home=str_replace("http://", "", $home);
				$home=str_replace("https//", "", $home);
				$home=str_replace("http//", "", $home);
			}
			
			if ($args['eslink']=="s"){
				return "<a href='$home'>$home</a>";
			}else{
				return $home;
			}
		}
		function agregavertrag() {
		  $options = get_option( '_invoices_options' );
		  return $options['vertrag'];
		}
		function agregalizenzgeber() {
		  $options = get_option( '_invoices_options' );
		  return $options['lizenzgeber'];
		}
	}
	add_action('init', 'agregaustidnr_init');

function estilo_icono() {
    // Define el código CSS
    $css_personalizado = '
		.toplevel_page_my_custom_settings>.dashicons-admin-settings:before{color:#83A2FF!important;}
		//.toplevel_page_my_custom_settings div.dashicons-admin-settings:before{color:yellow!important;}
		//.dashicons-admin-settings{color:yellow!important;background-color:white!important;}
    ';

    // Registra el estilo
    wp_register_style('estilo-personalizado-admin', false); // El segundo parámetro es la URL, que es falso en este caso

    // Agrega el código CSS personalizado al estilo registrado
    wp_add_inline_style('estilo-personalizado-admin', $css_personalizado);

    // Enqueue the style
    wp_enqueue_style('estilo-personalizado-admin');
}

// Engancha la función a la acción 'admin_enqueue_scripts'
//add_action('admin_enqueue_scripts', 'estilo_icono');

function paypal1($post){//sale en edit de order PAYPAL RECEIVER
	$id=$post->get_id();
	$tt=get_post_meta( $id,'_payment_method' );
	if ($tt[0]=='paypal'||$tt[0]=='ppec_paypal'||$tt[0]=='ppcp-gateway'||$tt[0]=='ppcp'){
		$options1 = get_post_meta( $id,'paypal_receiver' );
		echo "<p class='form-field form-field-wide wc-customer-user' style='color:blue;padding-top:190px;border:solid 1px gray;border-radius:3px;'>Paypal receiver: ".$options1[0]."</p>"; 
	}	
}

function get_waotiendas1_option($indice="nothing"){
	if(is_multisite()){
		$thissite = get_current_blog_id();
		switch_to_blog(1);
	}
	$option = get_option('_waotiendas_options',"");
	if(!isset($option[$indice])){
		$retorno = FALSE;
	}else{
		$retorno = $option[$indice];
	}
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}

function update_waotiendas1_option($indice,$valor){
	if(is_multisite()){
		$thissite = get_current_blog_id();
		switch_to_blog(1);
	}
	$option = get_option('_waotiendas_options');
	if(!is_bool($option[$indice])){
		$option[$indice]=$valor;
		if (update_option('_waotiendas_options',$option)){
			$retorno = TRUE;
		}else{
			$retorno = FALSE;
		}
	}else{
		$retorno = FALSE;
	}
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}


