<?php
/*
 version 1.1
*/
defined( 'ABSPATH' ) || exit;

add_shortcode('multisite_order_lookup', function() {
    // Verificar si el usuario está logueado y tiene privilegios
    if (!is_user_logged_in() || !current_user_can('manage_woocommerce') && !current_user_can('shop_supervisor')) {
        return "<p>There's nothing here for you :(</p>";
    }

    global $wpdb;
    $output = '';

    // Procesar el formulario cuando se envíe
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['emails']) && isset($_POST['start_date'])) {
        // Limpiar la entrada
        $emails = array_map('trim', explode("\n", sanitize_textarea_field($_POST['emails'])));
        $emails = array_filter($emails, 'is_email'); // Validar que sean emails

        $start_date = sanitize_text_field($_POST['start_date']);

        if (empty($emails)) {
            $output .= '<p>No se proporcionaron correos electrónicos válidos.</p>';
        } elseif (empty($start_date) || !strtotime($start_date)) {
            $output .= '<p>Por favor, proporciona una fecha válida.</p>';
        } else {
            // Obtener datos de todas las bases de datos en multisite
            $sites = get_sites();
            $results = [];

            foreach ($sites as $site) {
                switch_to_blog($site->blog_id);

                foreach ($emails as $email) {
                    $order = $wpdb->get_row($wpdb->prepare(
                        "SELECT posts.ID AS order_id, posts.post_date AS order_date
                        FROM {$wpdb->prefix}posts AS posts
                        INNER JOIN {$wpdb->prefix}postmeta AS meta ON posts.ID = meta.post_id
                        WHERE posts.post_type = 'shop_order' 
                          AND posts.post_status IN ('wc-completed', 'wc-processing') 
                          AND meta.meta_key = '_billing_email' AND meta.meta_value = %s
                          AND posts.post_date >= %s
                        ORDER BY posts.post_date DESC
                        LIMIT 1",
                        $email, $start_date
                    ));


/*				$utm_source = 'mautic'; // Filtro por origen "mautic"
				$order = $wpdb->get_row($wpdb->prepare(
					"SELECT posts.ID AS order_id, posts.post_date AS order_date
					FROM {$wpdb->prefix}posts AS posts
					INNER JOIN {$wpdb->prefix}postmeta AS meta ON posts.ID = meta.post_id
					LEFT JOIN {$wpdb->prefix}postmeta AS utm_meta ON posts.ID = utm_meta.post_id
					WHERE posts.post_type = 'shop_order' 
					  AND posts.post_status IN ('wc-completed', 'wc-processing') 
					  AND meta.meta_key = '_billing_email' AND meta.meta_value = %s
					  AND utm_meta.meta_key = '_wc_order_attribution_utm_source' AND utm_meta.meta_value = %s
					  AND posts.post_date >= %s
					ORDER BY posts.post_date DESC
					LIMIT 1",
					$email, $utm_source, $start_date
				));
*/



                    if ($order) {
                        $results[] = [
                            'email' => $email,
                            'date' => $order->order_date,
                            'link' => get_edit_post_link($order->order_id, 'raw'),
                            'site' => $site->domain . $site->path
                        ];
                    }
                }

                restore_current_blog();
            }

            // Ordenar resultados por fecha descendente
            usort($results, function($a, $b) {
                return strtotime($b['date']) - strtotime($a['date']);
            });

            // Construir la tabla de resultados
            $output .= '<table border="1" cellpadding="5" cellspacing="0">
                <thead>
                    <tr>
                        <th>Email</th>
                        <th>Fecha Última Compra</th>
                        <th>Enlace a la Orden</th>
                        <th>Multisite</th>
                    </tr>
                </thead>
                <tbody>';

            foreach ($results as $result) {
                $output .= '<tr>
                    <td>' . esc_html($result['email']) . '</td>
                    <td>' . esc_html($result['date']) . '</td>
                    <td>' . ($result['link'] ? '<a href="' . esc_url($result['link']) . '">Ver Orden</a>' : 'N/A') . '</td>
                    <td>' . esc_html($result['site']) . '</td>
                </tr>';
            }

            $output .= '</tbody></table>';
        }
    }

    // Formulario
    $output .= '<form method="post">
        <textarea name="emails" rows="10" cols="50" placeholder="Pega aquí los correos electrónicos, uno por línea."></textarea><br>
        <label for="start_date">Fecha mínima de la orden:</label>
        <input type="date" name="start_date" required><br>
        <button type="submit">Buscar</button>
    </form>';

    return $output;
});

// capturar parametros utm desde los templates de mautic
// aquí estamos usando variables de sesion, pero podríamos usar cookies (ver utilidad)
add_action('init', function() {
    if (isset($_GET['utm_source']) && isset($_GET['utm_campaign'])) {
        // Guardar en la sesión
        if (!session_id()) {
            session_start();
        }
        $_SESSION['utm_source'] = sanitize_text_field($_GET['utm_source']);
        $_SESSION['utm_campaign'] = sanitize_text_field($_GET['utm_campaign']);
    }
});

// Obtener la opción almacenada
$options = get_option('_mtt_options', []);
// Verificar si el parámetro 'mautictracking' está configurado como 'S'
if (!empty($options['mautictracking']) && $options['mautictracking'] === 'S') {
	// Añadir filtros en la lista de ordenes
	filtros_mautic();

	/*add_action('admin_menu', function () {
		add_menu_page(
			'Mautic Test',
			'Mautic Test',
			'manage_options',
			'mautic-test',
			'mautic_test_page'
		);
	});*/
} else {
    // Opcional: Manejo en caso de que 'mautictracking' no esté habilitado
    // error_log('Mautic Tracking no está habilitado.');
}


function filtros_mautic(){
	add_action('restrict_manage_posts', function($post_type) {
		if ($post_type !== 'shop_order') {
			return; // Solo ejecutamos el filtro en las órdenes de WooCommerce
		}
		
		// Campo para filtrar por utm_campaign
		$selected_campaign = isset($_GET['utm_campaign']) ? sanitize_text_field($_GET['utm_campaign']) : '';
		$selected_source = isset($_GET['utm_source']) ? sanitize_text_field($_GET['utm_source']) : '';
		/*echo '<input type="text" name="utm_campaign" value="' . esc_attr($selected_campaign) . '" placeholder="Filtrar por utm_campaign" style="margin-right:10px;" />';*/
		// Campo para filtrar por utm_source
		//echo '<input type="text" name="utm_source" value="' . esc_attr($selected_source) . '" placeholder="Filtrar por utm_source" />';

		echo '<input type="text" name="utm_campaign" value="' . esc_attr($selected_campaign) . '" 
			  placeholder="Filtrar por utm_campaign" 
			  style="margin-right:10px; color: #FFFFFF; background-color: #4E5D9D; 
					 background-image: url(\'https://mautic.winandoffice.com/mautic.jpeg\'); 
					 background-repeat: no-repeat; background-size: 20px 20px; 
					 background-position: 10px center; padding-left: 35px; border: none; 
					 outline: none; height: 30px;" />';

		echo '<input type="text" name="utm_source" value="' . esc_attr($selected_source) . '" 
			  placeholder="Filtrar por utm_source" 
			  style="margin-right:10px; color: #FFFFFF; background-color: #4E5D9D; 
					 background-image: url(\'https://mautic.winandoffice.com/mautic.jpeg\'); 
					 background-repeat: no-repeat; background-size: 20px 20px; 
					 background-position: 10px center; padding-left: 35px; border: none; 
					 outline: none; height: 30px;" />';

		echo '<style>
			  input[name="utm_campaign"]::placeholder,
			  input[name="utm_source"]::placeholder {
				  color: #FFFFFF; /* Color del placeholder */
				  opacity: 1; /* Asegura que el color se aplique completamente */
			  }
			  </style>';


//		
	});

	add_action('pre_get_posts', function($query) {
		if (!is_admin() || !$query->is_main_query() || $query->get('post_type') !== 'shop_order') {
			return; // Solo modificamos las consultas principales de la lista de órdenes
		}

		global $wpdb;

		// Filtro por utm_campaign
		if (!empty($_GET['utm_campaign'])) {
			$utm_campaign = sanitize_text_field($_GET['utm_campaign']);
			$query->set('meta_query', array_merge(
				$query->get('meta_query') ?: array(),
				array(
					array(
						'key' => '_wc_order_attribution_utm_campaign',
						'value' => $utm_campaign,
						'compare' => 'LIKE'
					)
				)
			));
		}

		// Filtro por utm_source
		if (!empty($_GET['utm_source'])) {
			$utm_source = sanitize_text_field($_GET['utm_source']);
			$query->set('meta_query', array_merge(
				$query->get('meta_query') ?: array(),
				array(
					array(
						'key' => '_wc_order_attribution_utm_source',
						'value' => $utm_source,
						'compare' => 'LIKE'
					)
				)
			));
		}
	});
}

// test de conexion con mautic
function mautic_test_page() {
    // Configuración de credenciales
    
	/*
	$mautic_base_url = 'https://mautic.winandoffice.com'; // Cambia por tu URL de Mautic
    $client_id = '1_18nllrx9ae5cgwcgso0w448w0w0w8k4osco4w8gk484csgk4k8'; // Public Key
    $client_secret = '517z1rvhqgw0k4kkw48gg00koso448kwgw8k0c08c44c8ok84w'; // Secret Key
    $auth_url = "$mautic_base_url/oauth/v2/token";
	*/

	$mautic_options = get_option('_mtt_options', array());
	$mautic_base_url = $mautic_options['mautic_url'];
	$client_id = $mautic_options['mautic_client_id'];
	$client_secret = $mautic_options['mautic_client_secret'];
    $auth_url = "$mautic_base_url/oauth/v2/token";
    // Obtener token de acceso usando Client Credentials
    $response = wp_remote_post($auth_url, [
        'body' => [
            'grant_type' => 'client_credentials',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
        ],
    ]);

    if (is_wp_error($response)) {
        echo '<p>Error al conectar con Mautic: ' . $response->get_error_message() . '</p>';
        return;
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (isset($data['access_token'])) {
        $access_token = $data['access_token'];
        echo '<p>Token obtenido exitosamente: ' . esc_html($access_token) . '</p>';

        // Ejemplo: Obtener lista de contactos
        $contacts_url = "$mautic_base_url/api/contacts?limit=1";
        $contacts_response = wp_remote_get($contacts_url, [
            'headers' => [
                'Authorization' => 'Bearer ' . $access_token,
            ],
        ]);

        if (is_wp_error($contacts_response)) {
            echo '<p>Error al obtener contactos: ' . $contacts_response->get_error_message() . '</p>';
        } else {
            $contacts_body = wp_remote_retrieve_body($contacts_response);
            $contacts = json_decode($contacts_body, true);

            echo '<h2>Contactos:</h2>';
            echo '<pre>' . esc_html(print_r($contacts, true)) . '</pre>';
        }
    } else {
        echo '<p>Error al obtener el token de acceso: ' . esc_html($body) . '</p>';
    }
}

// Acción cuando un usuario se registra
add_action('user_register', 'send_customer_to_mautic_on_register', 10, 1);
function send_customer_to_mautic_on_register($user_id) {
	global $wpdb;
    $user = get_userdata($user_id);

    $email = $user->user_email;
    //$first_name = $user->first_name;
    //$last_name = $user->last_name;
 
    $first_name = get_user_meta($user_id, 'first_name', true) ?: $user->user_login;  // Si no hay first_name, usar username
    $last_name = get_user_meta($user_id, 'last_name', true) ?: '';

	//$country = get_user_meta($user_id, 'billing_country', true); // Obtenemos el país de la dirección de facturación
	$country = get_country_large();

    // Obtener el dominio de la tienda
    $dominio = $_SERVER['HTTP_HOST']; // O usa get_site_url() si prefieres usar la URL completa

	if(is_multisite()){
		$site_id = get_current_blog_id(); // Obtener el ID del sitio actual
		$pais = $wpdb->get_var($wpdb->prepare(
			"SELECT path FROM {$wpdb->blogs} WHERE blog_id = %d",
			$site_id
		));
	}else{
		$pais = '/';
	}

    // Verificar si el correo ya fue enviado antes a Mautic
    if (!email_exists_in_postmeta($email)) {
        send_to_mautic($email, $first_name, $last_name, $country, $dominio, $pais);
    }
}

// Acción cuando se completa un pedido (compra anónima)
add_action('woocommerce_order_status_completed', 'send_customer_to_mautic_on_purchase', 10, 1);
function send_customer_to_mautic_on_purchase($order_id) {
	global $wpdb;
    $order = wc_get_order($order_id);

    // Obtener los datos del pedido
    $billing_email = $order->get_billing_email();
    $billing_first_name = $order->get_billing_first_name();
    $billing_last_name = $order->get_billing_last_name();
    $billing_country = get_country_large($order->get_billing_country()); 

    // Obtener el dominio de la tienda
    $dominio = $_SERVER['HTTP_HOST']; // O usa get_site_url() si prefieres usar la URL completa

    // Obtener el país
	if(is_multisite()){
		$site_id = get_current_blog_id(); // Obtener el ID del sitio actual
		$pais = $wpdb->get_var($wpdb->prepare(
			"SELECT path FROM {$wpdb->blogs} WHERE blog_id = %d",
			$site_id
		));
	}else{
		$pais = '/';
	}
    // Solo proceder si hay un correo electrónico y no ha sido enviado antes
    if (!empty($billing_email) && !email_exists_in_postmeta($billing_email,1)) {
        send_to_mautic($billing_email, $billing_first_name, $billing_last_name, $billing_country, $dominio, $pais);
    }
	 
}

// Función para verificar si el correo ya existe como metadato '_billing_email'
function email_exists_in_postmeta($email, $compare=0) {
    global $wpdb;

    // Consultamos wp_postmeta por el correo electrónico
    $result = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_billing_email' AND meta_value = %s",
        $email
    ));
    return $result > $compare; // Si el correo fue encontrado, significa que ya fue procesado
}

// Función para enviar los datos a Mautic 
function send_to_mautic($email, $first_name, $last_name, $country, $dominio, $pais) {

    if (is_multisite()) {
        $site_id = get_current_blog_id(); // Obtener el site_id del sitio actual
    } else {
        $site_id = 1; // Si no es multisite, consideramos el sitio como principal
    }
    // Si es el sitio principal (site_id 1), asignamos '/' como país
    if ($site_id == 1) {
        $pais = '/'; // País como '/'
    }

/*
        'custom_fields' => [
            'dominio' => $dominio, // Campo personalizado "dominio"
            'pais' => $pais      // Campo personalizado "pais"
        ]

		'customFields' => array(
			'dominio' => array('value' => $dominio),
			'pais' => array('value' => $pais)
		)

*/
    $url = 'https://mautic.winandoffice.com/api/contacts/new'; // URL de la API de Mautic
    $data = [
        'email' => $email,
        'firstname' => $first_name,
        'lastname' => $last_name,
        'country' => $country,
		'dominio' => $dominio,
		'pais' => $pais,
		'tags' => ['autogenerado']
    ];

    // Enviar la solicitud POST a Mautic
    $response = wp_remote_post($url, [
        'method'    => 'POST',
        'body'      => json_encode($data),
        'headers'   => [
            'Content-Type'  => 'application/json',
			'Authorization' => 'Bearer ' . get_access_token(), // Usar el token de autorización con 'Bearer'
        ]
    ]);

    // Verificación de la respuesta
    if (is_wp_error($response)) {
        error_log('Error al enviar datos a Mautic: ' . $response->get_error_message());
    } else {
        error_log('Datos enviados correctamente a Mautic.');
    }
}

// Obtener el token desde mautic
function get_access_token() {
    // Verifica si el token ha caducado o si es la primera vez que lo obtienes
    $token_info = get_option('mautic_access_token'); // Guarda el token en las opciones de WordPress o en tu almacenamiento preferido
    if (empty($token_info) || time() > $token_info['expires_at']) {
        // Si no existe o ha expirado, obtenemos un nuevo token
        //$client_id = '1_18nllrx9ae5cgwcgso0w448w0w0w8k4osco4w8gk484csgk4k8'; // Tu client_id
        //$client_secret = '517z1rvhqgw0k4kkw48gg00koso448kwgw8k0c08c44c8ok84w'; // Tu client_secret
		$mautic_options = get_option('_mtt_options', array());
        $client_id = $mautic_options['mautic_client_id'];
        $client_secret = $mautic_options['mautic_client_secret'];
        $mautic_url = $mautic_options['mautic_url'].'/oauth/v2/token';

        // Realiza la solicitud para obtener el token
        $response = wp_remote_post($mautic_url, [
            'body' => [
                'grant_type' => 'client_credentials',
                'client_id' => $client_id,
                'client_secret' => $client_secret,
            ],
        ]);

        if (is_wp_error($response)) {
            return null; // Si hay un error, regresa null
        }

        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        if (isset($data['access_token'])) {
            // Guardamos el nuevo token y su expiración
            $expires_at = time() + $data['expires_in']; // Tiempo de expiración
            update_option('mautic_access_token', [
                'access_token' => $data['access_token'],
                'expires_at' => $expires_at
            ]);

            return $data['access_token'];
        }

        return null; // Si no se obtiene un token, devuelve null
    }

    // Si ya existe y no ha caducado, lo utilizamos
    return $token_info['access_token'];
}

// Obtener el pais en formato largo. Ej: Germany
function get_country_large() {
    // Verificar si la geolocalización está habilitada en WooCommerce
    if ( class_exists( 'WC_Geolocation' ) && get_option( 'woocommerce_default_customer_address' ) === 'geolocate' ) {
        // Si la geolocalización está habilitada
        $geolocator = new WC_Geolocation();
        $location = $geolocator->geolocate();
        
        // Obtener el país ISO desde la geolocalización
        $country_iso = isset( $location['country'] ) ? $location['country'] : 'US'; // Default to 'US' if not found
        
    } else {
        // Si la geolocalización no está habilitada, usar el país configurado en la tienda
        $store_country = get_option( 'woocommerce_default_country' );  // Ejemplo: 'US:California'
        $country_iso = substr( $store_country, 0, 2 ); // Extraer el código ISO
    }

    // Obtener el nombre completo del país usando WordPress
    // Usamos la lista de países de WooCommerce o WordPress para obtener el nombre completo
    $countries = WC()->countries->get_countries();  // Obtenemos todos los países configurados en WooCommerce
    $country_name = isset( $countries[$country_iso] ) ? $countries[$country_iso] : 'Unknown Country';
    
    return $country_name;  // Retorna el nombre completo del país
}

