<?php
/*
Plugin Name: WAO Tiendas
Text Domain: wao-tiendas
Domain Path: /languages
Plugin URI: https://download.winandoffice.com/Install/pluginWaoUpdates/waotiendas/
Description: Funciones para las tiendas de Windows & Office. (Widgets paypal y color en configuracion)
Version: 2.8.7
Change Log: Configuracion mautic incluye test de conexion. Configuracion de email marketing incluye Mautic Tracking. Se añade wao-mautic.php. En configuracion de WAO TIENDAS, se incrementa la pesta&ntilde;a hooks. Se reactivó paypal receiver para payment plugins for paypal. Se completaron traducciones perdidas. Factura conPrecioUnitario no muestra informaci&aacute;n del cliente corregido!. .
Author: Arturo Zubieta
Author URI:https://download.winandoffice.com
License: GPL
*/
/*INDICE DEL Plugin
  =================
* AÑADIR LINK settings EN EL PLUGIN 33
* INSERTAR UN MENU "PARAMETROS FACTURA" EN SETTINGS DE WORDPRESS
  - FORMULARIO 
  - REGISTRO DE CAMPOS O VARIABLES EN LA BASE DE DATOS
  - VALIDACION
  - INPUTS PARA LOS CAMPOS DEL FORMULARIO EN EL FORMULARIO
  - CREAR LOS SHORTCODES
* AÑADIR PAYPAL RECEIVER EN CORREO Y PAGINA DE PEDIDO
* FACTURA A TRES COLUMNAS
* CREAR LA SEGUNDA PAGINA DE LA FACTURA
* WIDGET PAYPAL EN DASHBOARD
* USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
* COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
*/
//        load_plugin_textdomain( 'woocommerce-pdf-invoices-packing-slips', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
defined( 'ABSPATH' ) || exit;
// Definimos la version actual del plugin para la actualizacion automática
if (!defined('MY_PLUGIN_VERSION_WAOT')) {
    define('MY_PLUGIN_VERSION_WAOT', '2.8.7');
}

// Carga los archivos de traducción del plugin
function wao_tiendas_load_textdomain() {
    load_plugin_textdomain( 'wao-tiendas', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'wao_tiendas_load_textdomain' );

include("classes/wao-link.php");//link a settings en plugins
include("classes/wao-paypal-receiver.php");
include("classes/wao-factura3col.php");
include("classes/wao-2da-pagina-factura.php");
include("classes/mailtraintracking.php");
include("classes/wao-shortcodes.php");
include("classes/wao-dailysales-widget.php");
include("classes/wao-contact-support.php");
include("wao-update.php");
include("classes/wao-parametros-factura-chatgpt1.php");  
include("classes/wao-mautic.php");
//include("classes/wao-paypal-new.php");
//include("classes/wao-banks-widget.php");
//include("classes/wao-shopperapproved.php");
/////////ARTURO: USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
// Incluir NIF en la factura

add_filter( 'wpo_wcpdf_shop_address', 'scodes' );
add_filter( 'wpo_wcpdf_footer', 'scodes',99 );

function scodes($texto){
	$options = get_option('_invoices_options'); //aqui esta la raiz de vertrag y lizenzgeber
	//$texto=str_replace("[ustidnr]",$options["ustidnr"],$texto);
	$texto=str_replace("[ustidnr]",$options["ustidnr"],$texto);
	$texto=str_replace("[mspartner]",$options["mspartner"],$texto);
	$texto=str_replace("[correo]",$options["correo_factura"],$texto);
	$texto=str_replace("[direccion]",$options["direccion_factura"],$texto);
	$texto=str_replace("[direccion2]",$options["direccion2_factura"],$texto);
	$texto=str_replace("[hra]",$options["hra"],$texto);
	$texto=str_replace("[propietario]",$options["propietario"],$texto);
	$texto=str_replace("[nombreshop]",agreganombreshop(),$texto);
	$texto=str_replace("[direccion]",$options["direccion_factura"],$texto);
	$texto=str_replace("[telefono]",$options["telefono"],$texto);
	$texto=str_replace("[urltienda]",get_option('siteurl'),$texto);
	return $texto;
}
///////FIN DE FUNCION INCLUIR NIF. FUNCION ANULADA, PARA INCLUIR ESTOS DATOS, VASTA COLOCAR SHORTCODES EN LA CONFIGURACION DE PDF INVOICES/General/Shop Addres


//////COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
//add_action('wpo_wcpdf_before_billing_address','ponertitle',10,2); 
function ponertitle($type,$orden){
	$title=get_post_meta($orden->ID,"title",true);
	if(!empty($title)){
		if($title<>""){
			echo '<div class="billing-email">'.$title[0].'</div';
		}
	}
}
//////FIN DE COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA

//////NOMBRE Y COMPANIA EN FACTURA
//add_action('wpo_wcpdf_before_billing_address','compania',10,2);
function compania($tipo,$orden){
	?>
    <span class="custom-text">
    <?php echo "&nbsp;";?>
    </span><br>
    <?php
}

//////FIN DE NOMBRE Y COMPANIA EN FACTURA

///FUNCIONES COMUNES

function tabla($el,$estilo="none"){
	return "<table class='".$estilo."'>".$el."</table>";
}
function tr($el,$estilo="none"){
	return "<tr class='".$estilo."'>".$el."</tr>";
}
function td($el, $estilo="none"){
	return "<td class='".$estilo."'>".$el."</td>";
}
function tag($el,$tipo="b",$estilo="none"){
	return "<".$tipo."  class='".$estilo."'>".$el."</".$tipo.">";
}

// registro de template limpio 
function waotiendas_add_page_template($templates) {
    $templates[plugin_dir_path(__FILE__) . 'templates/template-limpio.php'] = 'Template Limpio';
    return $templates;
}
add_filter('theme_page_templates', 'waotiendas_add_page_template');

function waotiendas_redirect_page_template($template) {
    $post = get_post();
    $page_template = get_post_meta($post->ID, '_wp_page_template', true);

    if ('template-limpio.php' === basename($page_template)) {
        $template = plugin_dir_path(__FILE__) . 'templates/template-limpio.php';
    }

    return $template;
}
add_filter('page_template', 'waotiendas_redirect_page_template');


// hooks waotiendas

// recorre la option _textos_otions para insertar los hooks que esten guardados y activos
function mtextos(){
	$textos_aniadidos = get_option('_textos_options', array());
	foreach($textos_aniadidos as $texto){
		if($texto['activo']=='S'){
			$gancho = $texto['ubicacion'];
			$textox = $texto['texto'];
			$textox = process_shortcodes_in_html($textox);
			$prioridad = isset($texto['prioridad'])?$texto['prioridad']:5;
			add_action( $gancho, function() use ($textox){echo stripslashes($textox);}, $prioridad );
		}
	}
}
add_action('init','mtextos');
//
function traducir_textos_claros($html) {
    // Expresión regular para encontrar textos entre las etiquetas HTML
    $pattern = '/>([^<]+)</';

    // Usa preg_replace_callback para procesar cada coincidencia
    $html_traducido = preg_replace_callback($pattern, function($matches) {
        // Obtén el texto claro (sin espacios en blanco al inicio y final)
        $texto_claro = trim($matches[1]);

        // Si el texto no está vacío, tradúcelo; de lo contrario, devuélvelo sin cambios
        if (!empty($texto_claro)) {
            return '>' . __($texto_claro, 'wao-tiendas') . '<';
        } else {
            return $matches[0]; // Retorna el texto sin cambios
        }
    }, $html);

    return $html_traducido;
}
// reemplaza shortcodes en los textos hook configurados por la pestaña de configuracion waotiendas
function process_shortcodes_in_html($content) {
    // Usa preg_replace_callback para buscar shortcodes dentro de atributos HTML
    $content = preg_replace_callback(
        '/\[[^\]]+\]/', // Patrón para encontrar shortcodes
        function($matches) {
            // Procesa el shortcode encontrado
            return do_shortcode($matches[0]);
        },
        $content
    );

    return $content;
}
// Ejemplos de uso con tu contenido HTML

function algo(){
	return 'https://google.com';
};
add_shortcode('test', 'algo');


function traduce(){
 
	$textoy = get_option('_textos_options');
	$textox =$textoy[1]['texto'];
	// Llama a la función para traducir el contenido
	$textox_traducido = traducir_textos_claros($textox);
	$su=get_option('home')."/support?order_id=123";
	$textox_traducido = str_replace('[su]',$su,$textox_traducido);

	// Muestra el contenido traducido
	return stripslashes($textox_traducido);
}
add_shortcode('traduce','traduce');

